/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.swidgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import org.tigris.swidgets.ArrowButton;

public class ArrowIcon
implements Icon,
Serializable,
SwingConstants {
    private static final long serialVersionUID = -5251649967037193581L;
    private static final int SIZE = 10;
    private static final int ONE_TOUCH_SIZE = 6;
    private int[][] buffer;
    private int[][] northWestBuffer = new int[][]{{0, 0, 0, 2, 2, 0, 0, 0, 0}, {0, 0, 2, 1, 1, 1, 0, 0, 0}, {0, 2, 1, 1, 1, 1, 1, 0, 0}, {2, 1, 1, 1, 1, 1, 1, 1, 0}, {0, 3, 3, 3, 3, 3, 3, 3, 3}};
    private int[][] southEastBuffer = new int[][]{{2, 2, 2, 2, 2, 2, 2, 2, 0}, {0, 1, 1, 1, 1, 1, 1, 3, 3}, {0, 0, 1, 1, 1, 1, 3, 3, 0}, {0, 0, 0, 1, 1, 3, 3, 0, 0}, {0, 0, 0, 0, 3, 3, 0, 0, 0}};
    private int direction;
    private int width = 10;
    private int height = 10;

    public ArrowIcon(int n) {
        this.direction = n;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        ArrowButton arrowButton;
        ButtonModel buttonModel;
        int n3 = Math.min(10, 6);
        Color[] colorArray = new Color[]{component.getBackground(), UIManager.getColor("controlDkShadow"), UIManager.getColor("infoText"), UIManager.getColor("controlHighlight")};
        graphics.setColor(component.getBackground());
        graphics.fillRect(0, 0, component.getWidth(), component.getHeight());
        if (component instanceof ArrowButton && (buttonModel = (arrowButton = (ArrowButton)component).getModel()).isPressed()) {
            colorArray[1] = colorArray[2];
        }
        if (this.direction == 1 || this.direction == 5) {
            this.buffer = this.direction == 1 ? this.northWestBuffer : this.southEastBuffer;
            for (int i = 1; i <= this.buffer[0].length; ++i) {
                for (int j = 1; j < n3; ++j) {
                    if (this.buffer[j - 1][i - 1] == 0) continue;
                    graphics.setColor(colorArray[this.buffer[j - 1][i - 1]]);
                    graphics.drawLine(i, j, i, j);
                }
            }
        } else {
            this.buffer = this.direction == 7 ? this.northWestBuffer : this.southEastBuffer;
            for (int i = 1; i <= this.buffer[0].length; ++i) {
                for (int j = 1; j < n3; ++j) {
                    if (this.buffer[j - 1][i - 1] == 0) continue;
                    graphics.setColor(colorArray[this.buffer[j - 1][i - 1]]);
                    graphics.drawLine(j, i, j, i);
                }
            }
        }
    }

    public int getIconWidth() {
        return 10;
    }

    public int getIconHeight() {
        return 10;
    }

    public void setIconHeight(int n) {
        this.height = n;
    }

    public void setIconWidth(int n) {
        this.width = n;
    }
}

