/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.swidgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class GridLayout2
implements LayoutManager,
Serializable {
    public static final int NONE = 0;
    public static final int BOTH = 1;
    public static final int HORIZONTAL = 2;
    public static final int VERTICAL = 3;
    public static final int CENTER = 10;
    public static final int NORTH = 11;
    public static final int NORTHEAST = 12;
    public static final int EAST = 13;
    public static final int SOUTHEAST = 14;
    public static final int SOUTH = 15;
    public static final int SOUTHWEST = 16;
    public static final int WEST = 17;
    public static final int NORTHWEST = 18;
    private int hgap;
    private int vgap;
    private int rows;
    private int cols;
    public static final int MAXPREFERRED = 20;
    public static final int ROWCOLPREFERRED = 21;
    public static final int FITPARENT = 22;
    private int cellSizing = 22;
    private int fill = 1;
    private int anchor = 17;
    private int largestHeight;
    private int largestWidth;
    private int[] colWidth;
    private int[] rowHeight;

    public GridLayout2() {
        this(1, 0, 0, 0);
    }

    public GridLayout2(int n, int n2) {
        this(n, n2, 0, 0);
    }

    public GridLayout2(int n, int n2, int n3, int n4) {
        if (n == 0 && n2 == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.rows = n;
        this.cols = n2;
        this.hgap = n3;
        this.vgap = n4;
    }

    public GridLayout2(int n, int n2, int n3) {
        this(n, n2, 0, 0, n3);
    }

    public GridLayout2(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4);
        this.cellSizing = n5;
    }

    public GridLayout2(int n, int n2, int n3, int n4, int n5, int n6) {
        this(n, n2, n3, n4, n5);
        this.fill = n6;
    }

    public GridLayout2(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this(n, n2, n3, n4, n5, n6);
        this.anchor = n7;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n = container.getComponentCount();
            int n2 = this.rows;
            int n3 = this.cols;
            if (n2 > 0) {
                n3 = (n + n2 - 1) / n2;
            } else {
                n2 = (n + n3 - 1) / n3;
            }
            this.colWidth = new int[n3];
            this.rowHeight = new int[n2];
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    int n6 = j * n3 + i;
                    if (n6 >= n) continue;
                    if (container.getComponent(n6).getPreferredSize().getWidth() > (double)this.colWidth[i]) {
                        this.colWidth[i] = (int)container.getComponent(n6).getPreferredSize().getWidth();
                        if (this.colWidth[i] > n4) {
                            n4 = this.colWidth[i];
                        }
                    }
                    if (!(container.getComponent(n6).getPreferredSize().getHeight() > (double)this.rowHeight[j])) continue;
                    this.rowHeight[j] = (int)container.getComponent(n6).getPreferredSize().getHeight();
                    if (this.rowHeight[j] <= n5) continue;
                    n5 = this.rowHeight[j];
                }
            }
            return this.calculateSizes(container, this.colWidth, this.rowHeight, n2, n3, n4, n5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n = container.getComponentCount();
            int n2 = this.rows;
            int n3 = this.cols;
            if (n2 > 0) {
                n3 = (n + n2 - 1) / n2;
            } else {
                n2 = (n + n3 - 1) / n3;
            }
            this.colWidth = new int[n3];
            this.rowHeight = new int[n2];
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    int n6 = j * n3 + i;
                    if (n6 >= n) continue;
                    if (container.getComponent(n6).getMinimumSize().getWidth() > (double)this.colWidth[i]) {
                        this.colWidth[i] = (int)container.getComponent(n6).getMinimumSize().getWidth();
                        if (this.colWidth[i] > n4) {
                            n4 = this.colWidth[i];
                        }
                    }
                    if (!(container.getComponent(n6).getMinimumSize().getHeight() > (double)this.rowHeight[j])) continue;
                    this.rowHeight[j] = (int)container.getComponent(n6).getMinimumSize().getHeight();
                    if (this.rowHeight[j] <= n5) continue;
                    n5 = this.rowHeight[j];
                }
            }
            return this.calculateSizes(container, this.colWidth, this.rowHeight, n2, n3, n4, n5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            int n2;
            int n3;
            int n4 = container.getComponentCount();
            if (n4 == 0) {
                return;
            }
            Insets insets = container.getInsets();
            int n5 = this.rows;
            int n6 = this.cols;
            if (n5 > 0) {
                n6 = (n4 + n5 - 1) / n5;
            } else {
                n5 = (n4 + n6 - 1) / n6;
            }
            this.colWidth = new int[n6];
            this.rowHeight = new int[n5];
            this.largestWidth = 0;
            this.largestHeight = 0;
            if (this.cellSizing == 22) {
                n3 = container.getWidth() - (insets.left + insets.right + (n6 - 1) * this.hgap);
                n2 = container.getHeight() - (insets.top + insets.bottom + (n5 - 1) * this.vgap);
                this.largestWidth = n3 / n6;
                this.largestHeight = n2 / n5;
            } else {
                for (n3 = 0; n3 < n6; ++n3) {
                    for (n2 = 0; n2 < n5; ++n2) {
                        n = n2 * n6 + n3;
                        if (n >= n4) continue;
                        if (container.getComponent(n).getPreferredSize().getWidth() > (double)this.colWidth[n3]) {
                            this.colWidth[n3] = (int)container.getComponent(n).getPreferredSize().getWidth();
                            if (this.colWidth[n3] > this.largestWidth) {
                                this.largestWidth = this.colWidth[n3];
                            }
                        }
                        if (!(container.getComponent(n).getPreferredSize().getHeight() > (double)this.rowHeight[n2])) continue;
                        this.rowHeight[n2] = (int)container.getComponent(n).getPreferredSize().getHeight();
                        if (this.rowHeight[n2] <= this.largestHeight) continue;
                        this.largestHeight = this.rowHeight[n2];
                    }
                }
            }
            int n7 = insets.left;
            for (n = 0; n < n6; ++n) {
                n3 = this.getComponentCellWidth(n);
                int n8 = insets.top;
                for (int i = 0; i < n5; ++i) {
                    n2 = this.getComponentCellHeight(i);
                    int n9 = i * n6 + n;
                    if (n9 < n4) {
                        this.positionComponentInCell(container.getComponent(n9), n7, n8, n3, n2);
                    }
                    n8 += n2 + this.vgap;
                }
                n7 += n3 + this.hgap;
            }
        }
    }

    protected Dimension calculateSizes(Container container, int[] nArray, int[] nArray2, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        if (this.cellSizing == 21) {
            int n7;
            for (n7 = 0; n7 < n2; ++n7) {
                n5 += nArray[n7];
            }
            for (n7 = 0; n7 < n; ++n7) {
                n6 += nArray2[n7];
            }
        } else {
            n5 = n3 * n2;
            n6 = n4 * n;
        }
        Insets insets = container.getInsets();
        return new Dimension(insets.left + insets.right + n5 + (n2 - 1) * this.hgap, insets.top + insets.bottom + n6 + (n - 1) * this.vgap);
    }

    protected int getComponentCellHeight(int n) {
        if (this.cellSizing == 21) {
            return this.rowHeight[n];
        }
        return this.largestHeight;
    }

    protected int getComponentCellWidth(int n) {
        if (this.cellSizing == 21) {
            return this.colWidth[n];
        }
        return this.largestWidth;
    }

    protected void positionComponentInCell(Component component, int n, int n2, int n3, int n4) {
        int n5 = this.fill == 3 || this.fill == 0 ? (int)component.getPreferredSize().getWidth() : n3;
        int n6 = this.fill == 2 || this.fill == 0 ? (int)component.getPreferredSize().getHeight() : n4;
        int n7 = this.fill == 1 || this.fill == 2 || this.anchor == 18 || this.anchor == 17 || this.anchor == 16 ? n : (this.anchor == 12 || this.anchor == 13 || this.anchor == 14 ? n + n3 - n5 : n + (n3 - n5) / 2);
        int n8 = this.fill == 1 || this.fill == 3 || this.anchor == 11 || this.anchor == 18 || this.anchor == 12 ? n2 : (this.anchor == 14 || this.anchor == 15 || this.anchor == 16 ? n2 + n4 - n6 : n2 + (n4 - n6) / 2);
        component.setBounds(n7, n8, n5, n6);
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int n) {
        if (n == 0 && this.cols == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.rows = n;
    }

    public int getColumns() {
        return this.cols;
    }

    public void setCols(int n) {
        if (n == 0 && this.rows == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.cols = n;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    protected void setLargestHeight(int n) {
        this.largestHeight = n;
    }

    protected int getLargestHeight() {
        return this.largestHeight;
    }

    protected void setLargestWidth(int n) {
        this.largestWidth = n;
    }

    protected int getLargestWidth() {
        return this.largestWidth;
    }

    protected void setColWidth(int[] nArray) {
        this.colWidth = nArray;
    }

    protected int[] getColWidth() {
        return this.colWidth;
    }

    protected void setRowHeight(int[] nArray) {
        this.rowHeight = nArray;
    }

    protected int[] getRowHeight() {
        return this.rowHeight;
    }

    int getCellSizing() {
        return this.cellSizing;
    }
}

