/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.swidgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.border.Border;
import org.tigris.swidgets.ArrowButton;
import org.tigris.swidgets.Orientation;
import org.tigris.swidgets.Vertical;

public class Horizontal
extends Orientation {
    private static final Horizontal HORIZONTAL = new Horizontal();

    protected Horizontal() {
    }

    public static Orientation getInstance() {
        return HORIZONTAL;
    }

    public Orientation getPerpendicular() {
        return Vertical.getInstance();
    }

    public int getLength(Dimension dimension) {
        return (int)dimension.getWidth();
    }

    public int getLength(Component component) {
        return component.getWidth();
    }

    public int getLengthMinusInsets(Container container) {
        Insets insets = container.getInsets();
        return container.getWidth() - (insets.left + insets.right);
    }

    public int getBreadth(Dimension dimension) {
        return (int)dimension.getHeight();
    }

    public int getBreadth(Component component) {
        return component.getHeight();
    }

    public int getPosition(Point point) {
        return (int)point.getX();
    }

    public int getPosition(Component component) {
        return component.getX();
    }

    public int getOffset(Point point) {
        return (int)point.getY();
    }

    public int getLastUsablePosition(Container container) {
        return container.getWidth() - container.getInsets().right;
    }

    public int getFirstUsableOffset(Container container) {
        return container.getInsets().left;
    }

    public Point newPoint(int n, int n2) {
        return new Point(n, n2);
    }

    public int getPosition(MouseEvent mouseEvent) {
        return mouseEvent.getX();
    }

    public Dimension addLength(Dimension dimension, int n) {
        double d = dimension.getWidth() + (double)n;
        double d2 = dimension.getHeight();
        return new Dimension((int)d, (int)d2);
    }

    public Dimension addLength(Dimension dimension, Dimension dimension2) {
        return this.addLength(dimension, this.getLength(dimension2));
    }

    public Dimension addLength(Dimension dimension, Component component) {
        return this.addLength(dimension, this.getLength(component.getSize()));
    }

    public Dimension subtractLength(Dimension dimension, int n) {
        return this.addLength(dimension, -n);
    }

    public Dimension subtractLength(Dimension dimension, Dimension dimension2) {
        return this.subtractLength(dimension, this.getLength(dimension2));
    }

    public Dimension subtractLength(Dimension dimension, Component component) {
        return this.subtractLength(dimension, this.getLength(component.getSize()));
    }

    public Point addToPosition(Point point, int n) {
        double d = point.getX() + (double)n;
        double d2 = point.getY();
        return new Point((int)d, (int)d2);
    }

    public Point addToPosition(Point point, Dimension dimension) {
        return this.addToPosition(point, this.getLength(dimension));
    }

    public Point addToPosition(Point point, Component component) {
        return this.addToPosition(point, this.getLength(component.getSize()));
    }

    public Point subtractFromPosition(Point point, int n) {
        return this.addToPosition(point, -n);
    }

    public Point subtractFromPosition(Point point, Dimension dimension) {
        return this.addToPosition(point, -this.getLength(dimension));
    }

    public Point subtractFromPosition(Point point, Component component) {
        return this.addToPosition(point, -this.getLength(component.getSize()));
    }

    public Dimension setLength(Dimension dimension, int n) {
        return new Dimension(n, (int)dimension.getHeight());
    }

    public Dimension setLength(Dimension dimension, Dimension dimension2) {
        return new Dimension((int)dimension2.getWidth(), (int)dimension.getHeight());
    }

    public Dimension setBreadth(Dimension dimension, int n) {
        return new Dimension((int)dimension.getWidth(), n);
    }

    public Dimension setBreadth(Dimension dimension, Dimension dimension2) {
        return new Dimension((int)dimension.getWidth(), (int)dimension2.getHeight());
    }

    public Point setPosition(Point point, int n) {
        return new Point(n, (int)point.getY());
    }

    public Cursor getCursor() {
        return new Cursor(10);
    }

    public ArrowButton getStartArrowButton() {
        return new ArrowButton(7, (Border)null);
    }

    public ArrowButton getEndArrowButton() {
        return new ArrowButton(3, (Border)null);
    }
}

