/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.notation2;

import java.util.ArrayList;
import java.util.List;
import org.argouml.notation2.NotatedItem;
import org.argouml.notation2.NotationLanguage;

public final class NotationManager {
    private static NotationManager instance = new NotationManager();
    private List<NotationLanguage> languages = new ArrayList<NotationLanguage>();
    private List<NotatedItem> items = new ArrayList<NotatedItem>();

    private NotationManager() {
    }

    public static NotationManager getInstance() {
        return instance;
    }

    public void addNotationLanguage(NotationLanguage language) {
        this.languages.add(language);
    }

    public void addListener(NotatedItem item) {
        NotationLanguage nl = item.getNotationLanguage();
        if (nl == null) {
            nl = this.languages.get(0);
        }
        nl.createNotationText(item);
        this.items.add(item);
    }

    public void removeListener(NotatedItem item) {
        this.items.remove(item);
    }
}

