/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import org.argouml.core.propertypanels.model.GetterSetterManager;
import org.argouml.i18n.Translator;
import org.argouml.model.Model;
import org.argouml.ui.LookAndFeelMgr;
import org.argouml.ui.UndoableAction;
import org.tigris.swidgets.FlexiGridLayout;

public class RadioButtonPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -3786246432442765208L;
    private final Object umlElement;
    private final String propertyName;
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final GetterSetterManager getterSetterManager;

    public RadioButtonPanel(Object umlElement, String propertyName, boolean horizontal, GetterSetterManager getterSetterManager) {
        super(true);
        this.setDoubleBuffered(true);
        Collection options = getterSetterManager.getOptions(umlElement, propertyName, null);
        this.setLayout(horizontal ? new BoxLayout(this, 0) : new FlexiGridLayout(0, options.size()));
        this.propertyName = propertyName;
        this.getterSetterManager = getterSetterManager;
        this.umlElement = umlElement;
        Font font = LookAndFeelMgr.getInstance().getStandardFont();
        String label = Translator.localize((String)("label." + propertyName));
        if (label != null) {
            TitledBorder border = new TitledBorder(label);
            border.setTitleFont(font);
            this.setBorder(border);
        }
        SetAction action = new SetAction(getterSetterManager, umlElement, propertyName);
        this.buttonGroup.add(new JRadioButton());
        for (Object option : options) {
            String optionLabel = Translator.localize((String)("label." + propertyName + "-" + option));
            JRadioButton button = new JRadioButton(optionLabel);
            button.addActionListener((ActionListener)((Object)action));
            button.setActionCommand((String)option);
            button.setFont(font);
            button.setName((String)option);
            this.buttonGroup.add(button);
            this.add(button);
        }
        this.build();
        Model.getPump().addModelEventListener((PropertyChangeListener)this, umlElement, propertyName);
    }

    public void removeNotify() {
        Model.getPump().removeModelEventListener((PropertyChangeListener)this, this.umlElement, this.propertyName);
        Enumeration<AbstractButton> en = this.buttonGroup.getElements();
        en.nextElement();
        while (en.hasMoreElements()) {
            JRadioButton b = (JRadioButton)en.nextElement();
            b.removeActionListener(b.getAction());
        }
    }

    private GetterSetterManager getGetterSetter() {
        return this.getterSetterManager;
    }

    public void setEnabled(boolean enabled) {
        for (Component component : this.getComponents()) {
            component.setEnabled(enabled);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals(this.propertyName)) {
            this.build();
        }
    }

    private void build() {
        String value = (String)this.getGetterSetter().get(this.umlElement, this.propertyName, null);
        Enumeration<AbstractButton> en = this.buttonGroup.getElements();
        if (value == null) {
            en.nextElement().setSelected(true);
            return;
        }
        while (en.hasMoreElements()) {
            AbstractButton b = en.nextElement();
            if (!value.equals(b.getActionCommand())) continue;
            b.setSelected(true);
            break;
        }
    }

    private static class SetAction
    extends UndoableAction {
        private final GetterSetterManager getterSetter;
        private final String propertyName;
        private Object modelElement;

        protected SetAction(GetterSetterManager getterSetter, Object modelElement, String propertyName) {
            this.modelElement = modelElement;
            this.getterSetter = getterSetter;
            this.propertyName = propertyName;
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            JRadioButton source = (JRadioButton)e.getSource();
            this.getterSetter.set(this.modelElement, source.getActionCommand(), this.propertyName);
        }
    }
}

