/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import org.argouml.application.helpers.ResourceLoaderWrapper;
import org.argouml.core.propertypanels.model.IconIdentifiable;
import org.argouml.core.propertypanels.model.Named;
import org.argouml.core.propertypanels.ui.Expandable;
import org.argouml.core.propertypanels.ui.OldScrollList;
import org.argouml.core.propertypanels.ui.ScrollList;
import org.argouml.core.propertypanels.ui.ScrollListFactory;
import org.argouml.core.propertypanels.ui.ScrollListImpl;
import org.argouml.core.propertypanels.ui.SimpleListModel;
import org.argouml.core.propertypanels.ui.UMLModelElementListModel;
import org.argouml.core.propertypanels.ui.UmlControl;
import org.argouml.i18n.Translator;
import org.argouml.kernel.Command;
import org.argouml.kernel.Project;
import org.argouml.kernel.ProjectManager;
import org.argouml.model.Model;
import org.argouml.model.UmlHelper;
import org.argouml.ui.ActionCreateContainedModelElement;
import org.argouml.ui.UndoableAction;
import org.tigris.gef.presentation.FigTextEditor;
import org.tigris.toolbar.toolbutton.ToolBox;

class RowSelector
extends UmlControl
implements MouseListener,
ListDataListener,
ListSelectionListener,
Expandable {
    private static final Logger LOG = Logger.getLogger(RowSelector.class.getName());
    private static final long serialVersionUID = 3937183621483536749L;
    private final Object target;
    private final boolean readonly;
    private final List actions;
    private ScrollList scroll;
    private final Dimension shrunkPreferredSize;
    private final Dimension expandedPreferredSize;
    private final Dimension expandedMaximumSize;
    private final boolean expandable;
    private boolean expanded = false;
    private MovedModelElement movedModelElement = new MovedModelElement();
    private final DeleteAction deleteAction;
    private final Action removeAction;
    private final MoveUpAction moveUpAction;
    private final MoveDownAction moveDownAction;
    private final MoveTopAction moveTopAction;
    private final MoveBottomAction moveBottomAction;

    public RowSelector(DefaultListModel model) {
        this(model, false, true);
    }

    public RowSelector(DefaultListModel model, boolean expanded, boolean expandable) {
        super(new BorderLayout());
        AddAction addAction;
        String propertyName;
        this.expandable = expandable;
        Object metaType = null;
        List<Object> metaTypes = null;
        List<Action> newActions = null;
        List<Command> additionalNewCommands = null;
        if (model instanceof UMLModelElementListModel) {
            this.target = ((UMLModelElementListModel)model).getTarget();
            metaType = ((UMLModelElementListModel)model).getMetaType();
            propertyName = null;
            this.scroll = new OldScrollList(model, 1);
            this.readonly = Model.getModelManagementHelper().isReadOnly(this.target);
            metaTypes = null;
            newActions = ((UMLModelElementListModel)model).getNewActions();
        } else if (model instanceof SimpleListModel) {
            this.target = ((SimpleListModel)model).getUmlElement();
            propertyName = ((SimpleListModel)model).getPropertyName();
            metaType = ((SimpleListModel)model).getMetaType();
            metaTypes = ((SimpleListModel)model).getMetaTypes();
            additionalNewCommands = ((SimpleListModel)model).getAdditionalCommands();
            this.scroll = new ScrollListImpl(model, 1);
            this.readonly = Model.getModelManagementHelper().isReadOnly(this.target);
        } else {
            propertyName = null;
            this.target = null;
            this.readonly = true;
        }
        assert (this.target != null);
        if (metaTypes == null) {
            metaTypes = new ArrayList();
            metaTypes.add(metaType);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Creating list for {0}", this.target);
            LOG.log(Level.FINE, "model = {0}", model.getClass().getName());
            LOG.log(Level.FINE, "metatype = {0}", metaType);
            LOG.log(Level.FINE, "target = {0}", this.target);
        }
        this.add((JComponent)((Object)this.scroll));
        this.shrunkPreferredSize = ((JComponent)((Object)this.scroll)).getPreferredSize();
        this.remove((JComponent)((Object)this.scroll));
        this.scroll = ScrollListFactory.create(model);
        JScrollPane jscroll = (JScrollPane)((Object)this.scroll);
        this.add(jscroll);
        this.expandedPreferredSize = jscroll.getPreferredSize();
        this.expandedMaximumSize = jscroll.getMaximumSize();
        jscroll.setHorizontalScrollBarPolicy(31);
        if (model instanceof SimpleListModel && ((SimpleListModel)model).getAddCommand() != null) {
            this.removeAction = new RemoveAction(this.scroll.getList(), (SimpleListModel)model);
            addAction = new AddAction(((SimpleListModel)model).getAddCommand());
        } else {
            this.removeAction = null;
            addAction = null;
        }
        this.actions = new ArrayList(6);
        if (!expandable && !expanded) {
            jscroll.setVerticalScrollBarPolicy(21);
            this.deleteAction = null;
            this.moveUpAction = null;
            this.moveDownAction = null;
            this.moveTopAction = null;
            this.moveBottomAction = null;
            if (!this.readonly) {
                for (Object e : metaTypes) {
                    if (!Model.getUmlFactory().isContainmentValid(e, this.target)) continue;
                    String string = "button.new-" + Model.getMetaTypes().getName(e).toLowerCase();
                    ActionCreateContainedModelElement createAction = new ActionCreateContainedModelElement(e, this.target, propertyName, string);
                    this.actions.add(createAction);
                }
                if (newActions != null) {
                    this.actions.addAll(newActions);
                }
                if (additionalNewCommands != null && !additionalNewCommands.isEmpty()) {
                    for (Command command : additionalNewCommands) {
                        if (command instanceof IconIdentifiable && command instanceof Named) {
                            this.actions.add(new CommandAction(command, ((Named)command).getName(), ((IconIdentifiable)command).getIcon()));
                            continue;
                        }
                        this.actions.add(new CommandAction(command));
                    }
                }
                if (!this.actions.isEmpty()) {
                    JPanel buttonPanel = this.createSingleButtonPanel(this.actions);
                    this.add((Component)buttonPanel, "West");
                }
            }
        } else {
            if (!this.readonly) {
                if (addAction != null) {
                    this.actions.add(addAction);
                }
                if (this.removeAction != null) {
                    this.actions.add(this.removeAction);
                    this.deleteAction = null;
                } else {
                    this.deleteAction = new DeleteAction();
                    this.actions.add(this.deleteAction);
                }
                ArrayList<Object> createActions = new ArrayList<Object>();
                for (Object e : metaTypes) {
                    if (!Model.getUmlFactory().isContainmentValid(e, this.target)) continue;
                    String label = "button.new-" + Model.getMetaTypes().getName(e).toLowerCase();
                    ActionCreateContainedModelElement createAction = new ActionCreateContainedModelElement(e, this.target, label);
                    createActions.add(createAction);
                }
                if (additionalNewCommands != null && !additionalNewCommands.isEmpty()) {
                    for (Command command : additionalNewCommands) {
                        if (command instanceof IconIdentifiable && command instanceof Named) {
                            createActions.add((Object)new CommandAction(command, ((Named)command).getName(), ((IconIdentifiable)command).getIcon()));
                            continue;
                        }
                        createActions.add((Object)new CommandAction(command));
                    }
                }
                if (createActions.size() > 2) {
                    this.actions.add(createActions.toArray());
                } else {
                    this.actions.addAll(createActions);
                }
                if (Model.getUmlHelper().isMovable(metaType)) {
                    this.moveUpAction = new MoveUpAction();
                    this.moveDownAction = new MoveDownAction();
                    this.moveTopAction = new MoveTopAction();
                    this.moveBottomAction = new MoveBottomAction();
                } else {
                    this.moveUpAction = null;
                    this.moveDownAction = null;
                    this.moveTopAction = null;
                    this.moveBottomAction = null;
                }
            } else {
                this.moveUpAction = null;
                this.moveDownAction = null;
                this.moveTopAction = null;
                this.moveBottomAction = null;
                this.deleteAction = null;
            }
            this.addMouseListener(this);
            if (!Model.getModelManagementHelper().isReadOnly(this.target)) {
                if (this.deleteAction != null) {
                    this.getList().addListSelectionListener(this.deleteAction);
                }
                if (this.removeAction != null) {
                    this.getList().addListSelectionListener(this);
                }
                if (Model.getUmlHelper().isMovable(metaType)) {
                    this.getList().addListSelectionListener(this.moveUpAction);
                    this.getList().addListSelectionListener(this.moveDownAction);
                    this.getList().addListSelectionListener(this.moveTopAction);
                    this.getList().addListSelectionListener(this.moveBottomAction);
                }
            }
            this.getList().addMouseListener(this);
            this.getModel().addListDataListener(this);
        }
    }

    public Dimension getMinimumSize() {
        return this.shrunkPreferredSize;
    }

    public Dimension getMaximumSize() {
        Dimension size = super.getMaximumSize();
        size.height = this.expanded ? this.expandedMaximumSize.height : this.shrunkPreferredSize.height;
        return size;
    }

    public Dimension getPreferredSize() {
        if (this.expanded) {
            return this.expandedPreferredSize;
        }
        return this.shrunkPreferredSize;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JPopupMenu popup = new JPopupMenu();
            for (Object action : this.actions) {
                if (!(action instanceof Action)) continue;
                popup.add((Action)action);
            }
            if (this.moveTopAction != null) {
                popup.add((Action)((Object)this.moveTopAction));
                popup.add((Action)((Object)this.moveBottomAction));
                popup.add((Action)((Object)this.moveUpAction));
                popup.add((Action)((Object)this.moveDownAction));
            }
            if (popup.getComponentCount() > 0) {
                popup.show(this, e.getX(), e.getY());
            }
            e.consume();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JPopupMenu popup = new JPopupMenu();
            for (Object action : this.actions) {
                if (!(action instanceof Action)) continue;
                popup.add((Action)action);
            }
            if (this.moveTopAction != null) {
                popup.add((Action)((Object)this.moveTopAction));
                popup.add((Action)((Object)this.moveBottomAction));
                popup.add((Action)((Object)this.moveUpAction));
                popup.add((Action)((Object)this.moveDownAction));
            }
            if (popup.getComponentCount() > 0) {
                popup.show(this, e.getX(), e.getY());
            }
            e.consume();
        }
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public JComponent getExpansion() {
        int i;
        ArrayList<Action> flatActions = new ArrayList<Action>();
        for (Object o : this.actions) {
            if (o instanceof Action) {
                flatActions.add((Action)o);
                continue;
            }
            Object[] oa = (Object[])o;
            for (int j = 0; j < oa.length; ++j) {
                flatActions.add((Action)oa[j]);
            }
        }
        ToolBox tb = new ToolBox(2, flatActions.size() / 2 + flatActions.size() % 2, true);
        for (i = 0; i < flatActions.size() / 2 + flatActions.size() % 2; ++i) {
            tb.add((Action)flatActions.get(i));
        }
        if (this.moveUpAction != null) {
            tb.add((Action)((Object)this.moveUpAction));
        }
        if (this.moveTopAction != null) {
            tb.add((Action)((Object)this.moveTopAction));
        }
        if (flatActions.size() % 2 == 1) {
            tb.add((Component)new JPanel());
        }
        for (i = flatActions.size() / 2 + flatActions.size() % 2; i < flatActions.size(); ++i) {
            tb.add((Action)flatActions.get(i));
        }
        if (this.moveDownAction != null) {
            tb.add((Action)((Object)this.moveDownAction));
        }
        if (this.moveBottomAction != null) {
            tb.add((Action)((Object)this.moveBottomAction));
        }
        JPanel expander = new JPanel(new FlowLayout(2));
        expander.add((Component)tb);
        return expander;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean isExpandable() {
        return this.expandable;
    }

    public void removeNotify() {
        if (!this.readonly) {
            this.getList().removeListSelectionListener(this);
            this.getList().removeListSelectionListener(this.deleteAction);
            if (this.moveUpAction != null) {
                this.getList().removeListSelectionListener(this.moveUpAction);
                this.getList().removeListSelectionListener(this.moveDownAction);
                this.getList().removeListSelectionListener(this.moveTopAction);
                this.getList().removeListSelectionListener(this.moveBottomAction);
                this.getList().removeMouseListener(this);
            }
        }
        this.removeMouseListener(this);
        this.getModel().removeListDataListener(this);
        if (this.getModel() instanceof UMLModelElementListModel) {
            ((UMLModelElementListModel)this.getModel()).removeModelEventListener();
        } else {
            ((SimpleListModel)this.getModel()).removeModelEventListener();
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.scroll.getList().addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.scroll.getList().removeListSelectionListener(listener);
    }

    JList getList() {
        return this.scroll.getList();
    }

    public void clearSelection() {
        this.getList().clearSelection();
    }

    private ListModel getModel() {
        return this.scroll.getList().getModel();
    }

    public void contentsChanged(ListDataEvent e) {
    }

    public void intervalAdded(ListDataEvent e) {
        if (e.getIndex0() == e.getIndex1() && this.getModel().getElementAt(e.getIndex0()) == this.movedModelElement.getElement()) {
            LOG.log(Level.INFO, "Setting attribute to selected");
            final Object element = this.movedModelElement.getElement();
            this.movedModelElement.setElement(null);
            this.getList().setSelectedValue(element, true);
            Runnable doWorkRunnable = new Runnable(){

                public void run() {
                    RowSelector.this.getList().setSelectedValue(element, true);
                }
            };
            SwingUtilities.invokeLater(doWorkRunnable);
        }
    }

    public void intervalRemoved(ListDataEvent e) {
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.removeAction != null) {
            this.removeAction.setEnabled(this.getList().getSelectedIndex() > -1);
        }
    }

    private static class CommandAction
    extends UndoableAction {
        private final Command command;

        public CommandAction(Command cmd) {
            super("", (Icon)ResourceLoaderWrapper.lookupIcon((String)"Remove"));
            this.command = cmd;
        }

        public CommandAction(Command cmd, String name, Icon icon) {
            super(name, icon);
            this.command = cmd;
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            this.command.execute();
        }
    }

    private static class RemoveAction
    extends UndoableAction {
        private final SimpleListModel simpleListModel;
        private final JList list;

        public RemoveAction(JList list, SimpleListModel model) {
            super("", (Icon)ResourceLoaderWrapper.lookupIcon((String)"Remove"));
            this.simpleListModel = model;
            this.list = list;
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            Object objectToRemove = this.list.getSelectedValue();
            if (objectToRemove != null) {
                Command command = this.simpleListModel.getRemoveCommand(objectToRemove);
                command.execute();
            } else {
                LOG.log(Level.WARNING, "No selected object was found in the list control - we shouldn't be able to get here");
            }
        }
    }

    private static class AddAction
    extends UndoableAction {
        private Command command;

        public AddAction(Command command) {
            super("", (Icon)ResourceLoaderWrapper.lookupIcon((String)"Add"));
            this.command = command;
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            this.command.execute();
        }
    }

    private class MovedModelElement {
        private Object element;

        private MovedModelElement() {
        }

        public Object getElement() {
            return this.element;
        }

        public void setElement(Object element) {
            LOG.log(Level.INFO, "Setting moved model element to {0}", element);
            this.element = element;
        }
    }

    private class MoveBottomAction
    extends UndoableAction
    implements ListSelectionListener {
        private static final long serialVersionUID = -3459350012282215204L;

        MoveBottomAction() {
            super(Translator.localize((String)"menu.popup.movetobottom"), (Icon)ResourceLoaderWrapper.lookupIconResource((String)"MoveBottom"));
            this.setEnabled(false);
        }

        public void valueChanged(ListSelectionEvent e) {
            int index = RowSelector.this.getList().getSelectedIndex();
            this.setEnabled(index > -1 && index < RowSelector.this.getModel().getSize() - 1);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            RowSelector.this.movedModelElement.setElement(RowSelector.this.getList().getSelectedValues()[0]);
            assert (RowSelector.this.movedModelElement != null);
            Model.getUmlHelper().move(RowSelector.this.target, RowSelector.this.movedModelElement.getElement(), UmlHelper.Direction.BOTTOM);
        }
    }

    private class MoveTopAction
    extends UndoableAction
    implements ListSelectionListener {
        private static final long serialVersionUID = -2767622732024791396L;

        MoveTopAction() {
            super(Translator.localize((String)"menu.popup.movetotop"), (Icon)ResourceLoaderWrapper.lookupIconResource((String)"MoveTop"));
            this.setEnabled(false);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(RowSelector.this.getList().getSelectedIndex() > 0);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            RowSelector.this.movedModelElement.setElement(RowSelector.this.getList().getSelectedValues()[0]);
            assert (RowSelector.this.movedModelElement != null);
            Model.getUmlHelper().move(RowSelector.this.target, RowSelector.this.movedModelElement.getElement(), UmlHelper.Direction.TOP);
        }
    }

    private class MoveDownAction
    extends UndoableAction
    implements ListSelectionListener {
        private static final long serialVersionUID = -4898882853644454510L;

        MoveDownAction() {
            super(Translator.localize((String)"menu.popup.movedown"), (Icon)ResourceLoaderWrapper.lookupIconResource((String)"MoveDown"));
            this.setEnabled(false);
        }

        public void valueChanged(ListSelectionEvent e) {
            int index = RowSelector.this.getList().getSelectedIndex();
            this.setEnabled(index > -1 && index < RowSelector.this.getModel().getSize() - 1);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            RowSelector.this.movedModelElement.setElement(RowSelector.this.getList().getSelectedValues()[0]);
            assert (RowSelector.this.movedModelElement != null);
            Model.getUmlHelper().move(RowSelector.this.target, RowSelector.this.movedModelElement.getElement(), UmlHelper.Direction.DOWN);
        }
    }

    private class MoveUpAction
    extends UndoableAction
    implements ListSelectionListener {
        private static final long serialVersionUID = 92834374054221267L;

        MoveUpAction() {
            super(Translator.localize((String)"menu.popup.moveup"), (Icon)ResourceLoaderWrapper.lookupIconResource((String)"MoveUp"));
            this.setEnabled(false);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(RowSelector.this.getList().getSelectedIndex() > 0);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            RowSelector.this.movedModelElement.setElement(RowSelector.this.getList().getSelectedValues()[0]);
            assert (RowSelector.this.movedModelElement != null);
            Model.getUmlHelper().move(RowSelector.this.target, RowSelector.this.movedModelElement.getElement(), UmlHelper.Direction.UP);
        }
    }

    private class DeleteAction
    extends UndoableAction
    implements ListSelectionListener {
        private static final long serialVersionUID = -1466007194555518247L;

        public DeleteAction() {
            super(Translator.localize((String)"menu.popup.delete"), (Icon)ResourceLoaderWrapper.lookupIconResource((String)"DeleteFromModel"));
            this.setEnabled(false);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(RowSelector.this.getList().getSelectedIndex() > -1);
        }

        public void actionPerformed(ActionEvent ae) {
            TableCellEditor ce;
            JTable table;
            super.actionPerformed(ae);
            KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component focusOwner = focusManager.getFocusOwner();
            if (focusOwner instanceof FigTextEditor) {
                ((FigTextEditor)focusOwner).endEditing();
            } else if (focusOwner instanceof JTable && (table = (JTable)focusOwner).isEditing() && (ce = table.getCellEditor()) != null) {
                ce.cancelCellEditing();
            }
            Project p = ProjectManager.getManager().getCurrentProject();
            Object[] selectedValues = RowSelector.this.getList().getSelectedValues();
            p.moveToTrash(Arrays.asList(selectedValues));
        }
    }
}

