/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import org.argouml.application.helpers.ResourceLoaderWrapper;
import org.argouml.core.propertypanels.model.CheckBoxData;
import org.argouml.core.propertypanels.model.ControlData;
import org.argouml.core.propertypanels.model.GetterSetterManager;
import org.argouml.core.propertypanels.model.PanelData;
import org.argouml.core.propertypanels.ui.CheckBox;
import org.argouml.core.propertypanels.ui.ExpressionBodyField;
import org.argouml.core.propertypanels.ui.ExpressionLanguageField;
import org.argouml.core.propertypanels.ui.ExpressionModel;
import org.argouml.core.propertypanels.ui.LabelledComponent;
import org.argouml.core.propertypanels.ui.LabelledLayout;
import org.argouml.core.propertypanels.ui.ListFactory;
import org.argouml.core.propertypanels.ui.NavigateNextAction;
import org.argouml.core.propertypanels.ui.NavigatePreviousAction;
import org.argouml.core.propertypanels.ui.NavigateUpAction;
import org.argouml.core.propertypanels.ui.RadioButtonPanel;
import org.argouml.core.propertypanels.ui.SingleListFactory;
import org.argouml.core.propertypanels.ui.UMLActivityGraphContextComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLAssociationEndTypeComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLAssociationRoleBaseComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLCallActionOperationComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLCallEventOperationComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLChangeExpressionModel;
import org.argouml.core.propertypanels.ui.UMLCollaborationRepresentedClassifierComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLCollaborationRepresentedOperationComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLComboBox;
import org.argouml.core.propertypanels.ui.UMLComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLComboBoxNavigator;
import org.argouml.core.propertypanels.ui.UMLCommentBodyDocument;
import org.argouml.core.propertypanels.ui.UMLComponentInstanceClassifierComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLConditionExpressionModel;
import org.argouml.core.propertypanels.ui.UMLDefaultValueExpressionModel;
import org.argouml.core.propertypanels.ui.UMLDiscriminatorNameDocument;
import org.argouml.core.propertypanels.ui.UMLExpressionBodyField;
import org.argouml.core.propertypanels.ui.UMLExpressionExpressionModel;
import org.argouml.core.propertypanels.ui.UMLExpressionModel;
import org.argouml.core.propertypanels.ui.UMLExpressionPanel;
import org.argouml.core.propertypanels.ui.UMLExtensionPointLocationDocument;
import org.argouml.core.propertypanels.ui.UMLGeneralizationPowertypeComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLInitialValueExpressionModel;
import org.argouml.core.propertypanels.ui.UMLLinkAssociationComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLMessageActivatorComboBox;
import org.argouml.core.propertypanels.ui.UMLMessageActivatorComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLMetaClassComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLMethodSpecificationComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLModelElementNameDocument;
import org.argouml.core.propertypanels.ui.UMLModelElementNamespaceComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLMultiplicityPanel;
import org.argouml.core.propertypanels.ui.UMLOperationSpecificationDocument;
import org.argouml.core.propertypanels.ui.UMLPlainTextDocument;
import org.argouml.core.propertypanels.ui.UMLRecurrenceExpressionModel;
import org.argouml.core.propertypanels.ui.UMLScriptExpressionModel;
import org.argouml.core.propertypanels.ui.UMLSearchableComboBox;
import org.argouml.core.propertypanels.ui.UMLSignalComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLStateMachineContextComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLStructuralFeatureTypeComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLStubStateComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLSubmachineStateComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLSynchStateBoundDocument;
import org.argouml.core.propertypanels.ui.UMLTemplateParameterDefaultElementComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLTemplateParameterParameterComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLTextArea;
import org.argouml.core.propertypanels.ui.UMLTextField;
import org.argouml.core.propertypanels.ui.UMLTimeExpressionModel;
import org.argouml.core.propertypanels.ui.UMLTransitionTriggerComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLValueSpecificationModel;
import org.argouml.core.propertypanels.ui.UMLValueSpecificationPanelOptional;
import org.argouml.core.propertypanels.ui.XMLPropPanelFactory;
import org.argouml.i18n.Translator;
import org.argouml.model.Model;
import org.argouml.ui.ActionCreateContainedModelElement;
import org.argouml.uml.ui.ActionDeleteModelElements;
import org.argouml.uml.ui.foundation.extension_mechanisms.ActionNewStereotype;
import org.tigris.toolbar.ToolBarFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SwingUIFactory {
    private static final Logger LOG = Logger.getLogger(SwingUIFactory.class.getName());

    public void createGUI(Object target, JPanel panel) throws Exception {
        PanelData panelData = XMLPropPanelFactory.getInstance().getPropertyPanelsData(target.getClass());
        if (panelData == null) {
            panel.add(new JLabel("There is no panel configured for " + target.getClass()));
            LOG.log(Level.SEVERE, "No panel found for " + target.getClass());
            return;
        }
        this.createLabel(target, panelData, panel);
        for (ControlData prop : panelData.getProperties()) {
            try {
                this.createControl(target, panel, prop);
            }
            catch (Exception e) {
                String message = "Exception caught building control " + prop.getControlType() + " for property " + prop.getPropertyName() + " on panel for " + target;
                LOG.log(Level.SEVERE, message, e);
                try {
                    panel.add(new JLabel(message));
                }
                catch (Exception ex) {
                    throw e;
                }
            }
        }
    }

    private void createControl(Object target, JPanel panel, ControlData prop) throws Exception {
        if ("text".equals(prop.getControlType())) {
            this.buildTextboxPanel(panel, target, prop);
        } else if ("combo".equals(prop.getControlType())) {
            this.buildComboPanel(panel, target, prop);
        } else if ("checkgroup".equals(prop.getControlType())) {
            this.buildCheckGroup(panel, target, prop);
        } else if ("optionbox".equals(prop.getControlType())) {
            this.buildOptionBox(panel, target, prop);
        } else if ("singlerow".equals(prop.getControlType())) {
            this.buildSingleRow(panel, target, prop);
        } else if ("list".equals(prop.getControlType())) {
            this.buildList(panel, target, prop);
        } else if ("textarea".equals(prop.getControlType())) {
            this.buildTextArea(panel, target, prop);
        } else if ("separator".equals(prop.getControlType())) {
            panel.add(LabelledLayout.getSeparator());
        }
    }

    private void createLabel(Object target, PanelData panelData, JPanel panel) {
        String label;
        String metaTypeName = Model.getMetaTypes().getName(target);
        ToolBarFactory tbf = new ToolBarFactory(new Object[0]);
        tbf.setRollover(true);
        JToolBar tb = tbf.createToolBar();
        if (Model.getFacade().isAPseudostate(target)) {
            Object pseudostateKind = Model.getFacade().getKind(target);
            label = Model.getFacade().getName(pseudostateKind);
        } else {
            label = metaTypeName;
        }
        tb.add(new JLabel(label, ResourceLoaderWrapper.lookupIconResource((String)label), 2));
        if (!Model.getModelManagementHelper().isReadOnly(target)) {
            tb.add(new NavigateUpAction(target));
            if (panelData.isSiblingNavigation()) {
                tb.add(new NavigatePreviousAction(target));
                tb.add(new NavigateNextAction(target));
            }
            tb.add((Action)new ActionDeleteModelElements());
            tb.add((Action)new ActionNewStereotype());
            this.addCreateButtons(target, tb, panelData.getNewChildElements());
            Object parent = Model.getFacade().getModelElementContainer(target);
            this.addCreateButtons(parent, tb, panelData.getNewSiblingElements());
        }
        panel.add(tb);
    }

    private void addCreateButtons(Object container, JToolBar tb, Collection<Class<?>> metaTypes) {
        if (container != null) {
            for (Class<?> metaType : metaTypes) {
                if (!Model.getUmlFactory().isContainmentValid(metaType, container)) continue;
                tb.add((Action)new ActionCreateContainedModelElement(metaType, container));
            }
        }
    }

    private void buildTextArea(JPanel panel, Object target, ControlData prop) {
        UMLPlainTextDocument document;
        PropertyChangeListener model;
        JPanel p = new JPanel();
        JComponent control = null;
        String propertyName = prop.getPropertyName();
        Class<?> type = prop.getType();
        TitledBorder border = new TitledBorder(propertyName);
        p.setBorder(border);
        if ("initialValue".equals(propertyName)) {
            if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
                model = new UMLInitialValueExpressionModel(target);
                p = new UMLExpressionPanel((UMLExpressionModel)model, propertyName);
            } else {
                model = new UMLValueSpecificationModel(target, "initialValue");
                p = new UMLValueSpecificationPanelOptional((UMLValueSpecificationModel)model, propertyName);
            }
            control = p;
        } else if ("defaultValue".equals(propertyName)) {
            model = new UMLDefaultValueExpressionModel(target);
            control = p = new UMLExpressionPanel((UMLExpressionModel)model, propertyName);
        } else if ("specification".equals(propertyName)) {
            document = new UMLOperationSpecificationDocument(propertyName, target);
            UMLTextArea osta = new UMLTextArea(document);
            osta.setRows(3);
            control = new JScrollPane(osta);
        } else if ("body".equals(propertyName) && type == String.class) {
            document = new UMLCommentBodyDocument(propertyName, target);
            UMLTextArea text = new UMLTextArea(document);
            text.setLineWrap(true);
            text.setRows(5);
            control = new JScrollPane(text);
        } else if ("condition".equals(propertyName)) {
            UMLConditionExpressionModel conditionModel = new UMLConditionExpressionModel(target);
            UMLExpressionBodyField conditionArea = new UMLExpressionBodyField(conditionModel, true);
            conditionArea.setRows(5);
            control = new JScrollPane(conditionArea);
        } else if ("script".equals(propertyName)) {
            UMLScriptExpressionModel scriptModel = new UMLScriptExpressionModel(target);
            control = p = new UMLExpressionPanel(scriptModel, prop.getPropertyName());
        } else if ("recurrence".equals(propertyName)) {
            UMLRecurrenceExpressionModel recurrenceModel = new UMLRecurrenceExpressionModel(target);
            control = p = new UMLExpressionPanel(recurrenceModel, propertyName);
        } else if ("expression".equals(propertyName)) {
            model = new UMLExpressionExpressionModel(target);
            control = p = new UMLExpressionPanel((UMLExpressionModel)model, propertyName);
        } else if ("changeExpression".equals(propertyName)) {
            model = new UMLChangeExpressionModel(target);
            control = p = new UMLExpressionPanel((UMLExpressionModel)model, propertyName);
        } else if ("when".equals(propertyName)) {
            model = new UMLTimeExpressionModel(target);
            control = p = new UMLExpressionPanel((UMLExpressionModel)model, propertyName);
        }
        if (control != null) {
            if (control == p) {
                this.addControl(panel, null, control, target);
            } else {
                this.addControl(panel, Translator.localize((String)prop.getLabel()), control, target);
            }
        } else {
            GetterSetterManager getterSetter = GetterSetterManager.getGetterSetter(prop.getType());
            if (getterSetter.contains(propertyName)) {
                ExpressionModel model2 = new ExpressionModel(propertyName, prop.getTypes().get(0), target, getterSetter);
                ExpressionLanguageField languageField = new ExpressionLanguageField(model2);
                this.addControl(panel, Translator.localize((String)"label.language"), languageField, target);
                control = new JScrollPane(new ExpressionBodyField(model2));
                this.addControl(panel, null, control, target);
            }
        }
    }

    private void buildSingleRow(JPanel panel, Object target, ControlData prop) {
        SingleListFactory factory = new SingleListFactory();
        JComponent pane = factory.createComponent(target, prop.getPropertyName(), prop.getTypes());
        if (pane != null) {
            this.addControl(panel, Translator.localize((String)prop.getLabel()), pane, target);
        }
    }

    private void buildList(JPanel panel, Object target, ControlData prop) {
        ListFactory factory = new ListFactory();
        JComponent list = factory.createComponent(target, prop.getPropertyName(), prop.getTypes());
        if (list != null) {
            this.addControl(panel, Translator.localize((String)prop.getLabel()), list, target);
        }
    }

    private void buildOptionBox(JPanel panel, Object target, ControlData prop) {
        String propertyName = prop.getPropertyName();
        if (Model.getFacade().getUmlVersion().charAt(0) != '1' && "aggregation".equals(propertyName) && !Model.getFacade().isAAssociationEnd(target)) {
            return;
        }
        GetterSetterManager getterSetter = GetterSetterManager.getGetterSetter(prop.getType());
        if (getterSetter.contains(propertyName)) {
            RadioButtonPanel control = new RadioButtonPanel(target, propertyName, true, getterSetter);
            this.addControl(panel, null, control, target);
        }
    }

    private void buildCheckGroup(JPanel panel, Object target, ControlData prop) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        TitledBorder border = new TitledBorder(prop.getPropertyName());
        p.setBorder(border);
        if ("modifiers".equals(prop.getPropertyName())) {
            for (CheckBoxData data : prop.getCheckboxes()) {
                this.buildCheckBox(p, target, data);
            }
        }
        this.addControl(panel, null, p, target);
    }

    private void buildCheckBox(JPanel panel, Object target, CheckBoxData prop) {
        String propertyName = prop.getPropertyName();
        GetterSetterManager getterSetter = GetterSetterManager.getGetterSetter(prop.getType());
        String label = Translator.localize((String)prop.getLabel());
        if (getterSetter.contains(propertyName)) {
            CheckBox cb = new CheckBox(label, target, propertyName, getterSetter);
            if (Model.getModelManagementHelper().isReadOnly(target)) {
                cb.setEnabled(false);
            }
            panel.add(cb);
        }
    }

    private void buildComboPanel(JPanel panel, Object target, ControlData prop) {
        JComponent comp = null;
        String propertyName = prop.getPropertyName();
        if ("namespace".equals(prop.getPropertyName())) {
            UMLModelElementNamespaceComboBoxModel model = new UMLModelElementNamespaceComboBoxModel(propertyName, target);
            UMLSearchableComboBox combo = new UMLSearchableComboBox(model, ((UMLComboBoxModel)model).getAction(), true);
            comp = new UMLComboBoxNavigator(Translator.localize((String)"label.namespace.navigate.tooltip"), combo);
        } else if ("type".equals(prop.getPropertyName())) {
            UMLStructuralFeatureTypeComboBoxModel model = Model.getFacade().isATemplateParameter(target) ? new UMLStructuralFeatureTypeComboBoxModel(propertyName, Model.getFacade().getParameter(target)) : new UMLStructuralFeatureTypeComboBoxModel(propertyName, target);
            comp = new UMLComboBox(model);
        } else if ("base".equals(prop.getPropertyName())) {
            if (Model.getFacade().isAAssociationRole(target)) {
                UMLAssociationRoleBaseComboBoxModel model = new UMLAssociationRoleBaseComboBoxModel(propertyName, target);
                UMLSearchableComboBox combo = new UMLSearchableComboBox(model, ((UMLComboBoxModel)model).getAction(), true);
                comp = new UMLComboBoxNavigator(Translator.localize((String)"label.association.navigate.tooltip"), combo);
            }
        } else if ("powertype".equals(prop.getPropertyName())) {
            UMLGeneralizationPowertypeComboBoxModel model = new UMLGeneralizationPowertypeComboBoxModel(propertyName, target);
            UMLComboBox combo = new UMLComboBox(model);
            comp = combo;
        } else if ("multiplicity".equals(prop.getPropertyName())) {
            UMLMultiplicityPanel mPanel = new UMLMultiplicityPanel(propertyName, target);
            comp = mPanel;
        } else if ("activator".equals(prop.getPropertyName())) {
            UMLMessageActivatorComboBoxModel model = new UMLMessageActivatorComboBoxModel(propertyName, target);
            UMLMessageActivatorComboBox combo = new UMLMessageActivatorComboBox((UMLComboBoxModel)model, ((UMLComboBoxModel)model).getAction());
            comp = combo;
        } else if ("operation".equals(prop.getPropertyName())) {
            if (Model.getFacade().isACallEvent(target)) {
                UMLCallEventOperationComboBoxModel model = new UMLCallEventOperationComboBoxModel(propertyName, target);
                UMLComboBox combo = new UMLComboBox(model);
                comp = new UMLComboBoxNavigator(Translator.localize((String)"label.operation.navigate.tooltip"), combo);
            } else {
                UMLCallActionOperationComboBoxModel model = new UMLCallActionOperationComboBoxModel(propertyName, target);
                UMLComboBox combo = new UMLComboBox(model);
                comp = new UMLComboBoxNavigator(Translator.localize((String)"label.operation.navigate.tooltip"), combo);
            }
        } else if ("classifier".equals(prop.getPropertyName())) {
            UMLComponentInstanceClassifierComboBoxModel model = new UMLComponentInstanceClassifierComboBoxModel(propertyName, target);
            UMLComboBox combo = new UMLComboBox(model);
            comp = new UMLComboBoxNavigator(Translator.localize((String)"label.component-instance.navigate.tooltip"), combo);
        } else if ("representedClassifier".equals(prop.getPropertyName())) {
            UMLCollaborationRepresentedClassifierComboBoxModel model = new UMLCollaborationRepresentedClassifierComboBoxModel(propertyName, target);
            UMLComboBox combo = new UMLComboBox(model);
            comp = new UMLComboBoxNavigator(Translator.localize((String)"label.represented-classifier.navigate.tooltip"), combo);
        } else if ("representedOperation".equals(prop.getPropertyName())) {
            UMLCollaborationRepresentedOperationComboBoxModel model = new UMLCollaborationRepresentedOperationComboBoxModel(propertyName, target);
            UMLComboBox combo = new UMLComboBox(model);
            comp = new UMLComboBoxNavigator(Translator.localize((String)"label.represented-operation.navigate.tooltip"), combo);
        } else if ("context".equals(prop.getPropertyName())) {
            UMLComboBoxModel model = Model.getFacade().isAActivityGraph(target) ? new UMLActivityGraphContextComboBoxModel(propertyName, target) : new UMLStateMachineContextComboBoxModel(propertyName, target);
            UMLComboBox combo = new UMLComboBox(model);
            comp = new UMLComboBoxNavigator(Translator.localize((String)"label.context.navigate.tooltip"), combo);
        } else if ("association".equals(prop.getPropertyName())) {
            UMLLinkAssociationComboBoxModel model = new UMLLinkAssociationComboBoxModel(propertyName, target);
            comp = new UMLComboBoxNavigator(Translator.localize((String)"label.association.navigate.tooltip"), new UMLSearchableComboBox(model, ((UMLComboBoxModel)model).getAction(), true));
        } else if ("participant".equals(prop.getPropertyName())) {
            UMLAssociationEndTypeComboBoxModel model = new UMLAssociationEndTypeComboBoxModel(propertyName, target);
            comp = new UMLComboBox(model, true);
        } else if ("submachine".equals(prop.getPropertyName())) {
            UMLSubmachineStateComboBoxModel model = new UMLSubmachineStateComboBoxModel(propertyName, target);
            UMLComboBox submachineBox = new UMLComboBox(model);
            comp = new UMLComboBoxNavigator(Translator.localize((String)"tooltip.nav-submachine"), submachineBox);
        } else if ("referenceState".equals(prop.getPropertyName())) {
            UMLStubStateComboBoxModel model = new UMLStubStateComboBoxModel(propertyName, target);
            UMLComboBox referencestateBox = new UMLComboBox(model);
            comp = new UMLComboBoxNavigator(Translator.localize((String)"tooltip.nav-stubstate"), referencestateBox);
        } else if ("tagType".equals(prop.getPropertyName())) {
            UMLMetaClassComboBoxModel model = new UMLMetaClassComboBoxModel(propertyName, target);
            UMLComboBox typeComboBox = new UMLComboBox(model);
            comp = new UMLComboBoxNavigator(Translator.localize((String)"label.type.navigate.tooltip"), typeComboBox);
            comp.setEnabled(false);
        } else if ("parameter".equals(prop.getPropertyName())) {
            UMLTemplateParameterParameterComboBoxModel model = new UMLTemplateParameterParameterComboBoxModel(target);
            UMLComboBox combo = new UMLComboBox(model);
            comp = new UMLComboBoxNavigator(Translator.localize((String)"label.type.navigate.tooltip"), combo);
        } else if ("defaultElement".equals(prop.getPropertyName())) {
            UMLTemplateParameterDefaultElementComboBoxModel model = new UMLTemplateParameterDefaultElementComboBoxModel(propertyName, target);
            UMLComboBox combo = new UMLComboBox(model);
            comp = new UMLComboBoxNavigator(Translator.localize((String)"label.type.navigate.tooltip"), combo);
        } else if ("signal".equals(prop.getPropertyName())) {
            UMLSignalComboBoxModel model = new UMLSignalComboBoxModel(propertyName, target);
            UMLComboBox combo = new UMLComboBox(model);
            comp = new UMLComboBoxNavigator(Translator.localize((String)"label.type.navigate.tooltip"), combo);
        } else if ("trigger".equals(prop.getPropertyName())) {
            UMLTransitionTriggerComboBoxModel model = new UMLTransitionTriggerComboBoxModel(propertyName, target);
            UMLComboBox combo = new UMLComboBox(model);
            comp = new UMLComboBoxNavigator(Translator.localize((String)"label.type.navigate.tooltip"), combo);
        } else if ("specification".equals(prop.getPropertyName())) {
            UMLMethodSpecificationComboBoxModel model = new UMLMethodSpecificationComboBoxModel(propertyName, target);
            UMLComboBox combo = new UMLComboBox(model);
            comp = new UMLComboBoxNavigator(Translator.localize((String)"label.type.navigate.tooltip"), combo);
        }
        if (comp != null) {
            this.addControl(panel, Translator.localize((String)prop.getLabel()), comp, target);
        }
    }

    private void buildTextboxPanel(JPanel panel, Object target, ControlData prop) {
        UMLPlainTextDocument document = null;
        if ("name".equals(prop.getPropertyName())) {
            if (Model.getFacade().isATemplateParameter(target)) {
                target = Model.getFacade().getParameter(target);
            }
            document = new UMLModelElementNameDocument(prop.getPropertyName(), target);
        } else if ("discriminator".equals(prop.getPropertyName())) {
            document = new UMLDiscriminatorNameDocument(prop.getPropertyName(), target);
        } else if ("location".equals(prop.getPropertyName())) {
            document = new UMLExtensionPointLocationDocument(prop.getPropertyName(), target);
        } else if ("bound".equals(prop.getPropertyName())) {
            document = new UMLSynchStateBoundDocument(prop.getPropertyName(), target);
        }
        if (document != null) {
            UMLTextField tfield = new UMLTextField(document);
            this.addControl(panel, Translator.localize((String)prop.getLabel()), tfield, target);
        }
    }

    private void addControl(JPanel panel, String text, JComponent component, Object target) {
        if (Model.getModelManagementHelper().isReadOnly(target)) {
            component.setEnabled(false);
        }
        LabelledComponent lc = new LabelledComponent(text, component);
        panel.add(lc);
    }
}

