/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.argouml.core.propertypanels.ui.UMLComboBoxModel;
import org.argouml.i18n.Translator;
import org.argouml.model.AttributeChangeEvent;
import org.argouml.model.Model;
import org.argouml.model.UmlChangeEvent;
import org.argouml.ui.UndoableAction;
import org.argouml.uml.ui.UMLComboBox2;

class UMLMethodSpecificationComboBoxModel
extends UMLComboBoxModel {
    public UMLMethodSpecificationComboBoxModel(String propertyName, Object target) {
        super(target, "specification", false);
        Model.getPump().addClassModelEventListener((PropertyChangeListener)this, Model.getMetaTypes().getOperation(), "method");
    }

    protected boolean isValidElement(Object element) {
        Object specification = Model.getCoreHelper().getSpecification(this.getTarget());
        return specification == element;
    }

    protected void buildModelList() {
        if (this.getTarget() != null) {
            this.removeAllElements();
            Object classifier = Model.getFacade().getOwner(this.getTarget());
            this.addAll(Model.getFacade().getOperations(classifier));
        }
    }

    protected Object getSelectedModelElement() {
        return Model.getCoreHelper().getSpecification(this.getTarget());
    }

    public void modelChanged(UmlChangeEvent evt) {
        if (evt instanceof AttributeChangeEvent && evt.getPropertyName().equals("specification") && evt.getSource() == this.getTarget() && this.getChangedElement((PropertyChangeEvent)evt) != null) {
            Object elem = this.getChangedElement((PropertyChangeEvent)evt);
            this.setSelectedItem(elem);
        }
    }

    public Action getAction() {
        return new ActionSetMethodSpecification();
    }

    private static class ActionSetMethodSpecification
    extends UndoableAction {
        protected ActionSetMethodSpecification() {
            super(Translator.localize((String)"Set"), null);
            this.putValue("ShortDescription", Translator.localize((String)"Set"));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            Object source = e.getSource();
            Object oldOperation = null;
            Object newOperation = null;
            Object method = null;
            if (source instanceof UMLComboBox2) {
                UMLComboBox2 box = (UMLComboBox2)source;
                Object o = box.getTarget();
                if (Model.getFacade().isAMethod(o)) {
                    method = o;
                    oldOperation = Model.getCoreHelper().getSpecification(method);
                }
                o = box.getSelectedItem();
                if (Model.getFacade().isAOperation(o)) {
                    newOperation = o;
                }
            }
            if (newOperation != oldOperation && method != null) {
                Model.getCoreHelper().setSpecification(method, newOperation);
            }
        }
    }
}

