/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.argouml.core.propertypanels.ui.UMLValueSpecificationModel;
import org.argouml.i18n.Translator;
import org.argouml.util.ArgoDialog;

class UMLValueSpecificationValueFieldOpaqueExpressionDialog
extends ArgoDialog {
    private static final long serialVersionUID = -5429439639242117770L;
    private UMLValueSpecificationModel model;
    private int currentIndexCall;
    private int currentIndex;
    private JTextField curLanguage;
    private JTextArea curBody;
    private JList list;
    private DefaultListModel listModel;

    public UMLValueSpecificationValueFieldOpaqueExpressionDialog(UMLValueSpecificationModel aModel, int currentIndex) {
        super("OpaqueExpression", true);
        this.model = aModel;
        this.currentIndexCall = currentIndex;
        this.currentIndex = currentIndex;
        this.setSize(450, 300);
        this.buildFirstPanel();
        this.updateFields();
    }

    private void buildFirstPanel() {
        JPanel contentPanel = new JPanel(new GridBagLayout());
        this.add(contentPanel);
        JLabel labelLangage = new JLabel(Translator.localize((String)"label.language.tooltip"));
        JLabel labelBody = new JLabel(Translator.localize((String)"label.body.tooltip"));
        this.curBody = new JTextArea();
        this.curBody.setToolTipText(Translator.localize((String)"label.body.tooltip"));
        this.curBody.setRows(2);
        JPanel languagePanel = this.buildLanguagePanel();
        JPanel paneBtn = this.buildBoutonPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.5;
        c.weighty = 0.0;
        contentPanel.add((Component)labelLangage, c);
        c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.5;
        c.weighty = 0.0;
        contentPanel.add((Component)labelBody, c);
        c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.anchor = 12;
        contentPanel.add((Component)languagePanel, c);
        c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 1;
        c.gridx = 2;
        c.gridy = 1;
        c.weightx = 0.5;
        c.weighty = 1.0;
        contentPanel.add((Component)this.curBody, c);
        c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 0;
        c.gridx = 1;
        c.gridy = 1;
        contentPanel.add((Component)paneBtn, c);
    }

    private JPanel buildBoutonPanel() {
        JPanel paneBtn = new JPanel(new GridBagLayout());
        JButton btnApply = new JButton(Translator.localize((String)"button.ok"));
        btnApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Object[] tabValues = (String[])UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.model.getValue();
                boolean bContinue = true;
                if (!UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.curLanguage.getText().equals(tabValues[2 * UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex + 1])) {
                    bContinue = UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.isUniqueLanguage((String[])tabValues, UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.curLanguage.getText());
                }
                if (bContinue) {
                    tabValues[2 * ((UMLValueSpecificationValueFieldOpaqueExpressionDialog)UMLValueSpecificationValueFieldOpaqueExpressionDialog.this).currentIndex] = UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.curBody.getText();
                    tabValues[2 * ((UMLValueSpecificationValueFieldOpaqueExpressionDialog)UMLValueSpecificationValueFieldOpaqueExpressionDialog.this).currentIndex + 1] = UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.curLanguage.getText();
                    UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.model.setValue(tabValues);
                    UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.updateFields();
                }
            }
        });
        JButton btnAdd = new JButton("+");
        btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                String[] tabValues = (String[])UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.model.getValue();
                int num = UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.getEmptyLanguage(tabValues);
                if (num == -1) {
                    Object[] newTabValues = new String[tabValues.length + 2];
                    System.arraycopy(tabValues, 0, newTabValues, 0, tabValues.length);
                    newTabValues[tabValues.length] = "";
                    newTabValues[tabValues.length + 1] = "";
                    UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.model.setValue(newTabValues);
                    UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex = newTabValues.length / 2 - 1;
                    UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.updateFields();
                } else {
                    UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex = num;
                    UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.updateFields();
                }
            }
        });
        JButton btnDel = new JButton("-");
        btnDel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                String[] tabValues = (String[])UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.model.getValue();
                if (tabValues.length > 2) {
                    Object[] newTabValues = new String[tabValues.length - 2];
                    if (UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex > 0) {
                        System.arraycopy(tabValues, 0, newTabValues, 0, UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex * 2);
                    }
                    if (UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex < tabValues.length / 2) {
                        System.arraycopy(tabValues, UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex * 2 + 2, newTabValues, UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex * 2, tabValues.length - (UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex * 2 + 2));
                    }
                    UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.model.setValue(newTabValues);
                    if (UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex * 2 > newTabValues.length) {
                        UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex = newTabValues.length / 2 - 1;
                    }
                    UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.updateFields();
                } else {
                    Object[] newTabValues = new String[]{"", ""};
                    UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.model.setValue(newTabValues);
                    UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.updateFields();
                }
            }
        });
        JButton btnUp = new JButton("/\\");
        btnUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex > 0) {
                    Object[] tabValues = (String[])UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.model.getValue();
                    String[] savTabValues = new String[2];
                    System.arraycopy(tabValues, UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex * 2, savTabValues, 0, 2);
                    tabValues[((UMLValueSpecificationValueFieldOpaqueExpressionDialog)UMLValueSpecificationValueFieldOpaqueExpressionDialog.this).currentIndex * 2] = tabValues[UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex * 2 - 2];
                    tabValues[((UMLValueSpecificationValueFieldOpaqueExpressionDialog)UMLValueSpecificationValueFieldOpaqueExpressionDialog.this).currentIndex * 2 + 1] = tabValues[UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex * 2 - 1];
                    tabValues[(((UMLValueSpecificationValueFieldOpaqueExpressionDialog)UMLValueSpecificationValueFieldOpaqueExpressionDialog.this).currentIndex - 1) * 2] = savTabValues[0];
                    tabValues[(((UMLValueSpecificationValueFieldOpaqueExpressionDialog)UMLValueSpecificationValueFieldOpaqueExpressionDialog.this).currentIndex - 1) * 2 + 1] = savTabValues[1];
                    UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.model.setValue(tabValues);
                    UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex = UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex - 1;
                    UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.updateFields();
                }
            }
        });
        JButton btnDown = new JButton("\\/");
        btnDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex + 1 < UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.listModel.size()) {
                    Object[] tabValues = (String[])UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.model.getValue();
                    String[] savTabValues = new String[2];
                    System.arraycopy(tabValues, UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex * 2, savTabValues, 0, 2);
                    tabValues[((UMLValueSpecificationValueFieldOpaqueExpressionDialog)UMLValueSpecificationValueFieldOpaqueExpressionDialog.this).currentIndex * 2] = tabValues[(UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex + 1) * 2];
                    tabValues[((UMLValueSpecificationValueFieldOpaqueExpressionDialog)UMLValueSpecificationValueFieldOpaqueExpressionDialog.this).currentIndex * 2 + 1] = tabValues[(UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex + 1) * 2 + 1];
                    tabValues[(((UMLValueSpecificationValueFieldOpaqueExpressionDialog)UMLValueSpecificationValueFieldOpaqueExpressionDialog.this).currentIndex + 1) * 2] = savTabValues[0];
                    tabValues[(((UMLValueSpecificationValueFieldOpaqueExpressionDialog)UMLValueSpecificationValueFieldOpaqueExpressionDialog.this).currentIndex + 1) * 2 + 1] = savTabValues[1];
                    UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.model.setValue(tabValues);
                    UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex = UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex + 1;
                    UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.updateFields();
                }
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        paneBtn.add((Component)btnApply, c);
        c = new GridBagConstraints();
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 1;
        paneBtn.add((Component)btnAdd, c);
        c = new GridBagConstraints();
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 2;
        paneBtn.add((Component)btnDel, c);
        c = new GridBagConstraints();
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 3;
        paneBtn.add((Component)btnUp, c);
        c = new GridBagConstraints();
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 4;
        paneBtn.add((Component)btnDown, c);
        return paneBtn;
    }

    private JPanel buildLanguagePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.curLanguage = new JTextField();
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.setSelectedIndex(this.currentIndex);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                if (UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.list.getSelectedIndex() != -1 && UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.list.getSelectedIndex() != UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex) {
                    UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.currentIndex = UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.list.getSelectedIndex();
                    UMLValueSpecificationValueFieldOpaqueExpressionDialog.this.updateFields();
                }
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        panel.add((Component)this.curLanguage, c);
        c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 12;
        panel.add((Component)this.list, c);
        return panel;
    }

    private void updateFields() {
        String[] newTabText = (String[])this.model.getValue();
        if (newTabText != null) {
            this.listModel.removeAllElements();
            for (int i = 1; i < newTabText.length; i += 2) {
                this.listModel.addElement(newTabText[i]);
            }
            if (this.currentIndex * 2 < newTabText.length) {
                this.list.setSelectedIndex(this.currentIndex);
                this.curBody.setText(newTabText[2 * this.currentIndex]);
                this.curLanguage.setText(newTabText[2 * this.currentIndex + 1]);
            }
        }
    }

    private boolean isUniqueLanguage(String[] tabValues, String newLanguage) {
        boolean bContinue = true;
        for (int i = 1; i < tabValues.length && bContinue; i += 2) {
            if (i == this.currentIndex) continue;
            bContinue = !tabValues[i].equals(newLanguage);
        }
        return bContinue;
    }

    private int getEmptyLanguage(String[] tabValues) {
        int num = -1;
        for (int i = 1; i < tabValues.length && num == -1; i += 2) {
            if (!tabValues[i].equals("")) continue;
            num = (i - 1) / 2;
        }
        return num;
    }
}

