/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.java.profile;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.argouml.language.java.profile.ModelUtils;
import org.argouml.model.Model;
import org.argouml.moduleloader.ModuleInterface;
import org.argouml.profile.DefaultTypeStrategy;
import org.argouml.profile.Profile;
import org.argouml.profile.ProfileException;
import org.argouml.profile.ProfileFacade;
import org.argouml.profile.ProfileReference;
import org.argouml.profile.ResourceModelLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileJava
extends Profile
implements ModuleInterface {
    private static final String UML1_PROFILE_FILE = "/org/argouml/language/java/profile/default-java.xmi";
    private static final String UML2_PROFILE_FILE = "/org/argouml/language/java/profile/java-profile-uml2.xmi";
    private static final String UML1_PROFILE_URL = "http://argouml.org/profiles/uml14/default-java.xmi";
    private static final String UML2_PROFILE_URL = "http://argouml.org/profiles/uml2/java-profile-uml2.xmi";
    private static final Logger LOG = Logger.getLogger(ProfileJava.class.getName());
    static final String NAME = "Java";
    private Collection<Object> model = null;
    private ProfileReference profileReference;

    public ProfileJava() throws ProfileException {
        try {
            if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
                URL profileURL = new URL(UML1_PROFILE_URL);
                this.profileReference = new ProfileReference(UML1_PROFILE_FILE, profileURL);
            } else {
                URL profileURL = new URL(UML2_PROFILE_URL);
                this.profileReference = new ProfileReference(UML2_PROFILE_FILE, profileURL);
            }
        }
        catch (MalformedURLException e) {
            throw new ProfileException("Exception while creating profile reference.", (Throwable)e);
        }
        if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
            this.addProfileDependency(ProfileFacade.getManager().getUMLProfile());
            this.addProfileDependency("CodeGeneration");
        }
    }

    private Collection<Object> getModel() {
        if (this.model == null) {
            ResourceModelLoader profileModelLoader = new ResourceModelLoader(ProfileJava.class);
            try {
                this.model = profileModelLoader.loadModel(this.profileReference);
            }
            catch (ProfileException e) {
                if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
                    LOG.log(Level.SEVERE, "Exception loading profile file /org/argouml/language/java/profile/default-java.xmi", e);
                }
                LOG.log(Level.SEVERE, "Exception loading profile file /org/argouml/language/java/profile/java-profile-uml2.xmi", e);
            }
            if (this.model == null) {
                this.model = this.getFallbackModel();
                LOG.severe("Using fallback profile");
            }
        }
        return this.model;
    }

    private Collection<Object> getFallbackModel() {
        ArrayList<Object> result = new ArrayList<Object>();
        Object profile = Model.getModelManagementFactory().createProfile();
        Model.getCoreHelper().setName(profile, "Fallback Java profile");
        result.add(profile);
        return result;
    }

    public String getDisplayName() {
        return NAME;
    }

    public Collection<Object> getProfilePackages() {
        return this.getModel();
    }

    public Collection<Object> getLoadedPackages() {
        if (this.model == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.model);
    }

    public DefaultTypeStrategy getDefaultTypeStrategy() {
        return new DefaultTypeStrategy(){

            public Object getDefaultAttributeType() {
                return ModelUtils.findTypeInModel("int", ProfileJava.this.getModel().iterator().next());
            }

            public Object getDefaultParameterType() {
                return ModelUtils.findTypeInModel("int", ProfileJava.this.getModel().iterator().next());
            }

            public Object getDefaultReturnType() {
                return ModelUtils.findTypeInModel("void", ProfileJava.this.getModel().iterator().next());
            }
        };
    }

    public boolean enable() {
        try {
            ProfileFacade.register((Profile)this);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to enable the Java profile.", e);
            return false;
        }
        return true;
    }

    public boolean disable() {
        boolean removed = false;
        try {
            ProfileFacade.remove((Profile)this);
            removed = true;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to remove the Java profile.", e);
        }
        return removed;
    }

    public String getName() {
        return "Java profile";
    }

    public String getInfo(int type) {
        switch (type) {
            case 0: {
                return "Java profile.";
            }
            case 1: {
                return "The ArgoUML project team";
            }
            case 2: {
                return "0.33.8";
            }
            case 3: {
                return "http://argouml-java.tigris.org/";
            }
        }
        return null;
    }
}

