/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.java.reveng;

import org.argouml.language.java.reveng.ClassifierNotFoundException;
import org.argouml.language.java.reveng.Context;
import org.argouml.model.Model;
import org.argouml.profile.Profile;

class PackageContext
extends Context {
    private Object mPackage;
    private String javaName;
    private static final String GENERATED_TAG_VALUE = "true";

    public PackageContext(Context base, Object thePackage) {
        super(base);
        this.mPackage = thePackage;
        this.javaName = this.getJavaName(thePackage);
    }

    public Object get(String name, boolean interfacesOnly, Profile profile) throws ClassifierNotFoundException {
        Object mClassifier = Model.getFacade().lookupIn(this.mPackage, name);
        if (mClassifier == null) {
            Class<?> classifier;
            String clazzName = name;
            if (!Model.getFacade().isAModel(this.mPackage)) {
                clazzName = this.javaName + "." + name;
            }
            if ((classifier = this.findClass(clazzName, interfacesOnly)) != null) {
                try {
                    mClassifier = classifier.isInterface() ? Model.getCoreFactory().buildInterface(name, this.mPackage) : Model.getCoreFactory().buildClass(name, this.mPackage);
                }
                catch (Exception e) {
                    mClassifier = null;
                }
                if (mClassifier != null) {
                    this.setGeneratedTag(mClassifier);
                }
            }
        }
        if (mClassifier == null) {
            if (this.getContext() != null) {
                mClassifier = this.getContext().get(name, interfacesOnly, profile);
            } else if (!interfacesOnly && (name.equals("int") || name.equals("long") || name.equals("short") || name.equals("byte") || name.equals("char") || name.equals("float") || name.equals("double") || name.equals("boolean") || name.equals("void") || name.indexOf("[]") != -1)) {
                if (profile != null) {
                    try {
                        Object m = profile.getProfilePackages().iterator().next();
                        mClassifier = Model.getFacade().lookupIn(m, name);
                    }
                    catch (Exception e) {
                        mClassifier = null;
                    }
                }
                if (mClassifier == null) {
                    mClassifier = Model.getCoreFactory().buildDataType(name, this.mPackage);
                }
            }
        }
        if (mClassifier == null) {
            throw new ClassifierNotFoundException(name);
        }
        return mClassifier;
    }

    private void setGeneratedTag(Object element) {
        Object tv = Model.getFacade().getTaggedValue(element, "GeneratedFromImport");
        if (tv == null) {
            Model.getExtensionMechanismsHelper().addTaggedValue(element, Model.getExtensionMechanismsFactory().buildTaggedValue("GeneratedFromImport", GENERATED_TAG_VALUE));
        } else {
            Model.getExtensionMechanismsHelper().setValueOfTag(tv, GENERATED_TAG_VALUE);
        }
    }
}

