/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.java.reveng.classfile;

import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.argouml.language.java.reveng.classfile.ClassifierNotFoundException;
import org.argouml.model.Model;
import org.argouml.uml.reveng.ImportClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Context {
    private static final Logger LOG = Logger.getLogger(Context.class.getName());
    private Context context;

    public Context(Context base) {
        this.context = base;
    }

    public abstract Object get(String var1) throws ClassifierNotFoundException;

    public abstract Object get(String var1, boolean var2) throws ClassifierNotFoundException;

    public abstract Object getInterface(String var1) throws ClassifierNotFoundException;

    protected String getJavaName(Object mPackage) {
        Object parent = Model.getFacade().getNamespace(mPackage);
        if (Model.getFacade().isAModel(parent)) {
            return Model.getFacade().getName(mPackage);
        }
        if (parent != null) {
            return this.getJavaName(parent) + "." + Model.getFacade().getName(mPackage);
        }
        return "";
    }

    protected void setContext(Context c) {
        this.context = c;
    }

    protected Context getContext() {
        return this.context;
    }

    protected Class<?> findClass(String name, boolean interfacesOnly) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            clazz = this.findClassOnUserClasspath(name, interfacesOnly);
        }
        catch (LinkageError e) {
            LOG.log(Level.WARNING, "Linkage error loading found class " + name, e);
            clazz = this.findClassOnUserClasspath(name, interfacesOnly);
        }
        if (clazz != null && interfacesOnly && !clazz.isInterface()) {
            clazz = this.findClassOnUserClasspath(name, interfacesOnly);
        }
        return clazz;
    }

    private Class<?> findClassOnUserClasspath(String name, boolean interfacesOnly) {
        Class clazz = null;
        try {
            clazz = ImportClassLoader.getInstance().loadClass(name);
        }
        catch (MalformedURLException e) {
            LOG.log(Level.WARNING, "Classpath configuration error", e);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (LinkageError e) {
            LOG.log(Level.WARNING, "Linkage error loading found class " + name, e);
            return null;
        }
        if (clazz != null && interfacesOnly && !clazz.isInterface()) {
            return null;
        }
        return clazz;
    }
}

