/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Layer;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerManager
implements Serializable {
    private static final long serialVersionUID = -4133017459593099807L;
    private List<Layer> _layers = new ArrayList<Layer>();
    private Layer _activeLayer;
    private boolean _paintActiveOnly = false;
    private boolean _paintLayers = true;
    @Deprecated
    public Editor _editor = null;

    public LayerManager(Editor editor) {
        this._editor = editor;
    }

    public void addLayer(Layer lay, boolean makeActive) {
        if (this.findLayerNamed(lay.getName()) == null) {
            this._editor.getModeManager().leaveAll();
            this._layers.add(lay);
            lay.addEditor(this._editor);
            if (makeActive) {
                this.setActiveLayer(lay);
            }
        }
    }

    public void addLayer(Layer lay) {
        this.addLayer(lay, true);
    }

    public void removeAllLayers() {
        this._layers.clear();
        this._activeLayer = null;
    }

    public void replaceLayer(Layer oldLayer, Layer newLayer) {
        this._editor.getModeManager().leaveAll();
        oldLayer.removeEditor(this._editor);
        int oldIndex = this._layers.indexOf(oldLayer);
        this._layers.set(oldIndex, newLayer);
        newLayer.addEditor(this._editor);
        if (this._activeLayer == oldLayer) {
            this.setActiveLayer(newLayer);
        }
    }

    public void replaceActiveLayer(Layer layer) {
        if (this._activeLayer == null) {
            this.addLayer(layer, true);
        } else {
            this.replaceLayer(this._activeLayer, layer);
        }
    }

    public void removeLayer(Layer lay) {
        this._layers.remove(lay);
        lay.removeEditor(this._editor);
        if (this._activeLayer == lay) {
            this._activeLayer = this._layers.size() >= 1 ? this._layers.get(0) : null;
        }
    }

    public Layer findLayerNamed(String aName) {
        int count = this._layers.size();
        for (int layerIndex = 0; layerIndex < count; ++layerIndex) {
            Layer curLayer = this._layers.get(layerIndex);
            if (!aName.equals(curLayer.getName())) continue;
            return curLayer;
        }
        return null;
    }

    public void setActiveLayer(Layer lay) {
        if (this._activeLayer != null && this._activeLayer.isAlwaysOnTop()) {
            return;
        }
        if (this._layers.contains(lay)) {
            this._activeLayer = lay;
        } else {
            System.out.println("That layer is not one of my layers");
        }
    }

    public Layer getActiveLayer() {
        return this._activeLayer;
    }

    public List<Fig> getContents() {
        if (this._activeLayer == null) {
            return Collections.emptyList();
        }
        return this._activeLayer.getContents();
    }

    @Deprecated
    public List getContents(List oldList) {
        return this._activeLayer == null ? null : this._activeLayer.getContents();
    }

    public void paint(Graphics g) {
        this.paint(g, null);
    }

    public void paint(Graphics g, FigPainter painter) {
        if (!this._paintLayers) {
            return;
        }
        if (this._paintActiveOnly) {
            this._activeLayer.paint(g, painter);
        } else {
            Layer currentActiveLayer = this._activeLayer;
            boolean alwaysOnTopState = currentActiveLayer.isAlwaysOnTop();
            currentActiveLayer.setAlwaysOnTop(false);
            int count = this._layers.size();
            for (int layerIndex = 0; layerIndex < count; ++layerIndex) {
                Layer tmpLayer = this._layers.get(layerIndex);
                this.setActiveLayer(tmpLayer);
                tmpLayer.paint(g, painter);
            }
            this.setActiveLayer(currentActiveLayer);
            currentActiveLayer.setAlwaysOnTop(alwaysOnTopState);
        }
    }

    public void add(Fig f) {
        if (this._activeLayer != null) {
            this._activeLayer.add(f);
        }
    }

    public void remove(Fig f) {
        if (this._activeLayer != null) {
            this._activeLayer.remove(f);
        }
    }

    public void removeAll() {
        if (this._activeLayer != null) {
            this._activeLayer.removeAll();
        }
    }

    @Deprecated
    public Enumeration elements() {
        return this._activeLayer == null ? null : this._activeLayer.elements();
    }

    public Fig hit(Rectangle r) {
        return this._activeLayer == null ? null : this._activeLayer.hit(r);
    }

    public Fig presentationFor(Object obj) {
        Fig f = null;
        int count = this._layers.size();
        for (int layerIndex = 0; layerIndex < count; ++layerIndex) {
            Layer sub = this._layers.get(layerIndex);
            f = sub.presentationFor(obj);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    public void sendToBack(Fig f) {
        if (this._activeLayer != null) {
            this._activeLayer.sendToBack(f);
        }
    }

    public void bringForward(Fig f) {
        if (this._activeLayer != null) {
            this._activeLayer.bringForward(f);
        }
    }

    public void sendBackward(Fig f) {
        if (this._activeLayer != null) {
            this._activeLayer.sendBackward(f);
        }
    }

    public void bringToFront(Fig f) {
        if (this._activeLayer != null) {
            this._activeLayer.bringToFront(f);
        }
    }

    public void reorder(Fig f, int function) {
        if (this._activeLayer != null) {
            this._activeLayer.reorder(f, function);
        }
    }

    public void setEditor(Editor ed) {
        this._editor = ed;
        int layerCount = this._layers.size();
        for (int layerIndex = 0; layerIndex < layerCount; ++layerIndex) {
            Layer layer = this._layers.get(layerIndex);
            layer.addEditor(ed);
        }
    }

    public Editor getEditor() {
        return this._editor;
    }

    public void preSave() {
        int layerCount = this._layers.size();
        for (int layerIndex = 0; layerIndex < layerCount; ++layerIndex) {
            Layer layer = this._layers.get(layerIndex);
            layer.preSave();
        }
    }

    public void postSave() {
        int layerCount = this._layers.size();
        for (int layerIndex = 0; layerIndex < layerCount; ++layerIndex) {
            Layer layer = this._layers.get(layerIndex);
            layer.postSave();
        }
    }

    public void postLoad() {
        int layerCount = this._layers.size();
        for (int layerIndex = 0; layerIndex < layerCount; ++layerIndex) {
            Layer layer = this._layers.get(layerIndex);
            layer.postLoad();
        }
    }

    public void setPaintActiveOnly(boolean activeOnly) {
        this._paintActiveOnly = activeOnly;
    }

    public boolean getPaintActiveOnly() {
        return this._paintActiveOnly;
    }

    public void setPaintLayers(boolean paintLayers) {
        this._paintLayers = paintLayers;
    }

    public boolean getPaintLayers() {
        return this._paintLayers;
    }

    public void setScale(double scale) {
        int layerCount = this._layers.size();
        for (int layerIndex = 0; layerIndex < layerCount; ++layerIndex) {
            Layer layer = this._layers.get(layerIndex);
            layer.setScale(scale);
        }
    }
}

