/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.FigModifyingModeImpl;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.MutableGraphSupport;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.Handle;
import org.tigris.gef.undo.UndoManager;
import org.tigris.gef.util.Localizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModeModify
extends FigModifyingModeImpl {
    private static final long serialVersionUID = -914125238898272775L;
    private static final int MIN_DELTA = 4;
    private double degrees45 = 0.7853981633974483;
    private boolean _dragInProcess = false;
    private Point newMousePosition = new Point(0, 0);
    private Point dragStartMousePosition = new Point(0, 0);
    private Point dragStartSelectionPosition = null;
    private Handle _curHandle = new Handle(-1);
    private Rectangle _highlightTrap = null;
    private int _deltaMouseX;
    private int _deltaMouseY;
    private GraphModel graphModel;

    public ModeModify(Editor par) {
        super(par);
    }

    @Override
    public String instructions() {
        return Localizer.localize("GefBase", "ModeModifyInstructions");
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        mouseEvent.consume();
        Point p = mouseEvent.getPoint();
        this.getEditor().snap(p);
        this.newMousePosition.x = p.x;
        this.newMousePosition.y = p.y;
        this._deltaMouseX = p.x - this.dragStartMousePosition.x;
        this._deltaMouseY = p.y - this.dragStartMousePosition.y;
        if (!this._dragInProcess && Math.abs(this._deltaMouseX) < 4 && Math.abs(this._deltaMouseY) < 4) {
            return;
        }
        if (!this._dragInProcess) {
            this._dragInProcess = true;
            UndoManager.getInstance().startChain();
            this.graphModel = this.editor.getGraphModel();
            if (this.graphModel instanceof MutableGraphSupport) {
                ((MutableGraphSupport)this.graphModel).fireGraphChanged();
            }
        }
        boolean restrict45 = mouseEvent.isControlDown();
        this.handleMouseDragged(restrict45);
    }

    private void updateMouseDrag(KeyEvent keyEvent) {
        if (this._dragInProcess) {
            boolean restrict45 = keyEvent.isControlDown();
            this.handleMouseDragged(restrict45);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        super.keyPressed(keyEvent);
        this.updateMouseDrag(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        super.keyReleased(keyEvent);
        this.updateMouseDrag(keyEvent);
    }

    private void handleMouseDragged(boolean restrict45) {
        SelectionManager selectionManager;
        int deltaMouseX = this._deltaMouseX;
        int deltaMouseY = this._deltaMouseY;
        if (restrict45 && deltaMouseY != 0) {
            double degrees = Math.atan2(deltaMouseY, deltaMouseX);
            degrees = this.degrees45 * (double)Math.round(degrees / this.degrees45);
            double r = Math.sqrt(deltaMouseX * deltaMouseX + deltaMouseY * deltaMouseY);
            deltaMouseX = (int)(r * Math.cos(degrees));
            deltaMouseY = (int)(r * Math.sin(degrees));
        }
        if ((selectionManager = this.getEditor().getSelectionManager()).getLocked()) {
            Globals.showStatus("Cannot Modify Locked Objects");
            return;
        }
        if (this.dragStartSelectionPosition == null) {
            selectionManager.startDrag();
        }
        Point selectionCurrentPosition = null;
        selectionCurrentPosition = selectionManager.size() == 1 && (selectionManager.getFigs().get(0) instanceof FigEdge || this._curHandle.index > 0) ? new Point(this.dragStartMousePosition) : selectionManager.getDragLocation();
        if (this.dragStartSelectionPosition == null) {
            this.dragStartSelectionPosition = selectionCurrentPosition;
        }
        Point selectionNewPosition = new Point(this.dragStartSelectionPosition);
        selectionNewPosition.translate(deltaMouseX, deltaMouseY);
        this.getEditor().snap(selectionNewPosition);
        selectionNewPosition.x = Math.max(0, selectionNewPosition.x);
        selectionNewPosition.y = Math.max(0, selectionNewPosition.y);
        int deltaSelectionX = selectionNewPosition.x - selectionCurrentPosition.x;
        int deltaSelectionY = selectionNewPosition.y - selectionCurrentPosition.y;
        if (deltaSelectionX != 0 || deltaSelectionY != 0) {
            if (this._curHandle.index == -1) {
                this.setCursor(Cursor.getPredefinedCursor(13));
                if (this.legal(deltaSelectionX, deltaSelectionY, selectionManager)) {
                    selectionManager.drag(deltaSelectionX, deltaSelectionY);
                }
            } else if (this._curHandle.index >= 0) {
                this.setCursor(Cursor.getPredefinedCursor(1));
                selectionManager.dragHandle(this.newMousePosition.x, this.newMousePosition.y, this.dragStartMousePosition.x, this.dragStartMousePosition.y, this._curHandle);
                selectionManager.endTrans();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (me.isConsumed()) {
            return;
        }
        int x = me.getX();
        int y = me.getY();
        this.start();
        SelectionManager selectionManager = this.getEditor().getSelectionManager();
        if (selectionManager.size() == 0) {
            this.done();
        }
        if (selectionManager.getLocked()) {
            Globals.showStatus("Cannot Modify Locked Objects");
            me.consume();
            return;
        }
        this.dragStartMousePosition = me.getPoint();
        this.dragStartSelectionPosition = null;
        selectionManager.hitHandle(new Rectangle(x - 4, y - 4, 8, 8), this._curHandle);
        Globals.showStatus(this._curHandle.instructions);
        selectionManager.endTrans();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this._dragInProcess = false;
        if (me.isConsumed()) {
            return;
        }
        this.done();
        me.consume();
        SelectionManager sm = this.editor.getSelectionManager();
        sm.stopDrag();
        Vector<Fig> figs = sm.getFigs();
        int figCount = figs.size();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig selectedFig = (Fig)figs.get(figIndex);
            if (selectedFig instanceof FigNode) {
                Rectangle bbox = selectedFig.getBounds();
                Layer lay = selectedFig.getLayer();
                List<Fig> otherFigs = lay.getContents();
                Fig encloser = null;
                for (Fig otherFig : otherFigs) {
                    Rectangle trap;
                    if (!(otherFig instanceof FigNode) || !otherFig.getUseTrapRect() || (trap = otherFig.getTrapRect()) == null || !trap.contains(bbox.x, bbox.y) || !trap.contains(bbox.x + bbox.width, bbox.y + bbox.height)) continue;
                    encloser = otherFig;
                }
                selectedFig.setEnclosingFig(encloser);
            } else if (selectedFig instanceof FigEdge) {
                ((FigEdge)selectedFig).computeRoute();
                selectedFig.endTrans();
            }
            selectedFig.endTrans();
        }
    }

    @Override
    public void done() {
        super.done();
        SelectionManager sm = this.getEditor().getSelectionManager();
        sm.cleanUp();
        if (this._highlightTrap != null) {
            this.editor.damaged(this._highlightTrap);
            this._highlightTrap = null;
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this._highlightTrap != null) {
            Color selectRectColor = Globals.getPrefs().getRubberbandColor();
            g.setColor(selectRectColor);
            g.drawRect(this._highlightTrap.x - 1, this._highlightTrap.y - 1, this._highlightTrap.width + 1, this._highlightTrap.height + 1);
            g.drawRect(this._highlightTrap.x - 2, this._highlightTrap.y - 2, this._highlightTrap.width + 3, this._highlightTrap.height + 3);
        }
    }

    private void damageHighlightTrap() {
        if (this._highlightTrap == null) {
            return;
        }
        Rectangle r = new Rectangle(this._highlightTrap);
        r.x -= 2;
        r.y -= 2;
        r.width += 4;
        r.height += 4;
        this.editor.damaged(r);
    }

    private boolean legal(int dx, int dy, SelectionManager selectionManager) {
        this.damageHighlightTrap();
        this._highlightTrap = null;
        List<FigNode> draggingFigNodes = this.getNodes(selectionManager.getDraggableFigs());
        int figCount = draggingFigNodes.size();
        Rectangle figBounds = new Rectangle();
        boolean draggedOntoCanvas = true;
        Fig encloser = null;
        Fig draggedFig = null;
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            draggedFig = draggingFigNodes.get(figIndex);
            draggedFig.getBounds(figBounds);
            figBounds.x += dx;
            figBounds.y += dy;
            Layer lay = draggedFig.getLayer();
            List<FigNode> figsInLayer = this.getNodes(lay.getContents());
            for (Fig fig : figsInLayer) {
                if (!draggedFig.getUseTrapRect() && !fig.getUseTrapRect() || draggingFigNodes.contains(fig) || fig.getEnclosingFig() == draggedFig || !fig.isVisible()) continue;
                for (Rectangle trap : fig.getTrapRects(draggedFig)) {
                    if (trap == null || !trap.intersects(figBounds)) continue;
                    if (trap.contains(figBounds.x, figBounds.y) && trap.contains(figBounds.x + figBounds.width, figBounds.y + figBounds.height)) {
                        draggedOntoCanvas = false;
                        encloser = fig;
                        continue;
                    }
                    if (figBounds.contains(trap.x, trap.y) && figBounds.contains(trap.x + trap.width, trap.y + trap.height)) continue;
                    this._highlightTrap = trap;
                    this.damageHighlightTrap();
                    return false;
                }
            }
            if (!(draggedOntoCanvas ? !((MutableGraphSupport)this.graphModel).isEnclosable(((FigNode)draggedFig).getOwner(), null) : !((MutableGraphSupport)this.graphModel).isEnclosable(((FigNode)draggedFig).getOwner(), ((FigNode)encloser).getOwner()))) continue;
            return false;
        }
        return true;
    }

    private List<FigNode> getNodes(List<Fig> figs) {
        ArrayList<FigNode> results = new ArrayList<FigNode>(figs.size());
        for (Fig f : figs) {
            if (!(f instanceof FigNode)) continue;
            results.add((FigNode)f);
        }
        return results;
    }
}

