/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.FigModifyingModeImpl;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.ui.PopupGenerator;

public class ModePopup
extends FigModifyingModeImpl {
    private static final long serialVersionUID = 288785293995576958L;
    private static final Log LOG = LogFactory.getLog(ModePopup.class);

    public ModePopup(Editor par) {
        super(par);
    }

    public boolean canExit() {
        return false;
    }

    public String instructions() {
        return " ";
    }

    public boolean showPopup(MouseEvent me) {
        Object commonInstance;
        JPopupMenu editorPopup;
        int x = me.getX();
        int y = me.getY();
        Fig underMouse = this.editor.hit(x, y);
        me = this.editor.retranslateMouseEvent(me);
        if (underMouse == null && (editorPopup = this.editor.getPopupMenu()) != null) {
            editorPopup.show(me.getComponent(), me.getX(), me.getY());
            me.consume();
            return true;
        }
        if (!(underMouse instanceof PopupGenerator)) {
            return false;
        }
        SelectionManager selectionManager = this.editor.getSelectionManager();
        if (!selectionManager.containsFig(underMouse)) {
            selectionManager.select(underMouse);
        } else {
            Vector<Fig> selection = selectionManager.getFigs();
            Vector<Fig> reassertSelection = new Vector<Fig>(selection);
            selectionManager.select(reassertSelection);
        }
        Class commonClass = selectionManager.findCommonSuperClass();
        if (commonClass != null && (commonInstance = selectionManager.findFirstSelectionOfType(commonClass)) instanceof PopupGenerator) {
            PopupGenerator popupGenerator = (PopupGenerator)commonInstance;
            Vector actions = popupGenerator.getPopUpActions(me);
            JPopupMenu popup = new JPopupMenu();
            int size = actions.size();
            for (int i = 0; i < size; ++i) {
                Object a = actions.get(i);
                if (a instanceof AbstractAction) {
                    popup.add((AbstractAction)a);
                    continue;
                }
                if (a instanceof JMenu) {
                    popup.add((JMenu)a);
                    continue;
                }
                if (a instanceof JMenuItem) {
                    popup.add((JMenuItem)a);
                    continue;
                }
                if (!(a instanceof JSeparator)) continue;
                popup.add((JSeparator)a);
            }
            popup.show(this.editor.getJComponent(), me.getX(), me.getY());
            me.consume();
            return true;
        }
        return false;
    }

    public void mouseReleased(MouseEvent me) {
        boolean popUpDisplayed = false;
        if (me.isPopupTrigger() || me.getModifiers() == 4) {
            popUpDisplayed = this.showPopup(me);
            if (LOG.isDebugEnabled()) {
                if (popUpDisplayed) {
                    LOG.debug((Object)"MouseReleased detected as a popup trigger and popup displayed and event consumed");
                } else {
                    LOG.debug((Object)"MouseReleased detected as a popup trigger but no popup to display");
                }
            }
            return;
        }
        LOG.debug((Object)"MouseReleased is not a popup trigger");
    }

    public void mousePressed(MouseEvent me) {
        boolean popUpDisplayed = false;
        if (me.isPopupTrigger() || me.getModifiers() == 4) {
            popUpDisplayed = this.showPopup(me);
            if (LOG.isDebugEnabled()) {
                if (popUpDisplayed) {
                    LOG.debug((Object)"MousePressed detected as a popup and popup displayed and event consumed");
                } else {
                    LOG.debug((Object)"MousePressed detected as a popup but no popup to display");
                }
            }
            return;
        }
    }

    public void mouseClicked(MouseEvent me) {
        boolean popUpDisplayed = false;
        if (me.isPopupTrigger() || me.getModifiers() == 4) {
            popUpDisplayed = this.showPopup(me);
            if (LOG.isDebugEnabled()) {
                if (popUpDisplayed) {
                    LOG.debug((Object)"MouseClicked detected as a popup and popup displayed and event consumed");
                } else {
                    LOG.debug((Object)"MouseClicked detected as a popup but no popup to display");
                }
            }
        }
    }
}

