/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.ocl;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.ocl.ExpansionException;
import org.tigris.gef.ocl.MethodInfo;
import org.tigris.gef.ocl.OCLEvaluator;
import org.tigris.gef.ocl.TemplateRecord;

public class OCLExpander {
    public static String OCL_START = "<ocl";
    public static String OCL_END = "</ocl>";
    public Map _templates = new Hashtable();
    public Hashtable _bindings = new Hashtable();
    public boolean _useXMLEscapes = true;
    protected OCLEvaluator evaluator;
    private static final Log LOG = LogFactory.getLog(OCLExpander.class);

    public OCLExpander(Map templates) {
        this._templates = templates;
        this.createEvaluator();
    }

    protected void createEvaluator() {
        this.evaluator = new OCLEvaluator();
    }

    public void expand(OutputStream w, Object target) throws ExpansionException {
        this.expandContent(new PrintWriter(w), target, "", "");
    }

    private void expand(OutputStream w, Object target, String prefix, String suffix) throws ExpansionException {
        this.expandContent(new PrintWriter(w), target, prefix, suffix);
    }

    public void expand(Writer w, Object target) throws ExpansionException {
        this.expand(w, target, "", "");
    }

    public void expand(Writer w, Object target, String prefix) throws ExpansionException {
        this.expand(w, target, prefix, "");
    }

    private void expand(Writer w, Object target, String prefix, String suffix) throws ExpansionException {
        PrintWriter pw = w instanceof PrintWriter ? (PrintWriter)w : new PrintWriter(w);
        this.expandContent(pw, target, prefix, suffix);
    }

    private void expandContent(PrintWriter printWriter, Object target, String prefix, String suffix) throws ExpansionException {
        if (target == null) {
            return;
        }
        List exprs = this.findTemplatesFor(target);
        String expr = null;
        int numExpr = exprs == null ? 0 : exprs.size();
        for (int i = 0; i < numExpr && expr == null; ++i) {
            TemplateRecord tr = (TemplateRecord)exprs.get(i);
            if (tr.getGuard() == null || tr.getGuard().equals("")) {
                expr = tr.body;
                break;
            }
            this._bindings.put("self", target);
            List results = this.evaluate(this._bindings, tr.getGuard());
            if (results.size() <= 0 || Boolean.FALSE.equals(results.get(0))) continue;
            expr = tr.body;
            break;
        }
        if (expr == null) {
            printWriter.print(prefix);
            String s = target.toString();
            if (target instanceof MethodInfo) {
                MethodInfo mi = (MethodInfo)target;
                Object[] params = new Object[]{printWriter, new Integer(prefix.length())};
                try {
                    mi.getMethod().invoke(mi.getObject(), params);
                }
                catch (IllegalArgumentException e) {
                    throw new ExpansionException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ExpansionException(e);
                }
                catch (InvocationTargetException e) {
                    throw new ExpansionException(e);
                }
            } else {
                if (this._useXMLEscapes) {
                    s = this.replaceWithXMLEscapes(s);
                }
                printWriter.print(s);
            }
            printWriter.println(suffix);
            return;
        }
        StringTokenizer st = new StringTokenizer(expr, "\n\r");
        int lineNo = 0;
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            this.expandLine(printWriter, line, target, prefix, suffix, ++lineNo);
        }
    }

    private void expandLine(PrintWriter pw, String line, Object target, String prefix, String suffix, int lineNo) throws ExpansionException {
        int startTagPos = line.indexOf(OCL_START, 0);
        int endTagPos = line.indexOf(OCL_END, 0);
        if (startTagPos == -1 || endTagPos == -1) {
            pw.println(prefix + line + suffix);
            return;
        }
        if (line.indexOf(OCL_START, endTagPos) >= 0) {
            while (startTagPos >= 0) {
                int expressionPos = line.indexOf(62, startTagPos) + 1;
                boolean ignoreNull = this.isIgnoreNull(line.substring(startTagPos + 4, expressionPos));
                String before = line.substring(0, startTagPos);
                String expr = line.substring(expressionPos, endTagPos);
                String after = line.substring(endTagPos + OCL_END.length());
                this._bindings.put("self", target);
                if (target == null) {
                    throw new ExpansionException("Target is null when evaluating the expression '" + expr + "' at line " + lineNo);
                }
                List results = this.evaluate(this._bindings, expr);
                Iterator iter = results.iterator();
                StringWriter sw = new StringWriter();
                if (iter.hasNext()) {
                    Object o = iter.next();
                    if (o == null && !ignoreNull) {
                        throw new ExpansionException("Evaluated the expression '" + expr + "' to null on object of class " + target.getClass().getName() + " at line " + lineNo);
                    }
                    this.expand(sw, o, before, after);
                }
                if (iter.hasNext()) {
                    throw new IllegalStateException("A repeating expression cannot be on the same line as any other expression.");
                }
                line = sw.toString();
                while (line.endsWith("\n") || line.endsWith("\r")) {
                    line = line.substring(0, line.length() - 1);
                }
                startTagPos = line.indexOf(OCL_START, 0);
                endTagPos = line.indexOf(OCL_END, 0);
            }
            pw.println(prefix + line + suffix);
        } else {
            int expressionPos = line.indexOf(62, startTagPos) + 1;
            boolean ignoreNull = this.isIgnoreNull(line.substring(startTagPos + 4, expressionPos));
            prefix = prefix + line.substring(0, startTagPos);
            String expr = line.substring(expressionPos, endTagPos);
            suffix = line.substring(endTagPos + OCL_END.length()) + suffix;
            this._bindings.put("self", target);
            if (target == null) {
                throw new ExpansionException("Target is null when evaluating the expression '" + expr + "' at line " + lineNo);
            }
            List results = this.evaluate(this._bindings, expr);
            for (Object o : results) {
                if (o == null && !ignoreNull) {
                    throw new ExpansionException("Evaluated the expression '" + expr + "' to null on object of class " + target.getClass().getName() + " at line " + lineNo);
                }
                this.expand(pw, o, prefix, suffix);
            }
        }
    }

    private boolean isIgnoreNull(String attributes) {
        boolean ignoreNull = attributes.startsWith(" ignoreNull>");
        return ignoreNull;
    }

    private List findTemplatesFor(Object target) {
        ArrayList res = null;
        boolean shared = true;
        for (Class<?> c = target.getClass(); c != null; c = c.getSuperclass()) {
            ArrayList temps = (ArrayList)this._templates.get(c);
            if (temps == null) continue;
            if (res == null) {
                res = temps;
                continue;
            }
            if (shared) {
                shared = false;
                ArrayList newRes = new ArrayList();
                for (int i = 0; i < res.size(); ++i) {
                    newRes.add(res.get(i));
                }
                res = newRes;
            }
            for (int j = 0; j < temps.size(); ++j) {
                res.add(temps.get(j));
            }
        }
        return res;
    }

    private String replaceWithXMLEscapes(String s) {
        s = this.replaceAll(s, "&", "&amp;");
        s = this.replaceAll(s, "<", "&lt;");
        s = this.replaceAll(s, ">", "&gt;");
        s = this.replaceAll(s, "\"", "&quot;");
        s = this.replaceAll(s, "'", "&apos;");
        return s;
    }

    private String replaceAll(String s, String pat, String rep) {
        int index = s.indexOf(pat);
        int patLen = pat.length();
        int repLen = rep.length();
        while (index != -1) {
            s = s.substring(0, index) + rep + s.substring(index + patLen);
            index = s.indexOf(pat, index + repLen);
        }
        return s;
    }

    private List evaluate(Map bindings, String expr) throws ExpansionException {
        if ("self".equals(expr) || expr.startsWith("self.")) {
            List values = this.evaluator.eval(bindings, expr);
            return values;
        }
        int bracketPosn = expr.indexOf(40);
        String classAndMethod = expr.substring(0, bracketPosn);
        int lastBracketPosn = expr.lastIndexOf(41);
        expr = expr.substring(bracketPosn + 1, lastBracketPosn);
        List values = this.evaluator.eval(bindings, expr);
        ArrayList newValues = new ArrayList(values.size());
        int methodSeperator = classAndMethod.lastIndexOf(46);
        String className = classAndMethod.substring(0, methodSeperator);
        String methodName = classAndMethod.substring(methodSeperator + 1);
        try {
            Class<?> clazz = Class.forName(className);
            for (Object o : values) {
                Class argClass = o == null ? Object.class : o.getClass();
                Method m = this.getMethod(clazz, argClass, methodName);
                if (!Modifier.isStatic(m.getModifiers())) {
                    throw new ExpansionException("The method " + m.toString() + " was expected to be static");
                }
                Object[] args = new Object[]{o};
                if ((o = m.invoke(null, args)) instanceof List) {
                    return (List)o;
                }
                newValues.add(o);
            }
        }
        catch (Exception e) {
            if (e instanceof ExpansionException) {
                throw (ExpansionException)e;
            }
            throw new ExpansionException(e);
        }
        return newValues;
    }

    private Method getMethod(Class targetClass, Class parameterClass, String methodName) throws ExpansionException {
        Class parameter = parameterClass;
        Method[] m = targetClass.getMethods();
        Object method = null;
        do {
            for (int i = 0; i < m.length; ++i) {
                if (!m[i].getName().equals(methodName) || m[i].getParameterTypes().length != 1 || !m[i].getParameterTypes()[0].equals(parameter)) continue;
                return m[i];
            }
        } while ((parameter = parameter.getSuperclass()) != null);
        throw new ExpansionException("Can't find a method " + methodName + " on " + targetClass.getName() + " that takes an object compatible with " + parameterClass.getName() + " as the only argument");
    }
}

