/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import org.tigris.gef.presentation.ArrowHead;

public class ArrowHeadTriangle
extends ArrowHead {
    private static final long serialVersionUID = -438086672038929101L;

    public void paint(Graphics g, Point start, Point end, Color lineColor, Color fillColor) {
        int xTo = end.x;
        int xFrom = start.x;
        double dx = xTo - xFrom;
        int yTo = end.y;
        int yFrom = start.y;
        double dy = yTo - yFrom;
        double denom = this.dist(dx, dy);
        if (denom <= 0.01) {
            return;
        }
        double cos = (double)this.getHeight() / denom;
        double sin = (double)this.getWidth() / denom;
        double x = (double)xTo - cos * dx;
        double y = (double)yTo - cos * dy;
        int x1 = (int)(x - sin * dy);
        int y1 = (int)(y + sin * dx);
        int x2 = (int)(x + sin * dy);
        int y2 = (int)(y - sin * dx);
        Polygon triangle = new Polygon();
        triangle.addPoint(xTo, yTo);
        triangle.addPoint(x1, y1);
        triangle.addPoint(x2, y2);
        Graphics graphics = g;
        graphics.setColor(fillColor);
        graphics.fillPolygon(triangle);
        graphics.setColor(lineColor);
        graphics.drawPolygon(triangle);
    }
}

