/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.PathConv;
import org.tigris.gef.base.PathItemPlacementStrategy;
import org.tigris.gef.di.GraphEdge;
import org.tigris.gef.di.GraphNode;
import org.tigris.gef.graph.GraphEdgeHooks;
import org.tigris.gef.presentation.ArrowHead;
import org.tigris.gef.presentation.ArrowHeadNone;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.Handle;
import org.tigris.gef.ui.Highlightable;
import org.tigris.gef.undo.Memento;
import org.tigris.gef.undo.UndoManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FigEdge
extends Fig
implements Highlightable,
GraphEdge {
    private Fig sourcePortFig;
    private Fig destPortFig;
    private FigNode sourceFigNode;
    private FigNode destFigNode;
    private Fig routeFig;
    protected boolean _useNearest = false;
    protected boolean _highlight = false;
    protected ArrowHead _arrowHeadStart = ArrowHeadNone.TheInstance;
    protected ArrowHead _arrowHeadEnd = ArrowHeadNone.TheInstance;
    @Deprecated
    protected Vector<PathItem> _pathItems = new Vector();

    public FigEdge() {
        this.setFig(this.makeEdgeFig());
    }

    public FigEdge(Fig s, Fig d, FigNode sfn, FigNode dfn, Object edge) {
        this.setSourcePortFig(s);
        this.setDestPortFig(d);
        this.setSourceFigNode(sfn);
        this.setDestFigNode(dfn);
        this.setOwner(edge);
        this.setFig(this.makeEdgeFig());
        this.routeFig.setGroup(this);
        this.routeFig.setLayer(this.getLayer());
    }

    public void addPathItem(Fig newFig, PathConv newPath) {
        this._pathItems.addElement(new PathItem(newFig, newPath));
        newFig.setGroup(this);
    }

    @Override
    public void calcBounds() {
        this.routeFig.calcBounds();
        Rectangle res = this.routeFig.getBounds();
        Point loc = new Point();
        int size = this._pathItems.size();
        for (int i = 0; i < size; ++i) {
            PathItem element = this._pathItems.elementAt(i);
            PathConv pc = element.getPath();
            Fig f = element.getFig();
            int oldX = f.getX();
            int oldY = f.getY();
            int halfWidth = f.getWidth() / 2;
            int halfHeight = f.getHeight() / 2;
            pc.stuffPoint(loc);
            if (oldX != loc.x || oldY != loc.y) {
                f.damage();
                f.setLocation(loc.x - halfWidth, loc.y - halfHeight);
            }
            res.add(f.getBounds());
        }
        this._x = res.x;
        this._y = res.y;
        this._w = res.width;
        this._h = res.height;
    }

    @Override
    public final void cleanUp() {
        this.routeFig.cleanUp();
    }

    public final void computeRoute() {
        if (UndoManager.getInstance().isGenerateMementos()) {
            Memento memento = new Memento(){
                Point[] points;
                {
                    this.points = FigEdge.this.getPoints();
                }

                public void undo() {
                    UndoManager.getInstance().addMementoLock(this);
                    Point[] newpoints = FigEdge.this.getPoints();
                    FigEdge.this.setPoints(this.points);
                    this.points = newpoints;
                    FigEdge.this.damage();
                    UndoManager.getInstance().removeMementoLock(this);
                }

                public void redo() {
                    this.undo();
                }

                public void dispose() {
                }

                public String toString() {
                    return (this.isStartChain() ? "*" : " ") + "ComputeRouteMemento " + Arrays.toString(this.points);
                }
            };
            UndoManager.getInstance().addMemento(memento);
        }
        this.computeRouteImpl();
    }

    public abstract void computeRouteImpl();

    @Override
    public final boolean contains(int x, int y) {
        if (this.routeFig.contains(x, y)) {
            return true;
        }
        int size = this._pathItems.size();
        for (int i = 0; i < size; ++i) {
            Fig f = this._pathItems.elementAt(i).getFig();
            if (!f.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeFromDiagram() {
        if (this.sourceFigNode != null) {
            this.sourceFigNode.removeFigEdge(this);
        }
        if (this.destFigNode != null) {
            this.destFigNode.removeFigEdge(this);
        }
        super.removeFromDiagram();
    }

    public final boolean getBetweenNearestPoints() {
        return this._useNearest;
    }

    @Override
    public final Rectangle getBounds(Rectangle r) {
        if (r == null) {
            r = new Rectangle();
        }
        this.routeFig.getBounds(r);
        int size = this._pathItems.size();
        for (int pathItemIndex = 0; pathItemIndex < size; ++pathItemIndex) {
            PathItem pathItem = this._pathItems.get(pathItemIndex);
            Fig f = pathItem.getFig();
            r.add(f.getBounds());
        }
        return r;
    }

    @Override
    public boolean getDashed() {
        return this.routeFig.getDashed();
    }

    public final ArrowHead getDestArrowHead() {
        return this._arrowHeadEnd;
    }

    public final FigNode getDestFigNode() {
        return this.destFigNode;
    }

    public Fig getDestPortFig() {
        return this.destPortFig;
    }

    public final Fig getFig() {
        return this.routeFig;
    }

    @Override
    public final Point getFirstPoint() {
        return this.routeFig.getFirstPoint();
    }

    @Override
    public final boolean getHighlight() {
        return this._highlight;
    }

    @Override
    public final Point getLastPoint() {
        return this.routeFig.getLastPoint();
    }

    @Override
    public final Color getLineColor() {
        return this.routeFig.getLineColor();
    }

    @Override
    public final boolean hasFillColor() {
        return false;
    }

    @Override
    public final int getLineWidth() {
        return this.routeFig.getLineWidth();
    }

    @Override
    public final int getNumPoints() {
        return this.routeFig.getNumPoints();
    }

    public final Fig getPathItem(PathConv pointOnPath) {
        return null;
    }

    public final Fig getPathItemFig(PathItem pathItem) {
        Fig fig = pathItem.getFig();
        return fig;
    }

    public final Vector getPathItemFigs() {
        Vector<Fig> figs = new Vector<Fig>();
        for (int i = 0; i < this._pathItems.size(); ++i) {
            figs.add(this.getPathItemFig(this._pathItems.elementAt(i)));
        }
        return figs;
    }

    public PathItemPlacementStrategy getPathItemPlacementStrategy(Fig fig) {
        for (PathItem pi : this._pathItems) {
            Fig f = this.getPathItemFig(pi);
            if (!fig.equals(f)) continue;
            return pi.getPathItemPlacementStrategy();
        }
        return null;
    }

    public final Vector getPathItemsRaw() {
        return this._pathItems;
    }

    private List<PathItem> getPathItems() {
        return new ArrayList<PathItem>(this._pathItems);
    }

    public List<PathItemPlacementStrategy> getPathItemStrategies() {
        ArrayList<PathItemPlacementStrategy> strategyList = new ArrayList<PathItemPlacementStrategy>();
        for (PathItem item : this.getPathItems()) {
            strategyList.add(item.getPath());
        }
        return strategyList;
    }

    @Override
    public final int getPerimeterLength() {
        return this.routeFig.getPerimeterLength();
    }

    @Override
    public final Point[] getPoints() {
        return this.routeFig.getPoints();
    }

    @Override
    public final Point getPoint(int i) {
        return this.routeFig.getPoint(i);
    }

    @Override
    public String getPrivateData() {
        Fig spf = this.getSourcePortFig();
        Fig dpf = this.getDestPortFig();
        FigNode sfn = this.getSourceFigNode();
        FigNode dfn = this.getDestFigNode();
        String data = "";
        if (spf != null) {
            data = data + "sourcePortFig=\"" + spf.getId() + "\" ";
        }
        if (dpf != null) {
            data = data + "destPortFig=\"" + dpf.getId() + "\" ";
        }
        if (sfn != null) {
            data = data + "sourceFigNode=\"" + sfn.getId() + "\" ";
        }
        if (dfn != null) {
            data = data + "destFigNode=\"" + dfn.getId() + "\" ";
        }
        return data;
    }

    public final ArrowHead getSourceArrowHead() {
        return this._arrowHeadStart;
    }

    public final FigNode getSourceFigNode() {
        return this.sourceFigNode;
    }

    @Override
    public final GraphNode getSourceGraphNode() {
        return this.sourceFigNode;
    }

    @Override
    public final GraphNode getDestGraphNode() {
        return this.destFigNode;
    }

    public Fig getSourcePortFig() {
        return this.sourcePortFig;
    }

    @Override
    public final int[] getXs() {
        return this.routeFig.getXs();
    }

    @Override
    public final int[] getYs() {
        return this.routeFig.getYs();
    }

    @Override
    public boolean hit(Rectangle r) {
        if (this.routeFig.hit(r)) {
            return true;
        }
        int size = this._pathItems.size();
        for (int i = 0; i < size; ++i) {
            Fig f = this._pathItems.elementAt(i).getFig();
            if (!f.isAnnotation() || !f.hit(r)) continue;
            return true;
        }
        return false;
    }

    public final Fig hitFig(Rectangle r) {
        Enumeration<PathItem> iter = this._pathItems.elements();
        Fig res = null;
        if (this.routeFig.hit(r)) {
            res = this.routeFig;
        }
        while (iter.hasMoreElements()) {
            PathItem pi = iter.nextElement();
            Fig f = pi.getFig();
            if (!f.hit(r)) continue;
            res = f;
        }
        return res;
    }

    @Override
    public final boolean intersects(Rectangle r) {
        if (this.routeFig.intersectsPerimeter(r)) {
            return true;
        }
        int size = this._pathItems.size();
        for (int i = 0; i < size; ++i) {
            Fig f = this._pathItems.elementAt(i).getFig();
            if (!f.intersects(r)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isReshapable() {
        return this.routeFig.isReshapable();
    }

    @Override
    public final boolean isResizable() {
        return this.routeFig.isResizable();
    }

    @Override
    public final boolean isRotatable() {
        return this.routeFig.isRotatable();
    }

    protected abstract Fig makeEdgeFig();

    @Override
    public void paint(Graphics graphicContext) {
        Graphics g = graphicContext;
        this.routeFig.paint(g);
        this.paintArrowHeads(g);
        this.paintPathItems(g);
    }

    @Override
    public void appendSvg(StringBuffer sb) {
        this.routeFig.appendSvg(sb);
        this.appendSvgPathItems(sb);
    }

    protected final void paintArrowHeads(Object g) {
        this._arrowHeadStart.paintAtHead(g, this.routeFig);
        this._arrowHeadEnd.paintAtTail(g, this.routeFig);
    }

    public final void paintHighlightLine(Graphics g, int x1, int y1, int x2, int y2) {
        g.setColor(Globals.getPrefs().getHighlightColor());
        double dx = x2 - x1;
        double dy = y2 - y1;
        double denom = Math.sqrt(dx * dx + dy * dy);
        if (denom == 0.0) {
            return;
        }
        double orthoX = dy / denom;
        double orthoY = -dx / denom;
        for (double i = 2.0; i < 5.0; i += 0.27) {
            int hx1 = (int)((double)x1 + i * orthoX);
            int hy1 = (int)((double)y1 + i * orthoY);
            int hx2 = (int)((double)x2 + i * orthoX);
            int hy2 = (int)((double)y2 + i * orthoY);
            g.drawLine(hx1, hy1, hx2, hy2);
        }
    }

    protected final void paintPathItems(Graphics g) {
        Vector pathVec = this.getPathItemsRaw();
        for (int i = 0; i < pathVec.size(); ++i) {
            PathItem element = (PathItem)pathVec.elementAt(i);
            Fig f = element.getFig();
            f.paint(g);
        }
    }

    protected final void appendSvgPathItems(StringBuffer sb) {
        Vector pathVec = this.getPathItemsRaw();
        for (int i = 0; i < pathVec.size(); ++i) {
            PathItem element = (PathItem)pathVec.elementAt(i);
            Fig f = element.getFig();
            f.appendSvg(sb);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String pName = pce.getPropertyName();
        Object src = pce.getSource();
        if (pName.equals("disposed") && src == this.getOwner()) {
            this.removeFromDiagram();
        }
        if (pName.equals("highlight") && src == this.getOwner()) {
            this._highlight = (Boolean)pce.getNewValue();
            this.damage();
        }
    }

    public final void removePathItem(PathItem goneItem) {
        this._pathItems.removeElement(goneItem);
        goneItem.getFig().setGroup(null);
    }

    public final void removePathItem(Fig goneFig) {
        for (int i = 0; i < this._pathItems.size(); ++i) {
            PathItem curItem = this._pathItems.elementAt(i);
            if (curItem.getFig() != goneFig) continue;
            this.removePathItem(curItem);
            return;
        }
    }

    public final void setBetweenNearestPoints(boolean un) {
        this._useNearest = un;
    }

    @Override
    public final void setDashed(boolean d) {
        this.routeFig.setDashed(d);
    }

    public void setDestArrowHead(ArrowHead newArrow) {
        this._arrowHeadEnd = newArrow;
    }

    public void setDestFigNode(FigNode fn) {
        try {
            if (this.destFigNode != null) {
                this.destFigNode.removeFigEdge(this);
            }
            this.destFigNode = fn;
            fn.addFigEdge(this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void setDestPortFig(Fig fig) {
        if (fig == null) {
            throw new IllegalArgumentException("A destination port must be supplied");
        }
        this.destPortFig = fig;
    }

    public void setFig(Fig f) {
        if (this.routeFig != null && this.routeFig.getGroup() == this) {
            this.routeFig.setGroup(null);
        }
        this.routeFig = f;
        this.routeFig.setGroup(this);
        this.routeFig.setLayer(this.getLayer());
    }

    @Override
    public final void setHighlight(boolean b) {
        this._highlight = b;
        this.damage();
    }

    @Override
    public void setLineColor(Color c) {
        this.routeFig.setLineColor(c);
        this.setArrowColor(this.getSourceArrowHead(), c);
        this.setArrowColor(this.getDestArrowHead(), c);
    }

    private void setArrowColor(ArrowHead arrow, Color c) {
        if (arrow != null) {
            arrow.setLineColor(c);
        }
    }

    @Override
    public final void setLineWidth(int w) {
        this.routeFig.setLineWidth(w);
    }

    @Override
    public final void setNumPoints(int npoints) {
        this.routeFig.setNumPoints(npoints);
        this.calcBounds();
    }

    @Override
    public void setOwner(Object own) {
        Object oldOwner = this.getOwner();
        if (oldOwner instanceof GraphEdgeHooks) {
            ((GraphEdgeHooks)oldOwner).removePropertyChangeListener(this);
        } else if (oldOwner instanceof Highlightable) {
            ((Highlightable)oldOwner).removePropertyChangeListener(this);
        }
        if (own instanceof GraphEdgeHooks) {
            ((GraphEdgeHooks)own).addPropertyChangeListener(this);
        } else if (own instanceof Highlightable) {
            ((Highlightable)own).addPropertyChangeListener(this);
        }
        super.setOwner(own);
    }

    @Override
    public final void setPoints(Point[] ps) {
        this.routeFig.setPoints(ps);
        this.calcBounds();
    }

    @Override
    public final void setPoint(int i, int x, int y) {
        this.routeFig.setPoint(i, x, y);
        this.calcBounds();
    }

    @Override
    public void setPoint(Handle h, int x, int y) {
        this.routeFig.setPoint(h, x, y);
        this.calcBounds();
    }

    public void setSourceArrowHead(ArrowHead newArrow) {
        this._arrowHeadStart = newArrow;
    }

    public void setSourceFigNode(FigNode fn) {
        try {
            if (this.sourceFigNode != null) {
                this.sourceFigNode.removeFigEdge(this);
            }
            this.sourceFigNode = fn;
            fn.addFigEdge(this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setSourceGraphNode(GraphNode node) {
        this.setSourceFigNode((FigNode)node);
    }

    @Override
    public void setDestGraphNode(GraphNode node) {
        this.setDestFigNode((FigNode)node);
    }

    public final void setSourcePortFig(Fig fig) {
        if (fig == null) {
            throw new IllegalArgumentException("A source port must be supplied");
        }
        this.sourcePortFig = fig;
    }

    @Override
    public final void setXs(int[] xs) {
        this.routeFig.setXs(xs);
        this.calcBounds();
    }

    @Override
    public final void setYs(int[] ys) {
        this.routeFig.setYs(ys);
        this.calcBounds();
    }

    @Override
    public final void stuffPointAlongPerimeter(int dist, Point res) {
        this.routeFig.stuffPointAlongPerimeter(dist, res);
    }

    public final void translateEdge(int dx, int dy) {
        this.routeFig.translate(dx, dy);
        this.calcBounds();
    }

    @Override
    public void translateImpl(int dx, int dy) {
        this.routeFig.translate(dx, dy);
        this.calcBounds();
    }

    public final void updatePathItemLocations() {
        this.calcBounds();
    }

    private class PathItem
    implements Serializable {
        private static final long serialVersionUID = -5298572087861993804L;
        final Fig _fig;
        private final PathItemPlacementStrategy pathItemPlacementStrategy;

        PathItem(Fig f, PathConv pc) {
            this._fig = f;
            this.pathItemPlacementStrategy = pc;
        }

        @Deprecated
        public final PathConv getPath() {
            return (PathConv)this.pathItemPlacementStrategy;
        }

        public final PathItemPlacementStrategy getPathItemPlacementStrategy() {
            return this.pathItemPlacementStrategy;
        }

        public final Fig getFig() {
            return this._fig;
        }

        public final void paint() {
        }
    }
}

