/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.ByteLookupTable;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.LookupOp;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Globals;
import org.tigris.gef.di.GraphEdge;
import org.tigris.gef.di.GraphNode;
import org.tigris.gef.graph.GraphNodeHooks;
import org.tigris.gef.graph.GraphPortHooks;
import org.tigris.gef.graph.MutableGraphSupport;
import org.tigris.gef.presentation.Connector;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigGroup;
import org.tigris.gef.ui.Highlightable;
import org.tigris.gef.undo.UndoManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FigNode
extends FigGroup
implements Highlightable,
GraphNode,
MouseListener {
    private static final long serialVersionUID = 5312194520189613781L;
    private static final Log LOG = LogFactory.getLog(FigNode.class);
    private static final LookupOp SHADOW_LOOKUP_OP;
    private static final ConvolveOp SHADOW_CONVOLVE_OP;
    private BufferedImage shadowImage;
    private int cachedWidth = -1;
    private int cachedHeight = -1;
    private List<Connector> connectors = new ArrayList<Connector>();
    private boolean forceRepaint;
    protected static final int SHADOW_COLOR_VALUE = 32;
    protected static final int SHADOW_COLOR_ALPHA = 128;
    public static final double ang45 = 0.7853981633974483;
    public static final double ang135 = 2.356194490192345;
    public static final double ang225 = 3.9269908169872414;
    public static final double ang315 = 5.497787143782138;
    protected boolean _blinkPorts = false;
    protected boolean _highlight = false;
    private ArrayList<FigEdge> figEdges = new ArrayList();
    private int shadowSize = 0;

    public FigNode() {
    }

    public FigNode(Object node) {
        this.setOwner(node);
    }

    public FigNode(Object node, Collection figs) {
        this(node);
        this.setFigs(figs);
    }

    public boolean isDragConnectable() {
        return true;
    }

    @Override
    public Object clone() {
        FigNode figClone = (FigNode)super.clone();
        figClone.figEdges = (ArrayList)this.figEdges.clone();
        return figClone;
    }

    public void setBlinkPorts(boolean b) {
        this._blinkPorts = b;
        this.hidePorts();
    }

    public boolean isBlinkPorts() {
        return this._blinkPorts;
    }

    public void addFigEdge(FigEdge fe) {
        this.figEdges.add(fe);
    }

    public void addConnector(Connector connector) {
        this.connectors.add(connector);
        Fig connectorFig = (Fig)((Object)connector);
        Point centre = new Point(connectorFig.getX() + connectorFig.getHalfWidth(), connectorFig.getY() + connectorFig.getHalfHeight());
        Point attachPoint = this.getClosestPoint(centre);
        connectorFig.setLocation(attachPoint.x - connectorFig.getHalfWidth(), attachPoint.y - connectorFig.getHalfHeight());
        connector.setGraphNode(this);
    }

    public void removeConnector(Connector connector) {
        this.connectors.remove(connector);
    }

    public void removeFigEdge(FigEdge fe) {
        this.figEdges.remove(fe);
    }

    public Collection<FigEdge> getFigEdges(Collection<FigEdge> c) {
        if (c == null) {
            return this.figEdges;
        }
        c.addAll(this.figEdges);
        return c;
    }

    public List<FigEdge> getFigEdges() {
        return (List)this.figEdges.clone();
    }

    @Override
    public List<GraphEdge> getGraphEdges() {
        return (List)this.figEdges.clone();
    }

    @Override
    public void setOwner(Object node) {
        Object oldOwner = this.getOwner();
        if (oldOwner instanceof GraphNodeHooks) {
            ((GraphNodeHooks)oldOwner).removePropertyChangeListener(this);
        } else if (oldOwner instanceof Highlightable) {
            ((Highlightable)oldOwner).removePropertyChangeListener(this);
        }
        if (node instanceof GraphNodeHooks) {
            ((GraphNodeHooks)node).addPropertyChangeListener(this);
        } else if (node instanceof Highlightable) {
            ((Highlightable)node).addPropertyChangeListener(this);
        }
        super.setOwner(node);
    }

    @Override
    public boolean hit(Rectangle r) {
        int cornersHit = this.countCornersContained(r.x, r.y, r.width, r.height);
        if (this._filled) {
            return cornersHit > 0;
        }
        return cornersHit > 0 && cornersHit < 4;
    }

    @Override
    public boolean contains(int x, int y) {
        return this._x <= x && x <= this._x + this._w && this._y <= y && y <= this._y + this._h;
    }

    @Override
    public void setEnclosingFig(Fig f) {
        if (f != null && f != this.getEnclosingFig() && this.getLayer() != null) {
            int edgeCount = this.figEdges.size();
            for (int i = 0; i < edgeCount; ++i) {
                FigEdge fe = this.figEdges.get(i);
                this.getLayer().bringInFrontOf(fe, f);
            }
        }
        super.setEnclosingFig(f);
    }

    @Override
    public void endTrans() {
        int edgeCount = this.figEdges.size();
        for (int i = 0; i < edgeCount; ++i) {
            FigEdge f = this.figEdges.get(i);
            f.endTrans();
        }
        super.endTrans();
    }

    @Override
    public void removeFromDiagram() {
        while (this.figEdges.size() > 0) {
            FigEdge f = this.figEdges.get(this.figEdges.size() - 1);
            f.removeFromDiagram();
        }
        super.removeFromDiagram();
    }

    @Override
    public void deleteFromModel() {
        LOG.debug((Object)"Deleting FigNode from model");
        for (int i = this.figEdges.size() - 1; i >= 0; --i) {
            FigEdge f = this.figEdges.get(i);
            f.deleteFromModel();
        }
        super.deleteFromModel();
    }

    public void dispose() {
        this.deleteFromModel();
    }

    public void bindPort(Object port, Fig f) {
        Fig oldPortFig = this.getPortFig(port);
        if (oldPortFig != null) {
            oldPortFig.setOwner(null);
        }
        f.setOwner(port);
    }

    public void removePort(Fig rep) {
        if (rep.getOwner() != null) {
            rep.setOwner(null);
        }
    }

    public final Object hitPort(Point p) {
        return this.hitPort(p.x, p.y);
    }

    public Object hitPort(int x, int y) {
        Fig f = this.hitFig(new Rectangle(x, y, 1, 1));
        if (f != null) {
            Object owner = f.getOwner();
            return owner;
        }
        return null;
    }

    public Object deepHitPort(int x, int y) {
        int figCount = this.getFigCount();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig f = this.getFigAt(figIndex);
            Object own = f.getOwner();
            if (!f.contains(x, y) || own == null) continue;
            return own;
        }
        Rectangle r = new Rectangle(x - 16, y - 16, 32, 32);
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig f = this.getFigAt(figIndex);
            Object own = f.getOwner();
            if (!f.hit(r) || own == null) continue;
            return own;
        }
        return null;
    }

    public Fig getPortFig(Object np) {
        int figCount = this.getFigCount();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig f = this.getFigAt(figIndex);
            if (f.getOwner() != np) continue;
            return f;
        }
        return null;
    }

    public List getPortFigs() {
        ArrayList<Fig> portFigs = new ArrayList<Fig>();
        int figCount = this.getFigCount();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig f = this.getFigAt(figIndex);
            if (!this.isPortFig(f)) continue;
            portFigs.add(f);
        }
        return portFigs;
    }

    private boolean isPortFig(Fig f) {
        boolean retVal;
        boolean bl = retVal = f.getOwner() != null;
        if (retVal && this.getOwner() instanceof GraphNodeHooks) {
            retVal = f.getOwner() instanceof GraphPortHooks;
        }
        return retVal;
    }

    public int getPortSector(Fig portFig) {
        Rectangle nodeBBox = this.getBounds();
        Rectangle portBBox = portFig.getBounds();
        int nbbCenterX = nodeBBox.x + nodeBBox.width / 2;
        int nbbCenterY = nodeBBox.y + nodeBBox.height / 2;
        int pbbCenterX = portBBox.x + portBBox.width / 2;
        int pbbCenterY = portBBox.y + portBBox.height / 2;
        int dX = pbbCenterX - nbbCenterX;
        int dY = pbbCenterY - nbbCenterY;
        int sector = -1;
        if (Math.abs(dY * nodeBBox.width) > Math.abs(nodeBBox.height * dX)) {
            if (dY > 0) {
                sector = 1;
            }
        } else {
            sector = 2;
            if (dX > 0) {
                sector = -2;
            }
        }
        return sector;
    }

    @Override
    public void paint(Graphics g) {
        if (this.shadowSize > 0 && g instanceof Graphics2D) {
            int width = this.getWidth();
            int height = this.getHeight();
            int x = this.getX();
            int y = this.getY();
            if (width != this.cachedWidth || height != this.cachedHeight || this.forceRepaint) {
                this.forceRepaint = false;
                this.cachedWidth = width;
                this.cachedHeight = height;
                BufferedImage img = new BufferedImage(width + 100, height + 100, 2);
                Graphics ig = img.getGraphics();
                ig.translate(50 - x, 50 - y);
                this.paintOnce(ig);
                this.shadowImage = SHADOW_CONVOLVE_OP.filter(SHADOW_LOOKUP_OP.filter(img, null), null);
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.drawImage(this.shadowImage, null, x + this.shadowSize - 50, y + this.shadowSize - 50);
        }
        this.paintOnce(g);
    }

    private void paintOnce(Graphics g) {
        super.paint(g);
        if (this._highlight) {
            Color lineColor = Globals.getPrefs().getHighlightColor();
            this.drawRect(g, false, null, 3, lineColor, this._x - 5, this._y - 5, this._w + 9, this._h + 8, false, this._dashes, this._dashPeriod);
        }
    }

    @Override
    public void setHighlight(boolean b) {
        this._highlight = b;
        this.damage();
    }

    @Override
    public boolean getHighlight() {
        return this._highlight;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String pName = pce.getPropertyName();
        Object src = pce.getSource();
        if (pName.equals("disposed") && src == this.getOwner()) {
            this.removeFromDiagram();
        }
        if (pName.equals("highlight") && src == this.getOwner()) {
            this.setHighlight((Boolean)pce.getNewValue());
        }
    }

    public void showPorts() {
        int figCount = this.getFigCount();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig f = this.getFigAt(figIndex);
            if (f.getOwner() == null) continue;
            f.setLineWidth(1);
            f.setFilled(true);
        }
        this.endTrans();
    }

    public void hidePorts() {
        int figCount = this.getFigCount();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig f = this.getFigAt(figIndex);
            if (f.getOwner() == null) continue;
            f.setLineWidth(0);
            f.setFilled(false);
        }
        this.endTrans();
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        if (this._blinkPorts) {
            this.showPorts();
        }
    }

    @Override
    public void mouseExited(MouseEvent me) {
        if (this._blinkPorts) {
            this.hidePorts();
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    protected void translateImpl(int dx, int dy) {
        super.translateImpl(dx, dy);
        this.updateEdges();
    }

    public void superTranslate(int dx, int dy) {
        super.translate(dx, dy);
    }

    @Override
    protected void setBoundsImpl(int x, int y, int w, int h) {
        super.setBoundsImpl(x, y, w, h);
        this.updateEdges();
    }

    public void updateEdges() {
        if (!UndoManager.getInstance().isUndoInProgress()) {
            int edgeCount = this.figEdges.size();
            for (int edgeIndex = 0; edgeIndex < edgeCount; ++edgeIndex) {
                FigEdge fe = this.figEdges.get(edgeIndex);
                fe.computeRoute();
            }
        }
    }

    @Override
    public void cleanUp() {
        int edgeCount = this.figEdges.size();
        for (int i = 0; i < edgeCount; ++i) {
            FigEdge fe = this.figEdges.get(i);
            fe.cleanUp();
        }
    }

    public List<? extends Fig> getDragDependencies() {
        return null;
    }

    public List<Connector> getConnectors() {
        return this.connectors;
    }

    public void setShadowSize(int size) {
        if (size == this.shadowSize) {
            return;
        }
        MutableGraphSupport.enableSaveAction();
        this.shadowSize = size;
    }

    protected void setShadowSizeFriend(int size) {
        if (size == this.shadowSize) {
            return;
        }
        this.shadowSize = size;
    }

    public int getShadowSize() {
        return this.shadowSize;
    }

    public void forceRepaintShadow() {
        this.forceRepaint = true;
    }

    @Override
    public Rectangle getNodeBounds() {
        return this.getBounds();
    }

    static {
        byte[][] data = new byte[4][256];
        for (int i = 1; i < 256; ++i) {
            data[0][i] = 32;
            data[1][i] = 32;
            data[2][i] = 32;
            data[3][i] = -128;
        }
        float[] blur = new float[9];
        for (int i = 0; i < blur.length; ++i) {
            blur[i] = 0.083333336f;
        }
        SHADOW_LOOKUP_OP = new LookupOp(new ByteLookupTable(0, data), null);
        SHADOW_CONVOLVE_OP = new ConvolveOp(new Kernel(3, 3, blur));
    }
}

