/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.sql;

import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.argouml.application.api.Argo;
import org.argouml.configuration.Configuration;
import org.argouml.configuration.ConfigurationKey;
import org.argouml.language.sql.ColumnDefinition;
import org.argouml.language.sql.DomainMapper;
import org.argouml.language.sql.ForeignKeyDefinition;
import org.argouml.language.sql.ModelValidator;
import org.argouml.language.sql.SqlCodeCreator;
import org.argouml.language.sql.SqlCreatorLoader;
import org.argouml.language.sql.TableDefinition;
import org.argouml.language.sql.Utils;
import org.argouml.model.Model;
import org.argouml.ui.ExceptionDialog;
import org.argouml.ui.ProjectBrowser;
import org.argouml.ui.SelectCodeCreatorDialog;
import org.argouml.uml.generator.CodeGenerator;
import org.argouml.uml.generator.SourceUnit;
import org.argouml.uml.generator.TempFileUtils;

public final class GeneratorSql
implements CodeGenerator {
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    static final String PRIMARY_KEY_STEREOTYPE = "PK";
    static final String FOREIGN_KEY_STEREOTYPE = "FK";
    static final String NOT_NULL_STEREOTYPE = "NOT_NULL";
    static final String NULL_STEREOTYPE = "NULL";
    static final String SOURCE_COLUMN_TAGGED_VALUE = "source_column";
    static final String ASSOCIATION_NAME_TAGGED_VALUE = "association_name";
    private static final Logger LOG = Logger.getLogger(GeneratorSql.class);
    private static final GeneratorSql INSTANCE = new GeneratorSql();
    private DomainMapper domainMapper = new DomainMapper();
    private SqlCodeCreator sqlCodeCreator;
    private List<SqlCodeCreator> sqlCodeCreators;
    private static final String SCRIPT_FILENAME = "script.sql";
    private Map<Object, TableDefinition> tableDefinitions;
    private List<ForeignKeyDefinition> foreignKeyDefinitions;

    private GeneratorSql() {
    }

    private List<SqlCodeCreator> loadSqlCodeCreators() {
        ArrayList<SqlCodeCreator> result = new ArrayList<SqlCodeCreator>();
        SqlCreatorLoader el = new SqlCreatorLoader();
        Collection<Class<SqlCodeCreator>> classes = el.getCodeCreators();
        for (Class<SqlCodeCreator> c : classes) {
            try {
                SqlCodeCreator scc = c.newInstance();
                result.add(scc);
            }
            catch (InstantiationException e) {
                LOG.error((Object)("Exception while instantiating a SqlCodeCreator " + c.getName()), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)("Exception while accessing the constructor of a SqlCodeCreator " + c.getName()), (Throwable)e);
            }
        }
        return result;
    }

    public static GeneratorSql getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SourceUnit> generate(Collection elements, boolean deps) {
        LOG.debug((Object)"generate() called");
        File tmpdir = null;
        try {
            tmpdir = TempFileUtils.createTempDir();
            if (tmpdir != null) {
                this.generateFiles(elements, tmpdir.getPath(), deps);
                Collection collection = TempFileUtils.readAllFiles((File)tmpdir);
                return collection;
            }
            List<SourceUnit> list = Collections.emptyList();
            return list;
        }
        finally {
            if (tmpdir != null) {
                TempFileUtils.deleteDir((File)tmpdir);
            }
            LOG.debug((Object)"generate() terminated");
        }
    }

    private TableDefinition getTableDefinition(Object element) {
        TableDefinition tableDefinition = new TableDefinition();
        tableDefinition.setName(Model.getFacade().getName(element));
        for (Object attribute : Model.getFacade().getAttributes(element)) {
            String name = Model.getFacade().getName(attribute);
            ColumnDefinition cd = new ColumnDefinition();
            cd.setName(name);
            Object domain = Model.getFacade().getType(attribute);
            String domainName = Model.getFacade().getName(domain);
            String datatype = this.domainMapper.getDatatype(this.sqlCodeCreator.getClass(), domainName);
            cd.setDatatype(datatype);
            if (Utils.isNull(attribute)) {
                cd.setNullable(Boolean.TRUE);
            } else if (Utils.isNotNull(attribute)) {
                cd.setNullable(Boolean.FALSE);
            } else {
                cd.setNullable(null);
            }
            tableDefinition.addColumnDefinition(cd);
            if (!Utils.isPk(attribute)) continue;
            cd.setNullable(Boolean.FALSE);
            tableDefinition.addPrimaryKeyField(name);
        }
        return tableDefinition;
    }

    private void setNullable(TableDefinition tableDef, List<String> columnNames, boolean nullable) {
        for (String name : columnNames) {
            tableDef.getColumnDefinition(name).setNullable(nullable);
        }
    }

    private String generateCode(Collection elements) {
        this.tableDefinitions = new HashMap<Object, TableDefinition>();
        this.foreignKeyDefinitions = new ArrayList<ForeignKeyDefinition>();
        for (Object element : elements) {
            if (!Model.getFacade().isAClass(element)) continue;
            TableDefinition tableDef = this.getTableDefinition(element);
            this.tableDefinitions.put(element, tableDef);
        }
        if (elements.size() > 1) {
            for (Object element : elements) {
                Collection<ForeignKeyDefinition> fkDefs = this.getForeignKeyDefinitions(element);
                TableDefinition tableDef = this.tableDefinitions.get(element);
                for (ForeignKeyDefinition fkDef : fkDefs) {
                    if (fkDef.getReferencesLower() == 0) {
                        this.setNullable(tableDef, fkDef.getColumnNames(), true);
                        continue;
                    }
                    this.setNullable(tableDef, fkDef.getColumnNames(), false);
                }
                this.foreignKeyDefinitions.addAll(fkDefs);
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append("-- Table definitions").append(LINE_SEPARATOR);
        for (TableDefinition tableDef : this.tableDefinitions.values()) {
            sb.append(this.sqlCodeCreator.createTable(tableDef));
        }
        if (elements.size() > 1) {
            sb.append("-- Foreign key definitions").append(LINE_SEPARATOR);
            for (ForeignKeyDefinition fkDef : this.foreignKeyDefinitions) {
                sb.append(this.sqlCodeCreator.createForeignKey(fkDef));
            }
        }
        return sb.toString();
    }

    public Collection<String> generateFiles(Collection elements, String path, boolean deps) {
        String filename = SCRIPT_FILENAME;
        if (!path.endsWith(FILE_SEPARATOR)) {
            path = path + FILE_SEPARATOR;
        }
        ArrayList<String> result = new ArrayList<String>();
        String fullFilename = path + filename;
        if (!elements.isEmpty()) {
            LOG.debug((Object)"validating model");
            ModelValidator validator = new ModelValidator();
            List<String> problems = validator.validate(elements);
            if (problems.size() > 0) {
                LOG.debug((Object)"model not valid, exiting code generation");
                String error = Utils.stringsToString(problems, LINE_SEPARATOR);
                ExceptionDialog ed = new ExceptionDialog((Frame)ProjectBrowser.getInstance(), "Error in model", "Model not valid", error);
                ed.setModal(true);
                ed.setVisible(true);
            } else if (SelectCodeCreatorDialog.execute()) {
                String code = this.generateCode(elements);
                this.writeFile(fullFilename, code);
                result.add(fullFilename);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String filename, String content) {
        BufferedWriter fos = null;
        try {
            String inputSrcEnc = Configuration.getString((ConfigurationKey)Argo.KEY_INPUT_SOURCE_ENCODING);
            if (inputSrcEnc == null || inputSrcEnc.trim().equals("")) {
                inputSrcEnc = System.getProperty("file.encoding");
            }
            fos = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), inputSrcEnc));
            fos.write(content);
        }
        catch (IOException e) {
            LOG.error((Object)("IO Exception: " + e));
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)("FAILED: " + filename));
            }
        }
    }

    private Collection<ForeignKeyDefinition> getForeignKeyDefinitions(Object relation) {
        HashSet<ForeignKeyDefinition> fkDefs = new HashSet<ForeignKeyDefinition>();
        for (Object assocEnd : Model.getFacade().getAssociationEnds(relation)) {
            Collection otherAssocEnds;
            Object otherAssocEnd;
            ForeignKeyDefinition fkDef = this.getFkDef(relation, assocEnd, otherAssocEnd = (otherAssocEnds = Model.getFacade().getOtherAssociationEnds(assocEnd)).iterator().next());
            if (fkDef == null) continue;
            fkDefs.add(fkDef);
        }
        return fkDefs;
    }

    private ForeignKeyDefinition getFkDef(Object relation, Object assocEnd, Object otherAssocEnd) {
        ColumnDefinition colDef;
        Object assoc = Model.getFacade().getAssociation(assocEnd);
        List fkAttributes = Utils.getFkAttributes(relation, assoc);
        int otherUpper = Model.getFacade().getUpper(otherAssocEnd);
        if (otherUpper != 1 || fkAttributes.size() == 0) {
            return null;
        }
        ForeignKeyDefinition fkDef = new ForeignKeyDefinition();
        ArrayList<Object> srcAttributes = new ArrayList<Object>();
        Object srcRelation = Model.getFacade().getClassifier(otherAssocEnd);
        for (Object fkAttr : fkAttributes) {
            Object srcAttr = Utils.getSourceAttribute(fkAttr, srcRelation);
            srcAttributes.add(srcAttr);
        }
        TableDefinition tableDef = this.tableDefinitions.get(relation);
        fkDef.setTable(tableDef);
        for (Object fkAttr : fkAttributes) {
            colDef = tableDef.getColumnDefinition(Model.getFacade().getName(fkAttr));
            fkDef.addColumnDefinition(colDef);
        }
        tableDef = this.tableDefinitions.get(srcRelation);
        fkDef.setReferencesTable(tableDef);
        for (Object srcAttr : srcAttributes) {
            colDef = tableDef.getColumnDefinition(Model.getFacade().getName(srcAttr));
            fkDef.addReferencesColumn(colDef);
        }
        int lower = Model.getFacade().getLower(assocEnd);
        int upper = Model.getFacade().getUpper(assocEnd);
        int refLower = Model.getFacade().getLower(otherAssocEnd);
        int refUpper = Model.getFacade().getUpper(otherAssocEnd);
        fkDef.setForeignKeyName(Model.getFacade().getName(assoc));
        fkDef.setLower(lower);
        fkDef.setUpper(upper);
        fkDef.setReferencesLower(refLower);
        fkDef.setReferencesUpper(refUpper);
        return fkDef;
    }

    public Collection<String> generateFileList(Collection elements, boolean deps) {
        HashSet<String> c = new HashSet<String>();
        c.add(SCRIPT_FILENAME);
        return c;
    }

    public synchronized List<SqlCodeCreator> getSqlCodeCreators() {
        if (this.sqlCodeCreators == null) {
            this.sqlCodeCreators = this.loadSqlCodeCreators();
        }
        return this.sqlCodeCreators;
    }

    public DomainMapper getDomainMapper() {
        return this.domainMapper;
    }

    public void setSqlCodeCreator(SqlCodeCreator sqlCodeCreator) {
        this.sqlCodeCreator = sqlCodeCreator;
    }
}

