/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.sql;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;
import org.argouml.language.sql.SqlCodeCreator;
import org.argouml.language.sql.Utils;

public class SqlCreatorLoader {
    private static final Logger LOG = Logger.getLogger(SqlCreatorLoader.class);
    private File moduleDir;

    private Collection<Class> getClassesFromJar(ClassLoader classLoader, JarFile jarFile) {
        HashSet<Class> classes = new HashSet<Class>();
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            String name = ze.getName();
            if (!name.endsWith(".class")) continue;
            name = name.substring(0, name.length() - 6);
            name = name.replace("/", ".");
            try {
                classes.add(classLoader.loadClass(name));
            }
            catch (ClassNotFoundException e1) {
                LOG.info((Object)("Class could not be loaded from jar: " + name));
            }
            catch (UnsupportedClassVersionError e1) {
                LOG.error((Object)("Unsupported Java class version for " + name));
            }
            catch (NoClassDefFoundError e1) {
                LOG.error((Object)("Unable to find required class while loading " + name + " - may indicate an obsolete" + " extension module or an unresolved dependency"), (Throwable)e1);
            }
            catch (Throwable e1) {
                LOG.error((Object)("Unexpected error while loading " + name), e1);
            }
        }
        return classes;
    }

    private Collection<Class> getClassesFromDir(File dir) {
        HashSet<Class> result = new HashSet<Class>();
        if (!dir.exists()) {
            return result;
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                result.addAll(this.getClassesFromDir(file));
                continue;
            }
            if (file.getName().endsWith(".jar")) {
                try {
                    JarFile jarFile = new JarFile(file);
                    URLClassLoader cl = new URLClassLoader(new URL[]{file.toURL()}, this.getClass().getClassLoader());
                    result.addAll(this.getClassesFromJar(cl, jarFile));
                }
                catch (IOException e) {
                    LOG.error((Object)"Exception", (Throwable)e);
                }
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String className = file.getName();
            className = className.substring(0, className.length() - ".class".length());
            String packageName = dir.getAbsolutePath();
            if ((packageName = packageName.substring(this.moduleDir.getPath().length())).startsWith(File.separator)) {
                packageName = packageName.substring(1);
            }
            packageName = packageName.replace(File.separatorChar, '.');
            className = packageName + "." + className;
            try {
                result.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                LOG.info((Object)("Class could not be loaded from .class-file: " + className));
            }
        }
        return result;
    }

    public Collection<Class<SqlCodeCreator>> getCodeCreators() {
        HashSet<Class> classes = new HashSet<Class>();
        this.moduleDir = new File(Utils.getModuleRoot());
        classes.addAll(this.getClassesFromDir(this.moduleDir));
        HashSet<Class<SqlCodeCreator>> result = new HashSet<Class<SqlCodeCreator>>();
        for (Class foundClass : classes) {
            if (foundClass == SqlCodeCreator.class || !SqlCodeCreator.class.isAssignableFrom(foundClass)) continue;
            result.add(foundClass);
        }
        return result;
    }
}

