/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.sql.reveng;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.Parser;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.argouml.i18n.Translator;
import org.argouml.kernel.Project;
import org.argouml.language.sql.reveng.ANTLRNoCaseInputStreamReader;
import org.argouml.language.sql.reveng.Modeller;
import org.argouml.language.sql.reveng.SqlImportSettings;
import org.argouml.taskmgmt.ProgressMonitor;
import org.argouml.uml.reveng.FileImportUtils;
import org.argouml.uml.reveng.ImportInterface;
import org.argouml.uml.reveng.ImportSettings;
import org.argouml.uml.reveng.ImporterManager;
import org.argouml.uml.reveng.SettingsTypes;
import org.argouml.util.SuffixFilter;

public class SqlImport
implements ImportInterface {
    private Collection<Object> newElements;
    private String settingLevel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object> parseFiles(Project p, Collection<File> files, ImportSettings settings, ProgressMonitor monitor) throws ImportInterface.ImportException {
        SqlImportSettings.getInstance().saveSettings();
        SqlImportSettings sqlSettings = SqlImportSettings.getInstance();
        String sgbd = sqlSettings.getCodeSgbd();
        this.settingLevel = sqlSettings.getCodeLevel();
        this.newElements = new HashSet<Object>();
        monitor.updateMainTask(Translator.localize((String)"dialog.import.pass1"));
        monitor.setMaximumProgress(files.size());
        this.doImportPass(p, files, settings, monitor, 0, 0, sgbd);
        return this.newElements;
    }

    private void doImportPass(Project p, Collection<File> files, ImportSettings settings, ProgressMonitor monitor, int startCount, int pass, String sgbdName) {
        int count = startCount;
        for (File file : files) {
            if (monitor.isCanceled()) {
                monitor.updateSubTask(Translator.localize((String)"dialog.import.cancelled"));
                return;
            }
            try {
                this.parseFile(p, file, settings, pass, sgbdName);
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                monitor.notifyMessage(Translator.localize((String)"dialog.title.import-problems"), Translator.localize((String)"label.import-problems"), sw.toString());
                if (monitor.isCanceled()) break;
            }
            monitor.updateProgress(count++);
            monitor.updateSubTask(Translator.localize((String)"dialog.import.parsingAction", (Object[])new Object[]{file.getAbsolutePath()}));
        }
    }

    private void parseFile(Project p, File f, ImportSettings settings, int pass, String sgbdName) throws ImportInterface.ImportException {
        try {
            InputStreamReader isr;
            String encoding = settings.getInputSourceEncoding();
            FileInputStream in = new FileInputStream(f);
            try {
                isr = new InputStreamReader((InputStream)in, encoding);
            }
            catch (UnsupportedEncodingException e) {
                isr = new InputStreamReader(in);
            }
            Modeller modeller = new Modeller(p.getUserDefinedModelList().get(0), null, f.getName());
            modeller.setLevel(this.settingLevel);
            try {
                Class<?> lexerClass = Class.forName("org.argouml.language.sql.reveng." + sgbdName + "Lexer");
                Class[] argTypes = new Class[]{CharStream.class};
                Constructor<?> constructor = lexerClass.getDeclaredConstructor(argTypes);
                Object[] argumentsLexer = new Object[]{new ANTLRNoCaseInputStreamReader(isr)};
                Lexer instanceLexer = (Lexer)constructor.newInstance(argumentsLexer);
                Class<?> parserClass = Class.forName("org.argouml.language.sql.reveng." + sgbdName + "Parser");
                Class[] argTypesP = new Class[]{TokenStream.class};
                Constructor<?> constructorParser = parserClass.getDeclaredConstructor(argTypesP);
                Object[] arguments = new Object[]{new CommonTokenStream((TokenSource)instanceLexer)};
                Parser instanceParser = (Parser)constructorParser.newInstance(arguments);
                Class[] argTypesM = new Class[]{Modeller.class, Lexer.class};
                Method printMethod = parserClass.getMethod("dump_read", argTypesM);
                Object[] argumentsM = new Object[]{modeller, instanceLexer};
                printMethod.invoke((Object)instanceParser, argumentsM);
            }
            catch (ClassNotFoundException e) {
                StringBuilder errorString = new StringBuilder("Parser or Lexer not found : ");
                errorString.append(sgbdName);
                errorString.append(". ");
                errorString.append(this.buildErrorString(f));
                throw new ImportInterface.ImportException(errorString.toString(), (Throwable)e);
            }
            catch (Exception e) {
                String errorString = this.buildErrorString(f);
                throw new ImportInterface.ImportException(errorString, (Throwable)e);
            }
            finally {
                this.newElements.addAll(modeller.getNewElements());
                in.close();
            }
        }
        catch (IOException e) {
            throw new ImportInterface.ImportException(this.buildErrorString(f), (Throwable)e);
        }
    }

    private String buildErrorString(File f) {
        String path = "";
        try {
            path = f.getName();
            path = f.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "Exception in file: " + path;
    }

    public String getName() {
        return "Sql-import";
    }

    public String getInfo(int type) {
        switch (type) {
            case 0: {
                return "SQL import from dump files.";
            }
            case 1: {
                return "Laurent BRAUD";
            }
            case 2: {
                return "0.35.1";
            }
            case 3: {
                return "http://argouml-sql.tigris.org/";
            }
        }
        return null;
    }

    public SuffixFilter[] getSuffixFilters() {
        SuffixFilter[] result = new SuffixFilter[]{new SuffixFilter("sql", Translator.localize((String)"argouml-sql.filefilter.sql"))};
        return result;
    }

    public boolean disable() {
        return false;
    }

    public boolean enable() {
        ImporterManager.getInstance().addImporter((ImportInterface)this);
        return true;
    }

    public List<SettingsTypes.Setting> getImportSettings() {
        return SqlImportSettings.getInstance().getImportSettings();
    }

    public boolean isParseable(File file) {
        return FileImportUtils.matchesSuffix((Object)file, (SuffixFilter[])this.getSuffixFilters());
    }
}

