/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.argouml.application.api.GUISettingsTabInterface;
import org.argouml.i18n.Translator;
import org.argouml.language.sql.DomainMapper;
import org.argouml.language.sql.GeneratorSql;
import org.argouml.language.sql.SqlCodeCreator;
import org.argouml.ui.GridBagUtils;
import org.argouml.ui.TableModelCodeCreators;

public class SettingsTabSql
extends JPanel
implements GUISettingsTabInterface,
ListSelectionListener {
    private String[] columnNames = new String[]{Translator.localize((String)"argouml-sql.settings.domain"), Translator.localize((String)"argouml-sql.settings.datatype")};
    private List elements;
    private boolean initialized = false;
    private JLabel lblDomainMappings;
    private JLabel lblFound;
    private JTable tblFound;
    private SqlCodeCreator previousSelected;
    private JTable tblDomainMappings;

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateMappings();
        int index = this.tblFound.getSelectedRow();
        SqlCodeCreator scc = (SqlCodeCreator)this.tblFound.getModel().getValueAt(index, -1);
        TableModelDomainMappings tm = new TableModelDomainMappings(scc.getClass());
        this.tblDomainMappings.setModel(tm);
        this.previousSelected = scc;
    }

    private Object[] getElementForRow(int index) {
        return (Object[])this.elements.get(index);
    }

    public String getTabKey() {
        return "argouml-sql.settings.title";
    }

    public JPanel getTabPanel() {
        if (!this.initialized) {
            GridBagLayout l = new GridBagLayout();
            l.rowWeights = new double[]{0.0, 1.0, 0.0, 1.0};
            l.columnWeights = new double[]{0.0, 1.0};
            this.setLayout(l);
            this.lblFound = new JLabel(Translator.localize((String)"argouml-sql.settings.found-creators") + ":");
            this.tblFound = new JTable(new TableModelCodeCreators());
            this.tblFound.getSelectionModel().addListSelectionListener(this);
            this.lblDomainMappings = new JLabel(Translator.localize((String)"argouml-sql.settings.mapped-domains") + ":");
            this.tblDomainMappings = new JTable();
            this.add((Component)this.lblFound, GridBagUtils.captionConstraints(0, 0));
            JScrollPane spFound = new JScrollPane(this.tblFound);
            spFound.setPreferredSize(new Dimension(300, 200));
            this.add((Component)spFound, GridBagUtils.clientAlignConstraints(0, 1, 2, 1));
            this.add((Component)this.lblDomainMappings, GridBagUtils.captionConstraints(0, 2));
            this.add((Component)new JScrollPane(this.tblDomainMappings), GridBagUtils.clientAlignConstraints(0, 3, 2, 1));
            this.initialized = true;
        }
        return this;
    }

    public void handleResetToDefault() {
        GeneratorSql.getInstance().getDomainMapper().load();
    }

    public void handleSettingsTabCancel() {
        GeneratorSql.getInstance().getDomainMapper().load();
    }

    public void handleSettingsTabRefresh() {
        GeneratorSql.getInstance().getDomainMapper().load();
    }

    public void handleSettingsTabSave() {
        this.updateMappings();
        GeneratorSql.getInstance().getDomainMapper().save();
    }

    private void updateMappings() {
        if (this.previousSelected != null) {
            DomainMapper m = GeneratorSql.getInstance().getDomainMapper();
            m.clear(this.previousSelected.getClass());
            for (int i = 0; i < this.elements.size(); ++i) {
                Object[] element = this.getElementForRow(i);
                String domain = (String)element[0];
                String datatype = (String)element[1];
                m.setDatatype(this.previousSelected.getClass(), domain, datatype);
            }
        }
    }

    private class TableModelDomainMappings
    extends AbstractTableModel {
        public TableModelDomainMappings(Class codeCreatorClass) {
            DomainMapper m = GeneratorSql.getInstance().getDomainMapper();
            Map<String, String> mappings = m.getMappingsFor(codeCreatorClass);
            SettingsTabSql.this.elements = new ArrayList();
            if (mappings != null) {
                Set<Map.Entry<String, String>> entries = mappings.entrySet();
                for (Map.Entry<String, String> entry : entries) {
                    SettingsTabSql.this.elements.add(this.newElement(entry.getKey(), entry.getValue()));
                }
            }
        }

        private Object[] newElement(Object key, Object value) {
            Object[] element = new Object[]{key, value};
            return element;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex >= 0 && columnIndex <= 1) {
                return String.class;
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            return SettingsTabSql.this.columnNames[column];
        }

        @Override
        public int getRowCount() {
            return SettingsTabSql.this.elements.size() + 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object result = null;
            if (rowIndex == SettingsTabSql.this.elements.size()) {
                result = "";
            } else {
                Object[] element = SettingsTabSql.this.getElementForRow(rowIndex);
                result = element[columnIndex];
            }
            return result;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return rowIndex < this.getRowCount() && columnIndex >= 0 && columnIndex <= 1;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (rowIndex == SettingsTabSql.this.elements.size()) {
                if (columnIndex == 0) {
                    SettingsTabSql.this.elements.add(this.newElement(aValue, ""));
                } else if (columnIndex == 1) {
                    SettingsTabSql.this.elements.add(this.newElement("", aValue));
                }
            } else {
                ((SettingsTabSql)SettingsTabSql.this).getElementForRow((int)rowIndex)[columnIndex] = aValue;
            }
        }
    }
}

