/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.sequence2.diagram;

import java.awt.Rectangle;
import org.argouml.sequence2.diagram.FigDestroy;
import org.argouml.sequence2.diagram.FigMessage;
import org.argouml.uml.diagram.DiagramSettings;
import org.argouml.uml.diagram.ui.ArgoFigGroup;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigRect;

class FigActivation
extends ArgoFigGroup {
    static final int DEFAULT_HEIGHT = 40;
    static final int DEFAULT_WIDTH = 20;
    private FigRect rectFig;
    private FigDestroy destroyFig;
    private FigMessage activatingMessage;

    public FigActivation(Object owner, Rectangle bounds, DiagramSettings settings, FigMessage activatingMessage) {
        this(owner, bounds, settings, activatingMessage, false);
    }

    public FigActivation(Object owner, Rectangle bounds, DiagramSettings settings, FigMessage activatingMessage, boolean destroy) {
        super(owner, settings);
        this.activatingMessage = activatingMessage;
        this.initialize(bounds, destroy);
    }

    private void initialize(Rectangle bounds, boolean destroy) {
        if (bounds.width == 0) {
            bounds.width = 20;
        }
        if (bounds.height == 0) {
            bounds.height = 40;
        }
        this.rectFig = new FigRect(bounds.x - bounds.width / 2, bounds.y, bounds.width, bounds.height, LINE_COLOR, FILL_COLOR);
        this.rectFig.setLineWidth(1);
        this.addFig((Fig)this.rectFig);
        this.setDestroy(destroy);
    }

    public void setDestroy(boolean isDestroy) {
        if (isDestroy) {
            if (this.destroyFig == null) {
                this.destroyFig = new FigDestroy(this.getOwner(), new Rectangle(this.getX(), this.getY() + this.getHeight(), this.getWidth(), this.getWidth()), this.getSettings());
                this.addFig((Fig)this.destroyFig);
            }
        } else {
            if (this.destroyFig != null) {
                this.removeFig((Fig)this.destroyFig);
            }
            this.destroyFig = null;
        }
    }

    public boolean isDestroy() {
        return this.destroyFig != null;
    }

    public boolean isActivatorEnd(FigMessage messageFig) {
        if (messageFig == null) {
            throw new IllegalArgumentException("An instance of FigMessage is required");
        }
        if (!messageFig.isReplyMessage()) {
            return false;
        }
        if (this.activatingMessage == null) {
            return false;
        }
        return this.activatingMessage.getSourceFigNode() == messageFig.getDestFigNode();
    }

    public FigMessage getActivatingMessage() {
        return this.activatingMessage;
    }
}

