/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.activity2.diagram;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.logging.Logger;
import org.argouml.activity2.diagram.DiagramElement;
import org.argouml.notation2.NotatedItem;
import org.argouml.notation2.NotationLanguage;
import org.argouml.notation2.NotationManager;
import org.argouml.notation2.NotationTextEvent;
import org.argouml.notation2.NotationType;
import org.argouml.uml.diagram.DiagramSettings;
import org.tigris.gef.presentation.FigGroup;
import org.tigris.gef.presentation.FigText;

class FigNotation
extends FigText
implements NotatedItem,
DiagramElement {
    private static final Logger LOG = Logger.getLogger(FigNotation.class.getName());
    private final NotationType notationType;

    public FigNotation(Object owner, Rectangle bounds, DiagramSettings settings, NotationType notationType) {
        super(bounds.x, bounds.y, bounds.width, bounds.height, true);
        this.setOwner(owner);
        this.setFont(settings.getFontPlain());
        this.notationType = notationType;
        this.setTabAction(2);
        this.setReturnAction(2);
        this.setLineWidth(0);
        super.setFilled(true);
        NotationManager.getInstance().addListener((NotatedItem)this);
    }

    public void setLineWidth(int lw) {
        super.setLineWidth(0);
    }

    public void setFilled(boolean filled) {
    }

    public Dimension getMinimumSize() {
        int w = this.getFontMetrics().stringWidth(this.getText());
        int h = this.getFontMetrics().getHeight();
        int minWidth = w + this.getLeftMargin() + this.getRightMargin() + 2 * this.getLineWidth();
        int minHeight = h + this.getTopMargin() + this.getBotMargin() + 2 * this.getLineWidth();
        return new Dimension(minWidth, minHeight);
    }

    public Object getMetaType() {
        return this.getOwner().getClass();
    }

    public NotationLanguage getNotationLanguage() {
        return null;
    }

    public NotationType getNotationType() {
        return this.notationType;
    }

    public void notationTextChanged(NotationTextEvent event) {
        this.setText(event.getText());
        this.setUnderline(event.isUnderlined());
        this.setBold(event.isBold());
        this.setItalic(event.isItalic());
        if (this.getMinimumSize().width > this.getWidth()) {
            this.setWidth(this.getMinimumSize().width);
        }
        this.damage();
    }

    public void setText(String s) {
        String oldText = this.getText();
        if (s.equals(oldText)) {
            return;
        }
        Rectangle oldBounds = this.getBounds();
        super.setText(s);
        this.firePropChange("text", oldText, s);
        FigGroup group = (FigGroup)this.getGroup();
        if (group != null && (oldBounds.width < this.getBounds().width || oldBounds.height < this.getBounds().height)) {
            group.calcBounds();
        }
    }

    public void setUnderline(boolean u) {
        if (this.getUnderline() == u) {
            return;
        }
        super.setUnderline(u);
    }

    public void setBold(boolean b) {
        if (this.getBold() == b) {
            return;
        }
        super.setBold(b);
    }

    public void setItalic(boolean i) {
        if (this.getItalic() == i) {
            return;
        }
        super.setItalic(i);
    }
}

