/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.AccessControlException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import tudresden.ocl.OclTree;
import tudresden.ocl.check.OclTypeException;
import tudresden.ocl.check.types.ModelFacade;
import tudresden.ocl.check.types.Type;
import tudresden.ocl.gui.ConstraintRepresentation;
import tudresden.ocl.gui.EditingUtilities;
import tudresden.ocl.gui.OCLEditor;
import tudresden.ocl.gui.OCLEditorModel;
import tudresden.ocl.gui.OCLEditorPreferences;
import tudresden.ocl.gui.OCLToolbar;
import tudresden.ocl.gui.events.ConstraintChangeEvent;
import tudresden.ocl.gui.events.ConstraintChangeListener;
import tudresden.ocl.parser.OclParserException;
import tudresden.ocl.parser.analysis.DepthFirstAdapter;
import tudresden.ocl.parser.node.AConstraint;
import tudresden.ocl.parser.node.EOF;
import tudresden.ocl.parser.node.Node;
import tudresden.ocl.parser.node.PConstraintBody;
import tudresden.ocl.parser.node.PContextDeclaration;
import tudresden.ocl.parser.node.Start;

public class OCLEditor
extends JPanel
implements ListSelectionListener,
ConstraintChangeListener,
EditingUtilities {
    private static SimpleAttributeSet s_sasField = new SimpleAttributeSet();
    private static SimpleAttributeSet s_sasNormalText = new SimpleAttributeSet();
    private static SimpleAttributeSet s_sasNoEditText = new SimpleAttributeSet();
    private OCLEditorModel m_oclemModel;
    private ConstraintRepresentation m_crCurrent;
    private ConstraintTableModel m_ctmTableModel = this.createConstraintTableModel();
    private boolean m_fDoTypeCheck = true;
    private boolean m_fDoAutoSplit = true;
    private boolean m_fNoContextEdit = false;
    public static final int OPTIONMASK_TYPECHECK = 1;
    public static final int OPTIONMASK_AUTOSPLIT = 2;
    private int m_nOptionMask = 3;
    private boolean m_fInEditMode = false;
    private boolean m_fConstraintChanged;
    private boolean m_fCreatedFreshConstraint = false;
    private boolean m_fHandleCaretUpdates = true;
    private int m_nOldDot = 0;
    private int m_nOldMark = 0;
    private JToolBar m_jtbTools;
    private JButton m_jbNew;
    private JButton m_jbRemove;
    private JButton m_jbEdit;
    private JButton m_jbSaveEditResult;
    private JPanel pad1;
    private JButton m_jbPreferences;
    private JPanel pad2;
    private JCheckBox m_jcbQuickBar;
    private JPanel m_jpToolbarWrapper;
    private OCLToolbar m_ocltbQuickBar;
    private JPanel m_jpEditorPanel;
    private JScrollPane m_jspConstraintEditorScroller;
    private JTextPane m_jtpConstraintEditor;
    private JSplitPane m_jspMainPane;
    private JPanel m_jpConstraintListPane;
    private JScrollPane m_jspConstraintListScroller;
    private JTable m_jtConstraintList;
    private JPanel m_jpPreviewPane;
    private JPanel m_jpPreviewGroup;
    private JScrollPane m_jspConstraintPreviewScroller;
    private JTextPane m_jtpConstraintPreview;

    public OCLEditor() {
        this.initComponents();
        this.m_jpToolbarWrapper.remove(this.m_jpEditorPanel);
        this.m_jtConstraintList.getSelectionModel().setSelectionMode(0);
        this.m_jtConstraintList.getSelectionModel().addListSelectionListener(this);
        this.m_ocltbQuickBar.setVisible(false);
    }

    protected JToolBar getToolbar() {
        return this.m_jtbTools;
    }

    protected OCLToolbar getSyntaxAssistantToolbar() {
        return this.m_ocltbQuickBar;
    }

    protected ConstraintTableModel createConstraintTableModel() {
        return new ConstraintTableModel(this);
    }

    public OCLEditorModel getModel() {
        return this.m_oclemModel;
    }

    public void setModel(OCLEditorModel oclemModel) {
        this.setEditMode(false);
        if (this.m_oclemModel != null) {
            this.m_oclemModel.removeConstraintChangeListener(this);
        }
        this.m_oclemModel = oclemModel;
        this.m_ctmTableModel.setOCLModel(oclemModel);
        if (this.m_oclemModel != null) {
            this.m_oclemModel.addConstraintChangeListener(this);
        }
        this.m_jtConstraintList.clearSelection();
    }

    public boolean isInEditMode() {
        return this.m_fInEditMode;
    }

    public void setEditMode(boolean fEditMode) {
        if (fEditMode == this.m_fInEditMode) {
            return;
        }
        if (!this.m_fInEditMode) {
            if (this.m_crCurrent == null) {
                return;
            }
            this.m_fInEditMode = true;
            this.m_fConstraintChanged = false;
            this.m_jpToolbarWrapper.remove(this.m_jspMainPane);
            this.m_jpToolbarWrapper.add((Component)this.m_jpEditorPanel, "Center");
            this.m_jbNew.setVisible(false);
            this.m_jbRemove.setVisible(false);
            this.m_jbEdit.setIcon(new ImageIcon(this.getClass().getResource("/tudresden/ocl/images/Cancel16.gif")));
            this.m_jbEdit.setToolTipText("Click to cancel editing without saving changes");
            this.m_jbSaveEditResult.setVisible(true);
            this.m_jtpConstraintEditor.requestFocus();
            this.m_ocltbQuickBar.setVisible(this.m_jcbQuickBar.isSelected());
            this.m_jcbQuickBar.setVisible(true);
        } else {
            int nIdx;
            this.m_fInEditMode = false;
            if (this.m_fCreatedFreshConstraint && !this.m_fConstraintChanged && (nIdx = this.m_jtConstraintList.getSelectedRow()) != -1) {
                this.m_oclemModel.removeConstraintAt(nIdx);
            }
            this.m_fCreatedFreshConstraint = false;
            this.m_fConstraintChanged = false;
            this.m_jpToolbarWrapper.remove(this.m_jpEditorPanel);
            this.m_jpToolbarWrapper.add((Component)this.m_jspMainPane, "Center");
            this.setEditorText(this.m_crCurrent);
            this.m_jbNew.setVisible(true);
            this.m_jbRemove.setVisible(true);
            this.m_jbEdit.setIcon(new ImageIcon(this.getClass().getResource("/tudresden/ocl/images/Edit16.gif")));
            this.m_jbEdit.setToolTipText("Click to edit the currently selected constraint");
            this.m_jbSaveEditResult.setVisible(false);
            this.m_ocltbQuickBar.setVisible(false);
            this.m_jcbQuickBar.setVisible(false);
        }
        this.m_jpToolbarWrapper.revalidate();
        this.m_jpToolbarWrapper.repaint();
    }

    public boolean isValidConstraintName(String sName) {
        if (sName == null || sName.length() == 0) {
            return false;
        }
        if (!Character.isLetter(sName.charAt(0)) || !Character.isLowerCase(sName.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < sName.length()) {
            if (!Character.isLetterOrDigit(sName.charAt(i)) && sName.charAt(i) != '_') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setOptionMask(int nOptionMask) {
        this.m_nOptionMask = nOptionMask;
        if (this.m_nOptionMask == 0) {
            return;
        }
    }

    public int getOptionMask() {
        return this.m_nOptionMask;
    }

    public void setNoContextEdit(boolean fNoContextEdit) {
        this.m_fNoContextEdit = fNoContextEdit;
    }

    public boolean getNoContextEdit() {
        return this.m_fNoContextEdit;
    }

    public void setDoTypeCheck(boolean fDoTypeCheck) {
        this.m_fDoTypeCheck = fDoTypeCheck;
    }

    public boolean getDoTypeCheck() {
        return this.m_fDoTypeCheck;
    }

    public OclTree parseAndCheckConstraint(String sConstraint, ModelFacade mfFacade) throws OclParserException, IOException, OclTypeException {
        final OclTree tree = OclTree.createTree(sConstraint, mfFacade);
        if (tree != null && this.m_fDoTypeCheck) {
            DepthFirstAdapter dfaTypeChecker = new DepthFirstAdapter(){
                private RuntimeException m_rteException = null;

                public void inStart(Start node) {
                    this.defaultIn(node);
                }

                public void outStart(Start s) {
                    if (this.m_rteException != null) {
                        throw this.m_rteException;
                    }
                }

                public void defaultIn(Node node) {
                    block2: {
                        try {
                            Type o = tree.getNodeType(node);
                        }
                        catch (RuntimeException e) {
                            if (this.m_rteException != null) break block2;
                            this.m_rteException = e;
                        }
                    }
                }
            };
            try {
                tree.apply(dfaTypeChecker);
                try {
                    tree.applyGeneratedTests();
                }
                catch (AccessControlException ace) {}
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new OclTypeException(e.getMessage());
            }
        }
        return tree;
    }

    public void setDoAutoSplit(boolean fDoAutoSplit) {
        this.m_fDoAutoSplit = fDoAutoSplit;
    }

    public boolean getDoAutoSplit() {
        return this.m_fDoAutoSplit;
    }

    public List splitConstraint(OclTree ocltConstraint) {
        LinkedList lResult = new LinkedList();
        class Splitter
        extends DepthFirstAdapter {
            private final /* synthetic */ List val$lResult;
            private final /* synthetic */ OCLEditor this$0;

            Splitter(OCLEditor this$0, List val$lResult) {
                this.this$0 = this$0;
                this.val$lResult = val$lResult;
            }

            public void caseAConstraint(AConstraint node) {
                PContextDeclaration pcd = node.getContextDeclaration();
                Iterator<E> i = node.getConstraintBody().iterator();
                while (i.hasNext()) {
                    PConstraintBody pcbCurrent = (PConstraintBody)i.next();
                    LinkedList<Object> lTempBody = new LinkedList<Object>();
                    lTempBody.add(pcbCurrent.clone());
                    this.val$lResult.add(new OclTree(new Start(new AConstraint((PContextDeclaration)pcd.clone(), lTempBody), new EOF())));
                }
            }
        }
        ocltConstraint.apply(new Splitter(this, lResult));
        return lResult;
    }

    void addConstraintText(String[] saBefore, String sText, String[] saAfter) {
        if (this.m_crCurrent != null && this.isInEditMode()) {
            int i;
            int nSelStart = -1;
            int nSelEnd = -1;
            this.m_fHandleCaretUpdates = false;
            this.m_jtpConstraintEditor.replaceSelection("");
            if (saBefore != null) {
                this.m_jtpConstraintEditor.setCharacterAttributes(s_sasField, true);
                i = 0;
                while (i < saBefore.length) {
                    if (i == 0) {
                        nSelStart = this.m_jtpConstraintEditor.getSelectionStart();
                        nSelEnd = nSelStart + saBefore[i].length();
                    }
                    this.m_jtpConstraintEditor.replaceSelection(saBefore[i]);
                    ++i;
                }
                this.m_jtpConstraintEditor.setCharacterAttributes(s_sasNormalText, true);
            }
            this.m_jtpConstraintEditor.replaceSelection(sText);
            if (saAfter != null) {
                this.m_jtpConstraintEditor.setCharacterAttributes(s_sasField, true);
                i = 0;
                while (i < saAfter.length) {
                    if (i == 0 && nSelStart == -1) {
                        nSelStart = this.m_jtpConstraintEditor.getSelectionStart();
                        nSelEnd = nSelStart + saAfter[i].length();
                    }
                    this.m_jtpConstraintEditor.replaceSelection(saAfter[i]);
                    ++i;
                }
                this.m_jtpConstraintEditor.setCharacterAttributes(s_sasNormalText, true);
            }
            if (nSelStart != -1) {
                this.m_jtpConstraintEditor.paintImmediately(0, 0, this.m_jtpConstraintEditor.getWidth(), this.m_jtpConstraintEditor.getHeight());
                this.m_jtpConstraintEditor.setSelectionStart(nSelStart);
                this.m_jtpConstraintEditor.setSelectionEnd(nSelEnd);
            }
            this.m_fHandleCaretUpdates = true;
        }
    }

    protected void setEditorText(ConstraintRepresentation cr) {
        this.m_jtpConstraintEditor.setCharacterAttributes(s_sasNormalText, true);
        if (cr != null) {
            if (this.m_fNoContextEdit) {
                int nPostPos;
                int nPrePos;
                ((OCLEditorDocument)this.m_jtpConstraintEditor.getDocument()).stopChecking();
                this.m_jtpConstraintEditor.setText("");
                ((OCLEditorDocument)this.m_jtpConstraintEditor.getDocument()).restartChecking();
                String s = cr.getData();
                int nInvPos = s.indexOf("inv");
                if (nInvPos == -1) {
                    nInvPos = s.length();
                }
                if ((nPrePos = s.indexOf("pre")) == -1) {
                    nPrePos = s.length();
                }
                if ((nPostPos = s.indexOf("post")) == -1) {
                    nPostPos = s.length();
                }
                int nContextEnd = Math.min(Math.min(nInvPos, nPrePos), nPostPos);
                this.m_jtpConstraintEditor.setCharacterAttributes(s_sasNoEditText, true);
                this.m_jtpConstraintEditor.replaceSelection(s.substring(0, nContextEnd));
                this.m_jtpConstraintEditor.setCharacterAttributes(s_sasNormalText, true);
                this.m_jtpConstraintEditor.replaceSelection(s.substring(nContextEnd));
            } else {
                ((OCLEditorDocument)this.m_jtpConstraintEditor.getDocument()).stopChecking();
                this.m_jtpConstraintEditor.setText(cr.getData());
                ((OCLEditorDocument)this.m_jtpConstraintEditor.getDocument()).restartChecking();
            }
        } else {
            ((OCLEditorDocument)this.m_jtpConstraintEditor.getDocument()).stopChecking();
            this.m_jtpConstraintEditor.setText("");
            ((OCLEditorDocument)this.m_jtpConstraintEditor.getDocument()).restartChecking();
        }
    }

    private void initComponents() {
        this.m_jtbTools = new JToolBar();
        this.m_jbNew = new JButton();
        this.m_jbRemove = new JButton();
        this.m_jbEdit = new JButton();
        this.m_jbSaveEditResult = new JButton();
        this.m_jbSaveEditResult.setVisible(false);
        this.pad1 = new JPanel();
        this.m_jbPreferences = new JButton();
        this.pad2 = new JPanel();
        this.m_jcbQuickBar = new JCheckBox();
        this.m_jcbQuickBar.setVisible(false);
        this.m_jpToolbarWrapper = new JPanel();
        this.m_ocltbQuickBar = new OCLToolbar();
        this.m_jpEditorPanel = new JPanel();
        this.m_jspConstraintEditorScroller = new JScrollPane();
        this.m_jtpConstraintEditor = new JTextPane();
        this.m_jspMainPane = new JSplitPane();
        this.m_jpConstraintListPane = new JPanel();
        this.m_jspConstraintListScroller = new JScrollPane();
        this.m_jtConstraintList = new JTable();
        this.m_jpPreviewPane = new JPanel();
        this.m_jpPreviewGroup = new JPanel();
        this.m_jspConstraintPreviewScroller = new JScrollPane();
        this.m_jtpConstraintPreview = new JTextPane();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(500, 300));
        this.setMinimumSize(new Dimension(500, 300));
        this.m_jtbTools.setName("OCL Editor Tools");
        this.m_jbNew.setIcon(new ImageIcon(this.getClass().getResource("/tudresden/ocl/images/New16.gif")));
        this.m_jbNew.setToolTipText("Click to create a new constraint");
        this.m_jbNew.setMargin(new Insets(0, 0, 0, 0));
        this.m_jbNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OCLEditor.this.onNewConstraintButton(evt);
            }
        });
        this.m_jtbTools.add(this.m_jbNew);
        this.m_jbRemove.setIcon(new ImageIcon(this.getClass().getResource("/tudresden/ocl/images/Delete16.gif")));
        this.m_jbRemove.setToolTipText("Click to remove the currently selected constraint");
        this.m_jbRemove.setMargin(new Insets(0, 0, 0, 0));
        this.m_jbRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OCLEditor.this.onRemoveConstraintButton(evt);
            }
        });
        this.m_jtbTools.add(this.m_jbRemove);
        this.m_jbEdit.setIcon(new ImageIcon(this.getClass().getResource("/tudresden/ocl/images/Edit16.gif")));
        this.m_jbEdit.setToolTipText("Click to edit the currently selected constraint");
        this.m_jbEdit.setMargin(new Insets(0, 0, 0, 0));
        this.m_jbEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OCLEditor.this.onEditButton(evt);
            }
        });
        this.m_jtbTools.add(this.m_jbEdit);
        this.m_jbSaveEditResult.setIcon(new ImageIcon(this.getClass().getResource("/tudresden/ocl/images/Ok16.gif")));
        this.m_jbSaveEditResult.setToolTipText("Check OCL syntax and save constraint into model");
        this.m_jbSaveEditResult.setMargin(new Insets(0, 0, 0, 0));
        this.m_jbSaveEditResult.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OCLEditor.this.onSubmitConstraintButton(evt);
            }
        });
        this.m_jtbTools.add(this.m_jbSaveEditResult);
        this.pad1.setMaximumSize(new Dimension(10, 10));
        this.m_jtbTools.add(this.pad1);
        this.m_jbPreferences.setIcon(new ImageIcon(this.getClass().getResource("/tudresden/ocl/images/Preferences16.gif")));
        this.m_jbPreferences.setToolTipText("Click to inspect and modify OCL editor preferences.");
        this.m_jbPreferences.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OCLEditor.this.onPreferencesButton(evt);
            }
        });
        this.m_jtbTools.add(this.m_jbPreferences);
        this.pad2.setPreferredSize(new Dimension(5, 10));
        this.pad2.setMinimumSize(new Dimension(5, 10));
        this.pad2.setMaximumSize(new Dimension(5, 10));
        this.m_jtbTools.add(this.pad2);
        this.m_jcbQuickBar.setToolTipText("Check to see the syntax assistant toolbar");
        this.m_jcbQuickBar.setText("Syntax Assistant");
        this.m_jcbQuickBar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OCLEditor.this.onQuickBarButton(evt);
            }
        });
        this.m_jtbTools.add(this.m_jcbQuickBar);
        this.add((Component)this.m_jtbTools, "North");
        this.m_jpToolbarWrapper.setLayout(new BorderLayout());
        this.m_ocltbQuickBar.setEditor(this);
        this.m_jpToolbarWrapper.add((Component)this.m_ocltbQuickBar, "North");
        this.m_jpEditorPanel.setLayout(new GridBagLayout());
        this.m_jpEditorPanel.setBorder(new TitledBorder("Edit constraint"));
        this.m_jtpConstraintEditor.setToolTipText("Edit the constraint expression");
        this.m_jtpConstraintEditor.setDocument(new OCLEditorDocument());
        this.m_jtpConstraintEditor.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                OCLEditor.this.onCaretUpdate(evt);
            }
        });
        this.m_jspConstraintEditorScroller.setViewportView(this.m_jtpConstraintEditor);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.gridheight = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(5, 5, 10, 5);
        gridBagConstraints1.anchor = 18;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.m_jpEditorPanel.add((Component)this.m_jspConstraintEditorScroller, gridBagConstraints1);
        this.m_jpToolbarWrapper.add((Component)this.m_jpEditorPanel, "Center");
        this.m_jspMainPane.setOneTouchExpandable(true);
        this.m_jpConstraintListPane.setLayout(new GridBagLayout());
        this.m_jpConstraintListPane.setPreferredSize(new Dimension(100, 37));
        this.m_jtConstraintList.setToolTipText("Lists all constraints. Selecting a constraint, shows its body in the right hand preview pane. Clicking twice on a constraint allows editing the constraint's name.");
        this.m_jtConstraintList.setModel(this.m_ctmTableModel);
        this.m_jspConstraintListScroller.setViewportView(this.m_jtConstraintList);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(10, 5, 5, 5);
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.m_jpConstraintListPane.add((Component)this.m_jspConstraintListScroller, gridBagConstraints2);
        this.m_jspMainPane.setLeftComponent(this.m_jpConstraintListPane);
        this.m_jpPreviewPane.setLayout(new GridBagLayout());
        this.m_jpPreviewPane.setPreferredSize(new Dimension(100, 80));
        this.m_jpPreviewGroup.setLayout(new GridBagLayout());
        this.m_jpPreviewGroup.setBorder(new TitledBorder("Preview"));
        this.m_jtpConstraintPreview.setToolTipText("Constraint expression preview");
        this.m_jtpConstraintPreview.setEditable(false);
        this.m_jspConstraintPreviewScroller.setViewportView(this.m_jtpConstraintPreview);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridwidth = 0;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints4.anchor = 18;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        this.m_jpPreviewGroup.add((Component)this.m_jspConstraintPreviewScroller, gridBagConstraints4);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.gridheight = 0;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.insets = new Insets(0, 5, 20, 5);
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        this.m_jpPreviewPane.add((Component)this.m_jpPreviewGroup, gridBagConstraints3);
        this.m_jspMainPane.setRightComponent(this.m_jpPreviewPane);
        this.m_jpToolbarWrapper.add((Component)this.m_jspMainPane, "Center");
        this.add((Component)this.m_jpToolbarWrapper, "Center");
    }

    private void onEditButton(ActionEvent evt) {
        this.setEditMode(!this.isInEditMode());
    }

    private void onNewConstraintButton(ActionEvent evt) {
        if (this.m_oclemModel != null) {
            int nOldCount = this.m_oclemModel.getConstraintCount();
            this.m_oclemModel.addConstraint();
            if (this.m_oclemModel.getConstraintCount() > nOldCount) {
                this.m_fCreatedFreshConstraint = true;
                this.setEditMode(true);
            }
        }
    }

    private void onPreferencesButton(ActionEvent evt) {
        ((Component)new OCLEditorPreferences(new JFrame(), this)).setVisible(true);
    }

    private void onCaretUpdate(CaretEvent evt) {
        if (!this.m_fHandleCaretUpdates) {
            return;
        }
        final CaretEvent e = evt;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Element eAffected = OCLEditor.this.m_jtpConstraintEditor.getDocument().getDefaultRootElement();
                while (!eAffected.isLeaf()) {
                    eAffected = eAffected.getElement(eAffected.getElementIndex(e.getDot()));
                }
                if (eAffected.getAttributes().getAttribute("isField") == Boolean.TRUE) {
                    int nFieldStart = eAffected.getStartOffset();
                    int nFieldEnd = eAffected.getEndOffset();
                    int nMark = e.getMark();
                    int nDot = e.getDot();
                    int nSelStart = 0;
                    int nSelEnd = 0;
                    if (nMark == nDot) {
                        if (OCLEditor.this.m_nOldDot > nDot) {
                            nSelStart = nFieldEnd;
                            nSelEnd = nFieldStart;
                        } else {
                            nSelStart = nFieldStart;
                            nSelEnd = nFieldEnd;
                        }
                    } else if (nMark < nDot) {
                        if (OCLEditor.this.m_nOldDot > nDot) {
                            nSelStart = Math.min(nMark, nFieldStart);
                            nSelEnd = Math.min(nDot, nFieldStart);
                        } else {
                            nSelStart = nMark > nFieldStart ? nFieldStart : nMark;
                            nSelEnd = nDot <= nFieldEnd ? nFieldEnd : nDot;
                        }
                    } else if (OCLEditor.this.m_nOldDot < nDot) {
                        nSelStart = Math.max(nMark, nFieldEnd);
                        nSelEnd = Math.max(nDot, nFieldEnd);
                    } else {
                        nSelStart = nMark < nFieldEnd ? nFieldEnd : nMark;
                        nSelEnd = nDot >= nFieldStart ? nFieldStart : nDot;
                    }
                    Caret c = OCLEditor.this.m_jtpConstraintEditor.getCaret();
                    OCLEditor.this.m_fHandleCaretUpdates = false;
                    c.setDot(nSelStart);
                    c.moveDot(nSelEnd);
                    OCLEditor.this.m_fHandleCaretUpdates = true;
                    OCLEditor.this.m_nOldMark = nSelEnd;
                    OCLEditor.this.m_nOldDot = nSelEnd;
                } else {
                    OCLEditor.this.m_nOldDot = e.getDot();
                    OCLEditor.this.m_nOldMark = e.getMark();
                }
            }
        });
    }

    private void onQuickBarButton(ActionEvent evt) {
        this.m_ocltbQuickBar.setVisible(this.m_jcbQuickBar.isSelected());
        this.revalidate();
        this.repaint();
    }

    protected String wrapMessage(String sMessage, int nMaxLineLen) {
        StringBuffer sbResult = new StringBuffer(sMessage.length());
        int i = 0;
        while (i < sMessage.length()) {
            int nEndOfLine = i + nMaxLineLen;
            if (nEndOfLine > sMessage.length()) {
                nEndOfLine = sMessage.length();
            }
            while (nEndOfLine > i + 1 && sMessage.charAt(nEndOfLine - 1) != ' ') {
                --nEndOfLine;
            }
            sbResult.append(sMessage.substring(i, nEndOfLine - 1)).append('\n');
            i = nEndOfLine;
        }
        return sbResult.toString();
    }

    private void onSubmitConstraintButton(ActionEvent evt) {
        int nIdx;
        if (this.m_oclemModel != null && (nIdx = this.m_jtConstraintList.getSelectedRow()) != -1) {
            try {
                this.m_oclemModel.getConstraintAt(nIdx).setData(this.m_jtpConstraintEditor.getText(), this);
                this.m_fConstraintChanged = true;
                this.setEditMode(false);
            }
            catch (OclParserException ope) {
                int nCaretPos = this.getCaretPositionFromLineAndColumn(ope.getErrorLine(), ope.getErrorCol());
                String sWrappedMessage = this.wrapMessage(ope.getMessage(), 50);
                JOptionPane.showMessageDialog(null, "Syntax error:\n" + sWrappedMessage, "Error", 0);
                this.m_jtpConstraintEditor.select(nCaretPos, nCaretPos);
                this.m_jtpConstraintEditor.requestFocus();
            }
            catch (OclTypeException ote) {
                String sWrappedMessage = this.wrapMessage(ote.getMessage(), 50);
                JOptionPane.showMessageDialog(null, "Type checking failed:\n" + sWrappedMessage, "Error", 0);
            }
            catch (IllegalStateException ise) {
                String sWrappedMessage = this.wrapMessage(ise.getMessage(), 50);
                JOptionPane.showMessageDialog(null, "Couldn't set constraint:\n" + sWrappedMessage, "Error", 0);
            }
        }
    }

    protected int getCaretPositionFromLineAndColumn(int nLine, int nCol) {
        int nCurLine = 1;
        int nCurCol = 1;
        String sText = this.m_jtpConstraintEditor.getText();
        int nCaret = 0;
        while (nCurLine != nLine || nCurCol != nCol) {
            if (nCaret >= sText.length()) {
                return 0;
            }
            if (sText.charAt(nCaret) == '\n') {
                ++nCurLine;
                nCurCol = 1;
            } else {
                ++nCurCol;
            }
            ++nCaret;
        }
        return nCaret;
    }

    private void onRemoveConstraintButton(ActionEvent evt) {
        int nIdx;
        if (this.m_oclemModel != null && (nIdx = this.m_jtConstraintList.getSelectedRow()) != -1) {
            this.m_oclemModel.removeConstraintAt(nIdx);
        }
    }

    public void valueChanged(ListSelectionEvent p1) {
        int newIndex = this.m_jtConstraintList.getSelectedRow();
        this.m_crCurrent = newIndex != -1 ? (this.m_oclemModel != null ? this.m_oclemModel.getConstraintAt(newIndex) : null) : null;
        this.setEditorText(this.m_crCurrent);
        if (this.m_crCurrent != null) {
            this.m_jtpConstraintPreview.setText(this.m_crCurrent.getData());
        } else {
            this.m_jtpConstraintPreview.setText("");
        }
    }

    public void constraintAdded(ConstraintChangeEvent cce) {
        this.m_jtConstraintList.setRowSelectionInterval(cce.getIndex(), cce.getIndex());
    }

    public void constraintRemoved(ConstraintChangeEvent cce) {
        if (cce.getIndex() == this.m_jtConstraintList.getSelectedRow()) {
            this.m_jtConstraintList.clearSelection();
        }
    }

    public void constraintNameChanged(ConstraintChangeEvent cce) {
    }

    public void constraintDataChanged(ConstraintChangeEvent cce) {
        if (cce.getIndex() == this.m_jtConstraintList.getSelectedRow()) {
            this.m_jtpConstraintEditor.setText(cce.getNew().getData());
            this.m_jtpConstraintPreview.setText(cce.getNew().getData());
            this.m_fConstraintChanged = true;
        }
    }

    static {
        if (StyleConstants.Alignment != null) {
            // empty if block
        }
        s_sasField.addAttribute(StyleConstants.CharacterConstants.Underline, Boolean.TRUE);
        s_sasField.addAttribute("isField", Boolean.TRUE);
        s_sasNoEditText.addAttribute(StyleConstants.CharacterConstants.Italic, Boolean.TRUE);
        s_sasNoEditText.addAttribute("allowEdit", Boolean.FALSE);
        s_sasNoEditText.addAttribute("isField", Boolean.TRUE);
    }

    protected static class ConstraintTableModel
    extends AbstractTableModel
    implements ConstraintChangeListener {
        protected OCLEditorModel m_oclemModel;
        protected WeakReference m_wrocle;
        static /* synthetic */ Class class$java$lang$String;

        public ConstraintTableModel(OCLEditor ocle) {
            this.m_wrocle = new WeakReference<OCLEditor>(ocle);
        }

        public void setOCLModel(OCLEditorModel oclemModel) {
            if (this.m_oclemModel != null) {
                this.m_oclemModel.removeConstraintChangeListener(this);
            }
            this.m_oclemModel = oclemModel;
            if (this.m_oclemModel != null) {
                this.m_oclemModel.addConstraintChangeListener(this);
            }
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            if (this.m_oclemModel != null) {
                return this.m_oclemModel.getConstraintCount();
            }
            return 0;
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int nIdx) {
            return "Constraint Name";
        }

        public Class getColumnClass(int nIdx) {
            return class$java$lang$String == null ? (class$java$lang$String = ConstraintTableModel.class$("java.lang.String")) : class$java$lang$String;
        }

        public Object getValueAt(int row, int column) {
            if (this.m_oclemModel != null) {
                ConstraintRepresentation cr = this.m_oclemModel.getConstraintAt(row);
                if (cr != null) {
                    return cr.getName();
                }
                return null;
            }
            return null;
        }

        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        public void setValueAt(Object value, int row, int column) {
            ConstraintRepresentation cr;
            if (column == 0 && this.m_oclemModel != null && (cr = this.m_oclemModel.getConstraintAt(row)) != null) {
                try {
                    cr.setName(value.toString(), (OCLEditor)this.m_wrocle.get());
                }
                catch (IllegalArgumentException iae) {
                    JOptionPane.showMessageDialog(null, "Invalid name: " + iae.getMessage(), "Error", 0);
                }
                catch (IllegalStateException ise) {
                    JOptionPane.showMessageDialog(null, "Couldn't set name: " + ise.getMessage(), "Error", 0);
                }
            }
        }

        public void constraintAdded(ConstraintChangeEvent cce) {
            this.fireTableRowsInserted(cce.getIndex(), cce.getIndex());
        }

        public void constraintRemoved(ConstraintChangeEvent cce) {
            this.fireTableRowsDeleted(cce.getIndex(), cce.getIndex());
        }

        public void constraintNameChanged(ConstraintChangeEvent cce) {
            this.fireTableCellUpdated(cce.getIndex(), 0);
        }

        public void constraintDataChanged(ConstraintChangeEvent cce) {
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    protected static class OCLEditorDocument
    extends DefaultStyledDocument {
        private int m_nDoCheckUneditable = 0;

        protected OCLEditorDocument() {
        }

        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            this.checkEditLocation(offset, 0);
            super.insertString(offset, str, a);
        }

        public void remove(int offset, int length) throws BadLocationException {
            this.checkEditLocation(offset, length);
            super.remove(offset, length);
        }

        public void stopChecking() {
            --this.m_nDoCheckUneditable;
        }

        public void restartChecking() {
            ++this.m_nDoCheckUneditable;
        }

        protected void checkEditLocation(int offset, int length) throws BadLocationException {
            if (this.m_nDoCheckUneditable < 0) {
                return;
            }
            Element eAffected = this.getDefaultRootElement();
            while (!eAffected.isLeaf()) {
                eAffected = eAffected.getElement(eAffected.getElementIndex(offset));
            }
            while (eAffected != null && (eAffected.getStartOffset() <= offset || eAffected.getEndOffset() >= offset + length)) {
                if (eAffected.getAttributes().getAttribute("allowEdit") == Boolean.FALSE) {
                    throw new BadLocationException("Editing not allowed.", Math.max(offset, eAffected.getStartOffset()));
                }
                eAffected = this.getNeighbouringElement(eAffected);
            }
        }

        protected Element getNeighbouringElement(Element e) {
            Element eTemp = e.getParentElement();
            while (eTemp != null && eTemp.getEndOffset() <= e.getEndOffset()) {
                e = eTemp;
                eTemp = eTemp.getParentElement();
            }
            while (eTemp != null && !eTemp.isLeaf()) {
                eTemp = eTemp.getElement(eTemp.getElementIndex(e.getEndOffset()));
            }
            return eTemp;
        }
    }
}

