/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.lib;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import tudresden.ocl.lib.Ocl;
import tudresden.ocl.lib.OclAnyImpl;
import tudresden.ocl.lib.OclBoolean;
import tudresden.ocl.lib.OclBooleanEvaluatable;
import tudresden.ocl.lib.OclCollection;
import tudresden.ocl.lib.OclException;
import tudresden.ocl.lib.OclInteger;
import tudresden.ocl.lib.OclIterator;
import tudresden.ocl.lib.OclRoot;
import tudresden.ocl.lib.OclRootEvaluatable;

public class OclSequence
extends OclCollection {
    public OclSequence(List list) {
        super(list);
    }

    public OclSequence(int dummy, String reason) {
        super(dummy, reason);
    }

    public static OclSequence getEmptyOclSequence() {
        return new OclSequence(new ArrayList());
    }

    public OclBoolean isEqualTo(Object o) {
        if (!(o instanceof OclSequence)) {
            System.out.println("OclSequence isEqualTo() is called with a non-OclSequence parameter");
            return OclBoolean.FALSE;
        }
        OclSequence other = (OclSequence)o;
        if (this.isUndefined()) {
            return new OclBoolean(0, this.getUndefinedReason());
        }
        if (other.isUndefined()) {
            return new OclBoolean(0, other.getUndefinedReason());
        }
        Iterator i1 = this.collection.iterator();
        Iterator i2 = other.collection.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i1.next().equals(i2.next())) continue;
            return OclBoolean.FALSE;
        }
        if (i1.hasNext() || i2.hasNext()) {
            return OclBoolean.FALSE;
        }
        return OclBoolean.TRUE;
    }

    public OclRoot getFeature(final String name) {
        if (this.isUndefined()) {
            return this;
        }
        final OclIterator iter = this.getIterator();
        return (OclSequence)this.collect(iter, new OclRootEvaluatable(){

            public OclRoot evaluate() {
                return iter.getValue().getFeature(name);
            }
        });
    }

    public OclCollection select(OclIterator iter, OclBooleanEvaluatable eval) {
        if (this.isUndefined()) {
            return this;
        }
        List l = this.selectToList(iter, eval);
        if (l == null) {
            return new OclSequence(0, "error in selectToList");
        }
        return new OclSequence(l);
    }

    public OclCollection collect(OclIterator iter, OclRootEvaluatable eval) {
        if (this.isUndefined()) {
            return this;
        }
        List l = this.collectToList(iter, eval);
        if (l == null) {
            return new OclSequence(0, "error in collectToList");
        }
        return new OclSequence(l);
    }

    public OclCollection union(OclCollection col) {
        if (this.isUndefined()) {
            return this;
        }
        if (col.isUndefined()) {
            return col;
        }
        if (col instanceof OclSequence) {
            return this.union((OclSequence)col);
        }
        return new OclSequence(0, "OclSequence union() called with non-OclSequence argument");
    }

    public OclSequence union(OclSequence seq) {
        if (this.isUndefined()) {
            return this;
        }
        if (seq.isUndefined()) {
            return seq;
        }
        ArrayList list = new ArrayList(this.collection);
        list.addAll(seq.collection);
        return new OclSequence(list);
    }

    public OclSequence append(OclRoot obj) {
        if (this.isUndefined()) {
            return this;
        }
        if (obj.isUndefined()) {
            return new OclSequence(0, obj.getUndefinedReason());
        }
        if (Ocl.STRICT_VALUE_TYPES || !(this.collection instanceof List)) {
            ArrayList<OclRoot> list = new ArrayList<OclRoot>(this.collection);
            list.add(obj);
            return new OclSequence(list);
        }
        this.collection.add(obj);
        return this;
    }

    public OclSequence prepend(OclRoot obj) {
        if (this.isUndefined()) {
            return this;
        }
        if (obj.isUndefined()) {
            return new OclSequence(0, obj.getUndefinedReason());
        }
        if (Ocl.STRICT_VALUE_TYPES || !(this.collection instanceof List)) {
            ArrayList<OclRoot> list = new ArrayList<OclRoot>(this.collection.size() + 1);
            list.add(obj);
            list.addAll(this.collection);
            return new OclSequence(list);
        }
        ((List)this.collection).add(0, obj);
        return this;
    }

    public OclSequence subSequence(OclInteger lower, OclInteger upper) {
        if (this.isUndefined()) {
            return this;
        }
        if (lower.isUndefined()) {
            return new OclSequence(0, lower.getUndefinedReason());
        }
        if (upper.isUndefined()) {
            return new OclSequence(0, upper.getUndefinedReason());
        }
        try {
            ArrayList oldlist = !(this.collection instanceof List) ? new ArrayList(this.collection) : (ArrayList)this.collection;
            List newlist = oldlist.subList(lower.getInt() - 1, upper.getInt());
            if (Ocl.STRICT_VALUE_TYPES) {
                return new OclSequence(new ArrayList(newlist));
            }
            return new OclSequence(newlist);
        }
        catch (IndexOutOfBoundsException e) {
            return new OclSequence(0, "illegal index in OclSequence substring(" + lower + ", " + upper + ")");
        }
    }

    public OclRoot at(OclInteger index) {
        if (this.isUndefined()) {
            return new OclAnyImpl(0, this.getUndefinedReason());
        }
        if (index.isUndefined()) {
            return new OclAnyImpl(0, index.getUndefinedReason());
        }
        if (!(this.collection instanceof List)) {
            this.collection = new ArrayList(this.collection);
        }
        try {
            return (OclRoot)((List)this.collection).get(index.getInt() - 1);
        }
        catch (IndexOutOfBoundsException e) {
            return new OclAnyImpl(0, "illegal index " + index + " in OclSequence at()");
        }
    }

    public OclRoot first() {
        return this.at(new OclInteger(1));
    }

    public OclRoot last() {
        return this.at(this.size());
    }

    public OclCollection including(OclRoot obj) {
        return this.append(obj);
    }

    public OclCollection excluding(OclRoot obj) {
        if (this.isUndefined()) {
            return this;
        }
        if (obj.isUndefined()) {
            return new OclSequence(0, obj.getUndefinedReason());
        }
        ArrayList list = new ArrayList(this.collection.size());
        Iterator iter = this.collection.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            try {
                if (obj.isEqualTo(next).isTrue()) continue;
                list.add(next);
            }
            catch (OclException e) {
                list.add(next);
            }
        }
        return new OclSequence(list);
    }

    public String toString() {
        return "OclSequence" + super.toString();
    }
}

