/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.normalize;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import tudresden.ocl.OclTree;
import tudresden.ocl.normalize.TreeNormalizer;
import tudresden.ocl.parser.analysis.DepthFirstAdapter;
import tudresden.ocl.parser.node.AConstraint;
import tudresden.ocl.parser.node.AExpression;
import tudresden.ocl.parser.node.AFeatureCallParameters;
import tudresden.ocl.parser.node.AFeaturePrimaryExpression;
import tudresden.ocl.parser.node.AIterateDeclarator;
import tudresden.ocl.parser.node.ALetExpression;
import tudresden.ocl.parser.node.ANamePathNameBegin;
import tudresden.ocl.parser.node.APathName;
import tudresden.ocl.parser.node.AStandardDeclarator;
import tudresden.ocl.parser.node.PDeclarator;
import tudresden.ocl.parser.node.PPathNameBegin;
import tudresden.ocl.parser.node.TName;

public class VariableClarification
extends DepthFirstAdapter
implements TreeNormalizer {
    OclTree tree;
    boolean isChanged;
    HashMap replacements = new HashMap();
    HashSet usedVariables = new HashSet();

    public void normalize(OclTree tree) {
        this.tree = tree;
        tree.apply(this);
        tree.assureInvariant("context AExpression inv : letExpression -> forAll ( le | not self . parent . boundNames -> includes ( le . name ) )  ");
        tree.assureInvariant("context AStandardDeclarator : not parent . parent . boundNames -> includes ( name.toString() )");
        tree.assureInvariant("context AIterateDeclarator : let ppb = parent . parent . boundNames in not ( ppb -> includes ( iterator.toString() ) or ppb -> includes( accumulator.toString() ) )");
    }

    public void inAConstraint(AConstraint c) {
        this.isChanged = false;
    }

    public void outAConstraint(AConstraint c) {
        if (this.isChanged) {
            this.tree.changeNotify(c);
        }
    }

    public void caseAExpression(AExpression e) {
        HashMap oldReplacements = new HashMap(this.replacements);
        Iterator iter = e.getLetExpression().iterator();
        while (iter.hasNext()) {
            String newName;
            ALetExpression le = (ALetExpression)iter.next();
            le.apply(this);
            String oldName = le.getName().toString().trim();
            if (this.usedVariables.contains(oldName)) {
                newName = this.tree.getNameCreator().getUniqueName("Let");
                le.setName(new TName(newName));
                this.isChanged = true;
            } else {
                newName = null;
                this.usedVariables.add(oldName);
            }
            this.replacements.put(oldName, newName);
        }
        e.getLogicalExpression().apply(this);
        this.replacements = oldReplacements;
    }

    public void caseAFeatureCallParameters(AFeatureCallParameters fcp) {
        PDeclarator decl = fcp.getDeclarator();
        if (decl != null) {
            String oldAccuReplacement;
            String newAccuName;
            String oldIterReplacement;
            String newIterName;
            String oldAccuName;
            String oldIterName;
            decl.apply(this);
            AStandardDeclarator sdecl = null;
            AIterateDeclarator idecl = null;
            if (decl instanceof AStandardDeclarator) {
                sdecl = (AStandardDeclarator)decl;
                oldIterName = sdecl.getName().toString().trim();
                oldAccuName = null;
            } else {
                idecl = (AIterateDeclarator)decl;
                oldIterName = idecl.getIterator().toString().trim();
                oldAccuName = idecl.getAccumulator().toString().trim();
            }
            if (this.usedVariables.contains(oldIterName)) {
                newIterName = this.tree.getNameCreator().getUniqueName("Iter");
                this.isChanged = true;
                oldIterReplacement = this.replacements.put(oldIterName, newIterName);
            } else {
                this.usedVariables.add(oldIterName);
                newIterName = null;
                oldIterReplacement = null;
            }
            if (oldAccuName != null && this.usedVariables.contains(oldAccuName)) {
                newAccuName = this.tree.getNameCreator().getUniqueName("Accu");
                this.isChanged = true;
                oldAccuReplacement = this.replacements.put(oldAccuName, newAccuName);
            } else {
                this.usedVariables.add(oldAccuName);
                newAccuName = null;
                oldAccuReplacement = null;
            }
            if (newIterName != null) {
                if (sdecl != null) {
                    sdecl.setName(new TName(newIterName));
                } else {
                    idecl.setIterator(new TName(newIterName));
                }
            }
            if (newAccuName != null) {
                idecl.setAccumulator(new TName(newAccuName));
            }
            fcp.getActualParameterList().apply(this);
            if (oldIterReplacement != null) {
                this.replacements.put(oldIterName, oldIterReplacement);
            }
            if (oldAccuReplacement != null) {
                this.replacements.put(oldAccuName, oldAccuReplacement);
            }
        } else if (fcp.getActualParameterList() != null) {
            fcp.getActualParameterList().apply(this);
        }
    }

    public void inAFeaturePrimaryExpression(AFeaturePrimaryExpression fpe) {
        String s = fpe.toString().trim();
        if (this.replacements.keySet().contains(s) && this.replacements.get(s) != null) {
            String repl = (String)this.replacements.get(s);
            fpe.setPathName(new APathName((PPathNameBegin)new ANamePathNameBegin(new TName(repl)), new LinkedList()));
        }
    }
}

