/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.parser;

import java.util.Iterator;
import java.util.LinkedList;
import tudresden.ocl.OnlyNameFinder;
import tudresden.ocl.parser.OclParserException;
import tudresden.ocl.parser.analysis.AnalysisAdapter;
import tudresden.ocl.parser.lexer.Lexer;
import tudresden.ocl.parser.node.AActualParameterList;
import tudresden.ocl.parser.node.AActualParameterListTail;
import tudresden.ocl.parser.node.ABarFcpHelper;
import tudresden.ocl.parser.node.AColonFcpHelper;
import tudresden.ocl.parser.node.ACommaFcpHelper;
import tudresden.ocl.parser.node.AConcreteFeatureCallParameters;
import tudresden.ocl.parser.node.ADeclaratorTail;
import tudresden.ocl.parser.node.ADeclaratorTypeDeclaration;
import tudresden.ocl.parser.node.AEmptyFeatureCallParameters;
import tudresden.ocl.parser.node.AExpression;
import tudresden.ocl.parser.node.AFeatureCallParameters;
import tudresden.ocl.parser.node.AIterateDeclarator;
import tudresden.ocl.parser.node.AIterateFcpHelper;
import tudresden.ocl.parser.node.AStandardDeclarator;
import tudresden.ocl.parser.node.Node;
import tudresden.ocl.parser.node.PExpression;
import tudresden.ocl.parser.node.PFcpHelper;
import tudresden.ocl.parser.node.TName;
import tudresden.ocl.parser.parser.Parser;

public class OclParser
extends Parser {
    protected AstFix fix = new AstFix();
    protected Node oclNode;

    public OclParser(Lexer lexer) {
        super(lexer);
    }

    protected void filter() {
        this.oclNode = this.node;
        this.oclNode.apply(this.fix);
        this.node = this.oclNode;
    }

    class AstFix
    extends AnalysisAdapter {
        AstFix() {
        }

        public void caseAEmptyFeatureCallParameters(AEmptyFeatureCallParameters efcp) {
            OclParser.this.oclNode = new AFeatureCallParameters(efcp.getLPar(), null, null, efcp.getRPar());
        }

        public void caseAConcreteFeatureCallParameters(AConcreteFeatureCallParameters cfcp) {
            boolean isDeclarator = false;
            boolean isIterateDeclarator = false;
            LinkedList tail = cfcp.getFcpHelper();
            PFcpHelper[] fcpHelpers = new PFcpHelper[tail.size()];
            Iterator iter = tail.iterator();
            int i = 0;
            while (iter.hasNext()) {
                PFcpHelper fh;
                fcpHelpers[i] = fh = (PFcpHelper)iter.next();
                ++i;
                if (fh instanceof ACommaFcpHelper || fh instanceof AColonFcpHelper) continue;
                if (fh instanceof AIterateFcpHelper) {
                    isIterateDeclarator = true;
                    continue;
                }
                if (fh instanceof ABarFcpHelper) {
                    isDeclarator = true;
                    continue;
                }
                throw new RuntimeException("unknown subclass of PFcpHelper");
            }
            if (isIterateDeclarator && !isDeclarator) {
                throw new OclParserException("parser error: illegal feature call parameters format in \"" + cfcp + "\"; " + "must contain \";\" only if it contains \"|\"");
            }
            AFeatureCallParameters fcp = isIterateDeclarator ? this.getFcpWithIterateDeclarator(cfcp, (AExpression)cfcp.getExpression(), fcpHelpers) : (isDeclarator ? this.getFcpWithStandardDeclarator(cfcp, (AExpression)cfcp.getExpression(), fcpHelpers) : this.getFcpWithoutDeclarator(cfcp, (AExpression)cfcp.getExpression(), fcpHelpers));
            OclParser.this.oclNode = fcp;
        }

        protected AFeatureCallParameters getFcpWithIterateDeclarator(AConcreteFeatureCallParameters cfcp, AExpression expr, PFcpHelper[] fcpHelpers) {
            AIterateDeclarator iDecl = new AIterateDeclarator();
            if (!(fcpHelpers.length == 3 && fcpHelpers[0] instanceof AColonFcpHelper && fcpHelpers[1] instanceof AIterateFcpHelper && fcpHelpers[2] instanceof ABarFcpHelper)) {
                throw new OclParserException("parser error: feature call parameters with iterate declarator must have the format \"( name: type; name: type = expr | expr )\"");
            }
            AColonFcpHelper fcpHelper0 = (AColonFcpHelper)fcpHelpers[0];
            AIterateFcpHelper fcpHelper1 = (AIterateFcpHelper)fcpHelpers[1];
            ABarFcpHelper fcpHelper2 = (ABarFcpHelper)fcpHelpers[2];
            iDecl.setIterator(this.getOnlyNameIn(expr));
            iDecl.setIterType(new ADeclaratorTypeDeclaration(fcpHelper0.getColon(), fcpHelper0.getSimpleTypeSpecifier()));
            iDecl.setSemicolon(fcpHelper1.getSemicolon());
            iDecl.setAccumulator(fcpHelper1.getName());
            iDecl.setAccType(new ADeclaratorTypeDeclaration(fcpHelper1.getColon(), fcpHelper1.getSimpleTypeSpecifier()));
            iDecl.setEqual(fcpHelper1.getEqual());
            iDecl.setExpression(fcpHelper1.getExpression());
            iDecl.setBar(fcpHelper2.getBar());
            AActualParameterList params = new AActualParameterList(fcpHelper2.getExpression(), new LinkedList());
            AFeatureCallParameters result = new AFeatureCallParameters(cfcp.getLPar(), iDecl, params, cfcp.getRPar());
            return result;
        }

        protected AFeatureCallParameters getFcpWithStandardDeclarator(AConcreteFeatureCallParameters cfcp, AExpression expr, PFcpHelper[] fcpHelpers) {
            ADeclaratorTypeDeclaration typeDecl;
            ADeclaratorTail dt;
            int numHelpers = fcpHelpers.length;
            boolean ok = true;
            if (numHelpers < 1) {
                ok = false;
            } else if (!(fcpHelpers[numHelpers - 1] instanceof ABarFcpHelper)) {
                ok = false;
            }
            int i = 0;
            while (i < numHelpers - 2) {
                if (!(fcpHelpers[i] instanceof ACommaFcpHelper)) {
                    ok = false;
                }
                ++i;
            }
            if (numHelpers - 2 >= 0 && !(fcpHelpers[numHelpers - 2] instanceof ACommaFcpHelper) && !(fcpHelpers[numHelpers - 2] instanceof AColonFcpHelper)) {
                ok = false;
            }
            if (!ok) {
                throw new OclParserException("parser error: feature call parameters with standard declarator must have the format \"( name, ... , name: type | expr )\"");
            }
            LinkedList<ADeclaratorTail> declaratorTail = new LinkedList<ADeclaratorTail>();
            int i2 = 0;
            while (i2 < numHelpers - 2) {
                ACommaFcpHelper fcpHelperI = (ACommaFcpHelper)fcpHelpers[i2];
                dt = new ADeclaratorTail(fcpHelperI.getComma(), this.getOnlyNameIn(fcpHelperI.getExpression()));
                declaratorTail.addLast(dt);
                ++i2;
            }
            if (numHelpers > 1) {
                PFcpHelper fcpHelperNm2;
                if (fcpHelpers[numHelpers - 2] instanceof ACommaFcpHelper) {
                    fcpHelperNm2 = (ACommaFcpHelper)fcpHelpers[numHelpers - 2];
                    dt = new ADeclaratorTail(((ACommaFcpHelper)fcpHelperNm2).getComma(), this.getOnlyNameIn(((ACommaFcpHelper)fcpHelperNm2).getExpression()));
                    declaratorTail.addLast(dt);
                    typeDecl = null;
                } else {
                    fcpHelperNm2 = (AColonFcpHelper)fcpHelpers[numHelpers - 2];
                    typeDecl = new ADeclaratorTypeDeclaration(((AColonFcpHelper)fcpHelperNm2).getColon(), ((AColonFcpHelper)fcpHelperNm2).getSimpleTypeSpecifier());
                }
            } else {
                typeDecl = null;
            }
            ABarFcpHelper barHelper = (ABarFcpHelper)fcpHelpers[numHelpers - 1];
            AStandardDeclarator sDecl = new AStandardDeclarator(this.getOnlyNameIn(expr), declaratorTail, typeDecl, barHelper.getBar());
            AActualParameterList params = new AActualParameterList(barHelper.getExpression(), new LinkedList());
            AFeatureCallParameters result = new AFeatureCallParameters(cfcp.getLPar(), sDecl, params, cfcp.getRPar());
            return result;
        }

        protected AFeatureCallParameters getFcpWithoutDeclarator(AConcreteFeatureCallParameters cfcp, AExpression expr, PFcpHelper[] fcpHelpers) {
            LinkedList<AActualParameterListTail> paramList = new LinkedList<AActualParameterListTail>();
            int i = 0;
            while (i < fcpHelpers.length) {
                if (!(fcpHelpers[i] instanceof ACommaFcpHelper)) {
                    throw new OclParserException("parser error: declarator-less feature call paramaters must have the format \"( expr, ..., expr )\"");
                }
                ACommaFcpHelper cfh = (ACommaFcpHelper)fcpHelpers[i];
                AActualParameterListTail aplt = new AActualParameterListTail(cfh.getComma(), cfh.getExpression());
                paramList.add(aplt);
                ++i;
            }
            AActualParameterList params = new AActualParameterList((PExpression)expr, paramList);
            AFeatureCallParameters result = new AFeatureCallParameters(cfcp.getLPar(), null, params, cfcp.getRPar());
            return result;
        }

        protected TName getOnlyNameIn(PExpression expr) {
            OnlyNameFinder onf = new OnlyNameFinder(false);
            expr.apply(onf);
            return onf.getName();
        }
    }
}

