/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.euml;

import org.argouml.model.euml.EUMLModelImplementation;

public class CommandStackImpl {
    private EUMLModelImplementation modelImplementation;

    public CommandStackImpl(EUMLModelImplementation implementation) {
        this.modelImplementation = implementation;
        implementation.getEditingDomain().getCommandStack().flush();
    }

    public boolean canRedo() {
        return this.modelImplementation.getEditingDomain().getCommandStack().canRedo();
    }

    public boolean canUndo() {
        return this.modelImplementation.getEditingDomain().getCommandStack().canUndo();
    }

    public String getRedoLabel() {
        return this.canRedo() ? this.modelImplementation.getEditingDomain().getCommandStack().getRedoCommand().getLabel() : null;
    }

    public String getUndoLabel() {
        return this.canUndo() ? this.modelImplementation.getEditingDomain().getCommandStack().getUndoCommand().getLabel() : null;
    }

    public boolean isCommandStackCapabilityAvailable() {
        return true;
    }

    public void redo() {
        this.modelImplementation.getEditingDomain().getCommandStack().redo();
    }

    public void undo() {
        this.modelImplementation.getEditingDomain().getCommandStack().undo();
    }
}

