/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.euml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.argouml.model.ExtensionMechanismsHelper;
import org.argouml.model.euml.EUMLModelImplementation;
import org.argouml.model.euml.UMLUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExtensionMechanismsHelperEUMLImpl
implements ExtensionMechanismsHelper {
    private static final String PTYPE_BOOLEAN_NAME = "Boolean";
    private static final String PTYPE_INTEGER_NAME = "Integer";
    private static final String PTYPE_STRING_NAME = "String";
    private static final String PTYPE_UNATURAL_NAME = "UnlimitedNatural";
    private EUMLModelImplementation modelImpl;
    private Collection commonTaggedValueTypes;

    public ExtensionMechanismsHelperEUMLImpl(EUMLModelImplementation implementation) {
        this.modelImpl = implementation;
    }

    @Override
    public void addBaseClass(Object handle, Object baseClass) {
        if (handle instanceof Stereotype) {
            Class metaclass = this.getMetaclass(baseClass);
            Profile profile = ((Stereotype)handle).getProfile();
            if (metaclass != null && profile != null) {
                profile.createMetaclassReference((PackageableElement)metaclass);
                ((Stereotype)handle).createExtension(metaclass, false);
                return;
            }
        }
        throw new IllegalArgumentException("Not a Stereotype or illegal base class");
    }

    @Override
    public void addCopyStereotype(Object modelElement, Object stereotype) {
        this.modelImpl.getCoreHelper().addStereotype(modelElement, stereotype);
    }

    @Override
    public void addExtendedElement(Object handle, Object extendedElement) {
    }

    @Override
    public void addTaggedValue(Object handle, Object taggedValue) {
        if (!(handle instanceof Element)) {
            return;
        }
        if (!(taggedValue instanceof Property)) {
            return;
        }
        Element elem = (Element)handle;
        Property prop = (Property)taggedValue;
        Stereotype stereotype = (Stereotype)prop.eContainer();
        ArrayList<Object> value = null;
        if (prop.isMultivalued()) {
            value = UMLUtil.getTaggedValue((Element)elem, (String)stereotype.getQualifiedName(), (String)prop.getName());
            ArrayList<Object> newValue = new ArrayList<Object>();
            if (value instanceof Collection) {
                newValue.addAll((Collection)value);
            } else if (value != null) {
                newValue.add(value);
            }
            newValue.add(this.getDefaultValueFor((Property)taggedValue));
            value = newValue;
        } else {
            value = this.getDefaultValueFor((Property)taggedValue);
        }
        this.setTaggedValue(elem, prop, value);
    }

    @Override
    public void applyProfile(Object handle, Object profile) {
        if (profile instanceof Profile) {
            if (((Profile)profile).isDefined()) {
                if (handle instanceof Model) {
                    ((Model)handle).applyProfile((Profile)profile);
                } else if (handle instanceof Profile) {
                    ((Profile)handle).applyProfile((Profile)profile);
                }
            }
            for (Package p : ((Profile)profile).getNestedPackages()) {
                if (!(p instanceof Profile)) continue;
                this.applyProfile(handle, p);
            }
        }
    }

    @Override
    public Collection getAllPossibleStereotypes(Collection models, Object modelElement) {
        ArrayList<Stereotype> ret = new ArrayList<Stereotype>();
        if (modelElement instanceof Element) {
            for (Stereotype stereo : this.getStereotypes(models)) {
                if (!((Element)modelElement).isStereotypeApplicable(stereo)) continue;
                ret.add(stereo);
            }
        }
        return ret;
    }

    @Override
    @Deprecated
    public String getMetaModelName(Object m) {
        if (m instanceof Element) {
            return this.getMetaModelName(m.getClass());
        }
        throw new IllegalArgumentException("Not an Element");
    }

    protected String getMetaModelName(Class clazz) {
        return this.modelImpl.getMetaTypes().getName(clazz);
    }

    @Override
    public Object getStereotype(Object ns, Object stereo) {
        if (!(ns instanceof Profile)) {
            throw new IllegalArgumentException("profile");
        }
        if (!(stereo instanceof Stereotype)) {
            throw new IllegalArgumentException("stereotype");
        }
        String name = ((Stereotype)stereo).getName();
        EList baseClasses = ((Stereotype)stereo).getAllExtendedMetaclasses();
        if (name == null || baseClasses.size() != 1) {
            return null;
        }
        Class baseClass = (Class)baseClasses.iterator().next();
        for (Stereotype o : this.getStereotypes(ns)) {
            if (!name.equals(o.getName()) || !o.getAllExtendedMetaclasses().contains((Object)baseClass)) continue;
            return o;
        }
        return null;
    }

    @Override
    public Object getStereotype(Collection models, Object stereo) {
        if (stereo == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (!(stereo instanceof Stereotype)) {
            throw new IllegalArgumentException("stereotype");
        }
        String name = ((Stereotype)stereo).getName();
        EList baseClasses = ((Stereotype)stereo).getAllExtendedMetaclasses();
        if (name == null || baseClasses.size() != 1) {
            return null;
        }
        Class baseClass = (Class)baseClasses.iterator().next();
        for (Model model : models) {
            for (Stereotype o : this.getStereotypes(model)) {
                if (!name.equals(o.getName()) || !o.getAllExtendedMetaclasses().contains((Object)baseClass)) continue;
                return o;
            }
        }
        return null;
    }

    @Override
    public Collection<Stereotype> getStereotypes(Object ns) {
        if (ns instanceof Profile) {
            return new ArrayList<Stereotype>((Collection<Stereotype>)((Profile)ns).getOwnedStereotypes());
        }
        return Collections.emptySet();
    }

    @Override
    public Collection<Stereotype> getStereotypes(Collection models) {
        ArrayList<Stereotype> l = new ArrayList<Stereotype>();
        if (models != null) {
            for (Object ns : models) {
                if (!(ns instanceof Profile)) continue;
                l.addAll((Collection<Stereotype>)((Profile)ns).getOwnedStereotypes());
                for (Package p : ((Profile)ns).getNestedPackages()) {
                    if (!(p instanceof Profile)) continue;
                    l.addAll(this.getAllStereotypesIn((Profile)p));
                }
            }
        }
        return l;
    }

    @Override
    public Collection<Type> getCommonTaggedValueTypes() {
        if (this.commonTaggedValueTypes == null) {
            this.commonTaggedValueTypes = new ArrayList();
            URI uri = URI.createURI((String)"pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml");
            ResourceSet rs = this.modelImpl.getEditingDomain().getResourceSet();
            Resource res = rs.getResource(uri, true);
            Model m = (Model)((Package)EcoreUtil.getObjectByType((Collection)res.getContents(), (EClassifier)UMLPackage.Literals.MODEL));
            this.commonTaggedValueTypes.add(m.getOwnedMember(PTYPE_BOOLEAN_NAME));
            this.commonTaggedValueTypes.add(m.getOwnedMember(PTYPE_INTEGER_NAME));
            this.commonTaggedValueTypes.add(m.getOwnedMember(PTYPE_STRING_NAME));
            this.commonTaggedValueTypes.add(m.getOwnedMember(PTYPE_UNATURAL_NAME));
        }
        return this.commonTaggedValueTypes;
    }

    @Override
    public boolean hasStereotype(Object handle, String name) {
        if (name == null || !(handle instanceof Element)) {
            throw new IllegalArgumentException();
        }
        Element element = (Element)handle;
        return element.getAppliedStereotype(name) != null;
    }

    @Override
    public boolean isStereotype(Object object, String name, String base) {
        if (!(object instanceof Stereotype)) {
            return false;
        }
        Stereotype st = (Stereotype)object;
        if (name == null && st.getName() != null) {
            return false;
        }
        if (base == null && !st.getAllExtendedMetaclasses().isEmpty()) {
            return false;
        }
        for (Class c : st.getAllExtendedMetaclasses()) {
            if (!c.getName().equals(base)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStereotypeInh(Object object, String name, String base) {
        if (!(object instanceof Stereotype)) {
            return false;
        }
        if (this.isStereotype(object, name, base)) {
            return true;
        }
        Iterator<Classifier> it = this.modelImpl.getCoreHelper().getSupertypes(object).iterator();
        while (it.hasNext()) {
            if (!this.isStereotypeInh(it.next(), name, base)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidStereotype(Object theModelElement, Object theStereotype) {
        if (theModelElement instanceof Element && theStereotype instanceof Stereotype) {
            return ((Element)theModelElement).isStereotypeApplicable((Stereotype)theStereotype);
        }
        return false;
    }

    @Override
    public void removeBaseClass(Object handle, Object baseClass) {
        if (handle instanceof Stereotype) {
            Class metaclass = this.getMetaclass(baseClass);
            Profile profile = ((Stereotype)handle).getProfile();
            if (metaclass != null && profile != null) {
                Stereotype st = (Stereotype)handle;
                for (Extension ext : profile.getOwnedExtensions(false)) {
                    if (ext.getMetaclass() != metaclass || !ext.getEndTypes().contains((Object)st)) continue;
                    for (Property p : st.getAttributes()) {
                        Association assoc = p.getAssociation();
                        if (assoc == null || assoc != ext) continue;
                        p.destroy();
                        break;
                    }
                    ext.destroy();
                    break;
                }
                return;
            }
        }
        throw new IllegalArgumentException("Not a Stereotype or illegal base class");
    }

    @Override
    public void removeTaggedValue(Object handle, Object taggedValue) {
    }

    @Override
    public void setIcon(Object handle, Object icon) {
    }

    @Override
    public void setTaggedValue(Object handle, Collection taggedValues) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTaggedValue(Object handle, Object property, Object value) {
        ArrayList<Object> newValue;
        if (!(handle instanceof Element)) {
            return;
        }
        if (!(property instanceof Property)) {
            return;
        }
        Element elem = (Element)handle;
        Property prop = (Property)property;
        if (prop.isMultivalued() && !(value instanceof Collection)) {
            newValue = new ArrayList<Object>();
            newValue.add(value);
            value = newValue;
        } else if (!prop.isMultivalued() && value instanceof Collection) {
            Collection col = value;
            value = col.isEmpty() ? null : col.iterator().next();
        }
        if (value instanceof Collection) {
            newValue = new ArrayList();
            for (Object v : (Collection)value) {
                newValue.add(this.postprocessPropertyValue(prop, v));
            }
            value = newValue;
        } else {
            value = this.postprocessPropertyValue(prop, value);
        }
        Stereotype stereotype = (Stereotype)prop.eContainer();
        UMLUtil.setTaggedValue((Element)elem, (Stereotype)stereotype, (String)prop.getName(), value);
    }

    private Object postprocessPropertyValue(Property prop, Object value) {
        if (prop.getType() != null && PTYPE_UNATURAL_NAME.equals(prop.getType().getName()) && "*".equals(value)) {
            value = -1;
        }
        return value;
    }

    @Override
    public void setTagType(Object handle, String tagType) {
    }

    @Override
    public void setType(Object handle, Object type) {
    }

    @Override
    public void setValueOfTag(Object handle, String value) {
    }

    @Override
    public void setDataValues(Object handle, String[] value) {
    }

    @Override
    public void unapplyProfile(Object handle, Object profile) {
        if (profile instanceof Profile) {
            if (handle instanceof Package) {
                ((Model)handle).unapplyProfile((Profile)profile);
            } else if (handle instanceof Profile) {
                ((Profile)handle).unapplyProfile((Profile)profile);
            }
            for (Package p : ((Profile)profile).getNestedPackages()) {
                if (!(p instanceof Profile)) continue;
                this.unapplyProfile(handle, p);
            }
        }
    }

    @Override
    public Object makeProfileApplicable(Object handle) {
        EPackage result = null;
        if (handle instanceof Profile) {
            result = ((Profile)handle).define();
            for (Package p : ((Profile)handle).getNestedPackages()) {
                if (!(p instanceof Profile)) continue;
                this.makeProfileApplicable(p);
            }
        }
        return result;
    }

    private Collection<Stereotype> getAllStereotypesIn(Profile p) {
        ArrayList<Stereotype> l = new ArrayList<Stereotype>();
        for (Element elem : p.getOwnedElements()) {
            if (elem instanceof Stereotype) {
                l.add((Stereotype)elem);
                continue;
            }
            if (!(elem instanceof Profile)) continue;
            l.addAll(this.getAllStereotypesIn((Profile)elem));
        }
        return l;
    }

    private Class getMetaclass(Object baseClass) {
        Class metaclass = null;
        if (baseClass instanceof String) {
            URI uri = URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml");
            ResourceSet rs = this.modelImpl.getEditingDomain().getResourceSet();
            Resource res = rs.getResource(uri, true);
            Model m = (Model)EcoreUtil.getObjectByType((Collection)res.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
            metaclass = (Class)m.getOwnedType((String)baseClass);
        } else if (baseClass instanceof Class) {
            metaclass = (Class)baseClass;
        }
        return metaclass;
    }

    private Object getDefaultValueFor(Property property) {
        Object value = null;
        Type type = property.getType();
        if (type != null) {
            String tname = type.getName();
            if (PTYPE_BOOLEAN_NAME.equals(tname)) {
                value = Boolean.FALSE;
            } else if (PTYPE_INTEGER_NAME.equals(tname)) {
                value = new Integer(0);
            } else if (PTYPE_STRING_NAME.equals(tname)) {
                value = new String();
            } else if (PTYPE_UNATURAL_NAME.equals(tname)) {
                value = new Integer(0);
            }
        }
        return value;
    }
}

