/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.euml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.argouml.model.AbstractModelFactory;
import org.argouml.model.Defaults;
import org.argouml.model.IllegalModelElementConnectionException;
import org.argouml.model.InvalidElementException;
import org.argouml.model.MetaTypes;
import org.argouml.model.Model;
import org.argouml.model.UmlFactory;
import org.argouml.model.euml.ChangeCommand;
import org.argouml.model.euml.EUMLModelImplementation;
import org.argouml.model.euml.RunnableClass;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Actor;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.ComponentRealization;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ControlFlow;
import org.eclipse.uml2.uml.ControlNode;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.ExecutableNode;
import org.eclipse.uml2.uml.Extend;
import org.eclipse.uml2.uml.ExtensionPoint;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Include;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Node;
import org.eclipse.uml2.uml.ObjectFlow;
import org.eclipse.uml2.uml.ObjectNode;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.UseCase;

class UmlFactoryEUMLImpl
implements UmlFactory,
AbstractModelFactory {
    private static final Logger LOG = Logger.getLogger(UmlFactoryEUMLImpl.class.getName());
    private EUMLModelImplementation modelImpl;
    private MetaTypes metaTypes;
    private Map<java.lang.Class<? extends Element>, List> validConnectionMap = new HashMap<java.lang.Class<? extends Element>, List>();
    private HashMap<java.lang.Class<? extends Element>, java.lang.Class<?>[]> validContainmentMap = new HashMap();
    private static final java.lang.Class[][] VALID_CONNECTIONS = new java.lang.Class[][]{{Connector.class, Lifeline.class}, {Generalization.class, Classifier.class}, {ComponentRealization.class, Element.class, Component.class}, {Dependency.class, Element.class}, {Usage.class, NamedElement.class}, {PackageImport.class, NamedElement.class}, {Abstraction.class, Class.class, Interface.class, null}, {Association.class, Type.class}, {Extend.class, UseCase.class}, {Include.class, UseCase.class}, {Transition.class, State.class}, {AssociationClass.class, Type.class}, {Property.class, Classifier.class, Association.class}, {ControlFlow.class, ControlNode.class}, {ControlFlow.class, ExecutableNode.class}, {ControlFlow.class, ControlNode.class, ExecutableNode.class}, {ObjectFlow.class, ObjectNode.class}, {ObjectFlow.class, Action.class, ObjectNode.class}};

    public UmlFactoryEUMLImpl(EUMLModelImplementation implementation) {
        this.modelImpl = implementation;
        this.metaTypes = this.modelImpl.getMetaTypes();
        this.buildValidConnectionMap();
        this.buildValidContainmentMap();
    }

    public Object buildConnection(Object elementType, Object fromElement, Object fromStyle, Object toElement, Object toStyle, Object unidirectional, Object namespace) throws IllegalModelElementConnectionException {
        if (!this.isConnectionValid(elementType, fromElement, toElement, true)) {
            throw new IllegalModelElementConnectionException("Cannot make a " + elementType.getClass().getName() + " between a " + fromElement.getClass().getName() + " and a " + toElement.getClass().getName());
        }
        Object connection = null;
        if (elementType == this.metaTypes.getAssociationRole()) {
            connection = Model.getCollaborationsFactory().buildAssociationRole(fromElement, toElement);
        } else if (elementType == this.metaTypes.getAssociation()) {
            connection = this.modelImpl.getCoreFactory().buildAssociation((Object)((Classifier)fromElement), (Object)((AggregationKind)toStyle), (Object)((Classifier)toElement), (Object)((AggregationKind)fromStyle), (Boolean)unidirectional);
        } else if (elementType == this.metaTypes.getAssociationEnd()) {
            if (fromElement instanceof Association) {
                connection = this.modelImpl.getCoreFactory().buildAssociationEnd(toElement, fromElement);
            } else if (fromElement instanceof Classifier) {
                connection = this.modelImpl.getCoreFactory().buildAssociationEnd(fromElement, toElement);
            }
        } else if (elementType == this.metaTypes.getAssociationClass()) {
            connection = this.modelImpl.getCoreFactory().buildAssociationClass(fromElement, toElement);
        } else if (elementType == this.metaTypes.getAssociationRole()) {
            connection = this.modelImpl.getCollaborationsFactory().buildAssociationRole(fromElement, fromStyle, toElement, toStyle, (Boolean)unidirectional);
        } else if (elementType == this.metaTypes.getGeneralization()) {
            connection = this.modelImpl.getCoreFactory().buildGeneralization(fromElement, toElement);
        } else if (elementType == this.metaTypes.getPackageImport()) {
            connection = this.modelImpl.getCoreFactory().buildPackageImport(fromElement, toElement);
        } else if (elementType == this.metaTypes.getUsage()) {
            connection = this.modelImpl.getCoreFactory().buildUsage(fromElement, toElement);
        } else if (elementType == this.metaTypes.getComponentRealization()) {
            connection = this.modelImpl.getCoreFactory().buildComponentRealization(fromElement, toElement);
        } else if (elementType == this.metaTypes.getDependency()) {
            connection = this.modelImpl.getCoreFactory().buildDependency(fromElement, toElement);
        } else if (elementType == this.metaTypes.getAbstraction()) {
            connection = this.modelImpl.getCoreFactory().buildRealization(fromElement, toElement, namespace);
        } else if (elementType == this.metaTypes.getLink()) {
            connection = this.modelImpl.getCommonBehaviorFactory().buildLink(fromElement, toElement);
        } else if (elementType == this.metaTypes.getExtend()) {
            connection = this.modelImpl.getUseCasesFactory().buildExtend(toElement, fromElement);
        } else if (elementType == this.metaTypes.getInclude()) {
            connection = this.modelImpl.getUseCasesFactory().buildInclude(fromElement, toElement);
        } else if (elementType == this.metaTypes.getControlFlow()) {
            ActivityNode fromActivity = (ActivityNode)fromElement;
            ActivityNode toActivity = (ActivityNode)fromElement;
            ControlFlow cf = UMLFactory.eINSTANCE.createControlFlow();
            cf.setActivity(fromActivity.getActivity());
            cf.setSource(fromActivity);
            cf.setTarget(toActivity);
            connection = cf;
        } else if (elementType == this.metaTypes.getObjectFlow()) {
            ActivityNode fromObject = (ActivityNode)fromElement;
            ActivityNode toObject = (ActivityNode)fromElement;
            ControlFlow of = UMLFactory.eINSTANCE.createControlFlow();
            of.setActivity(fromObject.getActivity());
            of.setSource(fromObject);
            of.setTarget(toObject);
            connection = of;
        } else if (elementType == this.metaTypes.getTransition()) {
            connection = this.modelImpl.getStateMachinesFactory().buildTransition(fromElement, toElement);
        }
        if (connection == null) {
            throw new IllegalModelElementConnectionException("Cannot make a " + elementType.getClass().getName() + " between a " + fromElement.getClass().getName() + " and a " + toElement.getClass().getName());
        }
        return connection;
    }

    public Object buildNode(Object elementType, Object container, String propertyName) {
        Object element = this.buildNode(elementType);
        this.modelImpl.getCoreHelper().addOwnedElement(container, element);
        return element;
    }

    public Object buildNode(Object elementType, Object container) {
        return this.buildNode(elementType, container, null);
    }

    public Object buildNode(Object elementType, Object container, String property, Defaults defaults) {
        Object element = this.buildNode(elementType, container, property);
        if (defaults != null) {
            Object type = defaults.getDefaultType(elementType);
            String name = defaults.getDefaultName(elementType);
            if (type != null) {
                this.modelImpl.getCoreHelper().setType(element, type);
            }
            if (name != null) {
                this.modelImpl.getCoreHelper().setName(element, name);
            }
        }
        return element;
    }

    public Object buildNode(Object elementType) {
        Object o = null;
        if (elementType == this.metaTypes.getActor()) {
            o = this.modelImpl.getUseCasesFactory().createActor();
        } else if (elementType == this.metaTypes.getTagDefinition()) {
            o = this.modelImpl.getExtensionMechanismsFactory().createTagDefinition();
        } else if (elementType == this.metaTypes.getUseCase()) {
            o = this.modelImpl.getUseCasesFactory().createUseCase();
        } else if (elementType == this.metaTypes.getUMLClass()) {
            o = this.modelImpl.getCoreFactory().buildClass();
        } else if (elementType == this.metaTypes.getInterface()) {
            o = this.modelImpl.getCoreFactory().buildInterface();
        } else if (elementType == this.metaTypes.getDataType()) {
            o = this.modelImpl.getCoreFactory().createDataType();
        } else if (elementType == this.metaTypes.getPackage()) {
            o = this.modelImpl.getModelManagementFactory().createPackage();
        } else if (elementType == this.metaTypes.getProfile()) {
            o = this.modelImpl.getModelManagementFactory().createProfile();
        } else if (elementType == this.metaTypes.getModel()) {
            o = this.modelImpl.getModelManagementFactory().createModel();
        } else if (elementType == this.metaTypes.getActivity()) {
            o = this.modelImpl.getActivityGraphsFactory().createActivityGraph();
        } else if (elementType == this.metaTypes.getCallBehaviorAction()) {
            o = UMLFactory.eINSTANCE.createCallBehaviorAction();
        } else if (elementType == this.metaTypes.getCreateObjectAction()) {
            o = UMLFactory.eINSTANCE.createCreateObjectAction();
        } else if (elementType == this.metaTypes.getDestroyObjectAction()) {
            o = UMLFactory.eINSTANCE.createDestroyObjectAction();
        } else if (elementType == this.metaTypes.getActivityParameterNode()) {
            o = UMLFactory.eINSTANCE.createActivityParameterNode();
        } else if (elementType == this.metaTypes.getCentralBufferNode()) {
            o = UMLFactory.eINSTANCE.createCentralBufferNode();
        } else if (elementType == this.metaTypes.getDataStoreNode()) {
            o = UMLFactory.eINSTANCE.createDataStoreNode();
        } else if (elementType == this.metaTypes.getExpansionNode()) {
            o = UMLFactory.eINSTANCE.createExpansionNode();
        } else if (elementType == this.metaTypes.getAcceptEventAction()) {
            o = UMLFactory.eINSTANCE.createAcceptEventAction();
        } else if (elementType == this.metaTypes.getSendSignalAction()) {
            o = UMLFactory.eINSTANCE.createSendSignalAction();
        } else if (elementType == this.metaTypes.getInputPin()) {
            o = UMLFactory.eINSTANCE.createInputPin();
        } else if (elementType == this.metaTypes.getOutputPin()) {
            o = UMLFactory.eINSTANCE.createOutputPin();
        } else if (elementType == this.metaTypes.getState()) {
            o = UMLFactory.eINSTANCE.createState();
        } else if (elementType == this.metaTypes.getFinalState()) {
            o = UMLFactory.eINSTANCE.createFinalState();
        } else if (elementType == this.metaTypes.getPort()) {
            o = UMLFactory.eINSTANCE.createPort();
        } else if (elementType == this.metaTypes.getRegion()) {
            o = UMLFactory.eINSTANCE.createRegion();
        } else if (elementType == this.metaTypes.getPseudostate()) {
            o = this.modelImpl.getStateMachinesFactory().createPseudostate();
        } else if (elementType == this.metaTypes.getActionState()) {
            o = this.modelImpl.getActivityGraphsFactory().createActionState();
        } else if (elementType == this.metaTypes.getSubactivityState()) {
            o = this.modelImpl.getActivityGraphsFactory().createSubactivityState();
        } else if (elementType == this.metaTypes.getPartition()) {
            o = this.modelImpl.getActivityGraphsFactory().createPartition();
        } else if (elementType == this.metaTypes.getStubState()) {
            o = this.modelImpl.getStateMachinesFactory().createStubState();
        } else if (elementType == this.metaTypes.getSubmachineState()) {
            o = this.modelImpl.getStateMachinesFactory().createSubmachineState();
        } else if (elementType == this.metaTypes.getCompositeState()) {
            o = this.modelImpl.getStateMachinesFactory().createCompositeState();
        } else if (elementType == this.metaTypes.getSynchState()) {
            o = this.modelImpl.getStateMachinesFactory().createSynchState();
        } else if (elementType == this.metaTypes.getInstanceSpecification()) {
            o = UMLFactory.eINSTANCE.createInstanceSpecification();
        } else {
            if (elementType == this.metaTypes.getState()) {
                throw new IllegalArgumentException("Attempt to instantiate abstract type");
            }
            if (elementType == this.metaTypes.getClassifierRole()) {
                o = this.modelImpl.getCollaborationsFactory().createClassifierRole();
            } else if (elementType == this.metaTypes.getLifeline()) {
                o = this.modelImpl.getCollaborationsFactory().createLifeline();
            } else if (elementType == this.metaTypes.getComponent()) {
                o = this.modelImpl.getCoreFactory().createComponent();
            } else if (elementType == this.metaTypes.getNode()) {
                o = this.modelImpl.getCoreFactory().createNode();
            } else if (elementType == this.metaTypes.getNodeInstance()) {
                o = this.modelImpl.getCommonBehaviorFactory().createNodeInstance();
            } else if (elementType == this.metaTypes.getObject()) {
                o = this.modelImpl.getCommonBehaviorFactory().createObject();
            } else if (elementType == this.metaTypes.getComment()) {
                o = this.modelImpl.getCoreFactory().createComment();
            } else {
                if (elementType == this.metaTypes.getNamespace()) {
                    throw new IllegalArgumentException("Attempt to instantiate abstract type");
                }
                if (elementType == this.metaTypes.getOperation()) {
                    o = this.modelImpl.getCoreFactory().createOperation();
                } else if (elementType == this.metaTypes.getEnumeration()) {
                    o = this.modelImpl.getCoreFactory().createEnumeration();
                } else if (elementType == this.metaTypes.getEnumerationLiteral()) {
                    o = this.modelImpl.getCoreFactory().createEnumerationLiteral();
                } else if (elementType == this.metaTypes.getStereotype()) {
                    o = this.modelImpl.getExtensionMechanismsFactory().createStereotype();
                } else if (elementType == this.metaTypes.getAttribute()) {
                    o = this.modelImpl.getCoreFactory().createAttribute();
                } else if (elementType == this.metaTypes.getSignal()) {
                    o = this.modelImpl.getCommonBehaviorFactory().createSignal();
                } else if (elementType == this.metaTypes.getException()) {
                    o = this.modelImpl.getCommonBehaviorFactory().createException();
                } else if (elementType == this.metaTypes.getTransition()) {
                    o = this.modelImpl.getStateMachinesFactory().createTransition();
                } else if (elementType == this.metaTypes.getParameter()) {
                    o = this.modelImpl.getCoreFactory().createParameter();
                } else if (elementType == this.metaTypes.getExtensionPoint()) {
                    o = this.modelImpl.getUseCasesFactory().createExtensionPoint();
                } else if (elementType == this.metaTypes.getReception()) {
                    o = this.modelImpl.getCommonBehaviorFactory().createReception();
                } else if (elementType == this.metaTypes.getProperty()) {
                    o = this.modelImpl.getCoreFactory().createAttribute();
                } else if (elementType == this.metaTypes.getSubsystem()) {
                    o = this.modelImpl.getModelManagementFactory().createSubsystem();
                }
            }
        }
        if (!(o instanceof EObject)) {
            throw new IllegalArgumentException("Attempted to create unsupported element type: " + elementType);
        }
        return o;
    }

    public void delete(final Object elem) {
        if (!(elem instanceof EObject)) {
            throw new IllegalArgumentException("elem must be instance of EObject");
        }
        RunnableClass run = new RunnableClass(){

            public void run() {
                EcoreUtil.delete((EObject)((EObject)elem));
            }
        };
        this.modelImpl.getEditingDomain().getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Remove from the model the element #", elem));
    }

    public boolean isRemoved(Object o) {
        if (o instanceof Element) {
            return ((Element)o).eResource() == null;
        }
        throw new IllegalArgumentException("Not an Element : " + o);
    }

    public boolean isConnectionType(Object connectionType) {
        return this.validConnectionMap.get(connectionType) != null;
    }

    public boolean isConnectionValid(Object connectionType, Object fromElement, Object toElement, boolean checkWFR) {
        ArrayList validItems = (ArrayList)this.validConnectionMap.get(connectionType);
        if (validItems == null) {
            return false;
        }
        for (java.lang.Class[] modeElementPair : validItems) {
            if (!modeElementPair[0].isInstance(fromElement) || !modeElementPair[1].isInstance(toElement)) continue;
            if (checkWFR) {
                return this.isConnectionWellformed((java.lang.Class)connectionType, (Element)fromElement, (Element)toElement);
            }
            return true;
        }
        return false;
    }

    public boolean isContainmentValid(Object metaType, Object container) {
        for (java.lang.Class<? extends Element> containerType : this.validContainmentMap.keySet()) {
            if (!containerType.isInstance(container)) continue;
            java.lang.Class<?>[] validElements = this.validContainmentMap.get(containerType);
            for (int eIter = 0; eIter < validElements.length; ++eIter) {
                if (metaType != validElements[eIter]) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isConnectionWellformed(java.lang.Class connectionType, Element fromElement, Element toElement) {
        if (fromElement == null || toElement == null) {
            return false;
        }
        return connectionType != Generalization.class || fromElement.getClass() == toElement.getClass();
    }

    private void buildValidConnectionMap() {
        java.lang.Class connection = null;
        for (int i = 0; i < VALID_CONNECTIONS.length; ++i) {
            java.lang.Class[] modeElementPair;
            connection = VALID_CONNECTIONS[i][0];
            ArrayList<java.lang.Class[]> validItems = (ArrayList<java.lang.Class[]>)this.validConnectionMap.get(connection);
            if (validItems == null) {
                validItems = new ArrayList<java.lang.Class[]>();
                this.validConnectionMap.put(connection, validItems);
            }
            if (VALID_CONNECTIONS[i].length < 3) {
                modeElementPair = new java.lang.Class[]{VALID_CONNECTIONS[i][1], VALID_CONNECTIONS[i][1]};
                validItems.add(modeElementPair);
                continue;
            }
            modeElementPair = new java.lang.Class[]{VALID_CONNECTIONS[i][1], VALID_CONNECTIONS[i][2]};
            validItems.add(modeElementPair);
            if (VALID_CONNECTIONS[i].length >= 4 || VALID_CONNECTIONS[i][1] == VALID_CONNECTIONS[i][2]) continue;
            java.lang.Class[] reversedModeElementPair = new java.lang.Class[]{VALID_CONNECTIONS[i][2], VALID_CONNECTIONS[i][1]};
            validItems.add(reversedModeElementPair);
        }
    }

    private void buildValidContainmentMap() {
        this.validContainmentMap.clear();
        this.validContainmentMap.put(Element.class, new java.lang.Class[0]);
        this.validContainmentMap.put(Region.class, new java.lang.Class[]{State.class, Pseudostate.class});
        this.validContainmentMap.put(State.class, new java.lang.Class[]{Region.class});
        this.validContainmentMap.put(StateMachine.class, new java.lang.Class[]{Region.class});
        this.validContainmentMap.put(Package.class, new java.lang.Class[]{Package.class, Actor.class, UseCase.class, Class.class, Interface.class, Component.class, Node.class, Enumeration.class, DataType.class, Signal.class});
        this.validContainmentMap.put(Package.class, new java.lang.Class[]{Package.class, Actor.class, UseCase.class, Class.class, Interface.class, Component.class, Node.class, Enumeration.class, DataType.class, Signal.class});
        this.validContainmentMap.put(Stereotype.class, new java.lang.Class[]{Property.class});
        this.validContainmentMap.put(Profile.class, new java.lang.Class[]{Stereotype.class, ElementImport.class, PackageImport.class});
        this.validContainmentMap.put(Class.class, new java.lang.Class[]{Property.class, Operation.class, Class.class, Reception.class});
        this.validContainmentMap.put(Classifier.class, new java.lang.Class[]{TemplateParameter.class});
        this.validContainmentMap.put(Interface.class, new java.lang.Class[]{Property.class, Operation.class, Reception.class});
        this.validContainmentMap.put(Signal.class, new java.lang.Class[]{Operation.class, Property.class});
        this.validContainmentMap.put(Actor.class, new java.lang.Class[]{Operation.class, Reception.class});
        this.validContainmentMap.put(UseCase.class, new java.lang.Class[]{ExtensionPoint.class, Property.class, Operation.class, Reception.class});
        this.validContainmentMap.put(Extend.class, new java.lang.Class[]{ExtensionPoint.class});
        this.validContainmentMap.put(Component.class, new java.lang.Class[]{Operation.class, Reception.class});
        this.validContainmentMap.put(Node.class, new java.lang.Class[]{Operation.class, Reception.class});
        this.validContainmentMap.put(Enumeration.class, new java.lang.Class[]{EnumerationLiteral.class, Operation.class});
        this.validContainmentMap.put(DataType.class, new java.lang.Class[]{Operation.class, Reception.class});
        this.validContainmentMap.put(Operation.class, new java.lang.Class[]{Parameter.class});
        this.validContainmentMap.put(Stereotype.class, new java.lang.Class[]{Property.class});
        this.validContainmentMap.put(Action.class, new java.lang.Class[]{Pin.class});
    }

    public void deleteExtent(Object element) {
        Resource resource = ((EObject)element).eResource();
        if (resource == null) {
            LOG.log(Level.WARNING, "Tried to delete null resource");
            throw new InvalidElementException(element != null ? element.toString() : "Null");
        }
        this.modelImpl.unloadResource(resource);
    }

    public Collection getExtentElements(String extentName) {
        if (extentName != null && extentName.startsWith("pathmap://UML_")) {
            try {
                URI uri = URI.createURI((String)extentName);
                Resource r = this.modelImpl.getEditingDomain().getResourceSet().getResource(uri, true);
                this.modelImpl.getReadOnlyMap().put(r, Boolean.TRUE);
                return r.getContents();
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "failed to get resource: " + extentName);
            }
        }
        return null;
    }

    public Collection getExtentPackages(String extentName) {
        Collection elements = this.getExtentElements(extentName);
        if (elements != null) {
            ArrayList result = new ArrayList();
            for (Object element : elements) {
                if (!(element instanceof Package)) continue;
                result.add(element);
            }
        }
        return null;
    }
}

