/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.state2.diagram;

import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import org.argouml.i18n.Translator;
import org.argouml.model.DeleteInstanceEvent;
import org.argouml.model.Model;
import org.argouml.model.StateDiagram;
import org.argouml.state2.diagram.FigEntryPoint;
import org.argouml.state2.diagram.FigExitPoint;
import org.argouml.state2.diagram.FigVertex;
import org.argouml.state2.diagram.StateDiagramGraphModel;
import org.argouml.ui.CmdCreateNode;
import org.argouml.uml.diagram.ArgoDiagram;
import org.argouml.uml.diagram.DiagramElement;
import org.argouml.uml.diagram.DiagramFactory;
import org.argouml.uml.diagram.DiagramSettings;
import org.argouml.uml.diagram.state.ui.FigBranchState;
import org.argouml.uml.diagram.state.ui.FigDeepHistoryState;
import org.argouml.uml.diagram.state.ui.FigFinalState;
import org.argouml.uml.diagram.state.ui.FigForkState;
import org.argouml.uml.diagram.state.ui.FigInitialState;
import org.argouml.uml.diagram.state.ui.FigJoinState;
import org.argouml.uml.diagram.state.ui.FigJunctionState;
import org.argouml.uml.diagram.state.ui.FigShallowHistoryState;
import org.argouml.uml.diagram.state.ui.StateDiagramRenderer;
import org.argouml.uml.diagram.static_structure.ui.FigComment;
import org.argouml.uml.diagram.ui.ActionSetMode;
import org.argouml.uml.diagram.ui.RadioAction;
import org.argouml.uml.diagram.ui.UMLDiagram;
import org.tigris.gef.base.LayerPerspective;
import org.tigris.gef.base.LayerPerspectiveMutable;
import org.tigris.gef.base.ModeCreatePolyEdge;
import org.tigris.gef.graph.GraphEdgeRenderer;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeRenderer;
import org.tigris.gef.graph.MutableGraphModel;
import org.tigris.gef.presentation.FigNode;

public class UMLStateDiagram
extends UMLDiagram
implements StateDiagram {
    @Deprecated
    public UMLStateDiagram() {
        super((GraphModel)new StateDiagramGraphModel());
    }

    public UMLStateDiagram(String name, Object machine) {
        super(name, machine, (GraphModel)new StateDiagramGraphModel());
        if (name == null || name.trim().length() == 0) {
            name = this.getLabelName() + Model.getFacade().getName(machine);
            try {
                this.setName(name);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this.initialize(machine);
    }

    public void initialize(Object o) {
        this.setNamespace(o);
        StateDiagramGraphModel gm = this.createGraphModel();
        gm.setHomeModel(this.namespace);
        StateDiagramRenderer rend = new StateDiagramRenderer();
        LayerPerspectiveMutable lay = new LayerPerspectiveMutable(Model.getFacade().getName(this.namespace), (MutableGraphModel)gm);
        lay.setGraphNodeRenderer((GraphNodeRenderer)rend);
        lay.setGraphEdgeRenderer((GraphEdgeRenderer)rend);
        this.setLayer((LayerPerspective)lay);
        Model.getPump().addModelEventListener((PropertyChangeListener)((Object)this), this.namespace, new String[]{"remove"});
    }

    private StateDiagramGraphModel createGraphModel() {
        if (this.getGraphModel() instanceof StateDiagramGraphModel) {
            return (StateDiagramGraphModel)this.getGraphModel();
        }
        return new StateDiagramGraphModel();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.namespace && evt instanceof DeleteInstanceEvent) {
            Model.getPump().removeModelEventListener((PropertyChangeListener)((Object)this), this.namespace, new String[]{"remove"});
            if (this.getProject() != null) {
                this.getProject().moveToTrash((Object)this);
            } else {
                DiagramFactory.getInstance().removeDiagram((ArgoDiagram)this);
            }
        }
    }

    protected Object[] getUmlActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getNodeAction(Model.getMetaTypes().getState()));
        actions.add(this.getEdgeAction(Model.getMetaTypes().getTransition()));
        actions.add(null);
        actions.add(this.getPseudoAction(Model.getPseudostateKind().getInitial()));
        actions.add(this.getNodeAction(Model.getMetaTypes().getFinalState()));
        actions.add(this.getPseudoAction(Model.getPseudostateKind().getEntryPoint()));
        actions.add(this.getPseudoAction(Model.getPseudostateKind().getExitPoint()));
        actions.add(this.getPseudoAction(Model.getPseudostateKind().getJunction()));
        actions.add(this.getPseudoAction(Model.getPseudostateKind().getChoice()));
        actions.add(this.getPseudoAction(Model.getPseudostateKind().getFork()));
        actions.add(this.getPseudoAction(Model.getPseudostateKind().getJoin()));
        actions.add(this.getPseudoAction(Model.getPseudostateKind().getShallowHistory()));
        actions.add(this.getPseudoAction(Model.getPseudostateKind().getDeepHistory()));
        return actions.toArray();
    }

    public String getLabelName() {
        return Translator.localize((String)"label.statemachine-diagram");
    }

    private Action getNodeAction(Object metaType) {
        String label = this.getLabel(metaType);
        return new RadioAction((Action)new CmdCreateNode(metaType, label));
    }

    private Action getPseudoAction(Object kind) {
        String label = "button.new-" + Model.getFacade().getName(kind).toLowerCase();
        return new RadioAction((Action)((Object)new CreatePseudostateAction(kind, label)));
    }

    private Action getEdgeAction(Object metaType) {
        String label = this.getLabel(metaType);
        return new RadioAction((Action)new ActionSetMode(ModeCreatePolyEdge.class, "edgeClass", metaType, label));
    }

    private String getLabel(Object metaType) {
        return "button.new-" + Model.getMetaTypes().getName(metaType).toLowerCase();
    }

    public boolean relocate(Object base) {
        return false;
    }

    public void encloserChanged(FigNode enclosed, FigNode oldEncloser, FigNode newEncloser) {
    }

    public boolean doesAccept(Object objectToAccept) {
        if (Model.getFacade().isAVertex(objectToAccept)) {
            return true;
        }
        return Model.getFacade().isAComment(objectToAccept);
    }

    public DiagramElement createDiagramElement(Object modelElement, Rectangle bounds) {
        Object figNode = null;
        DiagramSettings settings = this.getDiagramSettings();
        if (Model.getFacade().isAFinalState(modelElement)) {
            figNode = new FigFinalState(modelElement, bounds, settings);
        } else if (Model.getFacade().isAState(modelElement)) {
            figNode = new FigVertex(modelElement, bounds, settings);
        } else if (Model.getFacade().isAComment(modelElement)) {
            figNode = new FigComment(modelElement, bounds, settings);
        } else if (Model.getFacade().isAPseudostate(modelElement)) {
            Object kind = Model.getFacade().getKind(modelElement);
            if (kind == null) {
                return null;
            }
            if (kind.equals(Model.getPseudostateKind().getInitial())) {
                figNode = new FigInitialState(modelElement, bounds, settings);
            } else if (kind.equals(Model.getPseudostateKind().getEntryPoint())) {
                figNode = new FigEntryPoint(modelElement, bounds, settings);
            } else if (kind.equals(Model.getPseudostateKind().getExitPoint())) {
                figNode = new FigExitPoint(modelElement, bounds, settings);
            } else if (kind.equals(Model.getPseudostateKind().getChoice())) {
                figNode = new FigBranchState(modelElement, bounds, settings);
            } else if (kind.equals(Model.getPseudostateKind().getJunction())) {
                figNode = new FigJunctionState(modelElement, bounds, settings);
            } else if (kind.equals(Model.getPseudostateKind().getFork())) {
                figNode = new FigForkState(modelElement, bounds, settings);
            } else if (kind.equals(Model.getPseudostateKind().getJoin())) {
                figNode = new FigJoinState(modelElement, bounds, settings);
            } else if (kind.equals(Model.getPseudostateKind().getShallowHistory())) {
                figNode = new FigShallowHistoryState(modelElement, bounds, settings);
            } else if (kind.equals(Model.getPseudostateKind().getDeepHistory())) {
                figNode = new FigDeepHistoryState(modelElement, bounds, settings);
            }
        }
        return figNode;
    }

    public boolean isRelocationAllowed(Object base) {
        return false;
    }

    public Collection getRelocationCandidates(Object root) {
        return null;
    }

    private class CreatePseudostateAction
    extends CmdCreateNode {
        public CreatePseudostateAction(Object kind, String name) {
            super(Model.getMetaTypes().getPseudostate(), name);
            this.setArg("kind", kind);
        }

        public Object makeNode() {
            Object newNode = super.makeNode();
            Object kind = this.getArg("kind");
            Model.getCoreHelper().setKind(newNode, kind);
            return newNode;
        }
    }
}

