/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.uml.reveng.idl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.argouml.model.Model;
import org.argouml.uml.reveng.ImportClassLoader;
import org.argouml.uml.reveng.idl.ClassifierNotFoundException;
import org.argouml.uml.reveng.idl.Context;

class OuterClassifierContext
extends Context {
    private static final Logger LOG = Logger.getLogger(OuterClassifierContext.class.getName());
    private Object mClassifier;
    private Object mPackage;
    private String namePrefix;
    private String packageJavaName;

    public OuterClassifierContext(Context base, Object theClassifier, Object thePackage, String theNamePrefix) {
        super(base);
        this.mClassifier = theClassifier;
        this.mPackage = thePackage;
        this.namePrefix = theNamePrefix;
        this.packageJavaName = this.getJavaName(thePackage);
    }

    @Override
    public Object getInterface(String name) throws ClassifierNotFoundException {
        return this.get(name, true);
    }

    @Override
    public Object get(String name) throws ClassifierNotFoundException {
        return this.get(name, false);
    }

    @Override
    public Object get(String name, boolean interfacesOnly) throws ClassifierNotFoundException {
        Object iClassifier;
        block16: {
            iClassifier = Model.getFacade().lookupIn(this.mClassifier, name);
            if (iClassifier == null) {
                try {
                    Class<?> classifier;
                    if (Model.getFacade().isAModel(this.mPackage)) {
                        classifier = Class.forName(this.namePrefix + name);
                    } else {
                        String clazzName = this.packageJavaName + "." + this.namePrefix + name;
                        classifier = Class.forName(clazzName);
                    }
                    if (classifier.isInterface()) {
                        iClassifier = Model.getCoreFactory().buildInterface(name, this.mClassifier);
                    } else {
                        if (interfacesOnly) {
                            throw new ClassNotFoundException();
                        }
                        iClassifier = Model.getCoreFactory().buildClass(name, this.mClassifier);
                    }
                }
                catch (ClassNotFoundException e) {
                    try {
                        Class classifier;
                        if (Model.getFacade().isAModel(this.mPackage)) {
                            classifier = ImportClassLoader.getInstance().loadClass(this.namePrefix + name);
                        } else {
                            String clazzName = this.packageJavaName + "." + this.namePrefix + name;
                            classifier = ImportClassLoader.getInstance().loadClass(clazzName);
                        }
                        if (classifier.isInterface()) {
                            iClassifier = Model.getCoreFactory().buildInterface(name, this.mClassifier);
                        } else {
                            if (interfacesOnly) {
                                throw new ClassNotFoundException();
                            }
                            iClassifier = Model.getCoreFactory().buildClass(name, this.mClassifier);
                        }
                    }
                    catch (Exception e1) {
                        if (!(e1 instanceof ClassNotFoundException)) {
                            LOG.log(Level.WARNING, "Exception", e1);
                        }
                        if (this.getContext() == null) break block16;
                        iClassifier = this.getContext().get(name, interfacesOnly);
                    }
                }
            }
        }
        return iClassifier;
    }
}

