/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.catalina.util.CustomObjectInputStream;

public final class FileStore
extends StoreBase
implements Store {
    private static final String FILE_EXT = ".session";
    private String directory = ".";
    private File directoryFile = null;
    private static final String info = "FileStore/1.0";
    private static final String storeName = "fileStore";
    private static final String threadName = "FileStore";

    public void clear() throws IOException {
        String[] keys = this.keys();
        int i = 0;
        while (i < keys.length) {
            this.remove(keys[i]);
            ++i;
        }
    }

    private File file(String id) {
        File tempdir;
        if (this.directory == null) {
            return null;
        }
        String pathname = String.valueOf(this.directory) + "/" + id + FILE_EXT;
        File file = new File(pathname);
        if (!file.isAbsolute() && (tempdir = this.getDirectoryFile()) != null) {
            file = new File(tempdir, pathname);
        }
        return file;
    }

    public String getDirectory() {
        return this.directory;
    }

    private File getDirectoryFile() {
        if (this.directoryFile == null) {
            Container container = this.manager.getContainer();
            if (container instanceof Context) {
                ServletContext servletContext = ((Context)container).getServletContext();
                this.directoryFile = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            } else {
                throw new IllegalArgumentException("directory not set, I can't work with this Container");
            }
        }
        return this.directoryFile;
    }

    public String getInfo() {
        return info;
    }

    public int getSize() throws IOException {
        String[] files = this.getDirectoryFile().list();
        int keycount = 0;
        int i = 0;
        while (i < files.length) {
            if (files[i].endsWith(FILE_EXT)) {
                ++keycount;
            }
            ++i;
        }
        return keycount;
    }

    public String getStoreName() {
        return storeName;
    }

    public String getThreadName() {
        return threadName;
    }

    public String[] keys() throws IOException {
        String[] files = this.getDirectoryFile().list();
        int keycount = 0;
        int i = 0;
        while (i < files.length) {
            if (files[i].endsWith(FILE_EXT)) {
                ++keycount;
            } else {
                files[i] = null;
            }
            ++i;
        }
        String[] keys = new String[keycount];
        if (keycount > 0) {
            keycount = 0;
            int i2 = 0;
            while (i2 < files.length) {
                if (files[i2] != null) {
                    keys[keycount] = files[i2].substring(0, files[i2].lastIndexOf(46));
                    ++keycount;
                }
                ++i2;
            }
        }
        return keys;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Session load(String id) throws ClassNotFoundException, IOException {
        Object bis;
        File file = this.file(id);
        if (file == null) {
            return null;
        }
        if (this.debug >= 1) {
            this.log(this.sm.getString(String.valueOf(this.getStoreName()) + ".loading", id, file.getAbsolutePath()));
        }
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        Loader loader = null;
        ClassLoader classLoader = null;
        try {
            fis = new FileInputStream(file.getAbsolutePath());
            bis = new BufferedInputStream(fis);
            Container container = this.manager.getContainer();
            if (container != null) {
                loader = container.getLoader();
            }
            if (loader != null) {
                classLoader = loader.getClassLoader();
            }
            ois = classLoader != null ? new CustomObjectInputStream((InputStream)bis, classLoader) : new ObjectInputStream((InputStream)bis);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (this.debug < 1) return null;
            this.log("No persisted data file found");
            return null;
        }
        catch (IOException e) {
            if (ois == null) throw e;
            try {
                ois.close();
            }
            catch (IOException iOException) {}
            ois = null;
            throw e;
        }
        try {
            StandardSession session = (StandardSession)this.manager.createSession();
            session.readObjectData(ois);
            session.setManager(this.manager);
            bis = session;
            Object var9_12 = null;
            if (ois == null) return bis;
        }
        catch (Throwable container) {
            Object var9_13 = null;
            if (ois == null) throw container;
            try {
                ois.close();
                throw container;
            }
            catch (IOException iOException) {}
            throw container;
        }
        try {
            ois.close();
            return bis;
        }
        catch (IOException iOException) {}
        return bis;
    }

    public void remove(String id) throws IOException {
        File file = this.file(id);
        if (file == null) {
            return;
        }
        if (this.debug >= 1) {
            this.log(this.sm.getString(String.valueOf(this.getStoreName()) + ".removing", id, file.getAbsolutePath()));
        }
        file.delete();
    }

    public void save(Session session) throws IOException {
        File file = this.file(session.getId());
        if (file == null) {
            return;
        }
        if (this.debug >= 1) {
            this.log(this.sm.getString(String.valueOf(this.getStoreName()) + ".saving", session.getId(), file.getAbsolutePath()));
        }
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(file.getAbsolutePath());
            oos = new ObjectOutputStream(new BufferedOutputStream(fos));
        }
        catch (IOException e) {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
            throw e;
        }
        try {
            ((StandardSession)session).writeObjectData(oos);
        }
        finally {
            Object var6_7 = null;
            oos.close();
        }
    }

    public void setDirectory(String path) {
        String oldDirectory = this.directory;
        this.directory = path;
        this.directoryFile = null;
        this.support.firePropertyChange("directory", oldDirectory, this.directory);
    }
}

