/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Wrapper;

public final class InstanceSupport {
    private InstanceListener[] listeners = new InstanceListener[0];
    private Wrapper wrapper = null;

    public InstanceSupport(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    public void addInstanceListener(InstanceListener listener) {
        InstanceListener[] instanceListenerArray = this.listeners;
        synchronized (instanceListenerArray) {
            InstanceListener[] results = new InstanceListener[this.listeners.length + 1];
            int i = 0;
            while (i < this.listeners.length) {
                results[i] = this.listeners[i];
                ++i;
            }
            results[this.listeners.length] = listener;
            this.listeners = results;
        }
    }

    public void fireInstanceEvent(String type, Filter filter) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, filter, type);
        InstanceListener[] interested = null;
        InstanceListener[] instanceListenerArray = this.listeners;
        synchronized (instanceListenerArray) {
            interested = (InstanceListener[])this.listeners.clone();
        }
        int i = 0;
        while (i < interested.length) {
            interested[i].instanceEvent(event);
            ++i;
        }
    }

    public void fireInstanceEvent(String type, Filter filter, Throwable exception) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, filter, type, exception);
        InstanceListener[] interested = null;
        InstanceListener[] instanceListenerArray = this.listeners;
        synchronized (instanceListenerArray) {
            interested = (InstanceListener[])this.listeners.clone();
        }
        int i = 0;
        while (i < interested.length) {
            interested[i].instanceEvent(event);
            ++i;
        }
    }

    public void fireInstanceEvent(String type, Filter filter, ServletRequest request, ServletResponse response) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, filter, type, request, response);
        InstanceListener[] interested = null;
        InstanceListener[] instanceListenerArray = this.listeners;
        synchronized (instanceListenerArray) {
            interested = (InstanceListener[])this.listeners.clone();
        }
        int i = 0;
        while (i < interested.length) {
            interested[i].instanceEvent(event);
            ++i;
        }
    }

    public void fireInstanceEvent(String type, Filter filter, ServletRequest request, ServletResponse response, Throwable exception) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, filter, type, request, response, exception);
        InstanceListener[] interested = null;
        InstanceListener[] instanceListenerArray = this.listeners;
        synchronized (instanceListenerArray) {
            interested = (InstanceListener[])this.listeners.clone();
        }
        int i = 0;
        while (i < interested.length) {
            interested[i].instanceEvent(event);
            ++i;
        }
    }

    public void fireInstanceEvent(String type, Servlet servlet) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, servlet, type);
        InstanceListener[] interested = null;
        InstanceListener[] instanceListenerArray = this.listeners;
        synchronized (instanceListenerArray) {
            interested = (InstanceListener[])this.listeners.clone();
        }
        int i = 0;
        while (i < interested.length) {
            interested[i].instanceEvent(event);
            ++i;
        }
    }

    public void fireInstanceEvent(String type, Servlet servlet, Throwable exception) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, servlet, type, exception);
        InstanceListener[] interested = null;
        InstanceListener[] instanceListenerArray = this.listeners;
        synchronized (instanceListenerArray) {
            interested = (InstanceListener[])this.listeners.clone();
        }
        int i = 0;
        while (i < interested.length) {
            interested[i].instanceEvent(event);
            ++i;
        }
    }

    public void fireInstanceEvent(String type, Servlet servlet, ServletRequest request, ServletResponse response) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, servlet, type, request, response);
        InstanceListener[] interested = null;
        InstanceListener[] instanceListenerArray = this.listeners;
        synchronized (instanceListenerArray) {
            interested = (InstanceListener[])this.listeners.clone();
        }
        int i = 0;
        while (i < interested.length) {
            interested[i].instanceEvent(event);
            ++i;
        }
    }

    public void fireInstanceEvent(String type, Servlet servlet, ServletRequest request, ServletResponse response, Throwable exception) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, servlet, type, request, response, exception);
        InstanceListener[] interested = null;
        InstanceListener[] instanceListenerArray = this.listeners;
        synchronized (instanceListenerArray) {
            interested = (InstanceListener[])this.listeners.clone();
        }
        int i = 0;
        while (i < interested.length) {
            interested[i].instanceEvent(event);
            ++i;
        }
    }

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    public void removeInstanceListener(InstanceListener listener) {
        InstanceListener[] instanceListenerArray = this.listeners;
        synchronized (instanceListenerArray) {
            int n = -1;
            int i = 0;
            while (i < this.listeners.length) {
                if (this.listeners[i] == listener) {
                    n = i;
                    break;
                }
                ++i;
            }
            if (n < 0) {
                Object var3_5 = null;
                return;
            }
            InstanceListener[] results = new InstanceListener[this.listeners.length - 1];
            int j = 0;
            int i2 = 0;
            while (i2 < this.listeners.length) {
                if (i2 != n) {
                    results[j++] = this.listeners[i2];
                }
                ++i2;
            }
            this.listeners = results;
        }
    }
}

