/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.runtime;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class ApplicationHelper {
    protected static ApplicationHelper Singleton = null;
    protected Vector classPath;
    protected Hashtable imageCache = new Hashtable(31);

    public static ApplicationHelper Singleton() {
        if (Singleton == null) {
            Singleton = new ApplicationHelper();
        }
        return Singleton;
    }

    public Vector splitSeparatedString(String toParse, String separator) {
        if (toParse == null) {
            return new Vector(0);
        }
        Vector<String> res = new Vector<String>(20);
        String s = toParse;
        if (!s.endsWith(separator)) {
            s = s + separator;
        }
        while (s.indexOf(separator) >= 0) {
            String p = s.substring(0, s.indexOf(separator));
            s = s.substring(p.length() + 1);
            if ((p = p.trim()).length() <= 0) continue;
            res.addElement(p);
        }
        return res;
    }

    public String replace(String s, String key, String value) {
        int i = s.indexOf(key);
        if (i < 0) {
            return s;
        }
        StringBuffer res = new StringBuffer(s.length());
        res.append(s.substring(0, i));
        res.append(value);
        res.append(s.substring(i + key.length()));
        return this.replace(res.toString(), key, value);
    }

    public void copy(File from, File to) throws Exception {
        FileInputStream in = new FileInputStream(from);
        byte[] buf = new byte[(int)from.length()];
        in.read(buf, 0, buf.length);
        in.close();
        FileOutputStream out = new FileOutputStream(to);
        out.write(buf);
        out.close();
    }

    protected String getURL(String urlOrFile) throws MalformedURLException {
        try {
            if (urlOrFile.indexOf(":") >= 0 || urlOrFile.startsWith("/")) {
                if (urlOrFile.startsWith("/")) {
                    return "file://" + urlOrFile;
                }
                return "file:///" + urlOrFile;
            }
            String currentDirectory = System.getProperty("user.dir");
            String file = currentDirectory.replace(File.separatorChar, '/') + '/';
            if (file.charAt(0) != '/') {
                file = "/" + file;
            }
            URL baseURL = new URL("file", null, file);
            return new URL(baseURL, urlOrFile).toString();
        }
        catch (SecurityException ex) {
            return urlOrFile.replace(File.separatorChar, '/');
        }
    }

    public String getDirectory(String file) {
        while (!new File(file).isDirectory()) {
            if (file.indexOf(File.separator) >= 0) {
                file = file.substring(0, file.lastIndexOf(File.separator));
                continue;
            }
            return "";
        }
        return file;
    }

    public String getFileName(String file) {
        if (file.indexOf(File.separator) >= 0) {
            return file.substring(file.lastIndexOf(File.separator) + 1, file.length());
        }
        return file;
    }

    public JFrame createFrameOn(Component comp) {
        JFrame frame = new JFrame();
        frame.getContentPane().add("Center", comp);
        frame.pack();
        return frame;
    }

    public JDialog createDialogOn(Frame owner, Component comp, boolean modal) {
        JDialog frame = new JDialog(owner, modal);
        frame.getContentPane().add("Center", comp);
        frame.pack();
        return frame;
    }

    public JMenuItem createMenuItem(final Object target, String title, int mnemonic, final String method) {
        JMenuItem result = new JMenuItem(title, mnemonic);
        result.setName(method);
        result.addActionListener(new ActionListener(){
            static /* synthetic */ Class class$java$awt$event$ActionEvent;

            public void actionPerformed(ActionEvent e) {
                try {
                    Method m = target.getClass().getMethod(method, class$java$awt$event$ActionEvent == null ? (class$java$awt$event$ActionEvent = 1.class$("java.awt.event.ActionEvent")) : class$java$awt$event$ActionEvent);
                    if (m != null) {
                        m.invoke(target, e);
                    }
                }
                catch (NoSuchMethodException nse) {
                    System.out.println("please implement the eventhandler method:" + method + "( ActionEvent e )");
                }
                catch (InvocationTargetException iex) {
                    iex.getTargetException().printStackTrace();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        return result;
    }

    public JMenu createMenu(String title, int mnemonic) {
        JMenu result = new JMenu(title);
        result.setMnemonic(mnemonic);
        return result;
    }

    public void centerWindow(Window win) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int w = win.getSize().width;
        int h = win.getSize().height;
        ((Component)win).setLocation(d.width / 2 - w / 2, d.height / 2 - h / 2);
    }

    public AbstractButton createToolbarAction(final Object target, String ttip, final String method, String image) {
        JButton b = new JButton();
        b.setToolTipText(ttip);
        b.addActionListener(new ActionListener(){
            static /* synthetic */ Class class$java$awt$event$ActionEvent;

            public void actionPerformed(ActionEvent e) {
                try {
                    Method m = target.getClass().getMethod(method, class$java$awt$event$ActionEvent == null ? (class$java$awt$event$ActionEvent = 2.class$("java.awt.event.ActionEvent")) : class$java$awt$event$ActionEvent);
                    if (m != null) {
                        m.invoke(target, e);
                    }
                }
                catch (NoSuchMethodException nse) {
                    System.out.println("please implement the eventhandler method:" + method + "( ActionEvent e )");
                }
                catch (InvocationTargetException iex) {
                    iex.getTargetException().printStackTrace();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        Image im = this.getImage(target.getClass(), "images/" + image);
        b.setMargin(new Insets(2, 2, 2, 2));
        if (im != null) {
            b.setIcon(new ImageIcon(im));
        } else {
            b.setText(":(");
        }
        return b;
    }

    public Vector classPath() {
        if (this.classPath == null) {
            String s = System.getProperty("java.class.path");
            this.classPath = this.splitSeparatedString(File.pathSeparator, s);
        }
        return this.classPath;
    }

    public Container getTopComponent(Component comp) {
        Container c = comp.getParent();
        while (!(c instanceof Window) && !(c instanceof Applet) && c != null) {
            c = c.getParent();
        }
        return c;
    }

    public Hashtable getImageCache() {
        return this.imageCache;
    }

    public URL ressolveRessource(String name, Class clazz) {
        String pack = "";
        try {
            String urlString;
            pack = clazz.getName();
            int i = pack.lastIndexOf(46);
            pack = i >= 0 ? pack.substring(0, i) : "";
            pack = pack.replace('.', '/');
            URL url = clazz.getResource("/" + pack + "/" + name);
            if (url == null) {
                url = clazz.getResource("/" + name);
            }
            if (url != null && (urlString = url.toString()).indexOf("/DLL") >= 0 && urlString.toLowerCase().indexOf(".exe") >= 0) {
                i = urlString.indexOf("/DLL");
                urlString = urlString.substring(0, i) + "/ZIP" + urlString.substring(i + 4);
                url = new URL(urlString);
            }
            if (url == null && name.endsWith(".gml") && !name.startsWith("forms/")) {
                return this.ressolveRessource("forms/" + name, clazz);
            }
            return url;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Image getImage(Class ressourceLoader, String relativeName) {
        return this.getImage(ressourceLoader, relativeName, true);
    }

    public Image getImage(Class ressourceLoader, String relativeName, boolean cache) {
        URL url;
        Image img = null;
        if (cache) {
            img = (Image)this.getImageCache().get(relativeName);
        }
        if (img == null && (url = this.ressolveRessource(relativeName.replace(File.separatorChar, '/'), ressourceLoader)) != null) {
            img = Toolkit.getDefaultToolkit().getImage(url);
        }
        if (img != null) {
            this.getImageCache().put(relativeName, img);
        }
        return img;
    }
}

