/*
 * Decompiled with CFR 0.152.
 */
package JCollections;

import de.netcomputing.util.Tracer;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Random;

public final class IntTable
implements Serializable {
    public transient int[] keys;
    public transient Object[] values;
    public transient int numberOfElements;
    public static int collision = 0;
    static final long serialVersionUID = 7262625831330845068L;

    private final boolean isEmpty(int index) {
        return this.keys[index] == 0 && this.values[index] == null;
    }

    private void writeObject(ObjectOutputStream oo) throws IOException {
        oo.defaultWriteObject();
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        oo.writeInt(this.numberOfElements);
        oo.writeInt(this.keys.length);
        int chkIdx = 0;
        int n = 0;
        while (n < this.keys.length) {
            if (!this.isEmpty(n)) {
                ++chkIdx;
                oo.writeInt(this.keys[n]);
                if (this.values[n] == null) {
                    oo.writeByte(0);
                } else {
                    oo.writeByte(1);
                    oo.writeObject(this.values[n]);
                }
            }
            ++n;
        }
        if (chkIdx != this.numberOfElements) {
            Tracer.This.println("Fatal Error numofelems:" + this.numberOfElements + " real:" + chkIdx);
            while (true) {
                // Infinite loop
            }
        }
    }

    private void readObject(ObjectInputStream oi) throws IOException, ClassNotFoundException {
        oi.defaultReadObject();
        int numelem = oi.readInt();
        int tablen = oi.readInt();
        this.keys = new int[tablen];
        this.values = new Object[tablen];
        this.numberOfElements = 0;
        int n = 0;
        while (n < numelem) {
            int tmp = oi.readInt();
            byte wasNull = oi.readByte();
            if (wasNull == 0) {
                this.put(tmp, null);
            } else {
                Object o = oi.readObject();
                this.put(tmp, o);
            }
            ++n;
        }
    }

    public IntTable() {
    }

    public IntTable(int initialSize) {
        this.keys = new int[initialSize];
        this.values = new Object[initialSize];
        this.numberOfElements = 0;
    }

    public final int keyAt(int n) {
        return this.values[n] == null ? -1 : this.keys[n];
    }

    public final Object valueAt(int n) {
        return this.isEmpty(n) ? null : this.values[n];
    }

    public final void setKeyValuePrivileged(int index, int key, Object val) {
        if (key >= 0) {
            this.keys[index] = key;
            this.values[index] = val;
        }
    }

    public final Object put(int key, Object value) {
        int tmp;
        if (key < 0) {
            return null;
        }
        Object result = null;
        if (this.numberOfElements * 3 > this.keys.length) {
            this.stepUp(this.keys.length * 3 / 2);
        }
        if (this.keys[tmp = key % this.keys.length] == 0 && this.values[tmp] == null) {
            ++this.numberOfElements;
            this.values[tmp] = value;
            this.keys[tmp] = key;
        } else if (this.keys[tmp] == key) {
            result = this.values[tmp];
            this.values[tmp] = value;
        } else {
            ++collision;
            int idx = tmp;
            while (true) {
                if (this.keys[idx] == 0 && this.values[idx] == null) {
                    ++this.numberOfElements;
                    this.values[idx] = value;
                    this.keys[idx] = key;
                    return null;
                }
                if (this.keys[idx] == key) {
                    result = this.values[idx];
                    this.values[idx] = value;
                    return result;
                }
                idx = (idx + 1) % this.keys.length;
            }
        }
        return result;
    }

    public final Object fastGet(int key) {
        if (this.values[key % this.keys.length] == null) {
            return null;
        }
        int tmp = key % this.keys.length;
        if (this.keys[tmp] == key) {
            return this.values[tmp];
        }
        int idx = ++tmp % this.keys.length;
        while (!this.isEmpty(idx)) {
            if (this.keys[idx] == key) {
                return this.values[idx];
            }
            ++idx;
            idx %= this.keys.length;
        }
        return null;
    }

    public final Object get(int key) {
        if (key < 0) {
            return null;
        }
        int tmp = key % this.keys.length;
        if (this.keys[tmp] == 0 && this.values[tmp] == null) {
            return null;
        }
        if (this.keys[tmp] == key) {
            return this.values[tmp];
        }
        int idx = ++tmp % this.keys.length;
        while (!this.isEmpty(idx)) {
            if (this.keys[idx] == key) {
                return this.values[idx];
            }
            ++idx;
            idx %= this.keys.length;
        }
        return null;
    }

    void stepUp(int newSize) {
        collision = 0;
        int[] oldTabKey = this.keys;
        Object[] oldTabVal = this.values;
        this.keys = new int[newSize];
        this.values = new Object[newSize];
        this.numberOfElements = 0;
        int n = 0;
        while (n < oldTabKey.length) {
            if (oldTabKey[n] != 0 || oldTabVal[n] != null) {
                this.put(oldTabKey[n], oldTabVal[n]);
            }
            ++n;
        }
    }

    public int[] keys() {
        int[] result = new int[this.numberOfElements];
        int idx = 0;
        int n = 0;
        while (n < this.keys.length) {
            if (!this.isEmpty(n)) {
                result[idx++] = this.keys[n];
            }
            ++n;
        }
        return result;
    }

    public Object[] elements() {
        Object[] result = new Object[this.numberOfElements];
        int idx = 0;
        int n = 0;
        while (n < this.keys.length) {
            if (!this.isEmpty(n)) {
                result[idx++] = this.values[n];
            }
            ++n;
        }
        return result;
    }

    public static void main(String[] arg) {
        long tim = System.currentTimeMillis();
        IntTable it = new IntTable(1);
        Random rnd = new Random(3456L);
        int n = 0;
        while (n < 10000) {
            int t = Math.abs(rnd.nextInt());
            it.put(t, new Integer(t));
            ++n;
        }
        Tracer.This.println("added " + n + " items in " + (System.currentTimeMillis() - tim) + " ms ");
        Tracer.This.println(" n:" + it.numberOfElements);
        tim = System.currentTimeMillis();
        int[] keys = it.keys();
        Tracer.This.println("key 0 " + keys[0]);
        n = 0;
        while (n < it.numberOfElements) {
            if ((Integer)it.get(keys[n]) == null || (Integer)it.get(keys[n]) != keys[n]) {
                Tracer.This.println("diff at " + n + " read:" + it.get(keys[n]));
            }
            ++n;
        }
        Tracer.This.println("accesstime " + (double)(System.currentTimeMillis() - tim) / (double)n + " ms ");
        try {
            ObjectOutputStream oo = new ObjectOutputStream(new FileOutputStream("test.oos"));
            oo.writeObject(it);
            oo.close();
            ObjectInputStream oi = new ObjectInputStream(new FileInputStream("test.oos"));
            it = (IntTable)oi.readObject();
            oi.close();
            keys = it.keys();
            n = 0;
            while (n < it.numberOfElements) {
                if ((Integer)it.get(keys[n]) == null || (Integer)it.get(keys[n]) != keys[n]) {
                    Tracer.This.println("diff at " + n + " read:" + it.get(keys[n]) + " should" + keys[n]);
                }
                ++n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(-1);
    }
}

