/*
 * Decompiled with CFR 0.152.
 */
package JCollections;

import JCollections.ISortFunc;
import JCollections.JCollectionImp;
import JCollections.JOrderedCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class JArray
extends JCollectionImp
implements JOrderedCollection {
    Vector v;

    public static ISortFunc StringSortFunc() {
        return new ISortFunc(){

            public boolean isGreaterOrEqual(Object a, Object b) {
                return a.toString().compareTo(b.toString()) >= 0;
            }
        };
    }

    public static ISortFunc StringSortFuncInverse() {
        return new ISortFunc(){

            public boolean isGreaterOrEqual(Object a, Object b) {
                return a.toString().compareTo(b.toString()) <= 0;
            }
        };
    }

    public static int compareToIgnoreCase(String a, String b) {
        int len1 = a.length();
        int len2 = b.length();
        int n = Math.min(len1, len2);
        int i = 0;
        while (n-- != 0) {
            int c2;
            int c1 = a.charAt(i) | 0x20;
            if (c1 == (c2 = b.charAt(i++) | 0x20)) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static ISortFunc UpperCaseStringSortFunc() {
        return new ISortFunc(){

            public boolean isGreaterOrEqual(Object a, Object b) {
                return JArray.compareToIgnoreCase(a.toString(), b.toString()) >= 0;
            }
        };
    }

    public static void QuickSort(JOrderedCollection a) {
        JArray.QuickSort(a, 0, a.size() - 1, JArray.UpperCaseStringSortFunc());
    }

    public static void QuickSort(JOrderedCollection a, ISortFunc ge) {
        JArray.QuickSort(a, 0, a.size() - 1, ge);
    }

    /*
     * Unable to fully structure code
     */
    static void QuickSort(JOrderedCollection a, int lo0, int hi0, ISortFunc ge) {
        block5: {
            lo = lo0;
            hi = hi0;
            if (hi0 <= lo0) break block5;
            mid = a.at((lo0 + hi0) / 2);
            ** GOTO lbl16
            {
                ++lo;
                do {
                    if (lo < hi0 && !ge.isGreaterOrEqual(a.at(lo), mid)) continue block0;
                    while (hi > lo0 && !ge.isGreaterOrEqual(mid, a.at(hi))) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    JArray.swap(a, lo, hi);
                    ++lo;
                    --hi;
lbl16:
                    // 3 sources

                } while (lo <= hi);
            }
        }
        if (lo0 < hi) {
            JArray.QuickSort(a, lo0, hi, ge);
        }
        if (lo < hi0) {
            JArray.QuickSort(a, lo, hi0, ge);
        }
    }

    private static void swap(JOrderedCollection a, int i, int j) {
        Object T = a.at(i);
        a.setAt(i, a.at(j));
        a.setAt(j, T);
    }

    public static void reverse(JOrderedCollection a) {
        int n = 0;
        while (n < (a.size() + 1) / 2) {
            JArray.swap(a, n, a.size() - n - 1);
            ++n;
        }
    }

    public JArray(List l) {
        this.v = new Vector(l);
    }

    public JArray() {
        this.v = new Vector();
    }

    public JArray(int size) {
        this.v = new Vector(size);
    }

    public JArray(Vector base) {
        this.v = base;
    }

    public void reverse() {
        JArray.reverse(this);
    }

    public Object find(Object o) {
        int i = this.v.indexOf(o);
        if (i < 0) {
            return null;
        }
        return this.at(i);
    }

    public Vector getVector() {
        return this.v;
    }

    public void add(Object o) {
        this.v.addElement(o);
    }

    public void sortBy(ISortFunc s) {
        JArray.QuickSort(this, s);
    }

    public void rem(Object o) {
        this.v.removeElement(o);
    }

    public void remAll() {
        this.v.removeAllElements();
    }

    public int size() {
        return this.v.size();
    }

    public Enumeration enumerate() {
        return this.v.elements();
    }

    public Enumeration cloneAndEnumerate() {
        return ((Vector)this.v.clone()).elements();
    }

    public void setAt(int index, Object o) {
        this.v.setElementAt(o, index);
    }

    public void addAt(int index, Object o) {
        this.v.insertElementAt(o, index);
    }

    public void setSize(int newSize) {
        this.v.setSize(newSize);
    }

    public void remAt(int index) {
        this.v.removeElementAt(index);
    }

    public Object at(int index) {
        return this.v.elementAt(index);
    }

    public void sort() {
        JArray.QuickSort(this, JArray.StringSortFunc());
    }

    public int indexOfByString(Object o) {
        int n = 0;
        while (n < this.v.size()) {
            if (o.toString().equals(this.v.elementAt(n).toString())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(Object o) {
        return this.v.indexOf(o);
    }

    public List asList() {
        ArrayList<Object> li = new ArrayList<Object>(this.size());
        int i = 0;
        while (i < this.size()) {
            li.add(this.at(i));
            ++i;
        }
        return li;
    }

    public Object get(int i) {
        return this.at(i);
    }
}

