/*
 * Decompiled with CFR 0.152.
 */
package Jack;

import JCollections.IntTable;
import Jack.JackFactory;
import de.netcomputing.util.Tracer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;

class AcceptorNode
implements Serializable {
    static final long serialVersionUID = 7162625831330845035L;
    transient IntTable transitions = new IntTable(2);
    transient AcceptorNode[] trans;
    transient String symbolName = null;
    transient String inversed = null;
    transient int id = -1;
    transient int pushback = 0;
    transient boolean ignored = false;
    transient boolean identity = false;
    static String empty = "";
    static int lf1 = 0;
    static int lf2 = 0;
    static int lf3 = 0;

    public AcceptorNode() {
    }

    AcceptorNode(int _id, String name, String inverse) {
        this.id = _id;
        this.symbolName = name;
        this.inversed = inverse;
        this.trans = JackFactory.CreateAcceptorNodeArray(256);
    }

    public void storeTo(DataOutput out, IntTable storedToID) {
        try {
            out.writeInt(this.hashCode());
            storedToID.put(this.hashCode(), Boolean.TRUE);
            out.writeInt(this.trans.length);
            int n = 0;
            while (n < this.trans.length) {
                if (this.trans[n] == null) {
                    ++lf1;
                } else {
                    Object acc = storedToID.fastGet(this.trans[n].hashCode());
                    if (acc == null) {
                        out.writeInt(n << 16);
                        ++lf2;
                        this.trans[n].storeTo(out, storedToID);
                    } else {
                        out.writeInt(n);
                        ++lf3;
                        out.writeInt(this.trans[n].hashCode());
                    }
                }
                ++n;
            }
            out.writeInt(-1);
            if (this.symbolName == null) {
                out.writeUTF(empty);
            } else {
                out.writeUTF(this.symbolName);
            }
            if (this.inversed == null) {
                out.writeUTF(empty);
            } else {
                out.writeUTF(this.inversed);
            }
            out.writeInt(this.id);
            out.writeInt(this.pushback);
            out.writeBoolean(this.ignored);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadFrom(DataInput in, IntTable storedToID) {
        try {
            int sw;
            int hcode = in.readInt();
            storedToID.put(hcode, this);
            int len = in.readInt();
            this.trans = JackFactory.CreateAcceptorNodeArray(len);
            while ((sw = in.readInt()) >= 0) {
                if (sw >= 65536) {
                    this.trans[sw >> 16] = JackFactory.CreateAcceptorNode();
                    this.trans[sw >> 16].loadFrom(in, storedToID);
                    ++lf2;
                    continue;
                }
                int code = in.readInt();
                Object node = storedToID.fastGet(code);
                if (node == null) {
                    Tracer.This.println("!!!!!!!!!!!!!!!!AcceptorNode::load unresolved id");
                }
                this.trans[sw] = (AcceptorNode)storedToID.fastGet(code);
                ++lf3;
            }
            this.symbolName = in.readUTF();
            this.inversed = in.readUTF();
            if (this.symbolName.length() == 0) {
                this.symbolName = null;
            }
            if (this.inversed.length() == 0) {
                this.inversed = null;
            }
            this.id = in.readInt();
            this.pushback = in.readInt();
            this.ignored = in.readBoolean();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream oi) throws IOException, ClassNotFoundException {
        oi.defaultReadObject();
        Tracer.This.println("AcceptorNode::readObject");
        IntTable tab = new IntTable(1000);
        lf1 = 0;
        lf2 = 0;
        lf3 = 0;
        this.loadFrom(oi, tab);
        Tracer.This.println(lf1 + " " + lf2 + " " + lf3);
    }

    private void writeObject(ObjectOutputStream oo) throws IOException {
        Tracer.This.println("AcceptorNode::writeObject");
        oo.defaultWriteObject();
        IntTable tab = new IntTable(1000);
        lf1 = 0;
        lf2 = 0;
        lf3 = 0;
        this.storeTo(oo, tab);
        Tracer.This.println(lf1 + " " + lf2 + " " + lf3);
    }

    void addSymbolicTransition(int c, Integer id) {
        this.transitions.put(c, id);
    }

    void resolveSymbolicTransitionIn(Hashtable allNodes) {
        int[] keys = this.transitions.keys();
        int n = 0;
        while (n < keys.length) {
            this.trans[keys[n]] = (AcceptorNode)allNodes.get(this.transitions.fastGet(keys[n]));
            this.transitions.put(keys[n], allNodes.get(this.transitions.fastGet(keys[n])));
            ++n;
        }
    }

    void replaceNodeIdFrom(Hashtable string2Id) {
        this.id = this.symbolName == null ? -1 : (Integer)string2Id.get(this.symbolName);
    }

    public void print() {
        Tracer.This.println("Node " + this.id + " accepts:" + this.symbolName);
        int[] en = this.transitions.keys();
        int n = 0;
        while (n < en.length) {
            Tracer.This.println("    '" + (char)en[n] + "' => " + this.transitions.fastGet(en[n]));
            ++n;
        }
    }
}

