/*
 * Decompiled with CFR 0.152.
 */
package Jack.gui;

import Jack.ISymbolTranslator;
import Jack.InputObject;
import Jack.gui.DebugTreeViewGUI;
import Jack.gui.ParserListItem;
import de.netcomputing.anyj.jwidgets.BasicListItem;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.anyj.jwidgets.beans.NCTreeBean;
import de.netcomputing.anyj.parsing.Scope;
import de.netcomputing.runtime.ApplicationHelper;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DebugTreeView
extends JPanel {
    JTextField findTxt;
    JLabel label;
    NCTreeBean scopeList;
    JEditorPane area;
    NCTreeBean list;
    HashMap scopeMap;
    ISymbolTranslator symbolKnower;

    public DebugTreeView() {
        this.initGui();
    }

    public void initGui() {
        new DebugTreeViewGUI().createGui(this);
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void init(Vector v, ISymbolTranslator symbolKnower, HashMap scMap) {
        this.scopeMap = scMap;
        this.list.addTarget(this, "actionClick");
        this.symbolKnower = symbolKnower;
        int n = 0;
        while (n < v.size()) {
            this.list.addItemRepainting(new ParserListItem((InputObject)v.elementAt(n), symbolKnower));
            ++n;
        }
    }

    public void init(InputObject root, ISymbolTranslator symbolKnower, HashMap scMap) {
        this.scopeMap = scMap;
        this.list.addTarget(this, "actionClick");
        this.symbolKnower = symbolKnower;
        this.list.addItemRepainting(new ParserListItem(root, symbolKnower));
    }

    public Object actionClick(Object a, Object s) {
        BasicListItem li = (BasicListItem)this.list.getSelectedItem();
        InputObject is = (InputObject)li.wrappedObject();
        this.area.setText(is.toString(" "));
        this.fillScopeMap(is);
        return null;
    }

    public void findTxt_keyPressed(KeyEvent var0) {
        if (var0.getKeyCode() == 10) {
            String idS = this.findTxt.getText().trim();
            int id = this.symbolKnower.idFor(idS);
            this.label.setText("FOUND ID:" + id);
            if (id > 0) {
                Vector v = this.list.getList();
                int n = this.list.getSelectionIndex() + 1;
                while (n < v.size() && ((InputObject)((ListItem)v.get(n)).wrappedObject()).getIntVal() != id) {
                    this.list.expandNodeAt(n);
                    ++n;
                }
                if (n < v.size()) {
                    this.list.setSelectionIndex(n);
                }
            }
        }
    }

    void fillScopeMap(InputObject is) {
        Scope scope = (Scope)this.scopeMap.get(is);
        if (scope == null) {
            this.scopeList.clear();
            this.label.setText("");
        } else {
            this.label.setText("CLASS:" + scope.getClazz() + "    definition pack:" + scope.getPack());
            Vector<Scope> v = new Vector<Scope>();
            Scope cs = scope;
            do {
                v.add(0, cs);
            } while ((cs = cs.supScope) != null);
            int n = 0;
            while (n < v.size()) {
                String key;
                Scope sp = (Scope)v.elementAt(n);
                Enumeration en = sp.scopTab.keys();
                while (en.hasMoreElements()) {
                    key = (String)en.nextElement();
                    this.scopeList.addLine(key + " - " + sp.scopTab.get(key));
                }
                this.scopeList.addLine("--");
                en = sp.methodTab.keys();
                while (en.hasMoreElements()) {
                    key = (String)en.nextElement();
                    this.scopeList.addLine(key + "(..) - " + sp.methodTab.get(key));
                }
                this.scopeList.addLine("---------------------------");
                ++n;
            }
        }
    }

    public static void Open(Vector v, ISymbolTranslator symbolKnower, HashMap scopMap) {
        JFrame f = new JFrame();
        DebugTreeView tv = new DebugTreeView();
        f.getContentPane().add(tv);
        tv.init(v, symbolKnower, scopMap);
        f.setBounds(10, 10, 500, 700);
        f.show();
    }
}

