/*
 * Decompiled with CFR 0.152.
 */
package Jxe;

import Jxe.AbstractDiffer;
import Jxe.AttributedTextLine;
import Jxe.TextDocument;

public class DocDiffer
extends AbstractDiffer {
    TextDocument remDoc;
    TextDocument addDoc;
    TextDocument result;
    boolean ignoreWS = true;

    public DocDiffer() {
        this.maxDiffDepth = 6;
        this.continWeight = 0;
        this.result = new TextDocument();
        this.result.init(null);
    }

    public TextDocument getResult() {
        return this.result;
    }

    public int[] rangeDiff() {
        int[] map = super.rangeDiff();
        int currAdd = 0;
        int currRem = 0;
        while (currAdd < this.addDoc.size() && currRem < this.remDoc.size()) {
            AttributedTextLine al = this.addDoc.lineAt(currAdd);
            AttributedTextLine rl = this.remDoc.lineAt(currRem);
            if (rl.marker == '\u0000') {
                this.result.addLineWithoutUndo(al);
                ++currAdd;
                ++currRem;
                continue;
            }
            if (map[currAdd] < 0 || map[currAdd] >= 0 && map[currAdd] < currRem) {
                this.result.addLineWithoutUndo(al);
                ++currAdd;
                continue;
            }
            if (rl.marker == '\u0001') {
                this.result.addLineWithoutUndo(rl);
                ++currRem;
                continue;
            }
            System.out.println("SHIT not happen !!" + rl.marker + " " + al.marker);
        }
        while (currAdd < this.addDoc.size() || currRem < this.remDoc.size()) {
            if (currAdd < this.addDoc.size()) {
                this.result.addLineWithoutUndo(this.addDoc.lineAt(currAdd++));
            }
            if (currRem >= this.remDoc.size()) continue;
            this.result.addLineWithoutUndo(this.remDoc.lineAt(currRem++));
        }
        return map;
    }

    public void init(TextDocument ad, TextDocument rem) {
        this.remDoc = rem;
        this.addDoc = ad;
    }

    protected boolean isAddUnique(int idx, int addStart, int addEnd, int remStart, int remEnd) {
        int cnt = 0;
        int addLen = addEnd;
        int i = addStart;
        while (i < addLen) {
            if (this.addDoc.lineAt(i).isEqual(this.addDoc.lineAt(idx), this.ignoreWS)) {
                ++cnt;
            }
            if (cnt > 1) {
                return false;
            }
            ++i;
        }
        int remLen = remEnd;
        int i2 = remStart;
        while (i2 < remLen) {
            if (this.remDoc.lineAt(i2).isEqual(this.addDoc.lineAt(idx), this.ignoreWS)) {
                ++cnt;
            }
            if (cnt > 2) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    protected int findRemIdx(int addIdx, int remStart, int remEnd) {
        int remLen = remEnd;
        int i = remStart;
        while (i < remLen) {
            if (this.remDoc.lineAt(i).isEqual(this.addDoc.lineAt(addIdx), this.ignoreWS)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int getAddLen() {
        return this.addDoc.size();
    }

    protected int getRemLen() {
        return this.remDoc.size();
    }

    protected boolean isWhiteSpaceAdd(int index) {
        return false;
    }

    protected boolean isWhiteSpaceRem(int index) {
        return false;
    }

    protected boolean isEqual(int addIdx, int remIdx) {
        return this.addDoc.lineAt(addIdx).isEqual(this.remDoc.lineAt(remIdx), this.ignoreWS);
    }

    protected void setRemChange(int start, int end) {
        int i = start;
        while (i < end) {
            this.remDoc.lineAt(i).mark('\u0001');
            ++i;
        }
    }

    protected void setAddChange(int start, int end) {
        int i = start;
        while (i < end) {
            this.addDoc.lineAt(i).mark('\u0002');
            ++i;
        }
    }

    protected void setEqualChange(int add, int rem) {
        this.addPosMap[add] = rem;
        this.addDoc.lineAt(add).mark('\u0000');
        this.remDoc.lineAt(rem).mark('\u0000');
    }

    public static void main(String[] args) {
    }
}

