/*
 * Decompiled with CFR 0.152.
 */
package Jxe;

import de.netcomputing.util.Tracer;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import netcomputing.tools.Platforms;

public class KeyboardEvent
implements Serializable {
    public static boolean KEYDEBUG = false;
    public boolean shift;
    public boolean control;
    public boolean meta;
    public boolean alt;
    public int key;
    public char keyChar;
    public static String special = "{}[]@\\~&|\"'";
    transient String ts;
    static final long serialVersionUID = 7162625831330845069L;

    public KeyboardEvent(boolean _shift, boolean _control, boolean _alt, boolean _meta, int _key) {
        this.shift = _shift;
        this.control = _control;
        this.meta = Platforms.IsSolaris() ? false : _meta;
        this.alt = _alt;
        this.key = _key;
    }

    public KeyboardEvent(KeyEvent e) {
        this.shift = e.isShiftDown();
        this.control = e.isControlDown();
        this.meta = e.isMetaDown();
        if (Platforms.IsSolaris()) {
            this.meta = false;
        }
        this.alt = e.isAltDown();
        this.key = e.getKeyCode();
        this.keyChar = e.getKeyChar();
        if (KEYDEBUG) {
            Tracer.This.println("KeyEvent keyChar:" + this.keyChar + " keyCode:" + this.key + " ==>" + this.toString() + " modifiers" + e.getModifiers());
        }
    }

    public boolean equals(Object ke) {
        KeyboardEvent k = (KeyboardEvent)ke;
        return k != null && k.key == this.key && k.control == this.control && (k.meta || k.alt) == (this.meta || this.alt) && k.shift == this.shift;
    }

    public String toString() {
        if (this.ts == null) {
            StringBuffer s = new StringBuffer(30);
            if (this.shift) {
                s.append("Shift ");
            }
            if (this.control) {
                s.append("Ctrl ");
            }
            if (this.alt) {
                s.append("Alt ");
            }
            if (this.meta) {
                s.append("Meta ");
            }
            s.append(KeyboardEvent.getKeyText(this.key));
            this.ts = s.toString();
        }
        return this.ts;
    }

    public int hashCode() {
        return this.key * (this.control ? 2 : 1) * (this.shift ? 3 : 1) * (this.meta ? 5 : 1) * (this.alt ? 7 : 1);
    }

    public static String getKeyText(int keyCode) {
        if (keyCode >= 48 && keyCode <= 57 || keyCode >= 65 && keyCode <= 90) {
            return String.valueOf((char)keyCode);
        }
        int index = ",./;=[\\]".indexOf(keyCode);
        if (index >= 0) {
            return String.valueOf((char)keyCode);
        }
        switch (keyCode) {
            case 10: {
                return Toolkit.getProperty("TRYST.enter", "Enter");
            }
            case 8: {
                return Toolkit.getProperty("TRYST.backSpace", "Backspace");
            }
            case 9: {
                return Toolkit.getProperty("TRYST.tab", "Tab");
            }
            case 3: {
                return Toolkit.getProperty("TRYST.cancel", "Cancel");
            }
            case 12: {
                return Toolkit.getProperty("TRYST.clear", "Clear");
            }
            case 16: {
                return Toolkit.getProperty("TRYST.shift", "Shift");
            }
            case 17: {
                return Toolkit.getProperty("TRYST.control", "Control");
            }
            case 18: {
                return Toolkit.getProperty("TRYST.alt", "Alt");
            }
            case 19: {
                return Toolkit.getProperty("TRYST.pause", "Pause");
            }
            case 20: {
                return Toolkit.getProperty("TRYST.capsLock", "Caps Lock");
            }
            case 27: {
                return Toolkit.getProperty("TRYST.escape", "Escape");
            }
            case 32: {
                return Toolkit.getProperty("TRYST.space", "Space");
            }
            case 33: {
                return Toolkit.getProperty("TRYST.pgup", "Page Up");
            }
            case 34: {
                return Toolkit.getProperty("TRYST.pgdn", "Page Down");
            }
            case 35: {
                return Toolkit.getProperty("TRYST.end", "End");
            }
            case 36: {
                return Toolkit.getProperty("TRYST.home", "Home");
            }
            case 37: {
                return Toolkit.getProperty("TRYST.left", "Left");
            }
            case 38: {
                return Toolkit.getProperty("TRYST.up", "Up");
            }
            case 39: {
                return Toolkit.getProperty("TRYST.right", "Right");
            }
            case 40: {
                return Toolkit.getProperty("TRYST.down", "Down");
            }
            case 106: {
                return Toolkit.getProperty("TRYST.multiply", "NumPad *");
            }
            case 107: {
                return Toolkit.getProperty("TRYST.add", "NumPad +");
            }
            case 108: {
                return Toolkit.getProperty("TRYST.separator", "NumPad ,");
            }
            case 109: {
                return Toolkit.getProperty("TRYST.subtract", "NumPad -");
            }
            case 110: {
                return Toolkit.getProperty("TRYST.decimal", "NumPad .");
            }
            case 111: {
                return Toolkit.getProperty("TRYST.divide", "NumPad /");
            }
            case 127: {
                return Toolkit.getProperty("TRYST.delete", "Delete");
            }
            case 144: {
                return Toolkit.getProperty("TRYST.numLock", "Num Lock");
            }
            case 145: {
                return Toolkit.getProperty("TRYST.scrollLock", "Scroll Lock");
            }
            case 112: {
                return Toolkit.getProperty("TRYST.f1", "F1");
            }
            case 113: {
                return Toolkit.getProperty("TRYST.f2", "F2");
            }
            case 114: {
                return Toolkit.getProperty("TRYST.f3", "F3");
            }
            case 115: {
                return Toolkit.getProperty("TRYST.f4", "F4");
            }
            case 116: {
                return Toolkit.getProperty("TRYST.f5", "F5");
            }
            case 117: {
                return Toolkit.getProperty("TRYST.f6", "F6");
            }
            case 118: {
                return Toolkit.getProperty("TRYST.f7", "F7");
            }
            case 119: {
                return Toolkit.getProperty("TRYST.f8", "F8");
            }
            case 120: {
                return Toolkit.getProperty("TRYST.f9", "F9");
            }
            case 121: {
                return Toolkit.getProperty("TRYST.f10", "F10");
            }
            case 122: {
                return Toolkit.getProperty("TRYST.f11", "F11");
            }
            case 123: {
                return Toolkit.getProperty("TRYST.f12", "F12");
            }
            case 61440: {
                return Toolkit.getProperty("TRYST.f13", "F13");
            }
            case 61441: {
                return Toolkit.getProperty("TRYST.f14", "F14");
            }
            case 61442: {
                return Toolkit.getProperty("TRYST.f15", "F15");
            }
            case 61443: {
                return Toolkit.getProperty("TRYST.f16", "F16");
            }
            case 61444: {
                return Toolkit.getProperty("TRYST.f17", "F17");
            }
            case 61445: {
                return Toolkit.getProperty("TRYST.f18", "F18");
            }
            case 61446: {
                return Toolkit.getProperty("TRYST.f19", "F19");
            }
            case 61447: {
                return Toolkit.getProperty("TRYST.f20", "F20");
            }
            case 61448: {
                return Toolkit.getProperty("TRYST.f21", "F21");
            }
            case 61449: {
                return Toolkit.getProperty("TRYST.f22", "F22");
            }
            case 61450: {
                return Toolkit.getProperty("TRYST.f23", "F23");
            }
            case 61451: {
                return Toolkit.getProperty("TRYST.f24", "F24");
            }
            case 154: {
                return Toolkit.getProperty("TRYST.printScreen", "Print Screen");
            }
            case 155: {
                return Toolkit.getProperty("TRYST.insert", "Insert");
            }
            case 156: {
                return Toolkit.getProperty("TRYST.help", "Help");
            }
            case 157: {
                return Toolkit.getProperty("TRYST.meta", "Meta");
            }
            case 192: {
                return Toolkit.getProperty("TRYST.backQuote", "Back Quote");
            }
            case 222: {
                return Toolkit.getProperty("TRYST.quote", "Quote");
            }
            case 224: {
                return Toolkit.getProperty("TRYST.up", "Up");
            }
            case 225: {
                return Toolkit.getProperty("TRYST.down", "Down");
            }
            case 226: {
                return Toolkit.getProperty("TRYST.left", "Left");
            }
            case 227: {
                return Toolkit.getProperty("TRYST.right", "Right");
            }
            case 128: {
                return Toolkit.getProperty("TRYST.deadGrave", "Dead Grave");
            }
            case 129: {
                return Toolkit.getProperty("TRYST.deadAcute", "Dead Acute");
            }
            case 130: {
                return Toolkit.getProperty("TRYST.deadCircumflex", "Dead Circumflex");
            }
            case 131: {
                return Toolkit.getProperty("TRYST.deadTilde", "Dead Tilde");
            }
            case 132: {
                return Toolkit.getProperty("TRYST.deadMacron", "Dead Macron");
            }
            case 133: {
                return Toolkit.getProperty("TRYST.deadBreve", "Dead Breve");
            }
            case 134: {
                return Toolkit.getProperty("TRYST.deadAboveDot", "Dead Above Dot");
            }
            case 135: {
                return Toolkit.getProperty("TRYST.deadDiaeresis", "Dead Diaeresis");
            }
            case 136: {
                return Toolkit.getProperty("TRYST.deadAboveRing", "Dead Above Ring");
            }
            case 137: {
                return Toolkit.getProperty("TRYST.deadDoubleAcute", "Dead Double Acute");
            }
            case 138: {
                return Toolkit.getProperty("TRYST.deadCaron", "Dead Caron");
            }
            case 139: {
                return Toolkit.getProperty("TRYST.deadCedilla", "Dead Cedilla");
            }
            case 140: {
                return Toolkit.getProperty("TRYST.deadOgonek", "Dead Ogonek");
            }
            case 141: {
                return Toolkit.getProperty("TRYST.deadIota", "Dead Iota");
            }
            case 142: {
                return Toolkit.getProperty("TRYST.deadVoicedSound", "Dead Voiced Sound");
            }
            case 143: {
                return Toolkit.getProperty("TRYST.deadSemivoicedSound", "Dead Semivoiced Sound");
            }
            case 150: {
                return Toolkit.getProperty("TRYST.ampersand", "Ampersand");
            }
            case 151: {
                return Toolkit.getProperty("TRYST.asterisk", "Asterisk");
            }
            case 152: {
                return Toolkit.getProperty("TRYST.quoteDbl", "Double Quote");
            }
            case 153: {
                return Toolkit.getProperty("TRYST.Less", "Less");
            }
            case 160: {
                return Toolkit.getProperty("TRYST.greater", "Greater");
            }
            case 161: {
                return Toolkit.getProperty("TRYST.braceLeft", "Left Brace");
            }
            case 162: {
                return Toolkit.getProperty("TRYST.braceRight", "Right Brace");
            }
            case 512: {
                return Toolkit.getProperty("TRYST.at", "At");
            }
            case 513: {
                return Toolkit.getProperty("TRYST.colon", "Colon");
            }
            case 514: {
                return Toolkit.getProperty("TRYST.circumflex", "Circumflex");
            }
            case 515: {
                return Toolkit.getProperty("TRYST.dollar", "Dollar");
            }
            case 516: {
                return Toolkit.getProperty("TRYST.euro", "Euro");
            }
            case 517: {
                return Toolkit.getProperty("TRYST.exclamationMark", "Exclamation Mark");
            }
            case 518: {
                return Toolkit.getProperty("TRYST.invertedExclamationMark", "Inverted Exclamation Mark");
            }
            case 519: {
                return Toolkit.getProperty("TRYST.leftParenthesis", "Left Parenthesis");
            }
            case 520: {
                return Toolkit.getProperty("TRYST.numberSign", "Number Sign");
            }
            case 45: {
                return Toolkit.getProperty("TRYST.minus", "Minus");
            }
            case 521: {
                return Toolkit.getProperty("TRYST.plus", "Plus");
            }
            case 522: {
                return Toolkit.getProperty("TRYST.rightParenthesis", "Right Parenthesis");
            }
            case 523: {
                return Toolkit.getProperty("TRYST.underscore", "Underscore");
            }
            case 24: {
                return Toolkit.getProperty("TRYST.final", "Final");
            }
            case 28: {
                return Toolkit.getProperty("TRYST.convert", "Convert");
            }
            case 29: {
                return Toolkit.getProperty("TRYST.noconvert", "No Convert");
            }
            case 30: {
                return Toolkit.getProperty("TRYST.accept", "Accept");
            }
            case 31: {
                return Toolkit.getProperty("TRYST.modechange", "Mode Change");
            }
            case 21: {
                return Toolkit.getProperty("TRYST.kana", "Kana");
            }
            case 25: {
                return Toolkit.getProperty("TRYST.kanji", "Kanji");
            }
            case 240: {
                return Toolkit.getProperty("TRYST.alphanumeric", "Alphanumeric");
            }
            case 241: {
                return Toolkit.getProperty("TRYST.katakana", "Katakana");
            }
            case 242: {
                return Toolkit.getProperty("TRYST.hiragana", "Hiragana");
            }
            case 243: {
                return Toolkit.getProperty("TRYST.fullWidth", "Full-Width");
            }
            case 244: {
                return Toolkit.getProperty("TRYST.halfWidth", "Half-Width");
            }
            case 245: {
                return Toolkit.getProperty("TRYST.romanCharacters", "Roman Characters");
            }
            case 256: {
                return Toolkit.getProperty("TRYST.allCandidates", "All Candidates");
            }
            case 257: {
                return Toolkit.getProperty("TRYST.previousCandidate", "Previous Candidate");
            }
            case 258: {
                return Toolkit.getProperty("TRYST.codeInput", "Code Input");
            }
            case 259: {
                return Toolkit.getProperty("TRYST.japaneseKatakana", "Japanese Katakana");
            }
            case 260: {
                return Toolkit.getProperty("TRYST.japaneseHiragana", "Japanese Hiragana");
            }
            case 261: {
                return Toolkit.getProperty("TRYST.japaneseRoman", "Japanese Roman");
            }
            case 262: {
                return Toolkit.getProperty("TRYST.kanaLock", "Kana Lock");
            }
            case 263: {
                return Toolkit.getProperty("TRYST.inputMethodOnOff", "Input Method On/Off");
            }
            case 65481: {
                return Toolkit.getProperty("TRYST.again", "Again");
            }
            case 65483: {
                return Toolkit.getProperty("TRYST.undo", "Undo");
            }
            case 65485: {
                return Toolkit.getProperty("TRYST.copy", "Copy");
            }
            case 65487: {
                return Toolkit.getProperty("TRYST.paste", "Paste");
            }
            case 65489: {
                return Toolkit.getProperty("TRYST.cut", "Cut");
            }
            case 65488: {
                return Toolkit.getProperty("TRYST.find", "Find");
            }
            case 65482: {
                return Toolkit.getProperty("TRYST.props", "Props");
            }
            case 65480: {
                return Toolkit.getProperty("TRYST.stop", "Stop");
            }
            case 65312: {
                return Toolkit.getProperty("TRYST.compose", "Compose");
            }
            case 65406: {
                return Toolkit.getProperty("TRYST.altGraph", "Alt Graph");
            }
        }
        if (keyCode >= 96 && keyCode <= 105) {
            String numpad = Toolkit.getProperty("TRYST.numpad", "NumPad");
            char c = (char)(keyCode - 96 + 48);
            return numpad + "-" + c;
        }
        String unknown = Toolkit.getProperty("TRYST.unknown", "Unknown keyCode");
        return unknown + ": 0x" + Integer.toString(keyCode, 16);
    }

    public static String getKeyModifiersText(int modifiers) {
        StringBuffer buf = new StringBuffer();
        if ((modifiers & 4) != 0) {
            buf.append(Toolkit.getProperty("TRYST.meta", "Meta"));
            buf.append("+");
        }
        if ((modifiers & 2) != 0) {
            buf.append(Toolkit.getProperty("TRYST.control", "Ctrl"));
            buf.append("+");
        }
        if ((modifiers & 8) != 0) {
            buf.append(Toolkit.getProperty("TRYST.alt", "Alt"));
            buf.append("+");
        }
        if ((modifiers & 1) != 0) {
            buf.append(Toolkit.getProperty("TRYST.shift", "Shift"));
            buf.append("+");
        }
        if ((modifiers & 0x20) != 0) {
            buf.append(Toolkit.getProperty("TRYST.altGraph", "Alt Graph"));
            buf.append("+");
        }
        if ((modifiers & 0x10) != 0) {
            buf.append(Toolkit.getProperty("TRYST.button1", "Button1"));
            buf.append("+");
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }
}

