/*
 * Decompiled with CFR 0.152.
 */
package Jxe;

import JCollections.ISortFunc;
import JCollections.JArray;
import JCollections.JSet;
import JCollections.JUnsafeArray;
import JCollections.JUnsafeTable;
import JCollections.JUnsafeVector;
import Jxe.AttributedTextLine;
import Jxe.CharAttr;
import Jxe.CollapsedTextLine;
import Jxe.DocumentStream;
import Jxe.GeneralDiff;
import Jxe.IHighlighter;
import Jxe.JXEOptions;
import Jxe.LineDiffer;
import Jxe.NoHighlighter;
import Jxe.PositionTracker;
import Jxe.TextView;
import Jxe.highlighters.JavaHighlighter;
import JxeExtensions.ExtBeautifyCode;
import de.netcomputing.anyj.AJEditOptions;
import de.netcomputing.anyj.jwidgets.Binder;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.IActor;
import de.netcomputing.anyj.jwidgets.JWMenuBar;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.cvswrap.commands.DiffEntry;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JComponent;
import jxeplugins.ICompletionProvider;
import netcomputing.tools.Executor;
import netcomputing.tools.INCPrintOut;
import netcomputing.tools.Platforms;

public class TextDocument
implements IActor,
ClipboardOwner,
TextView,
Cloneable {
    public static ArrayList clipBoardRing = new ArrayList();
    public static int MAXCLIPRINGSIZE = 10;
    JUnsafeVector lines;
    TextView tv;
    public CharAttr[] styles;
    int maxWidth;
    static TextDocument clipboard = null;
    static byte TABCODE = (byte)32;
    int selStartLine = -1;
    int selEndLine = -1;
    int selStartX = 0;
    int selEndX = 0;
    int selectingStartX = -1;
    int selectingStartY = -1;
    int cX = 0;
    int cY = 0;
    boolean cursorHidden;
    boolean modified = false;
    boolean isSelecting = false;
    boolean lostClip = true;
    boolean readOnly;
    IHighlighter hil;
    File lastFile;
    long lastAccessTime = 0L;
    String hiLightWord;
    boolean hilightWordMathCase = false;
    boolean hilightWordWholeWord = false;
    boolean drawKringel = false;
    int kringelStartX = 8;
    int kringelEndX = 12;
    int kringelStartY = -1;
    int kringelEndY = -1;
    boolean holdKringels = false;
    Stack redo;
    Stack undo;
    PositionTracker tracker;
    public Object completionEngineContext;
    String kringelText;
    Binder binder = new Binder(this);
    ICompletionProvider completionProvider;
    int lastBraceHighlightLine = -1;
    int threadCount = 0;
    byte[] linefeed = new byte[]{13, 10};
    boolean accessorModified = false;

    public static void AddToClipBoardRing(String selection) {
        clipBoardRing.add(0, selection);
        if (clipBoardRing.size() > MAXCLIPRINGSIZE) {
            clipBoardRing.remove(clipBoardRing.size() - 1);
        }
    }

    public static TextDocument CloneTextDocument(TextDocument org) {
        try {
            return (TextDocument)org.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public TextDocument() {
    }

    public void setKringelText(String text) {
        this.kringelText = text == null ? null : NCStringUtilities.WordWrap("<html>" + text + "</html>", 40, "<br>");
    }

    public String getKringelText() {
        return this.kringelText;
    }

    public void setHoldKringels(boolean holdKringels) {
        this.holdKringels = holdKringels;
    }

    public boolean getHoldKringels() {
        return this.holdKringels;
    }

    public void setKringelRange(int kringelStartX, int kringelStartY, int kringelEndX, int kringelEndY) {
        this.kringelStartX = kringelStartX;
        this.kringelStartY = kringelStartY;
        this.kringelEndX = kringelEndX;
        this.kringelEndY = kringelEndY;
    }

    public void setDrawKringel(boolean drawKringel) {
        if (this.drawKringel && !drawKringel && this.kringelStartY > 0) {
            this.drawKringel = drawKringel;
            this.repaintLines(this.kringelStartY, this.kringelEndY + 1);
            this.kringelStartY = -1;
        }
        this.drawKringel = drawKringel;
    }

    public boolean getDrawKringel() {
        return this.drawKringel;
    }

    public int getKringelEndX() {
        return this.kringelEndX;
    }

    public int getKringelEndY() {
        return this.kringelEndY;
    }

    public int getKringelStartX() {
        return this.kringelStartX;
    }

    public int getKringelStartY() {
        return this.kringelStartY;
    }

    public int[] getSelectionPosition() {
        return new int[]{this.selStartX(), this.selStartY(), this.selEndX(), this.selEndY()};
    }

    public void applyDiffEntries(Vector v) {
        int off = 0;
        int n = 0;
        while (n < v.size()) {
            DiffEntry di = (DiffEntry)v.elementAt(n);
            Vector diffLines = di.getLines();
            int diOff = di.getLineNoAt(2) + off - 1;
            int nn = 0;
            while (nn < diffLines.size()) {
                String li = (String)diffLines.elementAt(nn);
                if (li.startsWith(">")) {
                    this.setLineStyle(10, nn + diOff, true);
                    this.mark(nn + diOff, '\u0002');
                } else {
                    int rOff = 0;
                    if ("d".equals(di.getType().toLowerCase())) {
                        ++rOff;
                    }
                    this.insertLine(nn + diOff + rOff, new AttributedTextLine(li.substring(2)));
                    this.setLineStyle(10, nn + diOff + rOff, true);
                    this.mark(nn + diOff + rOff, '\u0001');
                    ++off;
                }
                ++nn;
            }
            ++n;
        }
    }

    public int getScreenIndent(int line) {
        int ind = this.getFirstCharX(line);
        ind = this.lineAt(line).translateX(ind);
        return ind;
    }

    public void trimSelection() {
        if (!this.hasSelection()) {
            return;
        }
        DocumentStream st = new DocumentStream(this, this.selStartX(), this.selStartY());
        while (Character.isWhitespace((char)st.read())) {
        }
        st.readBackward();
        this.selStartX = st.posX();
        this.selStartLine = st.posY();
        st = new DocumentStream(this, this.selEndX(), this.selEndY());
        while (Character.isWhitespace((char)st.readBackward())) {
        }
        st.read();
        this.selEndX = st.posX();
        this.selEndLine = st.posY();
    }

    public static Vector ParseDiff(Vector lines) throws Exception {
        String line = null;
        DiffEntry act = null;
        Vector<DiffEntry> diffEntries = new Vector<DiffEntry>();
        int i = 0;
        while (i < lines.size()) {
            line = (String)lines.get(i);
            if (line.startsWith(">") || line.startsWith("<") || line.startsWith("-")) {
                if (!line.startsWith("-")) {
                    act.getLines().addElement(line);
                }
            } else {
                act = new DiffEntry();
                try {
                    TextDocument.ParseDiffHead(line, act);
                    diffEntries.addElement(act);
                }
                catch (NumberFormatException ex) {
                    Tracer.This.println("NumberFormatException:" + line);
                }
            }
            ++i;
        }
        return diffEntries;
    }

    public static void ParseDiffHead(String line, DiffEntry toInsertIn) {
        line = line.trim();
        String type = "a";
        int i = line.indexOf("a");
        if (i <= 0) {
            i = line.indexOf("d");
            type = "d";
        }
        if (i <= 0) {
            i = line.indexOf("c");
            type = "c";
        }
        if (i <= 0) {
            throw new RuntimeException("unknown difftype:" + line);
        }
        String pre = line.substring(0, i);
        String past = line.substring(i + 1, line.length());
        toInsertIn.setType(type);
        if (pre.indexOf(",") >= 0) {
            toInsertIn.setLineNoAt(0, Integer.parseInt(pre.substring(0, pre.indexOf(","))));
            toInsertIn.setLineNoAt(1, Integer.parseInt(pre.substring(pre.indexOf(",") + 1)));
        } else {
            toInsertIn.setLineNoAt(0, Integer.parseInt(pre));
        }
        if (past.indexOf(",") >= 0) {
            toInsertIn.setLineNoAt(2, Integer.parseInt(past.substring(0, past.indexOf(","))));
            toInsertIn.setLineNoAt(3, Integer.parseInt(past.substring(past.indexOf(",") + 1)));
        } else {
            toInsertIn.setLineNoAt(2, Integer.parseInt(past));
        }
    }

    public static Vector DiffExternal(File fa, File fb) throws Exception {
        return TextDocument.DiffExternal(fa, fb, "-w -b -B --minimal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector DiffExternal(File fa, File fb, String opt) throws Exception {
        final Object lock = new Object();
        final Vector diff = new Vector();
        Executor.Exec("diff " + opt + " " + fb.getAbsolutePath() + " " + fa.getAbsolutePath(), ".", new INCPrintOut(){

            public void printLine(String s) {
                Tracer.This.println(s);
                diff.add(s);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processTerminated(int exitValue) {
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
            }
        });
        Object object = lock;
        synchronized (object) {
            lock.wait();
        }
        return TextDocument.ParseDiff(diff);
    }

    public void mergeDiffs(TextDocument docB, int[][] diff) {
        int actInsert = 0;
        int off = 1;
        boolean lastWasDiff = false;
        int n = 0;
        while (n < docB.size()) {
            if (docB.lineAt(n).getMark() != '\u0001') {
                lastWasDiff = false;
            } else if (docB.lineAt(n).getMark() == '\u0001') {
                int cy = n;
                int max = 0;
                int maxA = 0;
                if (!lastWasDiff) {
                    int nn = 0;
                    while (nn < diff.length) {
                        if (diff[nn][1] <= cy && max < diff[nn][1]) {
                            max = diff[nn][1];
                            maxA = diff[nn][0];
                        }
                        ++nn;
                    }
                    actInsert = maxA;
                    lastWasDiff = true;
                }
                int toIns = Math.min(actInsert + off, this.size() - 1);
                this.insertLine(toIns, docB.lineAt(n));
                ++off;
            }
            ++n;
        }
    }

    public void hilightDiffs(TextDocument docB, int[][] diff) {
        TextDocument.staticHilightDiffs(this, docB, diff);
    }

    private static void staticHilightDiffs(TextDocument docA, TextDocument docB, int[][] diff) {
        int n = 0;
        while (n < docA.size()) {
            docA.setLineStyle(10, n, false);
            docA.mark(n, '\u0002');
            ++n;
        }
        int n2 = 0;
        while (n2 < docB.size()) {
            docB.setLineStyle(10, n2, false);
            docB.mark(n2, '\u0001');
            ++n2;
        }
        int n3 = 0;
        while (n3 < diff.length) {
            docA.setLineStyle(0, diff[n3][0], false);
            docA.mark(diff[n3][0], '\u0000');
            ++n3;
        }
        int n4 = 0;
        while (n4 < diff.length) {
            docB.setLineStyle(0, diff[n4][1], false);
            docB.mark(diff[n4][1], '\u0000');
            ++n4;
        }
    }

    public TextDocument(JUnsafeVector lines) {
        this.init(null);
        this.lines = lines;
    }

    public TextDocument(String[] lines) {
        JUnsafeVector lin = new JUnsafeVector(lines.length);
        int i = 0;
        while (i < lines.length) {
            lin.addElement(new AttributedTextLine(lines[i]));
            ++i;
        }
        this.init(null);
        this.lines = lin;
    }

    public TextDocument(File f) {
        this.init(null);
        this.load(f);
        this.setFile(f);
    }

    public void optimizeDiff() {
        int state = 0;
        int state0Idx = 0;
        int i = 0;
        while (i < this.lines.size()) {
            switch (state) {
                case 0: {
                    if (this.lineAt((int)i).marker == '\u0001') {
                        state = 1;
                        state0Idx = i;
                        break;
                    }
                    if (this.lineAt((int)i).marker == '\u0002') {
                        state = 2;
                        state0Idx = i;
                        break;
                    }
                    state0Idx = -1;
                    break;
                }
                case 1: {
                    if (this.lineAt((int)i).marker == '\u0002' && state0Idx >= 0 && this.lineAt((int)state0Idx).marker == '\u0001') {
                        this.mergeLines(state0Idx, i);
                        ++state0Idx;
                        break;
                    }
                    if (this.lineAt((int)i).marker == '\u0001') break;
                    state0Idx = -1;
                    state = 0;
                    break;
                }
                case 2: {
                    if (this.lineAt((int)i).marker == '\u0001' && state0Idx >= 0 && this.lineAt((int)state0Idx).marker == '\u0002') {
                        this.mergeLines(state0Idx, i);
                        ++state0Idx;
                        break;
                    }
                    if (this.lineAt((int)i).marker == '\u0002') break;
                    state0Idx = -1;
                    state = 0;
                    break;
                }
                default: {
                    state = 0;
                }
            }
            ++i;
        }
    }

    void mergeLines(int removed, int added) {
        AttributedTextLine remLine = this.lineAt(removed);
        AttributedTextLine addLine = this.lineAt(added);
        AttributedTextLine remLineCpy = remLine.createCopy();
        AttributedTextLine addLineCpy = addLine.createCopy();
        remLineCpy.marker = remLine.marker;
        addLineCpy.marker = addLine.marker;
        LineDiffer df = new LineDiffer();
        df.init(addLine, remLine);
        df.doDiff();
        if (df.getAddChanges() + df.getRemChanges() != 0 && df.getAddChanges() + df.getRemChanges() > df.getEquals()) {
            this.lines.setElementAt(addLineCpy, added);
            this.lines.setElementAt(remLineCpy, removed);
        }
    }

    public boolean isInRange(int x, int y, int rangeStartCol, int rangeStartLine, int rangeEndCol, int rangeEndLine) {
        if (y < rangeStartLine || y >= rangeEndLine) {
            return false;
        }
        if (y == rangeStartLine) {
            if (y == rangeEndLine - 1) {
                return x >= rangeStartCol && x <= rangeEndCol;
            }
            return x >= rangeStartCol;
        }
        if (y == rangeEndLine - 1) {
            return x <= rangeEndCol;
        }
        return true;
    }

    public void setHilightWordWholeWord(boolean hilightWordWholeWord) {
        this.hilightWordWholeWord = hilightWordWholeWord;
    }

    public boolean getHilightWordWholeWord() {
        return this.hilightWordWholeWord;
    }

    public void setHilightWordMatchCase(boolean hilightWordMathCase) {
        this.hilightWordMathCase = hilightWordMathCase;
    }

    public boolean getHilightWordMatchCase() {
        return this.hilightWordMathCase;
    }

    public void setHiLightWord(String hiLightWord) {
        this.hiLightWord = hiLightWord;
    }

    public String getHiLightWord() {
        return this.hiLightWord;
    }

    public void setSelectingStartY(int selectingStartY) {
        this.selectingStartY = selectingStartY;
    }

    public int getSelectingStartY() {
        return this.selectingStartY;
    }

    public void setSelectingPoint(int selectingStartX, int selectingStartY) {
        this.selectingStartX = selectingStartX;
        this.selectingStartY = selectingStartY;
    }

    public void setSelectingStartX(int selectingStartX) {
        this.selectingStartX = selectingStartX;
    }

    public int getSelectingStartX() {
        return this.selectingStartX;
    }

    public void load(File file2) {
        if (file2 != null && file2.exists()) {
            FileInputStream inp = null;
            try {
                inp = new FileInputStream(file2);
                DataInputStream dis = new DataInputStream(inp);
                this.readFromStream(dis);
                inp.close();
            }
            catch (Exception e) {
                e.printStackTrace(Tracer.This);
            }
            try {
                inp.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.clearMarkers();
        }
    }

    public void init(TextView _tv) {
        this.lines = new JUnsafeVector(3);
        this.setView(_tv);
        if (this.styles == null) {
            this.styles = JXEOptions.StyleTable != null ? JXEOptions.StyleTable : AttributedTextLine.createDefaultStyles(JXEOptions.Monospaced, JXEOptions.FontSize, Color.black, Color.white);
        }
        this.undo = new Stack();
        this.redo = new Stack();
        this.hil = new NoHighlighter();
    }

    public void highlightAll() {
        this.getHighlighter().highlightAll(this);
    }

    public void setView(TextView _tv) {
        this.tv = _tv;
        if (this.tv == null) {
            this.tv = this;
        }
    }

    public boolean hasTracker() {
        return this.tracker != null;
    }

    public void setTracker(PositionTracker tr) {
        this.tracker = tr;
        this.binder().notifyTargets("trackerChanged");
    }

    public PositionTracker getTracker() {
        return this.tracker;
    }

    public void reset() {
        this.reset(3);
    }

    public boolean isVirtualSpace() {
        return JXEOptions.VIRTUALSPACE;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void reset(int numLines) {
        this.completionEngineContext = null;
        this.lines = new JUnsafeVector(numLines);
        this.setModified(false);
        this.tracker = null;
        this.undo = new Stack();
        this.redo = new Stack();
        this.selEndLine = -1;
        this.selStartLine = -1;
        this.maxWidth = 0;
        this.tv.adjustPosition(0, 0);
        this.moveCursorAbs(0, 0);
    }

    public CharAttr[] styleTable() {
        return this.styles;
    }

    public Binder binder() {
        return this.binder;
    }

    public File getFile() {
        return this.lastFile;
    }

    public void guessHiLighter() {
        String fs = this.getFile().getAbsolutePath();
        this.guessHilighterFrom(fs);
    }

    public void guessHilighterFrom(String fs) {
        int i = fs.lastIndexOf(".");
        IHighlighter hi = null;
        if (i >= 0) {
            try {
                fs = fs.substring(i + 1).toLowerCase();
                fs = ("" + fs.charAt(0)).toUpperCase() + fs.substring(1) + "Highlighter";
                hi = (IHighlighter)Class.forName("Jxe.highlighters." + fs).newInstance();
            }
            catch (Throwable e) {
                Tracer.This.println("could not find Jxe.highlighters." + fs);
            }
        }
        if (hi == null) {
            hi = new NoHighlighter();
        }
        this.setHighlighter(hi);
    }

    public ICompletionProvider getCompletionProvider() {
        return this.completionProvider;
    }

    public void setCompletionProvider(ICompletionProvider comp) {
        this.completionProvider = comp;
    }

    public void setFile(File f) {
        this.lastFile = f;
        if (f != null && this.tv != this && this.tv != null) {
            this.lastAccessTime = f.lastModified();
            this.guessHiLighter();
        }
    }

    public void setHighlighter(IHighlighter h) {
        this.hil = h;
    }

    public IHighlighter getHighlighter() {
        return this.hil;
    }

    public void load() {
        Frame fr = new Frame();
        FileDialog f = new FileDialog(fr, "Load Text", 0);
        if (this.lastFile == null) {
            f.setDirectory(System.getProperty("user.dir") + System.getProperty("file.separator"));
        } else {
            f.setDirectory(this.lastFile.getPath().substring(0, this.lastFile.getPath().length() - this.lastFile.getName().length()));
            f.setFile(this.lastFile.getName());
        }
        f.show();
        String fileName = f.getFile();
        if (fileName != null) {
            if (fileName.endsWith("*.*")) {
                fileName = fileName.substring(0, fileName.length() - 4);
            }
            this.setFile(new File(f.getDirectory() + fileName));
            Object result = null;
            try {
                File inputFile = this.lastFile;
                FileInputStream inp = new FileInputStream(inputFile);
                DataInputStream dis = new DataInputStream(inp);
                this.clearMarkers();
                this.readFromStream(dis);
                dis.close();
                inp.close();
                this.lastAccessTime = inputFile.lastModified();
            }
            catch (FileNotFoundException e) {
                Tracer.This.println("LoadFile: " + e);
            }
            catch (Exception e) {
                Tracer.This.println("LoadFile: " + e);
            }
        }
        fr.dispose();
        if (!this.lastFile.canWrite()) {
            this.setReadOnly(true);
        }
    }

    public void coreLoad(File f) {
        this.setFile(f);
        try {
            File inputFile = this.lastFile;
            FileInputStream inp = new FileInputStream(inputFile);
            DataInputStream dis = new DataInputStream(inp);
            this.readFromStream(dis, true);
            dis.close();
            inp.close();
            this.lastAccessTime = f.lastModified();
        }
        catch (FileNotFoundException e) {
            Tracer.This.println("LoadFile: " + e);
        }
        catch (Exception e) {
            Tracer.This.println("LoadFile: " + e);
        }
        if (!f.canWrite()) {
            this.setReadOnly(true);
        }
    }

    public void save(File f) throws Exception {
        File oldLast = this.lastFile;
        this.setFile(f);
        this.forcedSave();
        this.setFile(oldLast);
    }

    public byte[] toByteArray() {
        int size = 0;
        int n = 0;
        while (n < this.size()) {
            size += this.lineAt(n).size();
            ++n;
        }
        byte[] result = new byte[size];
        int count = 0;
        int n2 = 0;
        while (n2 < this.size()) {
            System.arraycopy(result, count, this.lineAt((int)n2).text, 0, this.lineAt(n2).size());
            count += this.lineAt(n2).size();
            ++n2;
        }
        return result;
    }

    public void save() throws Exception {
        this.forcedSave();
    }

    public void forcedSave() throws Exception {
        if (this.lastFile == null) {
            this.saveAs();
        }
        Object result = null;
        File outputFile = this.lastFile;
        FileOutputStream inp = new FileOutputStream(outputFile);
        DataOutputStream dis = new DataOutputStream(new BufferedOutputStream(inp, 10000));
        this.writeToStream(dis);
        dis.close();
        inp.close();
        this.lastAccessTime = this.lastFile.lastModified();
        this.setModified(false);
    }

    public void coreSave(File f) throws Exception {
        FileOutputStream inp = new FileOutputStream(f);
        DataOutputStream dis = new DataOutputStream(new BufferedOutputStream(inp, 10000));
        this.coreWriteToStream(dis);
        dis.close();
        inp.close();
        this.lastAccessTime = f.lastModified();
        this.setModified(false);
    }

    public void saveAs() throws Exception {
        Frame fr = new Frame();
        FileDialog f = new FileDialog(fr, "Save Text", 1);
        if (this.lastFile == null) {
            f.setDirectory(System.getProperty("user.dir") + System.getProperty("file.separator"));
        } else {
            f.setDirectory(this.lastFile.getPath().substring(0, this.lastFile.getPath().length() - this.lastFile.getName().length()));
            f.setFile(this.lastFile.getName());
        }
        f.show();
        String fileName = f.getFile();
        if (fileName != null) {
            if (fileName.endsWith("*.*")) {
                fileName = fileName.substring(0, fileName.length() - 4);
            }
            this.setFile(new File(f.getDirectory() + fileName));
            this.setModified(true);
            this.save();
        }
        fr.dispose();
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        Tracer.This.println("-------lost Clipboard");
        this.lostClip = true;
    }

    public void repaintAll() {
        if (this.tv != null && this.tv != this) {
            this.tv.updateView(0, this.size(), 0, 1024);
        }
    }

    public void repaintLines(int start) {
        if (this.tv != null) {
            this.tv.updateView(start, start + 1, 0, 1024);
        }
    }

    public void repaintLines(int start, int end) {
        if (this.tv != null && this.tv != this) {
            this.tv.updateView(start, end, 0, 1024);
        }
    }

    public void clearMarkers() {
        int n = 0;
        while (n < this.size()) {
            this.lineAt(n).mark('\u0000');
            ++n;
        }
    }

    public int[] markedLines() {
        Vector<Integer> v = new Vector<Integer>(10);
        int n = 0;
        while (n < this.size()) {
            if (this.isMarked(n)) {
                v.addElement(new Integer(n));
            }
            ++n;
        }
        int[] result = new int[v.size()];
        int n2 = 0;
        while (n2 < v.size()) {
            result[n2] = (Integer)v.elementAt(n2);
            ++n2;
        }
        return result;
    }

    public boolean isMarked(int y) {
        return this.lineAt(y).getMark() != '\u0000';
    }

    public void mark(int line, char mark) {
        this.lineAt(line).mark(mark);
        this.tv.updateView(line, line + 1, 0, 1024);
    }

    public AttributedTextLine lineAt(int n) {
        return (AttributedTextLine)this.lines.elementAt(n);
    }

    public char charAt(int x, int y) {
        AttributedTextLine line = (AttributedTextLine)this.lines.elementAt(y);
        if (x >= line.text.length) {
            return ' ';
        }
        return (char)(((char)line.text[x] + 256) % 256);
    }

    public char styleAt(int x, int y) {
        AttributedTextLine line = (AttributedTextLine)this.lines.elementAt(y);
        if (x >= line.text.length) {
            return '\u0000';
        }
        return (char)line.style[x];
    }

    public int maxWidth() {
        return this.maxWidth;
    }

    public int size() {
        return this.lines.size();
    }

    public int correctLinePosition(int lineNo, long timestamp) {
        return lineNo;
    }

    public int selStartX() {
        return this.selStartX;
    }

    public int selEndX() {
        return this.selEndX;
    }

    public int selStartY() {
        return this.selStartLine;
    }

    public int selEndY() {
        return this.selEndLine;
    }

    public int cX() {
        return this.cX;
    }

    public int cY() {
        return this.cY;
    }

    public boolean hasSelection() {
        return this.selStartLine != -1;
    }

    public void hideCursor(boolean b) {
        if (this.cursorHidden != b) {
            this.cursorHidden = b;
            this.tv.updateView(this.cY(), this.cY() + 1, this.cX(), this.cX() + 1);
        }
    }

    public void unsetSelection() {
        this.isSelecting = false;
        if (!this.hasSelection()) {
            return;
        }
        int os = this.selStartLine;
        int oe = this.selEndLine;
        this.selEndLine = -1;
        this.selStartLine = -1;
        this.selectingStartY = -1;
        this.selectingStartX = -1;
        this.tv.updateView(os, oe + 1, 0, 1024);
    }

    public void setLineStyle(int style, int line, boolean updateView) {
        this.setStyle(style, 0, line, this.lineAt(line).size(), line, updateView);
    }

    public void setStyle(int style, int lx, int ly, int lx1, int ly1, boolean updateView) {
        if (ly >= this.size()) {
            return;
        }
        if (ly1 >= this.size()) {
            ly1 = this.size() - 1;
            lx1 = this.lineAt(ly1).size();
        }
        if (ly1 > ly) {
            if (this.lineAt(ly).size() > 0) {
                this.lineAt(ly).setStyle(style, lx, this.lineAt(ly).size());
            }
            int line = ly + 1;
            while (line < ly1) {
                if (this.lineAt(line).size() > 0) {
                    this.lineAt(line).setStyle(style);
                }
                ++line;
            }
            if (ly1 > ly && this.lineAt(ly1).size() > 0) {
                this.lineAt(ly1).setStyle(style, 0, lx1);
            }
            if (updateView) {
                this.tv.updateView(ly, ly1 + 1, 0, 1024);
            }
        } else {
            this.lineAt(ly).setStyle(style, lx, lx1);
            if (updateView) {
                this.tv.updateView(ly, ly1 + 1, lx, lx1 + 1);
            }
        }
    }

    public void setSelection(int lx, int ly, int lx1, int ly1) {
        int updateELine;
        int updateSLine;
        int startL = -1;
        int endL = -1;
        int startX = -1;
        int endX = -1;
        if (ly > ly1 || ly == ly1 && lx > lx1) {
            startL = ly1;
            endL = ly;
            startX = lx1;
            endX = lx;
        } else if (ly < ly1 || ly == ly1 && lx < lx1) {
            startL = ly;
            endL = ly1;
            startX = lx;
            endX = lx1;
        } else {
            startL = ly;
            endL = ly1;
            startX = lx;
            endX = lx1;
        }
        if (this.selStartLine == -1) {
            updateSLine = startL;
            updateELine = endL;
        } else if (!(startL == this.selStartLine && startX == this.selStartX || endL == this.selEndLine && endX == this.selEndX)) {
            updateSLine = Math.min(this.selStartLine, startL);
            updateELine = Math.max(this.selEndLine, endL);
        } else if (startL != this.selStartLine || startX != this.selStartX) {
            updateSLine = Math.min(this.selStartLine, startL);
            updateELine = Math.max(this.selStartLine, startL);
        } else {
            updateSLine = Math.min(this.selEndLine, endL);
            updateELine = Math.max(this.selEndLine, endL);
        }
        this.selStartLine = startL;
        this.selEndLine = endL;
        this.selStartX = startX;
        this.selEndX = endX;
        this.isSelecting = true;
        this.tv.updateView(updateSLine, updateELine + 1, 0, 1024);
    }

    public String completionWordAsString(int x, int y) {
        String s;
        if (x > 0) {
            --x;
        }
        if ((s = this.lineSelAsString(this.getWordAt(x, y))).trim().length() == 0 && this.charAt(x, y) >= ' ') {
            return "" + this.charAt(x, y);
        }
        return s;
    }

    public String completionWordAsString() {
        return this.completionWordAsString(this.cX(), this.cY());
    }

    /*
     * Unable to fully structure code
     */
    String lineSelAsString(Point p) {
        block3: {
            s = "";
            if (!this.hasSelection() || this.selStartY() != this.selEndY()) ** GOTO lbl12
            p.x = this.selStartX();
            while (p.x < this.selEndX()) {
                s = s + this.charAt(p.x, this.selStartY());
                ++p.x;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                if (this.charAt(p.x, this.cY()) > ' ') {
                    s = s + this.charAt(p.x, this.cY());
                }
                ++p.x;
lbl12:
                // 2 sources

                ** while (p.x < p.y)
            }
        }
        return s;
    }

    public String getPartAsString(int line, int start, int end) {
        String s = "";
        while (start < end) {
            if (this.charAt(start, line) > ' ') {
                s = s + this.charAt(start, line);
            }
            ++start;
        }
        return s;
    }

    public String getCurrentWordAsString() {
        return this.currentWordAsString();
    }

    public String currentWordAsString() {
        try {
            return this.lineSelAsString(this.getCurrentWord());
        }
        catch (Exception ex) {
            return "";
        }
    }

    public void selectCompletionWord() {
        Point p = this.getWordAt(this.cX() - 1, this.cY());
        if (!Character.isJavaIdentifierPart(this.charAt(this.cX() - 1, this.cY()))) {
            return;
        }
        this.moveCursorAbs(p.x, this.cY());
        this.setSelection(p.x, this.cY(), p.y, this.cY());
    }

    public void selectCurrentWord() {
        Point p = this.getCurrentWord();
        this.moveCursorAbs(p.x, this.cY());
        this.setSelection(p.x, this.cY(), p.y, this.cY());
    }

    public void moveCursor(int dx, int dy) {
        int ncX = this.cX() + dx;
        int ncY = this.cY() + dy;
        if (ncY < this.size() && ncY >= 0) {
            if (this.isVirtualSpace()) {
                if (dx == 0) {
                    int oldx = this.lineAt(this.cY()).translateX(this.cX());
                    ncX = this.lineAt(ncY).untranslateX(oldx);
                }
                if (JXEOptions.WRAP_CURSOR && ncX < 0 && ncY > 0 && dx == -1) {
                    ncX = this.lineAt(--ncY).size();
                }
            } else {
                if (dx == 0) {
                    int oldx = this.lineAt(this.cY()).translateX(this.cX());
                    ncX = this.lineAt(ncY).untranslateX(oldx);
                }
                if (dx == -1 && dy == 0) {
                    ncX = Math.min(ncX, this.lineAt(ncY).size() - 1);
                }
                if (ncX < 0 && dx == -1) {
                    if (--ncY < 0) {
                        return;
                    }
                    ncX = this.lineAt(ncY).size();
                } else if (dx == 1 && dy == 0 && this.cX() >= this.lineAt(ncY).size()) {
                    ++ncY;
                    ncX = 0;
                }
            }
        }
        if (this.hasSelection() && !this.isSelecting) {
            if (dx > 0 || dy > 0) {
                ncX = this.selEndX;
                ncY = this.selEndLine;
            } else {
                ncX = this.selStartX;
                ncY = this.selStartLine;
            }
        }
        this.moveCursorAbs(ncX, ncY);
    }

    public void centerPosition(int line) {
        this.tv.setOffset(Math.max(0, line - 6));
        this.moveCursorAbs(this.cX(), line);
    }

    public void centerPosition() {
        this.tv.setOffset(Math.max(0, this.cY() - 6));
    }

    public void moveCursorAbs(int nx, int ny) {
        if (nx < 0 || ny < 0 || ny >= this.size()) {
            return;
        }
        this.moveCursorNoScroll(nx, ny);
        if (this.tv instanceof Component && ((Component)((Object)this.tv)).isShowing()) {
            JWMenuBar.ResetMenu();
        }
        this.tv.adjustPosition(this.cX(), this.cY());
    }

    public void moveCursorAbsWithFolding(int nx, int ny) {
        int realY = this.computeFoldedYFromUnfoldedY(ny);
        this.moveCursorAbs(nx, realY);
    }

    public int computeFoldedYFromUnfoldedY(int ny) {
        int realY = 0;
        int i = 0;
        while (i < this.size()) {
            if (this.lineAt(i) instanceof CollapsedTextLine) {
                int off = ((CollapsedTextLine)this.lineAt((int)i)).collapsed.size();
                if (ny < realY + off) {
                    this.expandBlock(i + 1);
                    return i;
                }
                realY += off + 1;
            } else {
                ++realY;
            }
            if (ny < realY) {
                this.expandBlock(i + 1);
                return i;
            }
            ++i;
        }
        return ny;
    }

    public TextView getView() {
        return this.tv;
    }

    public void adjustPosition() {
        this.tv.adjustPosition(this.cX(), this.cY());
    }

    public void moveCursorNoScroll(int nx, int ny) {
        if (nx < 0 || ny < 0 || ny >= this.size()) {
            return;
        }
        int ox = this.cX();
        int oy = this.cY();
        this.cX = nx;
        this.cY = ny;
        this.tv.updateView(oy, oy + 1, ox, ox + 1);
        this.tv.updateView(ny, ny + 1, nx, nx + 1);
        try {
            this.markCorrespondingBrace();
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
        this.binder().notifyTargets("moveCursor");
    }

    public void insert(String s, int style, int line, int pos) {
        this.insertQuiet(s, style, line, pos);
        this.tv.updateView(line, line + 1, pos, 1024);
    }

    protected void insertQuiet(String s, int style, int line, int pos) {
        this.setModified(true);
        StringBuffer buff = null;
        if (this.isVirtualSpace()) {
            buff = new StringBuffer(this.lineAt(line).size() + s.length());
            int n = pos - this.lineAt(line).size();
            while (n > 0) {
                buff.append(' ');
                --pos;
                --n;
            }
            buff.append(s);
        } else {
            pos = Math.min(pos, this.lineAt(line).size());
        }
        AttributedTextLine tl = new AttributedTextLine(buff == null ? s : buff.toString());
        tl.setStyle(style);
        this.lineAt(line).insert(tl, pos, line, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cut(int startLine, int endLine, int startX, int endX) {
        this.setModified(true);
        startLine = Math.max(0, startLine);
        startLine = Math.min(startLine, this.size() - 1);
        endLine = Math.max(0, endLine);
        endLine = Math.min(endLine, this.size() - 1);
        if (startLine == endLine) {
            this.delete(startLine, startX, endX);
            return;
        }
        try {
            this.tv.lockUpdate(true);
            this.delete(startLine, startX, 1024);
            this.delete(endLine, 0, endX);
            int n = 0;
            while (n < endLine - startLine - 1) {
                this.remLineAt(Math.min(startLine + 1, this.size() - 1));
                ++n;
            }
            Object var7_6 = null;
            this.tv.lockUpdate(false);
            this.tv.repaintAll();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.tv.lockUpdate(false);
            this.tv.repaintAll();
            throw throwable;
        }
        this.unLineBreakAt(startLine);
    }

    public String getSelectionAsString() {
        if (this.hasSelection()) {
            return this.getSelection().toString();
        }
        return null;
    }

    public TextDocument getSelection() {
        if (this.hasSelection()) {
            return this.createCopy(this.selStartY(), this.selEndY(), this.selStartX(), this.selEndX());
        }
        return null;
    }

    public TextDocument createCopy() {
        return this.createCopy(0, this.size() - 1, 0, this.lineAt(this.size() - 1).size());
    }

    public TextDocument createCopy(int startLine, int endLine, int startX, int endX) {
        TextDocument result = new TextDocument();
        result.init(null);
        startLine = Math.min(this.size() - 1, startLine);
        endLine = Math.min(this.size() - 1, endLine);
        if (startLine == endLine) {
            result.addLineWithoutUndo(this.lineAt(startLine).copyFrom(startX, endX));
        } else {
            result.addLineWithoutUndo(this.lineAt(startLine).copyFrom(startX, this.lineAt(startLine).size()));
            result.addLineWithoutUndo(this.lineAt(endLine).copyFrom(0, Math.min(this.lineAt(endLine).size(), endX)));
            int n = 0;
            while (n < endLine - startLine - 1) {
                result.addLineWithoutUndoAt(result.size() - 1, this.lineAt(startLine + n + 1).copyFrom(0, this.lineAt(startLine + n + 1).size()));
                ++n;
            }
        }
        return result;
    }

    public void clipboardCopy() {
        if (this.hasSelection()) {
            clipboard = this.createCopy(this.selStartLine, this.selEndLine, this.selStartX, this.selEndX);
            String tmpString = clipboard.toString();
            TextDocument.AddToClipBoardRing(tmpString);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(tmpString), this);
        }
    }

    public void insertTemplate(TextDocument doc) {
        int cy;
        this.markUndoDiff();
        int cx = this.cX();
        int initialY = cy = this.cY();
        int initialX = this.lineAt(cy).translateX(cx);
        Hashtable<String, String> vars = new Hashtable<String, String>(5);
        int n = 0;
        while (n < doc.size()) {
            int sel;
            String s = doc.lineAt(n).toString();
            int i = s.indexOf("|");
            if (i >= 0) {
                cx += i;
                cy += n;
            }
            if ((sel = s.indexOf("#")) >= 0) {
                int selX = sel;
                int selY = n;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < doc.size()) {
            String s = doc.lineAt(n2).toString();
            int varIdx = -1;
            while ((varIdx = s.indexOf("($")) >= 0) {
                int varEndIdx = s.indexOf(")", varIdx);
                if (varEndIdx < 0) continue;
                String var = s.substring(varIdx + 2, varEndIdx);
                String value = (String)vars.get(var);
                if (value == null) {
                    value = Confirm.GetText((Window)((NCPanel)((Object)this.getView())).getFrame(), null, "Value of ($" + var + ")", new String[]{"Please enter the value of the variable"}, "");
                    if (value == null) {
                        value = "";
                    }
                    vars.put(var, value);
                }
                s = NCStringUtilities.Replace(s, "($" + var + ")", value);
            }
            String realLine = "";
            if (n2 == 0) {
                this.insertAndMove(s);
                realLine = this.lineAt(initialY).toString();
            } else {
                realLine = this.constructSpace(initialX) + s;
                this.addLineAt(initialY + n2, new AttributedTextLine(realLine));
            }
            int i = realLine.indexOf("|");
            if (i >= 0) {
                cx = i;
            }
            if (n2 == 0) {
                initialX = this.lineAt(initialY).translateX(this.lineAt(initialY).getFirstChar());
            }
            ++n2;
        }
        this.moveCursorAbs(cx, cy);
        if (this.charAt(cx, cy) == '|') {
            this.moveCursor(1, 0);
            this.deleteBackward();
        }
        int n3 = 0;
        while (n3 < doc.size()) {
            this.highLightLine(initialY + n3);
            ++n3;
        }
        this.repaint();
    }

    public void paste(TextDocument p, int startLine, int startX) {
        AttributedTextLine tl;
        this.setModified(true);
        String s = "";
        this.tv.lockUpdate(true);
        int n = startX - this.lineAt(startLine).size();
        while (n > 0) {
            s = " " + s;
            --n;
        }
        if (s.length() > 0) {
            tl = new AttributedTextLine(s);
            this.lineAt(startLine).insert(tl, this.lineAt(startLine).size(), startLine, this);
        }
        if (p.size() > 1) {
            tl = this.lineAt(startLine).split(startX, startLine, this);
            this.lineAt(startLine).insert(p.lineAt(0), startX, startLine, this);
            int n2 = p.size() - 2;
            while (n2 >= 1) {
                this.addLineAt(startLine + 1, p.lineAt(n2));
                --n2;
            }
            this.addLineAt(startLine + p.size() - 1, tl);
            this.lineAt(startLine + p.size() - 1).insert(p.lineAt(p.size() - 1), 0, startLine + p.size() - 1, this);
            this.moveCursorAbs(p.lineAt(p.size() - 1).size(), p.size() - 1 + startLine);
        } else {
            this.lineAt(startLine).insert(p.lineAt(0), startX, startLine, this);
            this.moveCursorAbs(startX + p.lineAt(0).size(), startLine);
        }
        this.tv.lockUpdate(false);
        if (this.hil != null) {
            this.hil.processChange(this, startLine, startLine + p.size(), p.size(), true, false);
        }
        this.tv.updateView(startLine, this.size(), 0, 1024);
    }

    public void pasteString(String in) {
        try {
            String s = in;
            TextDocument doc = new TextDocument();
            doc.init(null);
            doc.readFromStream(new DataInputStream(new StringBufferInputStream(in)));
            this.pasteDoc(doc);
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void clipboardPaste() {
        this.markUndoDiff();
        this.setModified(true);
        if (this.lostClip) {
            Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
            try {
                if (t != null) {
                    String s = (String)t.getTransferData(DataFlavor.stringFlavor);
                    clipboard = new TextDocument();
                    clipboard.init(null);
                    clipboard.readFromStream(new DataInputStream(new StringBufferInputStream(s)));
                }
            }
            catch (Exception ex) {
                try {
                    int c;
                    InputStream in = (InputStream)t.getTransferData(DataFlavor.plainTextFlavor);
                    StringBuffer buf = new StringBuffer(1000);
                    while ((c = in.read()) >= 0) {
                        void var5_9;
                        buf.append((char)var5_9);
                    }
                    String s = buf.toString();
                    clipboard = new TextDocument();
                    clipboard.init(null);
                    clipboard.readFromStream(new DataInputStream(new StringBufferInputStream(s)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (clipboard != null) {
            int formatCY = this.cY();
            this.paste(clipboard.createCopy(0, clipboard.size() - 1, 0, 1024), this.cY(), this.cX);
            if (JXEOptions.FORMATONPASTE && (this.getFile().getName().endsWith(".java") || this.getFile().getName().endsWith(".cpp") || this.getFile().getName().endsWith(".c"))) {
                try {
                    if (clipboard.size() > 1 && JXEOptions.FORMATONPASTE) {
                        ExtBeautifyCode.Format1(this, formatCY, formatCY + clipboard.size() - 1);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void delete(int line, int start, int end) {
        if (line >= this.size()) {
            return;
        }
        if (this.lineAt(line).size() <= start) {
            return;
        }
        this.setModified(true);
        end = Math.min(this.lineAt(line).size(), end);
        this.lineAt(line).delete(start, end, line, this);
        if (this.hil != null) {
            this.hil.processChange(this, line, line + 1, end - start, false, true);
        } else {
            this.tv.updateView(line, line + 1, start, 1024);
        }
    }

    public synchronized void lineBreakAt(int line, int pos, int initialOffset) {
        this.setModified(true);
        pos = Math.min(this.lineAt(line).size(), pos);
        AttributedTextLine li = this.lineAt(line).split(pos, line, this);
        this.addLineAt(line + 1, li);
        int minus = this.lineAt(line + 1).translateX(this.lineAt(line + 1).getFirstChar());
        String s = this.constructSpace(initialOffset - minus).toString();
        li.insert(s, 0, line + 1, this);
        if (this.hil != null) {
            this.hil.processChange(this, line, line + 1, 1024, true, false);
        }
        this.tv.updateView(line, this.size(), 0, 1024);
    }

    public StringBuffer constructSpace(int targetX) {
        int n;
        targetX = Math.max(targetX, 0);
        StringBuffer buf = new StringBuffer(targetX);
        while (targetX >= JXEOptions.TAB) {
            if (JXEOptions.USE_TABS) {
                buf.append('\t');
            } else {
                n = 0;
                while (n < JXEOptions.TAB) {
                    buf.append(' ');
                    ++n;
                }
            }
            targetX -= JXEOptions.TAB;
        }
        n = 0;
        while (n < targetX) {
            buf.append(' ');
            ++n;
        }
        return buf;
    }

    public synchronized void deleteLine(int line) {
        this.setModified(true);
        this.remLineAt(line);
        if (this.hil != null) {
            this.hil.processChange(this, line, line + 1, 1024, false, false);
        }
        this.tv.updateView(line, this.size(), 0, 1024);
    }

    public synchronized void unLineBreakAt(int line) {
        this.setModified(true);
        if (line == this.size() - 1) {
            return;
        }
        this.lineAt(line).insert(this.lineAt(line + 1), this.lineAt(line).size(), line, this);
        this.remLineAt(line + 1);
        if (this.hil != null) {
            this.hil.processChange(this, line, line + 1, 1024, false, false);
        }
        this.tv.updateView(line, this.size(), 0, 1024);
    }

    public void updateAccessTime() {
        this.setFile(this.getFile());
    }

    public long getAccessTimeWhenLoaded() {
        if (this.lastAccessTime == 0L && this.lastFile != null) {
            this.lastAccessTime = this.getFile().lastModified();
        }
        return this.lastAccessTime;
    }

    public void deleteForward() {
        this.setModified(true);
        if (this.hasSelection()) {
            this.cutSelection();
            return;
        }
        if (this.cX() >= this.lineAt(this.cY()).size()) {
            this.insertAndMove(" ");
            this.deleteBackward();
            this.unLineBreakAt(this.cY());
        } else {
            this.delete(this.cY(), this.cX(), this.cX() + 1);
        }
    }

    public int getFirstCharX(int line) {
        return this.lineAt(line).getFirstChar();
    }

    public int getLastCharX(int line) {
        return this.lineAt(line).getLastChar();
    }

    public void deleteBackward() {
        this.setModified(true);
        if (this.hasSelection()) {
            this.cutSelection();
            return;
        }
        if (this.cX() == 0 || !this.isVirtualSpace() && this.lineAt(this.cY()).size() == 0) {
            if (this.cY() != 0) {
                this.moveCursorAbs(this.lineAt(this.cY() - 1).size(), this.cY() - 1);
                this.unLineBreakAt(this.cY());
            }
        } else {
            this.moveCursor(-1, 0);
            this.delete(this.cY(), this.cX(), this.cX() + 1);
            return;
        }
    }

    public void cutSelection() {
        this.markUndoDiff();
        this.setModified(true);
        this.moveCursorAbs(this.selStartX, this.selStartLine);
        this.cut(this.selStartLine, this.selEndLine, this.selStartX, this.selEndX);
        this.unsetSelection();
    }

    public void lineBreak() {
        this.setModified(true);
        if (this.hasSelection()) {
            this.cutSelection();
        }
        int tmp = this.lineAt(this.cY()).translateX(this.getFirstCharX(this.cY()));
        this.lineBreakAt(this.cY(), this.cX(), tmp);
        this.moveCursorAbs(this.lineAt(this.cY() + 1).untranslateX(tmp), this.cY() + 1);
    }

    public void markCorrespondingBrace() {
        try {
            if (this.cX() == 0) {
                return;
            }
            this.markOpeningBrace(this.cX() - 1, this.cY());
            this.markClosingBrace(this.cX() - 1, this.cY());
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    public void markOpeningBrace(int nx, int ny) {
        if (nx >= 0 && nx < this.lineAt(ny).size() && ")]}".indexOf(this.charAt(nx, ny)) >= 0) {
            int[] xy;
            if (nx == 0) {
                if (--ny < 0) {
                    return;
                }
                nx = this.lineAt(ny).size();
            }
            if ((xy = this.getOpeningBrace(nx, ny)) == null) {
                return;
            }
            if (xy[1] > 0) {
                if (this.lastBraceHighlightLine >= 0 && this.lastBraceHighlightLine < this.size()) {
                    this.repaintLines(this.lastBraceHighlightLine, this.lastBraceHighlightLine + 1);
                }
                this.lastBraceHighlightLine = xy[1];
                char sty = this.styleAt(xy[0], xy[1]);
                this.setStyle(11, xy[0], xy[1], xy[0] + 1, xy[1], true);
                if (this.getView() instanceof JComponent) {
                    Platforms.ensureRepaintFinished((JComponent)((Object)this.getView()));
                }
                this.setStyle(sty, xy[0], xy[1], xy[0] + 1, xy[1], false);
                new Thread(){

                    public void run() {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        TextDocument.this.repaintLines(xy[1]);
                    }
                }.start();
            }
        }
    }

    public void markClosingBrace(int nx, int ny) {
        if (nx >= 0 && nx <= this.lineAt(ny).size() && "({[".indexOf(this.charAt(nx, ny)) >= 0) {
            int[] xy;
            if (nx == this.lineAt(ny).size()) {
                if (++ny >= this.size()) {
                    return;
                }
                nx = 0;
            }
            if ((xy = this.getClosingBrace(nx + 1, ny)) == null) {
                return;
            }
            if (xy[1] < this.size()) {
                if (this.lastBraceHighlightLine >= 0 && this.lastBraceHighlightLine < this.size()) {
                    this.repaintLines(this.lastBraceHighlightLine, this.lastBraceHighlightLine + 1);
                }
                this.lastBraceHighlightLine = xy[1];
                char sty = this.styleAt(xy[0], xy[1]);
                this.setStyle(11, xy[0], xy[1], xy[0] + 1, xy[1], true);
                if (this.getView() instanceof JComponent) {
                    Platforms.ensureRepaintFinished((JComponent)((Object)this.getView()));
                }
                this.setStyle(sty, xy[0], xy[1], xy[0] + 1, xy[1], false);
                ++this.threadCount;
                if (this.threadCount < 5) {
                    new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                try {
                                    Thread.sleep(1000L);
                                    TextDocument.this.repaintLines(xy[1]);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    Object var3_2 = null;
                                    --TextDocument.this.threadCount;
                                }
                                Object var3_1 = null;
                                --TextDocument.this.threadCount;
                            }
                            catch (Throwable throwable) {
                                Object var3_3 = null;
                                --TextDocument.this.threadCount;
                                throw throwable;
                            }
                        }
                    }.start();
                }
            }
        }
    }

    void performAutoIndentIfBrace() {
        int xpos;
        if (!JXEOptions.AUTOINDENT) {
            return;
        }
        if (this.lineAt(this.cY()).getLastCharacter() == '}' && this.lineAt(this.cY()).getFirstCharacter() == '}' && (xpos = this.lineAt(this.cY()).getLastChar()) > 0) {
            int[] xy = this.getOpeningBrace(xpos - 1, this.cY());
            if (xy == null) {
                return;
            }
            if (xy[1] > 0) {
                xpos = this.lineAt(xy[1]).getFirstChar();
                int tmp = this.lineAt(xy[1]).translateX(Math.max(0, xpos));
                if (this.lineAt(this.cY()).getFirstChar() == this.lineAt(this.cY()).getLastChar() && tmp < this.lineAt(this.cY()).translateX(this.lineAt(this.cY()).getFirstChar())) {
                    while (tmp < this.lineAt(this.cY()).translateX(this.lineAt(this.cY()).getFirstChar())) {
                        this.insertTabInternal(this.cY(), -JXEOptions.INDENT);
                        this.moveCursorAbs(this.lineAt(this.cY()).size(), this.cY());
                    }
                }
            }
        }
    }

    public void lineBreakAutoIndent() {
        if (!JXEOptions.AUTOINDENT) {
            this.lineBreak();
            return;
        }
        this.setModified(true);
        if (this.hasSelection()) {
            this.cutSelection();
        }
        int first = this.getFirstCharX(this.cY());
        int tmp = this.lineAt(this.cY()).translateX(first);
        if (this.cX() > this.lineAt(this.cY()).getLastChar()) {
            String cl;
            boolean bIf = false;
            if (JXEOptions.IFAUTO && this.startsWithIndentKW(cl = this.lineAt(this.cY()).toString().trim())) {
                bIf = true;
            }
            if (this.lineAt(this.cY()).getLastCharacter() == '{' || bIf) {
                tmp = this.lineAt(this.cY()).translateX(first + JXEOptions.INDENT);
            }
        }
        this.lineBreakAt(this.cY(), this.cX(), tmp);
        this.moveCursorAbs(this.lineAt(this.cY() + 1).untranslateX(tmp), this.cY() + 1);
    }

    boolean startsWithIndentKW(String cl) {
        return cl.startsWith("if(") || cl.startsWith("if (") || cl.startsWith("case ") || cl.endsWith("else") || cl.startsWith("while(") || cl.startsWith("while (") || cl.startsWith("for(") || cl.startsWith("for (") || cl.startsWith("do(") || cl.startsWith("do (");
    }

    public void insertAndMove(String s) {
        String cl;
        this.setModified(true);
        if (this.hasSelection()) {
            this.cutSelection();
        }
        if (this.hil != null) {
            this.insertQuiet(s, 0, this.cY(), this.cX());
            this.hil.processChange(this, this.cY(), this.cY() + 1, s.length(), true, true);
        } else {
            this.insert(s, 0, this.cY(), this.cX());
        }
        this.cX = Math.min(this.lineAt(this.cY()).size() - s.length(), this.cX);
        this.moveCursor(s.length(), 0);
        if (s.equals("}")) {
            this.performAutoIndentIfBrace();
        }
        if (JXEOptions.AUTOINDENT && JXEOptions.IFAUTO && s.equals("{") && this.cY() > 0 && (this.startsWithIndentKW(cl = this.lineAt(this.cY() - 1).toString().trim()) && this.lineAt(this.cY() - 1).getLastCharacter() == ')' || cl.endsWith("else"))) {
            this.unInsertTab();
        }
    }

    public void highLightLine(int num) {
        if (this.hil != null) {
            this.hil.processChange(this, num, num + 1, 1024, true, true);
        }
    }

    public void unInsertTab() {
        String s = "";
        this.setModified(true);
        if (this.hasSelection() && this.selEndY() != this.selStartY()) {
            int n = this.selStartY();
            while (n < this.selEndY()) {
                this.insertTabInternal(n, -JXEOptions.INDENT);
                ++n;
            }
            this.tv.updateView(this.selStartY(), this.selEndY(), 0, 1024);
        } else {
            int actCur = this.cX() - this.lineAt(this.cY()).getFirstChar();
            this.insertTabInternal(this.cY(), -JXEOptions.INDENT);
            this.moveCursorAbs(this.lineAt(this.cY()).getFirstChar() + actCur, this.cY());
            this.tv.updateView(this.cY(), this.cY() + 1, 0, 1024);
        }
    }

    public void insertTabInternal(int line, int toAdd) {
        AttributedTextLine tl = this.lineAt(line);
        int fchar = tl.getFirstChar();
        int pos = tl.translateX(fchar);
        tl.delete(0, fchar, line, this);
        String s = this.constructSpace(Math.max(0, pos + toAdd)).toString();
        tl.insert(s, 0, line, this);
    }

    public void insertTab() {
        String s = "";
        this.setModified(true);
        if (this.hasSelection() && this.selEndY() != this.selStartY()) {
            int n = this.selStartY();
            while (n < this.selEndY()) {
                this.insertTabInternal(n, JXEOptions.INDENT);
                ++n;
            }
            this.tv.updateView(this.selStartY(), this.selEndY(), 0, 1024);
        } else if (this.getFirstCharX(this.cY()) >= Math.min(this.cX(), this.lineAt(this.cY()).size())) {
            if (JXEOptions.INDENT < JXEOptions.TAB) {
                int pos = this.lineAt(this.cY()).translateX(this.cX());
                if (!JXEOptions.VIRTUALSPACE) {
                    pos = Math.min(pos, this.lineAt(this.cY()).translateX(this.lineAt(this.cY()).size()));
                }
                this.insertTabInternal(this.cY(), JXEOptions.INDENT - pos % JXEOptions.INDENT);
                this.moveCursorAbs(this.lineAt(this.cY()).untranslateX(pos + JXEOptions.INDENT - pos % JXEOptions.INDENT), this.cY());
                return;
            }
            if (JXEOptions.USE_TABS) {
                this.insertAndMove("\t");
                return;
            }
            int pos = this.lineAt(this.cY()).translateX(this.cX());
            this.insertTabInternal(this.cY(), JXEOptions.INDENT - pos % JXEOptions.INDENT);
            this.moveCursorAbs(pos + (JXEOptions.INDENT - pos % JXEOptions.INDENT), this.cY());
        } else {
            if (JXEOptions.USE_TABS) {
                this.insertAndMove("\t");
                return;
            }
            int pos = this.lineAt(this.cY()).translateX(this.cX());
            while (s.length() < JXEOptions.INDENT - pos % JXEOptions.INDENT) {
                s = s + " ";
            }
            this.insertAndMove(s);
        }
    }

    public void pageDown() {
        int h = this.tv.visibleLines();
        this.lockUpdate(true);
        this.moveCursorNoScroll(this.cX(), this.cY() + h);
        this.lockUpdate(false);
        this.tv.page(h);
    }

    public void pageUp() {
        int h = this.tv.visibleLines();
        this.lockUpdate(true);
        this.moveCursorNoScroll(this.cX(), this.cY() - h);
        this.lockUpdate(false);
        this.tv.page(-h);
    }

    byte[] getLinefeed() {
        byte[] b = this.linefeed;
        if (AJEditOptions.This != null) {
            switch (AJEditOptions.This.getLFSetting()) {
                case 0: {
                    break;
                }
                case 1: {
                    b = new byte[]{10};
                    break;
                }
                case 2: {
                    b = new byte[]{13, 10};
                }
            }
        }
        return b;
    }

    public void writeToStream(DataOutputStream o) {
        try {
            ArrayList<AttributedTextLine> li = new ArrayList<AttributedTextLine>(this.lines.size());
            int i = 0;
            while (i < this.size()) {
                li.add(this.lineAt(i));
                ++i;
            }
            this.writeLinesToStream(o, li);
            this.setModified(false);
            this.binder().notifyTargets("save");
        }
        catch (Exception e) {
            e.printStackTrace();
            Confirm.MsgException(e);
        }
    }

    void writeLinesToStream(DataOutputStream o, ArrayList lines) throws IOException {
        byte[] b = this.getLinefeed();
        byte[] ahead = new byte[JXEOptions.TAB];
        byte[] tx = null;
        int n = 0;
        while (n < lines.size()) {
            int l;
            tx = ((AttributedTextLine)lines.get((int)n)).text;
            boolean isTab = true;
            boolean isLeadingWS = true;
            if (!JXEOptions.USE_TABS && JXEOptions.WRITE_TABS) {
                int screenPos = 0;
                l = 0;
                while (l < tx.length) {
                    if (tx[l] > 32) {
                        isLeadingWS = false;
                    }
                    if (isLeadingWS && tx[l] == 9) {
                        int count = JXEOptions.TAB - screenPos % JXEOptions.TAB;
                        int tab = 0;
                        while (tab < count) {
                            o.writeByte(32);
                            ++screenPos;
                            ++tab;
                        }
                    } else {
                        o.writeByte(tx[l]);
                        ++screenPos;
                    }
                    ++l;
                }
                if (n != this.size() - 1) {
                    o.write(b);
                }
            } else {
                l = 0;
                while (l < tx.length) {
                    if (tx[l] != 32 || !JXEOptions.WRITE_TABS) {
                        isTab = false;
                    }
                    ahead[l % JXEOptions.TAB] = tx[l];
                    if (l % JXEOptions.TAB == JXEOptions.TAB - 1) {
                        if (isTab) {
                            o.writeByte(9);
                        } else {
                            o.write(ahead);
                        }
                    }
                    ++l;
                }
                if (l % JXEOptions.TAB != 0) {
                    o.write(ahead, 0, l % JXEOptions.TAB);
                }
                if (n != this.size() - 1) {
                    o.write(b);
                }
            }
            if (lines.get(n) instanceof CollapsedTextLine && ((CollapsedTextLine)lines.get((int)n)).collapsed.size() > 0) {
                this.writeLinesToStream(o, ((CollapsedTextLine)lines.get((int)n)).collapsed);
            }
            ++n;
        }
    }

    public JUnsafeVector getModifiedLinesSinceLastSave() {
        JSet arr = new JSet(this.undo.size());
        int n = 0;
        while (n < this.undo.size()) {
            GeneralDiff diff = (GeneralDiff)this.undo.elementAt(n);
            if (diff.kind != 4 && diff.kind != 1 && diff.aline != null) {
                arr.add(diff.aline);
            }
            ++n;
        }
        JUnsafeVector res = new JUnsafeVector(arr.size());
        Enumeration e = arr.enumerate();
        while (e.hasMoreElements()) {
            res.addElement(e.nextElement());
        }
        return res;
    }

    public void coreWriteToStream(DataOutputStream o) {
        try {
            byte[] b = this.getLinefeed();
            byte[] tx = null;
            int n = 0;
            while (n < this.size()) {
                tx = this.lineAt((int)n).text;
                o.write(tx);
                if (n != this.size() - 1) {
                    o.write(b);
                }
                ++n;
            }
        }
        catch (Exception e) {
            Confirm.MsgException(e);
        }
        this.setModified(false);
        this.binder().notifyTargets("save");
    }

    public void readFromByteArrayNoReplace(byte[] file2) {
        int idx = 0;
        int lastLine = 0;
        this.lines = new JUnsafeVector(file2.length / 40);
        this.linefeed = new byte[]{10};
        while (idx < file2.length) {
            if (file2[idx] == 13 || file2[idx] == 10 || lastLine - idx > 1023) {
                AttributedTextLine li = new AttributedTextLine(file2, lastLine, idx - lastLine);
                this.lines.addElement(li);
                if (file2[idx] == 13) {
                    if (this.linefeed.length == 1) {
                        this.linefeed = new byte[]{13, 10};
                    }
                    ++idx;
                }
                if (idx < file2.length && file2[idx] == 13) {
                    ++idx;
                }
                if (idx >= file2.length || file2[idx] == 10) {
                    // empty if block
                }
                if ((lastLine = ++idx) - idx < 1023) continue;
                this.setModified(true);
                continue;
            }
            ++idx;
        }
        this.lines.addElement(new AttributedTextLine(file2, lastLine, idx - lastLine));
    }

    protected void readFromByteArrayFiltered(byte[] file2) {
        int idx = 0;
        int pos = 0;
        byte[] b = new byte[1024 + JXEOptions.READINTAB];
        try {
            StringBuffer tab = new StringBuffer(JXEOptions.READINTAB * 2);
            this.lines = new JUnsafeVector(file2.length / 20);
            this.linefeed = new byte[]{10};
            block6: while (true) {
                b[pos] = file2[idx++];
                if (pos < 1024 && b[pos] > 31) {
                    ++pos;
                    continue;
                }
                if (b[pos] == 10 || pos >= 1023) {
                    AttributedTextLine li = new AttributedTextLine(b, 0, pos);
                    this.lines.addElement(li);
                    pos = 0;
                    if (pos < 1023) continue;
                    this.setModified(true);
                    continue;
                }
                switch (b[pos]) {
                    case 9: {
                        int n = 0;
                        while (true) {
                            if (n >= JXEOptions.READINTAB) continue block6;
                            b[pos++] = TABCODE;
                            ++n;
                        }
                    }
                    case 13: {
                        if (this.linefeed.length != 1) break;
                        this.linefeed = new byte[]{13, 10};
                    }
                }
            }
        }
        catch (Exception e) {
            if (pos >= 0) {
                this.lines.addElement(new AttributedTextLine(b, 0, pos));
            }
            return;
        }
    }

    public void readFromStream(DataInputStream ii) {
        this.readFromStream(ii, false);
    }

    public void readFromStream(DataInputStream ii, boolean ignoreOptions) {
        this.completionEngineContext = null;
        byte[] file2 = null;
        this.tracker = null;
        this.maxWidth = 0;
        try {
            file2 = new byte[ii.available()];
            ii.readFully(file2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setModified(false);
        this.readFromByteArrayNoReplace(file2);
        if (this.hil != null) {
            this.hil.highlightAll(this);
        }
        if (this.tv != null) {
            this.tv.repaintAll();
            this.moveCursorAbs(0, 0);
        }
        this.undo = new Stack();
        this.redo = new Stack();
        this.binder().notifyTargets("load");
    }

    public Point getCurrentWord() {
        return this.getWordAt(this.cX(), this.cY());
    }

    public String getSelectedString() {
        if (!this.hasSelection() || this.selStartY() != this.selEndY()) {
            return null;
        }
        return this.getSelectionAsString();
    }

    boolean isIdentifierPart(char c) {
        if (Character.isJavaIdentifierPart(c)) {
            return true;
        }
        if (this.getFile() != null && !this.getFile().getName().endsWith(".java") && !this.getFile().getName().endsWith(".jsp")) {
            return c == '-' || c == ':' || c == '.';
        }
        return false;
    }

    public Point getWordAt(int xx, int yy) {
        int x = xx;
        int y = yy;
        int xleft = 0;
        int xright = 0;
        if (this.isIdentifierPart(this.charAt(x, y))) {
            while (x >= 0 && this.isIdentifierPart(this.charAt(x, y))) {
                --x;
            }
            if (xx - x > 0) {
                ++x;
            }
            xleft = x;
            x = xx;
            y = yy;
            while (this.isIdentifierPart(this.charAt(x, y))) {
                ++x;
            }
            xright = x;
        } else {
            xleft = xx;
            xright = xx + 1;
        }
        return new Point(xleft, xright);
    }

    public boolean isModified() {
        return this.readOnly ? false : this.accessorModified;
    }

    public void setModified(boolean b) {
        if (b && !this.holdKringels) {
            this.setDrawKringel(false);
        }
        if (b && !this.redo.isEmpty()) {
            this.redo.removeAllElements();
        }
        this.modified = b;
        if (this.accessorModified != b) {
            this.accessorModified = b;
            if (!this.readOnly) {
                this.propagateAction("documentModified", new Boolean(b), this);
            }
        }
        this.accessorModified = b;
    }

    public void setModifiedQuiet(boolean b) {
        this.modified = b;
        this.accessorModified = b;
        if (!this.readOnly) {
            this.propagateAction("documentModified", new Boolean(b), this);
        }
    }

    public void propagateAction(String sel, Object arg, Object sender) {
        if (this.tv != this) {
            this.tv.propagateAction(sel, arg, sender);
        }
    }

    public void addLine(AttributedTextLine li) {
        this.addLineAt(this.lines.size(), li);
    }

    public void setLineWithoutUndo(int i, AttributedTextLine li) {
        this.lines.setElementAt(li, i);
    }

    public void setLine(int i, AttributedTextLine li) {
        this.addDiff(new GeneralDiff(i, 0, 1, this.lineAt(i)));
        this.addDiff(new GeneralDiff(i, 0, 0, li));
        this.lines.setElementAt(li, i);
    }

    public void addLine(String s) {
        if (s.indexOf(8) >= 0) {
            Vector v = NCStringUtilities.SplitSeparatedString("\b", s);
            int i = 0;
            while (i < v.size()) {
                this.addLine(v.get(i).toString());
                ++i;
            }
        } else {
            this.addLine(new AttributedTextLine(s));
        }
    }

    public void addLineAt(int idx, AttributedTextLine li) {
        this.addLineWithoutUndoAt(idx, li);
        this.addDiff(new GeneralDiff(idx, 0, 0, li));
    }

    public void insertLine(int idx, AttributedTextLine li) {
        this.addLineAt(idx, li);
    }

    public void insertLine(int idx, String li) {
        this.addLineAt(idx, new AttributedTextLine(li));
    }

    public void addLineWithoutUndoAt(int idx, AttributedTextLine li) {
        if (this.isReadOnly()) {
            return;
        }
        this.lines.insertElementAt(li, idx);
        if (!this.holdKringels) {
            this.setDrawKringel(false);
        }
        if (this.tracker != null) {
            this.tracker.notifyInsert(idx);
        }
    }

    public void addLineWithoutUndo(AttributedTextLine li) {
        if (this.isReadOnly()) {
            return;
        }
        this.lines.addElement(li);
        if (!this.holdKringels) {
            this.setDrawKringel(false);
        }
        if (this.tracker != null) {
            this.tracker.notifyInsert(this.lines.size());
        }
    }

    public void remLineAt(int idx) {
        this.addDiff(new GeneralDiff(idx, 0, 1, this.lineAt(idx)));
        this.remLineWithoutUndoAt(idx);
    }

    public void remLineWithoutUndoAt(int idx) {
        this.remLineWithoutUndoAt(idx, false);
    }

    public void remLineWithoutUndoAt(int idx, boolean ignoreReadOnly) {
        if (!ignoreReadOnly && this.isReadOnly()) {
            return;
        }
        this.lines.removeElementAt(idx);
        if (!this.holdKringels) {
            this.setDrawKringel(false);
        }
        if (this.tracker != null) {
            this.tracker.notifyRemove(idx);
        }
    }

    public void lockUpdate(boolean b) {
        if (this.tv != null && this.tv != this) {
            this.tv.lockUpdate(b);
        }
    }

    public void redo() {
        while (!this.redo.empty() && ((GeneralDiff)this.redo.lastElement()).kind == 4) {
            this.redo.pop();
        }
        int minLine = this.size() * 10;
        int maxLine = -1;
        int newCX = 0;
        int newCY = 0;
        boolean insdel = false;
        this.lockUpdate(true);
        while (!this.redo.empty() && ((GeneralDiff)this.redo.lastElement()).kind != 4) {
            GeneralDiff gd = (GeneralDiff)this.redo.pop();
            minLine = Math.min(gd.line, minLine);
            maxLine = Math.max(gd.line, maxLine);
            switch (gd.kind) {
                case 0: {
                    this.addLineAt(gd.line, gd.aline);
                    newCX = this.cX();
                    newCY = gd.line;
                    insdel = true;
                    break;
                }
                case 1: {
                    this.remLineAt(gd.line);
                    newCX = this.cX();
                    newCY = gd.line;
                    insdel = true;
                    break;
                }
                case 3: {
                    this.lineAt(gd.line).delete(gd.col, gd.col + gd.what.length, gd.line, this);
                    newCX = gd.col;
                    newCY = gd.line;
                    break;
                }
                case 2: {
                    this.lineAt(gd.line).insert(new AttributedTextLine(gd.what, 0, gd.what.length), gd.col, gd.line, this);
                    newCX = gd.col;
                    newCY = gd.line;
                    break;
                }
                case 6: {
                    this.expandBlock(gd.line);
                    newCX = this.cX();
                    newCY = gd.line;
                    break;
                }
                case 5: {
                    CollapsedTextLine tl = CollapsedTextLine.Collapse(this, gd.line, gd.line + gd.col + 1);
                    int res = 0;
                    if (tl != null) {
                        res = tl.collapsed.size();
                    }
                    if (res > 0) {
                        this.addDiff(new GeneralDiff(gd.line, res, 5, null));
                    }
                    newCX = this.cX();
                    newCY = gd.line;
                }
            }
        }
        this.lockUpdate(false);
        if (maxLine >= 0 && minLine < this.size()) {
            this.moveCursorAbs(newCX, newCY);
            if (this.hil != null) {
                this.hil.processChange(this, minLine, Math.min(this.size(), maxLine + 1), 0, true, false);
            }
            if (insdel) {
                this.tv.updateView(minLine, this.size() - 1, 0, 1024);
            } else {
                this.tv.updateView(minLine, maxLine + 1, 0, 1024);
            }
        }
        this.markUndoDiff();
    }

    public void undo() {
        while (!this.undo.empty() && ((GeneralDiff)this.undo.lastElement()).kind == 4) {
            this.undo.pop();
        }
        this.redo.push(new GeneralDiff(4));
        boolean insdel = false;
        int minLine = this.size() * 10;
        int maxLine = -1;
        int newCX = 0;
        int newCY = 0;
        this.lockUpdate(true);
        while (!this.undo.empty() && ((GeneralDiff)this.undo.lastElement()).kind != 4) {
            GeneralDiff gd = (GeneralDiff)this.undo.pop();
            this.redo.push(gd);
            minLine = Math.min(gd.line, minLine);
            maxLine = Math.max(gd.line, maxLine);
            switch (gd.kind) {
                case 1: {
                    this.addLineWithoutUndoAt(gd.line, gd.aline);
                    newCX = this.cX();
                    newCY = gd.line;
                    insdel = true;
                    break;
                }
                case 0: {
                    this.remLineWithoutUndoAt(gd.line);
                    newCX = this.cX();
                    newCY = gd.line;
                    insdel = true;
                    break;
                }
                case 2: {
                    this.lineAt(gd.line).delete(gd.col, gd.col + gd.what.length, gd.line, null);
                    newCX = gd.col;
                    newCY = gd.line;
                    break;
                }
                case 3: {
                    this.lineAt(gd.line).insert(new AttributedTextLine(gd.what, 0, gd.what.length), gd.col, gd.line, null);
                    newCX = gd.col;
                    newCY = gd.line;
                    break;
                }
                case 5: {
                    ((CollapsedTextLine)this.lineAt(gd.line)).expand(this, gd.line);
                    newCX = this.cX();
                    newCY = gd.line;
                    break;
                }
                case 6: {
                    CollapsedTextLine.Collapse(this, gd.line, gd.line + gd.col + 1);
                    newCX = this.cX();
                    newCY = gd.line;
                }
            }
        }
        this.lockUpdate(false);
        if (maxLine >= 0 && minLine < this.size()) {
            this.moveCursorAbs(newCX, newCY);
            if (this.hil != null) {
                this.hil.processChange(this, minLine, Math.min(this.size(), maxLine + 1), 0, true, false);
            }
            if (insdel) {
                this.tv.updateView(minLine, this.size() - 1, 0, 1024);
            } else {
                this.tv.updateView(minLine, maxLine + 1, 0, 1024);
            }
        }
    }

    public void repaint() {
        this.tv.repaintAll();
    }

    public void markUndoDiff() {
        this.addDiff(new GeneralDiff(4));
    }

    public void addDiff(GeneralDiff diff) {
        if (diff.kind == 4 && this.undo.size() > 0 && ((GeneralDiff)this.undo.lastElement()).kind == 4) {
            return;
        }
        this.undo.push(diff);
    }

    public String toString() {
        Tracer.This.println("------------------TD.toString()-----------------------");
        StringBuffer s = new StringBuffer(this.size() * 40);
        int n = 0;
        while (n < this.size()) {
            s.append(this.lineAt(n).toString());
            if (n != this.size() - 1) {
                s.append("\n");
            }
            ++n;
        }
        return s.toString();
    }

    public boolean isEqual(TextDocument doc, boolean ignoreWS) {
        if (doc.size() != this.size()) {
            return false;
        }
        int n = 0;
        while (n < this.size()) {
            if (!this.lineAt(n).isEqual(doc.lineAt(n), ignoreWS)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isEqualsIgnoreComments(TextDocument doc, boolean ignoreWS) {
        DocumentStream me2 = new DocumentStream(this, 0, 0);
        DocumentStream other = new DocumentStream(doc, 0, 0);
        int actA = 0;
        int actB = 0;
        while (actA == actB && actA >= 0 && actB >= 0) {
            while ((actA = me2.readIgnoreComments()) >= 0 && actA <= 32) {
            }
            while ((actB = other.readIgnoreComments()) >= 0 && actB <= 32) {
            }
        }
        return actA == actB;
    }

    public void findAndSelectForward(String s, int sx, int sy) {
        int x = this.cX();
        int y = this.cY();
        if (s == null) {
            return;
        }
        if (s.length() == 0) {
            return;
        }
        DocumentStream ds = new DocumentStream(this, sx, sy);
        this.lockUpdate(true);
        if (ds.findNext(s, true, false)) {
            this.setSelection(ds.posX() - s.length(), ds.posY(), ds.posX(), ds.posY());
            this.moveCursorAbs(ds.posX(), ds.posY());
        } else {
            this.unsetSelection();
        }
        this.moveCursorAbs(x, y);
        this.lockUpdate(false);
        this.repaintAll();
    }

    public void replaceAll(String toReplace, String newString) {
        int x = this.cX();
        int y = this.cY();
        if (toReplace == null || newString == null) {
            return;
        }
        if (toReplace.length() == 0) {
            return;
        }
        DocumentStream ds = new DocumentStream(this, 0, 0);
        this.lockUpdate(true);
        while (ds.findNext(toReplace, true, false)) {
            this.setSelection(ds.posX() - toReplace.length(), ds.posY(), ds.posX(), ds.posY());
            this.moveCursorAbs(ds.posX(), ds.posY());
            this.insertAndMove(newString);
            int n = 0;
            while (n < newString.length() - toReplace.length()) {
                ds.read();
                ++n;
            }
        }
        this.unsetSelection();
        this.moveCursorAbs(x, y);
        this.lockUpdate(false);
    }

    /*
     * WARNING - void declaration
     */
    public int findPatternLine(int startLine, String afterPattern) {
        int c;
        DocumentStream ds = new DocumentStream(this, 0, startLine);
        int cnt = 0;
        block0: while ((c = ds.read()) > 0) {
            void var4_5;
            if (var4_5 == 47 && cnt < 2) {
                ++cnt;
                continue;
            }
            if (var4_5 == 36 && (cnt == 2 || cnt == 3)) {
                ++cnt;
                continue;
            }
            if (cnt == 4) {
                int cc = 0;
                while ((c = ds.read()) > 0) {
                    if (var4_5 == afterPattern.charAt(cc)) {
                        if (++cc != afterPattern.length()) continue;
                        return ds.posY();
                    }
                    cnt = 0;
                    continue block0;
                }
                continue;
            }
            cnt = 0;
        }
        return -1;
    }

    void findSequenceAndMark(int minVal, int maxVal, int minIdx, int maxIdx, int[][] diffs) {
        int n;
        if (diffs[minIdx][1] > minVal && diffs[minIdx][1] < maxVal) {
            n = minIdx;
        } else {
            n = minIdx + 1;
            while (n < maxIdx && (diffs[n][1] <= minVal || diffs[n][1] >= maxVal)) {
                ++n;
            }
            if (n >= maxIdx) {
                return;
            }
        }
        int foundMinIdx = n;
        int foundMaxIdx = n + 1;
        int actLo = foundMinIdx;
        n = foundMinIdx;
        while (n < maxIdx) {
            if (diffs[n][1] >= diffs[n + 1][1] || diffs[n][1] >= maxVal || diffs[n][1] <= minVal) {
                actLo = n;
            } else if (foundMaxIdx - foundMinIdx < n + 2 - actLo) {
                foundMinIdx = actLo;
                foundMaxIdx = n + 2;
            }
            ++n;
        }
        n = foundMinIdx;
        while (n < foundMaxIdx) {
            diffs[n][2] = 1;
            ++n;
        }
        if (minIdx < foundMinIdx) {
            this.findSequenceAndMark(minVal, diffs[foundMinIdx][1], minIdx, foundMinIdx, diffs);
        }
        if (maxIdx > foundMaxIdx) {
            this.findSequenceAndMark(diffs[foundMaxIdx - 1][1], maxVal, foundMaxIdx, maxIdx, diffs);
        }
    }

    public void diffToInternal(int minVal, int maxVal, int st, int en, TextDocument doc, int docSt, int docEn, JUnsafeVector res) {
        if (en - st <= 0 || docEn - docSt <= 0) {
            return;
        }
        JUnsafeTable tab = new JUnsafeTable((docEn - docSt) * 2);
        int[][] diffs = new int[Math.min(en - st, docEn - docSt) + 3][3];
        int diffCnt = 0;
        int elems = 0;
        int n = docSt;
        while (n < docEn) {
            Object o = tab.get(doc.lineAt(n));
            if (o != null) {
                if (!(o instanceof Boolean)) {
                    --elems;
                }
                tab.put(doc.lineAt(n), Boolean.TRUE);
            } else {
                tab.put(doc.lineAt(n), new Integer(n));
                ++elems;
            }
            ++n;
        }
        if (elems == 0) {
            tab.put(doc.lineAt(docSt), new Integer(docSt));
        }
        int n2 = st;
        while (n2 < en) {
            Object in = tab.get(this.lineAt(n2));
            if (in != null && !(in instanceof Boolean)) {
                if (n2 == 58) {
                    n2 = -1 + n2 + 1;
                }
                diffs[diffCnt][0] = n2;
                diffs[diffCnt++][1] = (Integer)in;
                tab.remove(this.lineAt(n2));
            }
            ++n2;
        }
        this.findSequenceAndMark(minVal, maxVal, 0, diffCnt, diffs);
        diffs[diffCnt][0] = en;
        diffs[diffCnt][1] = docEn;
        diffs[diffCnt][2] = 1;
        diffs[++diffCnt][0] = st - 1;
        diffs[diffCnt][1] = minVal;
        diffs[diffCnt][2] = 1;
        int lastIdx = diffCnt;
        if (en - st > 1) {
            int n3 = 0;
            while (n3 < diffCnt) {
                if (diffs[n3][2] != 0) {
                    if (diffs[n3][0] - diffs[lastIdx][0] > 1 && (diffs[lastIdx][1] != minVal || diffs[n3][1] != maxVal)) {
                        this.diffToInternal(diffs[lastIdx][1], diffs[n3][1], diffs[lastIdx][0] + 1, diffs[n3][0], doc, diffs[lastIdx][1] + 1, diffs[n3][1], res);
                    }
                    lastIdx = n3;
                }
                ++n3;
            }
        }
        diffs[--diffCnt][0] = -1;
        res.addElement(diffs);
    }

    public int[][] diffTo(TextDocument doc) {
        JUnsafeVector result = new JUnsafeVector(50);
        this.diffToInternal(-1, 9999999, 0, this.size(), doc, 0, doc.size(), result);
        int[][] resArr = null;
        int resCnt = 0;
        int n = 0;
        while (n < result.size()) {
            int[][] diffs = (int[][])result.elementAt(n);
            int nn = 0;
            while (diffs[nn][0] >= 0) {
                if (diffs[nn][2] != 0) {
                    ++resCnt;
                }
                ++nn;
            }
            ++n;
        }
        JUnsafeArray testAgain = new JUnsafeArray(resCnt);
        resCnt = 0;
        int n2 = 0;
        while (n2 < result.size()) {
            int[][] diffs = (int[][])result.elementAt(n2);
            int nn = 0;
            while (diffs[nn][0] >= 0) {
                if (diffs[nn][2] != 0) {
                    testAgain.add(diffs[nn]);
                }
                ++nn;
            }
            ++n2;
        }
        JArray.QuickSort(testAgain, new ISortFunc(){

            public boolean isGreaterOrEqual(Object a, Object b) {
                return ((int[])a)[0] >= ((int[])b)[0];
            }
        });
        int[][] agArr = new int[testAgain.size() + 1][3];
        int n3 = 0;
        while (n3 < testAgain.size()) {
            int[] diffs = (int[])testAgain.at(n3);
            agArr[n3][0] = diffs[0];
            agArr[n3][1] = diffs[1];
            agArr[n3][2] = 0;
            ++n3;
        }
        this.findSequenceAndMark(-1, 99999999, 0, agArr.length - 1, agArr);
        resCnt = 0;
        int n4 = 0;
        while (n4 < agArr.length - 1) {
            if (agArr[n4][2] != 0) {
                ++resCnt;
            }
            ++n4;
        }
        resArr = new int[resCnt][2];
        resCnt = 0;
        int n5 = 0;
        while (n5 < agArr.length - 1) {
            if (agArr[n5][2] != 0) {
                resArr[resCnt][0] = agArr[n5][0];
                resArr[resCnt][1] = agArr[n5][1];
                ++resCnt;
            }
            ++n5;
        }
        if (resCnt != agArr.length - 1) {
            Tracer.This.println("!     Diff Warning: nachbesserung war n\u00fdtig");
            Tracer.This.println("");
            Tracer.This.println("");
            Tracer.This.println("");
            Tracer.This.println("");
        }
        boolean error = false;
        int n6 = 1;
        while (n6 < resArr.length) {
            if (resArr[n6][0] <= resArr[n6 - 1][0]) {
                Tracer.This.println("!!!!!!!!!!!!!!!!!!! fehler in diff links" + resArr[n6 - 1][0] + "=>" + resArr[n6 - 1][0]);
                Tracer.This.println("!!!!!!!!!!!!!!!!!!!                     " + resArr[n6][0] + "=>" + resArr[n6][0]);
                error = true;
            }
            if (resArr[n6][1] <= resArr[n6 - 1][1]) {
                Tracer.This.println("!!!!!!!!!!!!!!!!!!! fehler in diff rechts" + resArr[n6 - 1][1] + "=>" + resArr[n6 - 1][1]);
                Tracer.This.println("!!!!!!!!!!!!!!!!!!!                      " + resArr[n6][1] + "=>" + resArr[n6][1]);
                error = true;
            }
            ++n6;
        }
        if (error) {
            int n7 = 0;
            while (n7 < resArr.length) {
                Tracer.This.println(resArr[n7][0] + " " + resArr[n7][1]);
                ++n7;
            }
        }
        return resArr;
    }

    public Object[] recoveryDiff(TextDocument doc) {
        JUnsafeTable tab = new JUnsafeTable(doc.size() * 2);
        Object[] result = new Object[this.size()];
        int n = 0;
        while (n < doc.size()) {
            tab.put(doc.lineAt(n), new Integer(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < result.length) {
            result[n2] = tab.get(this.lineAt(n2)) != null ? tab.get(this.lineAt(n2)) : this.lineAt(n2).toString();
            ++n2;
        }
        return result;
    }

    public int[] getClosingBrace(int x, int y) {
        int rCnt = 0;
        int resX = 0;
        int resY = 0;
        while (y < this.size() && rCnt >= 0) {
            if (this.styleAt(x, y) == '\u0000') {
                switch (this.charAt(x, y)) {
                    case '(': 
                    case '[': 
                    case '{': {
                        ++rCnt;
                        break;
                    }
                    case ')': 
                    case ']': 
                    case '}': {
                        --rCnt;
                    }
                }
            }
            resX = x++;
            resY = y;
            if (x < this.lineAt(y).size()) continue;
            ++y;
            x = 0;
        }
        if (y >= this.size()) {
            return null;
        }
        return new int[]{resX, resY};
    }

    public int collapseBlock() {
        int[] start = this.getOpeningBrace(this.cX(), this.cY());
        int[] end = this.getClosingBrace(this.cX(), this.cY());
        if (start != null && end != null) {
            this.moveCursorAbs(this.cX(), start[1]);
            CollapsedTextLine clLine = CollapsedTextLine.Collapse(this, start[1], end[1]);
            int res = 0;
            if (clLine != null) {
                res = clLine.collapsed.size();
            }
            if (res > 0) {
                this.addDiff(new GeneralDiff(start[1], res, 5, null));
                this.repaintAll();
            }
            return res;
        }
        return 0;
    }

    public void collapseComments() {
        int cx = this.cX();
        int cy = this.cY();
        int start = -1;
        int end = -1;
        int i = 0;
        while (i < this.size()) {
            int x = this.getLastCharX(i);
            if (x > 0 && (this.styleAt(x - 1, i) == JavaHighlighter.COMMENT || this.styleAt(x - 1, i) == JavaHighlighter.LINECOMMENT)) {
                if (start == -1) {
                    start = i;
                } else {
                    end = i;
                }
            } else {
                if (start != -1 && end != -1) {
                    CollapsedTextLine clLine = CollapsedTextLine.Collapse(this, start, end);
                    int res = 0;
                    if (clLine != null) {
                        res = clLine.collapsed.size();
                    }
                    if (res > 0) {
                        this.addDiff(new GeneralDiff(start, res, 5, null));
                    }
                    if ((i -= res) < cy) {
                        cy -= res;
                    }
                }
                end = -1;
                start = -1;
            }
            ++i;
        }
        this.moveCursorAbs(cx, cy);
    }

    public void expandBlock() {
        int cy = this.cY();
        this.expandBlock(cy);
    }

    int expandBlock(int cy) {
        if (!(this.lineAt(cy) instanceof CollapsedTextLine)) {
            return 0;
        }
        CollapsedTextLine tl = (CollapsedTextLine)this.lineAt(cy);
        int res = tl.collapsed.size();
        tl.expand(this, cy);
        this.addDiff(new GeneralDiff(cy, res, 6, null));
        this.repaintAll();
        return res;
    }

    public void expandAll() {
        int cx = this.cX();
        int cy = this.cY();
        int i = 0;
        while (i < this.size()) {
            int num = this.expandBlock(i);
            if (i < cy) {
                cy += num;
            }
            ++i;
        }
        this.moveCursorAbs(cx, cy);
    }

    public void collapseToLevel(int nestDepth) {
        boolean cont = true;
        int cx = this.cX();
        int cy = this.cY();
        DocumentStream ds = new DocumentStream(this, 0, 0);
        int c = 0;
        int depth = 0;
        block0: while (cont) {
            cont = false;
            while ((c = ds.readWithStyle()) >= 0) {
                if (c >> 8 != 0) continue;
                if ((c &= 0xFF) == 123) {
                    if (++depth != nestDepth || this.lineAt(ds.posY()) instanceof CollapsedTextLine) continue;
                    this.moveCursorAbs(ds.posX(), ds.posY());
                    int num = this.collapseBlock();
                    if (num + ds.posY() <= cy) {
                        cy -= num;
                    } else if (ds.posY() < cy && ds.posY() + num >= cy) {
                        cy = ds.posY();
                    }
                    cont = true;
                    continue block0;
                }
                if (c != 125) continue;
                --depth;
            }
        }
        this.moveCursorAbs(cx, cy);
    }

    public boolean markBraces() {
        int y;
        int x;
        int rCnt = 0;
        if (this.hasSelection()) {
            x = this.selStartX();
            y = this.selStartY();
        } else {
            x = this.cX();
            y = this.cY();
        }
        while (y >= 0 && rCnt >= 0) {
            if (--x < 0) {
                x = --y >= 0 ? this.lineAt(y).size() : 0;
            }
            if (this.styleAt(x, y) != '\u0000') continue;
            switch (this.charAt(x, y)) {
                case '(': 
                case '[': 
                case '{': {
                    --rCnt;
                    break;
                }
                case ')': 
                case ']': 
                case '}': {
                    ++rCnt;
                }
            }
        }
        int xl = x;
        int yu = Math.max(0, y);
        if (this.hasSelection()) {
            x = this.selEndX();
            y = this.selEndY();
        } else {
            x = this.cX();
            y = this.cY();
        }
        rCnt = 0;
        while (y < this.size() && rCnt >= 0) {
            if (this.styleAt(x, y) == '\u0000') {
                switch (this.charAt(x, y)) {
                    case '(': 
                    case '[': 
                    case '{': {
                        ++rCnt;
                        break;
                    }
                    case ')': 
                    case ']': 
                    case '}': {
                        --rCnt;
                    }
                }
            }
            if (++x < this.lineAt(y).size()) continue;
            ++y;
            x = 0;
        }
        y = Math.min(this.size() - 1, y);
        if (y > 0 && x == 0) {
            if (y != this.size() - 1 || this.lineAt(y).size() != 1) {
                --y;
            }
            x = this.lineAt(y).size();
        }
        this.moveCursorAbs(xl, yu);
        this.setSelection(xl, yu, x, y);
        return false;
    }

    public int[] getOpeningBrace(int x, int y) {
        int rCnt = 0;
        while (y >= 0 && rCnt >= 0) {
            if (--x < 0) {
                x = --y >= 0 ? this.lineAt(y).size() : 0;
            }
            if (y < 0) {
                return null;
            }
            if (this.styleAt(x, y) != '\u0000') continue;
            switch (this.charAt(x, y)) {
                case '(': 
                case '[': 
                case '{': {
                    --rCnt;
                    break;
                }
                case ')': 
                case ']': 
                case '}': {
                    ++rCnt;
                }
            }
        }
        if (y < 0) {
            return null;
        }
        int xl = x;
        int yu = Math.max(0, y);
        return new int[]{xl, yu};
    }

    public static void main(String[] arg) {
        TextDocument doc = new TextDocument();
        doc.coreLoad(new File("g:\\j11\\classes11\\Jxe\\TextDocument.java"));
        Tracer.This.println(doc.findPatternLine(0, "234"));
        Tracer.This.println(doc.findPatternLine(0, "app_init"));
        Tracer.This.println(doc.findPatternLine(0, "strulli"));
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(-1);
    }

    public int visibleLines() {
        if (this.tv != null && this.tv != this) {
            return this.tv.visibleLines();
        }
        return 0;
    }

    public void updateView(int starty, int endy, int startx, int endx) {
    }

    public void setOffset(int topLine) {
        if (this.tv != null && this.tv != this) {
            this.tv.setOffset(topLine);
        }
    }

    public void page(int h) {
        if (this.tv != null && this.tv != this) {
            this.tv.page(h);
        }
    }

    public Frame getTopFrame() {
        if (this.tv != null && this.tv != this) {
            return this.tv.getTopFrame();
        }
        return null;
    }

    public void adjustPosition(int x, int y) {
        if (this.tv != null && this.tv != this) {
            this.tv.adjustPosition(x, y);
        }
    }

    public void pasteFile(File f) {
        TextDocument doc = new TextDocument(f);
        this.pasteDoc(doc);
    }

    public void pasteDoc(TextDocument doc) {
        this.paste(doc, this.cY(), this.cX());
    }

    public void saveHtml(String file2) {
        try {
            PrintStream out = new PrintStream(new FileOutputStream(file2));
            out.println("<html><head><title>" + this.getFile().getAbsolutePath() + "</title></head><body>");
            out.println("<h3>" + this.getFile().getAbsolutePath() + "</h3>");
            out.println("<pre>");
            int n = 0;
            while (n < this.size()) {
                AttributedTextLine act = this.lineAt(n);
                act.printHtml(out);
                out.println();
                ++n;
            }
            out.println("</pre>");
            out.println("</body></html>");
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

