/*
 * Decompiled with CFR 0.152.
 */
package Jxe.completers;

import JCollections.JUnsafeTable;
import JWVFile.VFile;
import Jxe.TextDocument;
import Jxe.completers.XmlCompleter;
import editapp.EditApp;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Vector;

public class AntCompleter
extends XmlCompleter {
    JUnsafeTable tags = new JUnsafeTable(61);

    public AntCompleter(String cfgFile) {
        try {
            FileInputStream fr = new FileInputStream(cfgFile);
            DataInputStream in = new DataInputStream(fr);
            String line = null;
            String lastTag = "notag";
            String lastAtt = "noatt";
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                switch (line.charAt(0)) {
                    case '-': {
                        lastAtt = line.substring(1);
                        this.addAttribute(lastTag, lastAtt);
                        break;
                    }
                    case '#': {
                        this.addAttributeValue(lastTag, lastAtt, line.substring(1));
                        break;
                    }
                    default: {
                        int i = line.indexOf("==");
                        if (i < 0) {
                            this.addTag(line, line);
                        } else {
                            String hid = line.substring(i + 2);
                            line = line.substring(0, i);
                            this.addTag(line, hid);
                        }
                        lastTag = line;
                    }
                }
            }
            fr.close();
        }
        catch (Exception th) {
            th.printStackTrace();
        }
    }

    protected void findAndLoadDtd(TextDocument doc) {
    }

    void addTag(String name, String helpId) {
        name = name.toLowerCase();
        helpId = helpId.toLowerCase();
        JUnsafeTable atts = (JUnsafeTable)this.tags.get(name);
        if (atts == null) {
            atts = new JUnsafeTable(5);
            this.tags.put(name, atts);
        }
        if (helpId == null || helpId.trim().length() == 0) {
            helpId = name;
        }
        if (atts.get("helpId") == null || name.equals(atts.get("helpId"))) {
            atts.put("helpid", helpId);
        }
    }

    void addAttributeValue(String tag, String attribute, String value) {
        tag = tag.toLowerCase();
        value = value.toLowerCase();
        attribute = attribute.toLowerCase();
        JUnsafeTable atts = (JUnsafeTable)this.tags.get(tag);
        if (atts == null) {
            atts = new JUnsafeTable(5);
            this.tags.put(tag, atts);
        }
        Vector values = null;
        if (atts.get(attribute) instanceof Boolean || atts.get(attribute) == null) {
            atts.put(attribute, new Vector(3));
        }
        values = (Vector)atts.get(attribute);
        values.addElement(value);
    }

    void addAttribute(String tag, String attribute) {
        tag = tag.toLowerCase();
        attribute = attribute.toLowerCase();
        JUnsafeTable atts = (JUnsafeTable)this.tags.get(tag);
        if (atts == null) {
            atts = new JUnsafeTable(5);
            this.tags.put(tag, atts);
        }
        atts.put(attribute, Boolean.TRUE);
    }

    JUnsafeTable getAttributes(String tag) {
        return (JUnsafeTable)this.tags.get(tag.toLowerCase());
    }

    public Vector findAttributesFor(String tag) {
        JUnsafeTable atts = this.getAttributes(tag);
        if (atts != null) {
            Vector<String> res = new Vector<String>(atts.size());
            Enumeration en = atts.keys();
            while (en.hasMoreElements()) {
                String s = en.nextElement().toString();
                if (s.equals("helpid")) continue;
                res.addElement(s);
            }
            if (res.size() == 1) {
                res.addElement("zzzzzzz");
            }
            return res;
        }
        return null;
    }

    protected void showTagDoc(final String tag) {
        EditApp.App.doLazy(new Runnable(){

            public void run() {
                EditApp.App.agent.showFile(new VFile("#staticdata/doc/agent/ant/" + tag + ".html"));
            }
        });
    }

    public Vector findSubTagsFor(String tagName) {
        return this.findTopLevelTags();
    }

    public Vector findTopLevelTags() {
        Vector res = new Vector(this.tags.size());
        Enumeration en = this.tags.keys();
        while (en.hasMoreElements()) {
            res.add(en.nextElement());
        }
        return res;
    }

    public boolean canComplete() {
        return true;
    }
}

