/*
 * Decompiled with CFR 0.152.
 */
package JxeExtensions;

import Jxe.EditorExtension;
import Jxe.KeyboardEvent;
import Jxe.TextDocument;

public class ExtLineCommentSelection
extends EditorExtension {
    public static ExtLineCommentSelection This = new ExtLineCommentSelection();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean action(TextDocument doc, KeyboardEvent ke) {
        int sy = doc.selStartY();
        int ey = doc.selEndY();
        try {
            doc.lockUpdate(true);
            if (!doc.hasSelection()) {
                sy = ey = doc.cY();
            }
            if (doc.selEndX() == 0) {
                --ey;
            }
            if (ey < sy) {
                ey = sy;
            }
            int n = sy;
            while (n <= ey) {
                this.commentLine(doc, n);
                doc.highLightLine(n);
                ++n;
            }
            Object var7_6 = null;
            doc.lockUpdate(false);
            doc.repaintLines(sy, ey + 1);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            doc.lockUpdate(false);
            doc.repaintLines(sy, ey + 1);
            throw throwable;
        }
        return false;
    }

    void commentLine(TextDocument doc, int line) {
        int x = doc.lineAt(line).getFirstChar();
        if (x < doc.lineAt(line).size() - 1) {
            if (doc.charAt(x, line) == '/' && doc.charAt(x + 1, line) == '/') {
                doc.delete(line, x, x + 2);
            } else {
                doc.insert("//", 0, line, x);
            }
        } else {
            doc.insert("//", 0, line, x);
        }
    }

    public String description() {
        return "make current line commented";
    }

    public boolean allowMenu() {
        return false;
    }

    public String menuString() {
        return "Line Comment";
    }
}

