/*
 * Decompiled with CFR 0.152.
 */
package JxeExtensions;

import Jxe.EditorExtension;
import Jxe.KeyboardEvent;
import Jxe.TextDocument;

public class ExtMoveCursor
extends EditorExtension {
    String str = "left";

    public ExtMoveCursor() {
    }

    public ExtMoveCursor(String name) {
        this.str = name;
    }

    public boolean action(TextDocument doc, KeyboardEvent ke) {
        boolean sel = doc.hasSelection();
        if ("left".equals(this.str)) {
            doc.moveCursor(-1, 0);
            if (sel) {
                doc.unsetSelection();
                doc.moveCursor(-1, 0);
            }
        } else if ("right".equals(this.str)) {
            doc.moveCursor(1, 0);
            if (sel) {
                doc.unsetSelection();
                doc.moveCursor(1, 0);
            }
        } else if ("up".equals(this.str)) {
            doc.moveCursor(0, -1);
            if (sel) {
                doc.unsetSelection();
                doc.moveCursor(0, -1);
            }
        } else if ("down".equals(this.str)) {
            doc.moveCursor(0, 1);
            if (sel) {
                doc.unsetSelection();
                doc.moveCursor(0, 1);
            }
        } else if ("pgup".equals(this.str)) {
            doc.pageUp();
        } else if ("pgdown".equals(this.str)) {
            doc.pageDown();
        } else if ("home".equals(this.str)) {
            int first = doc.lineAt(doc.cY()).getFirstChar();
            doc.moveCursorAbs(doc.cX() <= first ? 0 : first, doc.cY());
        } else if ("end".equals(this.str)) {
            int last = doc.lineAt(doc.cY()).getLastChar();
            doc.moveCursorAbs(doc.cX() > last ? doc.lineAt(doc.cY()).size() : last + 1, doc.cY());
        }
        return true;
    }

    public String[] possibleArgs() {
        String[] args = new String[]{"up", "down", "left", "right", "home", "end", "pgup", "pgdown"};
        return args;
    }

    public String getArg() {
        return this.str;
    }

    public void setArg(String s) {
        this.str = s;
    }

    public String description() {
        return "move the cursor up down left or right";
    }
}

