/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat;

import com.stevesoft.pat.End;
import com.stevesoft.pat.Pattern;
import com.stevesoft.pat.RegSyntax;
import com.stevesoft.pat.Regex;
import com.stevesoft.pat.Skipped;
import com.stevesoft.pat.StrPos;
import com.stevesoft.pat.oneChar;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;

public class FileRegex
extends Regex {
    int dirflag = 0;
    static final int EITHER = 0;
    static final int DIR = 1;
    static final int NONDIR = 2;
    static final Regex root = new Regex(File.separatorChar == '/' ? "/$" : "(?:.:|)\\\\$");

    public FileRegex() {
    }

    public FileRegex(String s) {
        super(s);
    }

    public void compile(String s) throws RegSyntax {
        String npat = FileRegex.toFileRegex(s);
        super.compile(npat);
        if (File.separatorChar == '\\') {
            this.ignoreCase = true;
        }
    }

    public boolean accept(File dir, String s) {
        if (this.dirflag != 0) {
            File f = new File(s);
            if (f.isDirectory() && this.dirflag == 2) {
                return false;
            }
            if (!f.isDirectory() && this.dirflag == 1) {
                return false;
            }
        }
        return this.matchAt(s, 0);
    }

    public static String[] list(String f) {
        return FileRegex.list(f, 0);
    }

    static String[] list(String f, int df) {
        StringTokenizer st = new StringTokenizer(f, File.pathSeparator);
        Vector v = new Vector();
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            FileRegex.list1(path, v, df, true);
        }
        Object[] sa = new String[v.size()];
        v.copyInto(sa);
        return sa;
    }

    static void list1(String path, Vector v, int df, boolean rec) {
        if (root.matchAt(path, 0)) {
            v.addElement(path + ".");
            return;
        }
        File f = new File(path);
        if (f.getParent() != null && rec) {
            Vector v2 = new Vector();
            FileRegex.list1(f.getParent(), v2, 1, true);
            int i = 0;
            while (i < v2.size()) {
                String path2 = (String)v2.elementAt(i) + File.separator + f.getName();
                FileRegex.list1(path2, v, df, false);
                ++i;
            }
        } else {
            File base = new File(path);
            String dir_s = base.getParent();
            if (dir_s == null) {
                dir_s = ".";
            }
            File dir = new File(dir_s);
            FileRegex fr = new FileRegex(base.getName());
            if (fr.isLiteral()) {
                v.addElement(dir_s + File.separator + base.getName());
                return;
            }
            fr.dirflag = df;
            String[] sa = dir.list(fr);
            if (sa == null) {
                return;
            }
            int i = 0;
            while (i < sa.length) {
                v.addElement(dir_s + File.separator + sa[i]);
                ++i;
            }
        }
    }

    public static String toFileRegex(String s) {
        StrPos sp = new StrPos(s, 0);
        StringBuffer sb = new StringBuffer();
        if (sp.incMatch("{?e=")) {
            char e = sp.thisChar();
            sp.inc();
            if (sp.incMatch("}")) {
                sb.append("(?e=" + e + ")^");
            } else {
                sb.append("^(?e=");
            }
            sp.esc = e;
        }
        int ParenLvl = 0;
        while (!sp.eos()) {
            if (File.separatorChar == '\\') {
                if (sp.escaped()) {
                    sb.append("\\\\");
                }
                sp.dontMatch = false;
            }
            if (sp.incMatch("?")) {
                sb.append(".");
                continue;
            }
            if (sp.incMatch(".")) {
                sb.append(sp.esc);
                sb.append('.');
                continue;
            }
            if (sp.incMatch("{??")) {
                sb.append("(??");
                ++ParenLvl;
                continue;
            }
            if (sp.incMatch("{?!")) {
                sb.append("(?!");
                ++ParenLvl;
                continue;
            }
            if (sp.incMatch("{?=")) {
                sb.append("(?=");
                ++ParenLvl;
                continue;
            }
            if (sp.incMatch("{")) {
                sb.append("(?:");
                ++ParenLvl;
                continue;
            }
            if (sp.incMatch("}")) {
                sb.append(')');
                --ParenLvl;
                continue;
            }
            if (ParenLvl != 0 && sp.incMatch(",")) {
                sb.append('|');
                continue;
            }
            if (sp.incMatch("*")) {
                sb.append(".*");
                continue;
            }
            sb.append(sp.thisChar());
            sp.inc();
        }
        sb.append("$");
        return sb.toString();
    }

    public boolean isLiteral() {
        Pattern x = this.thePattern;
        while (x != null && !(x instanceof End)) {
            if (!(x instanceof oneChar) && !(x instanceof Skipped)) {
                return false;
            }
            x = x.next;
        }
        return true;
    }
}

