/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat.apps;

import com.stevesoft.pat.RegRes;
import com.stevesoft.pat.RegSyntax;
import com.stevesoft.pat.Regex;
import com.stevesoft.pat.apps.AppsKey;
import com.stevesoft.pat.apps.Deck;
import com.stevesoft.pat.apps.Message;
import com.stevesoft.pat.apps.TestGroup;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.util.Random;

public class ReGame
extends Applet {
    static final String hide_ans = "????";
    Label pat_msg;
    Label ans_msg;
    public TextField pat;
    public TextField ans_txt;
    public TestGroup[] tgroup;
    public TestGroup[] tgroup2;
    public RegRes[] answers;
    int score;
    Label unreg;
    public TextField score_txt;
    public Button home_btn;
    public Button redraw;
    boolean inited = false;
    boolean started = false;
    public Random qrand = new Random();
    int quizno = 0;
    int p_len = 0;
    boolean game_over = false;
    public Deck quizes = null;
    int max_score = 0;
    public Message mes = null;

    String unescme(String in) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < in.length()) {
            if (in.charAt(i) == '_') {
                char c;
                if ((c = in.charAt(++i)) == 'q') {
                    sb.append('\"');
                } else if (c == 'a') {
                    sb.append('&');
                } else if (c == 'l') {
                    sb.append('<');
                } else if (c == 'r') {
                    sb.append('>');
                } else if (c == 'b') {
                    sb.append('\\');
                } else {
                    sb.append('_');
                }
            } else {
                sb.append(in.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    void setScore(int s) {
        this.score = s;
        String st = "score: " + s;
        if (this.score_txt == null) {
            this.score_txt = new TextField(st);
            this.score_txt.setEditable(false);
        } else {
            this.score_txt.setText(st);
        }
    }

    void addScore(int s) {
        this.setScore(this.score + s);
    }

    public void init() {
        Panel user = new Panel();
        Panel ans = new Panel();
        Panel header = new Panel();
        Panel body = new Panel();
        user.setBackground(Color.red);
        ans.setBackground(Color.green);
        body.setBackground(Color.blue);
        header.setBackground(Color.white);
        this.add(header);
        this.add(body);
        body.setLayout(new GridLayout(1, 2));
        body.add(user);
        body.add(ans);
        this.pat_msg = new Label("Pattern");
        this.pat = new TextField();
        this.ans_msg = new Label("Answer");
        this.ans_txt = new TextField();
        this.ans_txt.setEditable(false);
        this.ans_txt.setText(hide_ans);
        String umsg = null;
        umsg = this.getParameter("Title");
        if (umsg == null) {
            umsg = "ReGame";
        }
        this.unreg = new Label(umsg);
        this.unreg.setAlignment(1);
        this.setScore(0);
        this.home_btn = new Button("About");
        this.redraw = new Button("Redraw");
        header.add(this.unreg);
        user.add(this.score_txt);
        this.score_txt.setEditable(false);
        ans.add(this.home_btn);
        ans.add(this.redraw);
        Panel p = new Panel();
        p.add(this.pat_msg);
        p.add(this.pat);
        user.add(p);
        Panel p2 = new Panel();
        p2.add(this.ans_msg);
        p2.add(this.ans_txt);
        ans.add(p2);
        int ngroups = new Integer(this.getParameter("NGroups"));
        this.tgroup = new TestGroup[ngroups];
        this.tgroup2 = new TestGroup[ngroups];
        this.answers = new RegRes[ngroups];
        int i = 0;
        while (i < ngroups) {
            this.tgroup[i] = new TestGroup("text" + (i + 1), false);
            this.tgroup2[i] = new TestGroup("text" + (i + 1), false);
            user.add(this.tgroup[i]);
            ans.add(this.tgroup2[i]);
            ++i;
        }
        GridBagLayout gb = new GridBagLayout();
        user.setLayout(gb);
        ans.setLayout(gb);
        header.setLayout(gb);
        this.setLayout(gb);
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.gridheight = 1;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gb.setConstraints(this.unreg, gc);
        gc.gridwidth = 1;
        gc.weightx = 1.0;
        gb.setConstraints(header, gc);
        gc.gridy = 1;
        gc.fill = 1;
        gc.weighty = 1.0;
        gb.setConstraints(body, gc);
        gc.fill = 2;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gb.setConstraints(this.home_btn, gc);
        gc.gridx = 1;
        gb.setConstraints(this.redraw, gc);
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gb.setConstraints(this.score_txt, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 2;
        gc.weightx = 0.0;
        p.setLayout(gb);
        p2.setLayout(gb);
        gb.setConstraints(p, gc);
        gb.setConstraints(p2, gc);
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.fill = 1;
        gc.gridx = 0;
        i = 0;
        while (i < ngroups) {
            gc.gridy = i + 2;
            gb.setConstraints(this.tgroup[i], gc);
            gb.setConstraints(this.tgroup2[i], gc);
            ++i;
        }
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.fill = 2;
        gc.weightx = 0.0;
        gb.setConstraints(this.pat_msg, gc);
        gb.setConstraints(this.ans_msg, gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        gb.setConstraints(this.pat, gc);
        gb.setConstraints(this.ans_txt, gc);
    }

    public void start() {
        int d;
        if (this.started) {
            return;
        }
        this.started = true;
        int nmax = new Integer(this.getParameter("NQuizes"));
        this.quizes = new Deck(nmax);
        try {
            d = new Integer(this.getParameter("NDiscards"));
        }
        catch (Throwable t_) {
            d = 0;
        }
        while (d > 0) {
            --d;
            this.quizes.draw();
        }
        this.setScore(0);
        this.getquiz();
        this.game_over = false;
    }

    Regex getquiz() {
        if (this.quizes.ncards() == 0) {
            this.score_txt.setText("Game Over: Score " + this.score + " of " + this.max_score);
            this.game_over = true;
            return null;
        }
        this.quizno = this.quizes.draw();
        this.pat.setText("");
        this.ans_txt.setText(hide_ans);
        String ps = this.unescme(this.getParameter("pat" + this.quizno));
        this.p_len = ps.length();
        Regex r = new Regex();
        RegSyntax rs = null;
        try {
            r.compile(ps);
        }
        catch (RegSyntax rst) {
            rs = rst;
        }
        int i = 0;
        while (i < this.tgroup.length) {
            String t = "txt" + (i + 1) + "-" + this.quizno;
            t = this.unescme(this.getParameter(t));
            this.tgroup[i].txt.setText(t);
            this.tgroup2[i].txt.setText(t);
            if (rs == null) {
                r.search(t);
                this.tgroup2[i].ShowRes(r);
                this.tgroup[i].ctxt.clear();
                this.answers[i] = r.result();
            } else {
                this.tgroup2[i].ShowError(rs);
                this.tgroup[i].ctxt.clear();
                this.answers[i] = new RegRes();
            }
            ++i;
        }
        return r;
    }

    public boolean action(Event e, Object o) {
        int i;
        this.repaint();
        if (e.target instanceof Button) {
            if (o.equals("About")) {
                Message m = new Message();
                m.setTitle("About");
                m.addCentered("ReGame");
                m.addCentered("A regular expression game");
                m.addCentered("by Steven R. Brandt");
                m.addCentered("Home page at");
                m.addCentered("http://javaregex.com");
                m.addButton(new Button("OK"));
                m.ask(this);
                return true;
            }
            int i2 = 0;
            while (i2 < this.tgroup.length) {
                this.tgroup[i2].repaint();
                ++i2;
            }
            i = 0;
            while (i < this.tgroup2.length) {
                this.tgroup2[i].repaint();
                ++i;
            }
        }
        if (e.target instanceof Message) {
            Message m = (Message)e.target;
            if (m.getTitle().equals("About")) {
                return true;
            }
            i = 0;
            while (i < this.tgroup.length) {
                this.tgroup[i].ctxt.clear();
                this.tgroup[i].ctxt.clear();
                ++i;
            }
            this.getquiz();
            this.mes = null;
            return true;
        }
        if (e.target instanceof TextField && this.mes == null) {
            if (this.game_over) {
                return true;
            }
            String p = this.pat.getText();
            Regex r = new Regex(p);
            this.mes = new Message();
            this.mes.setTitle("Score");
            this.ans_txt.setText(this.unescme(this.getParameter("pat" + this.quizno)));
            Regex ansr = new Regex(this.ans_txt.getText());
            int i3 = 0;
            while (i3 < this.tgroup.length) {
                r.search(this.tgroup[i3].txt.getText());
                ansr.search(this.tgroup2[i3].txt.getText());
                RegRes res = r.result();
                this.tgroup2[i3].ShowRes(ansr);
                this.tgroup[i3].ShowRes(r);
                if (res.equals(this.answers[i3])) {
                    String sc;
                    if (p.length() > this.p_len) {
                        sc = "Long Match: 5 pts";
                        this.addScore(5);
                    } else if (p.length() == this.p_len) {
                        sc = "Match: 10 pts";
                        this.addScore(10);
                    } else {
                        sc = "Short Match: 12 pts";
                        this.addScore(12);
                    }
                    this.mes.v.addElement(new Label(sc));
                } else {
                    System.out.println("user: " + res);
                    System.out.println("answ: " + this.answers[i3]);
                    this.mes.v.addElement(new Label("No Match"));
                }
                this.max_score += 10;
                ++i3;
            }
            this.mes.v.addElement(new Button("OK"));
            this.mes.ask(this);
            return true;
        }
        return false;
    }

    static {
        AppsKey.register();
    }
}

