/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat.wrap;

import com.stevesoft.pat.BasicStringBufferLike;
import com.stevesoft.pat.Regex;
import com.stevesoft.pat.StringLike;
import com.stevesoft.pat.wrap.StringBufferWrap;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessFileWrap
implements StringLike {
    long offset = 0L;
    RandomAccessFile raf;
    int i0 = 0;
    int iend = 0;
    byte[] buf = new byte[1024];

    public void setOffset(long o) {
        this.offset = o;
        this.iend = 0;
        this.i0 = 0;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getBufferSize() {
        return this.buf.length;
    }

    public void setBufferSize(int bs) {
        this.buf = new byte[bs];
        this.iend = 0;
        this.i0 = 0;
    }

    public RandomAccessFileWrap(String file2) throws IOException {
        this.raf = new RandomAccessFile(file2, "r");
    }

    public RandomAccessFileWrap(RandomAccessFile raf) {
        this.raf = raf;
    }

    public char charAt(int i) {
        if (i >= this.i0 && i < this.iend) {
            return (char)this.buf[i - this.i0];
        }
        try {
            this.i0 = i - 5;
            if (this.i0 < 0) {
                this.i0 = 0;
            }
            this.raf.seek((long)this.i0 + this.offset);
            this.iend = this.i0 + this.raf.read(this.buf, 0, this.buf.length);
            if (i >= this.i0 && i < this.iend) {
                return (char)this.buf[i - this.i0];
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new ArrayIndexOutOfBoundsException("Out of bounds for file: i=" + i + ", Final Buffer: i0=" + this.i0 + " iend=" + this.iend);
    }

    public String toString() {
        throw new Error("Not implemented");
    }

    public int length() {
        try {
            long len = this.raf.length() - this.offset;
            if (len > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)len;
        }
        catch (IOException ioe) {
            return 0;
        }
    }

    public String substring(int i1, int i2) {
        StringBuffer sb = new StringBuffer();
        int i = i1;
        while (i < i2) {
            sb.append(this.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    public Object unwrap() {
        return this.raf;
    }

    public static void main(String[] files) throws IOException {
        int i = 0;
        while (i < files.length) {
            RandomAccessFileWrap fw = new RandomAccessFileWrap(new RandomAccessFile(files[i], "r"));
            Regex r = new Regex("toString\\(\\) *(?@{})");
            r.setGFlag(true);
            r.optimize();
            System.out.print(files[i] + " ");
            int j = 0;
            do {
                if (r.searchFrom(fw, j)) {
                    System.out.println("Matched at index: " + r.matchedFrom());
                    j = r.matchedTo();
                } else {
                    System.out.println("not found");
                }
                System.out.println(r.stringMatched());
            } while (r.didMatch());
            ++i;
        }
    }

    public BasicStringBufferLike newStringBufferLike() {
        return new StringBufferWrap();
    }

    public int indexOf(char c) {
        int i = 0;
        while (i < this.length()) {
            if (this.charAt(i) == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

